/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.api;

import android.animation.LayoutTransition;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.media.MediaFormat;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.media.MediaBrowserCompat;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.session.MediaControllerCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import androidx.core.util.Consumer;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ProcessLifecycleOwner;
import androidx.media.MediaBrowserServiceCompat;
import androidx.media3.common.AudioAttributes;
import androidx.media3.common.Format;
import androidx.media3.common.MediaItem;
import androidx.media3.common.MediaMetadata;
import androidx.media3.common.PlaybackException;
import androidx.media3.common.Player;
import androidx.media3.common.Timeline;
import androidx.media3.common.TrackGroup;
import androidx.media3.common.TrackSelectionParameters;
import androidx.media3.common.Tracks;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.ExoPlayer;
import androidx.media3.exoplayer.hls.HlsManifest;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.TrackGroupArray;
import androidx.media3.exoplayer.trackselection.DefaultTrackSelector;
import androidx.media3.exoplayer.trackselection.MappingTrackSelector;
import androidx.media3.exoplayer.trackselection.TrackSelector;
import androidx.media3.exoplayer.video.VideoFrameMetadataListener;
import androidx.media3.ui.AspectRatioFrameLayout;
import androidx.media3.ui.PlayerView;
import androidx.media3.ui.R;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.Transformation;
import com.github.rubensousa.previewseekbar.PreviewBar;
import com.github.rubensousa.previewseekbar.PreviewLoader;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.koushikdutta.async.future.FutureCallback;
import com.koushikdutta.ion.Ion;
import com.koushikdutta.ion.Response;
import com.koushikdutta.ion.builder.Builders;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;
import tv.brid.domain.Api;
import tv.brid.domain.Language;
import tv.brid.domain.Partner;
import tv.brid.domain.Playlist;
import tv.brid.domain.Skin;
import tv.brid.domain.Track;
import tv.brid.domain.Video;
import tv.brid.sdk.AnalyticService;
import tv.brid.sdk.Analytics;
import tv.brid.sdk.AutoplayMode;
import tv.brid.sdk.ErrorView;
import tv.brid.sdk.ErrorViewConfig;
import tv.brid.sdk.R;
import tv.brid.sdk.Utils;
import tv.brid.sdk.api.BridAgeRestricted;
import tv.brid.sdk.api.BridPlayer;
import tv.brid.sdk.api.BridPoster;
import tv.brid.sdk.api.SdkContainer;
import tv.brid.sdk.api.SdkContainerImpl;
import tv.brid.sdk.brid_network.domain.AdTagVO;
import tv.brid.sdk.brid_network.domain.PrebidData;
import tv.brid.sdk.brid_network.network.ApiCall;
import tv.brid.sdk.brid_network.network.FetchData;
import tv.brid.sdk.brid_network.network.GetLatest;
import tv.brid.sdk.brid_network.network.GetLatestConfig;
import tv.brid.sdk.brid_network.network.GetLocation;
import tv.brid.sdk.brid_network.network.GetPlayersConfig;
import tv.brid.sdk.brid_network.network.GetPlaylist;
import tv.brid.sdk.brid_network.network.GetPlaylistByChannel;
import tv.brid.sdk.brid_network.network.GetPlaylistByTag;
import tv.brid.sdk.brid_network.network.GetPlaylistPagination;
import tv.brid.sdk.brid_network.network.GetVideo;
import tv.brid.sdk.brid_network.network.GetVideoConfig;
import tv.brid.sdk.brid_network.network.NetworkConnection;
import tv.brid.sdk.brid_network.network.location.GeoLocation;
import tv.brid.sdk.brid_network.network.location.Location;
import tv.brid.sdk.engine.AnalyticData;
import tv.brid.sdk.engine.AnalyticsSender;
import tv.brid.sdk.engine.BridPlayerEngineNew;
import tv.brid.sdk.engine.IBridPlayerEngine;
import tv.brid.sdk.engine.ads.AdAnalyticDC;
import tv.brid.sdk.engine.ads.AdProvider;
import tv.brid.sdk.hls.HlsSupport;
import tv.brid.sdk.hls.VideoSupport;
import tv.brid.sdk.lifecycle.LifecycleOwnerChangedListener;
import tv.brid.sdk.lifecycle.LifecycleTracker;
import tv.brid.sdk.lifecycle.LifecycleTrackerKt;
import tv.brid.sdk.lifecycle.Resumable;
import tv.brid.sdk.player.BridStyledPlayerView;
import tv.brid.sdk.player.ErrorHandler;
import tv.brid.sdk.player.NetworkParsingErrorHandler;
import tv.brid.sdk.player.ViewabilityAnalyticsRunner;
import tv.brid.sdk.player.adPlayer.AdPlayerType;
import tv.brid.sdk.player.adPlayer.IAdPlayer;
import tv.brid.sdk.player.adPlayer.PrebidPlayer.PrebidPlayer;
import tv.brid.sdk.player.adPlayer.ima.ImaPlayer;
import tv.brid.sdk.player.adapters.PlaylistAdapter;
import tv.brid.sdk.player.adapters.PlaylistTvAdapter;
import tv.brid.sdk.player.drm.DRMPlayer;
import tv.brid.sdk.player.listeners.BridPlayerListener;
import tv.brid.sdk.player.listeners.BridPlayerLogListener;
import tv.brid.sdk.player.playback.playlist.loop.timer.CountablePlayView;
import tv.brid.sdk.player.settings.HlsResolutionView;
import tv.brid.sdk.player.settings.OptionsList;
import tv.brid.sdk.player.settings.SettingsTvViewManager;
import tv.brid.sdk.player.ui.ActionButton;
import tv.brid.sdk.player.ui.BridPreviewTimeBar;
import tv.brid.sdk.player.ui.BridTvFocusChangeListener;
import tv.brid.sdk.player.ui.CountFinishedListener;
import tv.brid.sdk.player.ui.CustomColor;
import tv.brid.sdk.player.ui.ResolutionView;
import tv.brid.sdk.player.ui.UIVisibilityCustomization;
import tv.brid.sdk.player.ui.UtilsKt;
import tv.brid.sdk.player.ui.double_tap_layout.BridPlayerOverlay;
import tv.brid.sdk.player.ui.glide_transformation.GlideThumbnailTransformation;
import tv.brid.sdk.player.ui.glide_transformation.VttParser;

@UnstableApi
public final class BridPlayerImpl
extends MediaBrowserServiceCompat
implements View.OnClickListener,
AdapterView.OnItemClickListener,
VideoFrameMetadataListener,
BridPlayer,
AnalyticsSender,
FetchData,
Resumable,
PreviewLoader,
PreviewBar.OnScrubListener {
    public static final int DEBUG_LOG = 1;
    public static final int DEBUG_ERRORS = 2;
    public static final int DEBUG_ADS = 4;
    public static final int DEBUG_ANALYTICS = 8;
    public static final int DEBUG_ALL = 255;
    private BridStyledPlayerView playerView;
    private FrameLayout view;
    private FrameLayout playerHolder;
    private FrameLayout playerOverlayWrapper;
    private FrameLayout exoShareOverlay;
    private FrameLayout progressParent;
    private AspectRatioFrameLayout playerContentFrame;
    private List<MediaItem> mediaItems;
    private ExoPlayer player;
    private Dialog fullScreenDialog;
    private ProgressBar pbLoading;
    private ProgressBar pbLoadingPreroll;
    private RelativeLayout playlistHolder;
    private RelativeLayout unmuteLayout;
    private ImageView btnClosePlaylist;
    private ImageView previewImageView;
    private ListView playlist;
    private RecyclerView rvPlaylistTv;
    private PlaylistAdapter playListAdapter;
    private PlaylistTvAdapter playlistTvAdapter;
    private tv.brid.domain.Player playerVO;
    private Playlist playlistVO;
    private Partner partnerVO;
    private ArrayList<Video> videoVOS;
    private ArrayList<Video> relatedVideos;
    private Location location;
    private long timeCreated;
    private long resumePosition;
    private HashMap<String, String> macroTargeting = new HashMap();
    static BridPlayerListener mListener;
    static BridPlayerLogListener mLogListener;
    private transient List<View> controlsOverlayList;
    private Context context;
    private OptionsList resolutionView;
    private AdProvider adProvider;
    private AdAnalyticDC adAnalyticDC;
    private IBridPlayerEngine bridPlayerEngine;
    private PlayerEventListener playerEventListener = new PlayerEventListener();
    private ViewGroup centerControllsParent;
    private View rewWithAmount;
    private View ffwdWithAmount;
    private View rewButton;
    private View ffwdButton;
    private View creditsLayout = null;
    private View customController;
    private View networkErrorView;
    private View loadingAdView;
    private ViewabilityAnalyticsRunner var;
    private BridPoster bridPoster;
    private TextView txtTVTitle;
    private TextView creditsTextView = null;
    private TextView txtResolutionSD;
    private TextView txtTitle;
    private ImageButton btnReplay;
    private ImageButton btnFastBack;
    private ImageButton btnFastForward;
    private ImageButton btnPrev;
    private ImageButton btnNext;
    private ImageButton btnStart;
    private ImageButton btnPlay;
    private ImageButton btnPlayTV;
    private ImageButton unmuteBtn;
    private ImageButton btnFullScreen;
    private ImageButton btnShare;
    private ImageButton btnPlaylist;
    private ImageButton btnMute;
    private ImageButton btnSettings;
    private ImageButton btnBigUnmute;
    private ImageButton btnExtraControls;
    private ImageButton hideExtraControls;
    private ImageButton pipMinimise;
    private ImageButton btnCC;
    private UIVisibilityCustomization visual;
    public SdkContainer sdkContainer;
    private CountablePlayView countablePlayView;
    private VideoSupport videoSupport;
    private Video customVideo;
    private BridPreviewTimeBar progressBar;
    public ActionButton mTvLivestreamStart;
    public ActionButton mTvLivestreamLive;
    private LifecycleTracker lifecycleTracker;
    @DrawableRes
    private int fullscreenIcon;
    @DrawableRes
    private int fullscreenCloseIcon;
    @DrawableRes
    private int playIcon;
    @DrawableRes
    private int pauseIcon;
    @DrawableRes
    private int muteIcon;
    @DrawableRes
    private int unmuteIcon;
    @DrawableRes
    private int playlistIcon;
    @DrawableRes
    private int exitIcon;
    @DrawableRes
    private int shareIcon;
    @DrawableRes
    private int settingsIcon;
    @DrawableRes
    private int forwardIcon;
    @DrawableRes
    private int focusDrawable;
    @DrawableRes
    private int nextDrawable;
    @DrawableRes
    private int prevDrawable;
    @DrawableRes
    private int placeholderPosterImageRes = 0;
    private View controlsBackground;
    @ColorRes
    private int playedColor;
    @ColorRes
    private int unplayedColor;
    @ColorRes
    private int bufferedColor;
    @ColorRes
    private int scrubberColor;
    private Drawable fullscreenToggleDrawable;
    private Drawable fullscreenOffDrawable;
    private Drawable muteToggleDrawable;
    private Drawable mutedDrawable;
    private ImaPlayer imaPlayer;
    private AdTagVO currentAdTag;
    private LifecycleOwner lifecycleOwner;
    private ErrorHandler networkParsingErrorHandler;
    private ApiCall lastApiCall;
    private boolean forceAutoplay;
    private boolean isVideoPlaying = false;
    private boolean adControlsEnabled = false;
    private boolean isTablet = false;
    private boolean dontStackMidrolls = false;
    private boolean playerHaveSkin = false;
    private boolean isRepeated = false;
    private boolean networkState;
    private boolean hasInternet;
    private boolean vpaidInProgress;
    private boolean debugIma;
    private boolean tvMode;
    private boolean playAfterPlaylistClosed;
    private boolean isAgeVerified = false;
    private boolean playerFullscreen = false;
    private boolean playEnded = false;
    private boolean loadingIndicator = true;
    private boolean playInitiated;
    private boolean isMuted;
    private boolean isAutoPlayEnabled = true;
    private boolean isPlayerControlsEnabled = true;
    private boolean visibleTimeControls = true;
    private boolean shouldAutoPlay;
    private boolean playerLoaded;
    private boolean useVPAID = false;
    private boolean onPauseWhilePlaying = false;
    private boolean isPipEnabled = false;
    private boolean isInPipMode = false;
    private boolean useTouchPlayPause = false;
    private boolean isTvPlaylistOpen = false;
    private boolean isCcEnabled = false;
    private int controllerTimeoutMs = 4000;
    private int currentVideo = -1;
    private int buttonsInitiatedFor = -1;
    private int playerHolderWidth;
    private int playerHolderHeight;
    private int resizedFor = 0;
    private int resumeWindow;
    private int debug = 0;
    private int playlistId = 0;
    private int cornerRadius = 1;
    private int seekSeconds = -1;
    private int shouldShowExtraControls = 5;
    private int ccBottomOffset;
    private int ageGateId = 1;
    private int isVttEnabled = 0;
    private String creditsLabelColor = null;
    private String bridPlayerReference = null;
    private String countryCode = "en";
    private String previewImageVTT = "";
    private BridPlayerOverlay playerDoubleTapOverlay;
    private ViewGroup.LayoutParams originalPlayerParams;
    private LinearLayout exoBasicControls;
    private LinearLayout mandatoryControls;
    private LinearLayout extraControlsLayout;
    private LinearLayout tvPlaylistHolder;
    private LinearLayout settingsHolderTv;
    RelativeLayout exoBottomNoNetwork;
    private boolean isFirstPlaying = true;
    private boolean existAd = false;
    private int btnNextVisibility = 2;
    private int btnPrevVisibility = 2;
    private MediaSessionCompat mSession;
    private MediaSessionCallback mMediaSessionCallback;
    private static final String TAG = "BridPlayer-Log ";
    private PreviewLoader previewLoader;
    public static final long MEDIA_ACTIONS_PLAY_PAUSE = 518L;
    public static final long MEDIA_ACTIONS_ALL = 822L;
    private VttParser vttParser;
    private SettingsTvViewManager settingsTvViewManager;
    private PrebidPlayer prebidPlayer = null;
    private Boolean autoplayCC = false;
    int suppressSeekDiscontinuity = 0;
    int captionSelectedIndex = 0;
    View.OnKeyListener focusUpInterceptor = new View.OnKeyListener(){

        public boolean onKey(View v, int keyCode, KeyEvent event) {
            if (event.getAction() == 0 && keyCode == 19 && BridPlayerImpl.this.isTvPlaylistOpen) {
                BridPlayerImpl.this.setFocusOnElementTv();
            }
            return false;
        }
    };

    @SuppressLint(value={"ResourceAsColor"})
    public BridPlayerImpl(final Context context, FrameLayout parentView, int cornerRadius) {
        this.context = context;
        this.sdkContainer = new SdkContainerImpl(context);
        this.lifecycleTracker = new LifecycleTracker(new LifecycleOwnerChangedListener(){

            @Override
            public void provideLifecycleOwner(@NonNull LifecycleOwner owner) {
                if (BridPlayerImpl.this.lifecycleOwner == owner) {
                    return;
                }
                BridPlayerImpl.this.lifecycleOwner = owner;
                NetworkConnection networkConnection = null;
                if (Build.VERSION.SDK_INT >= 23) {
                    networkConnection = NetworkConnection.getInstance(context.getApplicationContext());
                }
                networkConnection.observe(owner, (Observer)new Observer<Boolean>(){

                    public void onChanged(Boolean aBoolean) {
                        Utils.log(this.getClass(), "tv.brid.sdk.brid_network.network.NetworkConnection onChanged", aBoolean.toString());
                        if (aBoolean == BridPlayerImpl.this.networkState) {
                            return;
                        }
                        BridPlayerImpl.this.networkState = aBoolean;
                        BridPlayerImpl.this.hasInternet = aBoolean;
                        if (!aBoolean.booleanValue() && BridPlayerImpl.this.bridPlayerEngine != null) {
                            BridPlayerImpl.this.bridPlayerEngine.onNetworkConnectionLost();
                        } else if (BridPlayerImpl.this.bridPlayerEngine != null) {
                            BridPlayerImpl.this.bridPlayerEngine.onNetworkConnectionSuccess();
                        }
                    }
                });
            }
        });
        ProcessLifecycleOwner.get().getLifecycle().addObserver((LifecycleObserver)this.lifecycleTracker);
        GetLocation apiService = new GetLocation(this);
        apiService.call();
        this.isTablet = context.getResources().getConfiguration().smallestScreenWidthDp >= 600;
        this.playerHolder = parentView;
        this.playerHolder.removeAllViews();
        this.timeCreated = System.currentTimeMillis() / 1000L;
        this.view = (FrameLayout)LayoutInflater.from((Context)context).inflate(R.layout.exo_player_holder, null);
        this.playerView = (BridStyledPlayerView)this.view.findViewById(R.id.brid_player_view);
        this.playerView.requestFocus();
        this.playerView.setShutterBackgroundColor(0);
        this.playerView.setControllerShowTimeoutMs(this.controllerTimeoutMs);
        this.playerView.setControllerAutoShow(true);
        if (cornerRadius > 0) {
            this.cornerRadius = cornerRadius;
        }
        this.playerView.setControllerVisibilityListener(new PlayerView.ControllerVisibilityListener(){

            public void onVisibilityChanged(int visibility) {
                Utils.log(this.getClass(), "onVisibilityChange", String.valueOf(visibility));
                if (BridPlayerImpl.this.playerVO == null) {
                    return;
                }
                BridPlayerImpl.this.setVisibilityToPlayerControlsLayout(visibility == 0);
                BridPlayerImpl.this.showHideTitleBar(visibility);
                if (BridPlayerImpl.this.isPipEnabled && !UtilsKt.isSDKRunningOnTvDevice(context)) {
                    BridPlayerImpl.this.pipMinimise.setVisibility(Boolean.TRUE.equals(BridPlayerImpl.this.playerVO.getTitleBar()) && visibility == 0 && BridPlayerImpl.this.playlistHolder.getVisibility() != 0 ? 0 : 8);
                }
                if (BridPlayerImpl.this.isInPipMode) {
                    BridPlayerImpl.this.playerView.hideController();
                }
                if (UtilsKt.isSDKRunningOnTvDevice(context) && BridPlayerImpl.this.progressBar != null) {
                    BridPlayerImpl.this.progressBar.requestFocus();
                }
            }
        });
        this.playerView.setTouchListener(new BridStyledPlayerView.TouchListener(){

            @Override
            public void onTouch() {
                if (BridPlayerImpl.this.useTouchPlayPause) {
                    if (BridPlayerImpl.this.player == null) {
                        return;
                    }
                    if (BridPlayerImpl.this.player.isPlaying()) {
                        BridPlayerImpl.this.pause();
                    } else {
                        BridPlayerImpl.this.play();
                    }
                }
            }
        });
        this.progressBar = (BridPreviewTimeBar)this.view.findViewById(R.id.exo_progress);
        this.playerContentFrame = (AspectRatioFrameLayout)this.view.findViewById(R.id.exo_content_frame);
        this.exoShareOverlay = (FrameLayout)this.view.findViewById(R.id.exo_share_overlay);
        this.playerOverlayWrapper = (FrameLayout)this.view.findViewById(R.id.playerOverlayWrapper);
        this.pbLoading = (ProgressBar)this.view.findViewById(R.id.exo_loading);
        this.pbLoadingPreroll = (ProgressBar)this.view.findViewById(R.id.exo_loading_preroll);
        this.loadingAdView = this.view.findViewById(R.id.view_loading_ad);
        this.btnNext = (ImageButton)this.view.findViewById(R.id.brid_exo_next);
        if (this.btnNext != null) {
            this.btnNext.setOnClickListener((View.OnClickListener)this);
        }
        this.btnPrev = (ImageButton)this.view.findViewById(R.id.brid_exo_prev);
        if (this.btnPrev != null) {
            this.btnPrev.setOnClickListener((View.OnClickListener)this);
        }
        this.customController = (View)this.view.findViewById(R.id.exo_bottom_bar).getParent();
        this.btnPlaylist = (ImageButton)this.view.findViewById(R.id.exo_playlist);
        this.playlistIcon = R.drawable.exo_controls_brid_open_playlist;
        this.btnPlaylist.setImageDrawable(ContextCompat.getDrawable((Context)context, (int)this.playlistIcon));
        this.btnCC = (ImageButton)this.view.findViewById(R.id.brid_cc);
        this.btnCC.setOnClickListener((View.OnClickListener)this);
        this.exitIcon = R.drawable.exo_controls_brid_close_playlist;
        this.btnNext.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    if (BridPlayerImpl.this.btnPrev.getVisibility() == 0) {
                        BridPlayerImpl.this.btnNext.setNextFocusLeftId(R.id.brid_exo_prev);
                    } else {
                        BridPlayerImpl.this.btnNext.setNextFocusLeftId(R.id.exo_settings);
                    }
                }
            }
        });
        if (!UtilsKt.isSDKRunningOnTvDevice(context)) {
            this.centerControllsParent = (ViewGroup)this.view.findViewById(R.id.exo_center_controls).getParent();
            this.visual = new UIVisibilityCustomization(context, this.view, (View)this.centerControllsParent);
            this.btnReplay = (ImageButton)this.view.findViewById(R.id.brid_replay);
            this.txtResolutionSD = (TextView)this.view.findViewById(R.id.exo_resolution_SD);
            this.txtResolutionSD.setOnClickListener((View.OnClickListener)this);
            if (this.btnReplay != null) {
                this.btnReplay.setOnClickListener((View.OnClickListener)this);
            }
            this.playerDoubleTapOverlay = (BridPlayerOverlay)this.view.findViewById(R.id.brid_player_overlay);
            this.playerDoubleTapOverlay.setVisibility(8);
            this.setDoubleTapListener();
            this.progressBar.addOnScrubListener(this);
            this.progressBar.setPreviewLoader(this);
            this.unmuteLayout = (RelativeLayout)this.view.findViewById(R.id.unmuteLayout);
            if (this.unmuteLayout != null) {
                this.unmuteLayout.setOnClickListener((View.OnClickListener)this);
            }
            this.playlistHolder = (RelativeLayout)this.view.findViewById(R.id.playlistHolder);
            this.playlist = (ListView)this.view.findViewById(R.id.playlist);
            this.playlist.setOnItemClickListener((AdapterView.OnItemClickListener)this);
            this.playlist.setNestedScrollingEnabled(true);
            this.exoBasicControls = (LinearLayout)this.view.findViewById(R.id.exo_basic_controls);
            this.extraControlsLayout = (LinearLayout)this.view.findViewById(R.id.exo_extra_controls);
            this.mandatoryControls = (LinearLayout)this.view.findViewById(R.id.mandatory_controls);
            this.exoBottomNoNetwork = (RelativeLayout)this.view.findViewById(R.id.bottom_no_network);
            this.btnExtraControls = (ImageButton)this.view.findViewById(R.id.exo_overflow_show);
            this.hideExtraControls = (ImageButton)this.playerView.findViewById(R.id.exo_overflow_hide);
            this.previewImageView = (ImageView)this.view.findViewById(R.id.previewImageView);
            this.btnPlay = (ImageButton)this.view.findViewById(R.id.exo_play_pause);
            if (this.btnPlay != null) {
                this.btnPlay.setOnClickListener((View.OnClickListener)this);
            }
            this.btnStart = (ImageButton)this.view.findViewById(R.id.exo_start);
            this.btnStart.setOnClickListener((View.OnClickListener)this);
            this.pipMinimise = (ImageButton)this.view.findViewById(R.id.brid_minimise);
            this.pipMinimise.setOnClickListener((View.OnClickListener)this);
            this.btnMute = (ImageButton)this.view.findViewById(R.id.exo_mute);
            this.btnMute.setOnClickListener((View.OnClickListener)this);
            this.btnClosePlaylist = (ImageView)this.view.findViewById(R.id.exo_close_playlist);
            this.btnClosePlaylist.setOnClickListener((View.OnClickListener)this);
            this.btnFullScreen = (ImageButton)this.view.findViewById(R.id.exo_fullscreen_brid);
            this.btnFullScreen.setOnClickListener((View.OnClickListener)this);
            this.btnShare = (ImageButton)this.view.findViewById(R.id.exo_share);
            this.btnShare.setOnClickListener((View.OnClickListener)this);
            this.btnPlaylist.setOnClickListener((View.OnClickListener)this);
            this.controlsBackground = this.view.findViewById(R.id.exo_controls_background);
            this.unmuteBtn = (ImageButton)this.view.findViewById(R.id.unmute_button);
            this.txtTitle = (TextView)this.view.findViewById(R.id.exo_title);
            this.fullscreenIcon = R.drawable.exo_controls_brid_open_fullscreen;
            this.fullscreenCloseIcon = R.drawable.exo_controls_brid_close_fullscreen;
            this.btnFullScreen.setImageDrawable(ContextCompat.getDrawable((Context)context, (int)R.drawable.exo_controls_brid_open_fullscreen));
            this.muteIcon = R.drawable.exo_controls_brid_mute;
            this.unmuteIcon = R.drawable.exo_controls_brid_muted;
            this.btnMute.setImageDrawable(ContextCompat.getDrawable((Context)context, (int)(this.isMuted ? this.unmuteIcon : this.muteIcon)));
            this.shareIcon = R.drawable.exo_controls_brid_open_share;
            this.btnShare.setImageDrawable(ContextCompat.getDrawable((Context)context, (int)this.shareIcon));
            this.settingsIcon = R.drawable.exo_styled_controls_settings;
            this.btnClosePlaylist.setImageDrawable(ContextCompat.getDrawable((Context)context, (int)this.exitIcon));
            this.nextDrawable = R.drawable.exo_controls_brid_next;
            this.btnNext.setImageDrawable(ContextCompat.getDrawable((Context)context, (int)this.nextDrawable));
            this.prevDrawable = R.drawable.exo_controls_brid_previous;
            this.btnPrev.setImageDrawable(ContextCompat.getDrawable((Context)context, (int)this.prevDrawable));
            this.playIcon = R.drawable.exo_icon_play;
            this.btnPlay.setImageDrawable(ContextCompat.getDrawable((Context)context, (int)this.playIcon));
            this.txtTitle.setVisibility(8);
            this.setPlayerCornerRadius(cornerRadius);
            this.centerControllsParent.setVisibility(8);
            this.customController.setVisibility(8);
        } else {
            this.centerControllsParent = (ViewGroup)this.view.findViewById(R.id.exo_bottom_bar).getParent();
            this.visual = new UIVisibilityCustomization(context, this.view, (View)this.centerControllsParent);
            this.rvPlaylistTv = (RecyclerView)this.view.findViewById(R.id.video_list);
            this.txtTVTitle = (TextView)this.view.findViewById(R.id.txtTitleTV);
            this.btnPlayTV = (ImageButton)this.view.findViewById(R.id.exo_play_pause_tv);
            if (this.btnPlayTV != null) {
                this.btnPlayTV.setOnClickListener((View.OnClickListener)this);
            }
            this.btnSettings = (ImageButton)this.view.findViewById(R.id.exo_settings);
            this.settingsHolderTv = (LinearLayout)this.view.findViewById(R.id.tvSettingsHolder);
            this.btnSettings.setOnClickListener((View.OnClickListener)this);
            this.btnPlaylist.setOnClickListener((View.OnClickListener)this);
            this.playIcon = R.drawable.ic_pause_tv;
            this.btnPlayTV.setImageDrawable(ContextCompat.getDrawable((Context)context, (int)this.playIcon));
            this.tvPlaylistHolder = (LinearLayout)this.view.findViewById(R.id.playlist_tv_container);
            this.btnPrev.setOnKeyListener(this.focusUpInterceptor);
            this.btnNext.setOnKeyListener(this.focusUpInterceptor);
            this.btnCC.setOnKeyListener(this.focusUpInterceptor);
            this.btnPlaylist.setOnKeyListener(this.focusUpInterceptor);
            this.btnSettings.setOnKeyListener(this.focusUpInterceptor);
        }
        this.fullScreenDialog = new Dialog(context, 16973834){

            public void onBackPressed() {
                if (BridPlayerImpl.this.playerFullscreen) {
                    BridPlayerImpl.this.closeFullscreenDialog();
                }
                super.onBackPressed();
            }
        };
        ViewTreeObserver vto = this.playerHolder.getViewTreeObserver();
        vto.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                int width = BridPlayerImpl.this.playerHolder.getMeasuredWidth();
                int height = BridPlayerImpl.this.playerHolder.getMeasuredHeight();
                if (BridPlayerImpl.this.getCurrentVideo() != null) {
                    BridPlayerImpl.this.setUpCreditsText(BridPlayerImpl.this.getCurrentVideo().getCredits());
                }
                BridPlayerImpl.this.visual.activateBottomControlsIfPlayExists();
                if (!(BridPlayerImpl.this.playerHolderWidth == width && BridPlayerImpl.this.playerHolderHeight == height || width == 0 || height == 0 || BridPlayerImpl.this.playerFullscreen)) {
                    BridPlayerImpl.this.playerHolderWidth = width;
                    BridPlayerImpl.this.playerHolderHeight = height;
                    if (BridPlayerImpl.this.playerVO == null) {
                        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(width, height);
                        BridPlayerImpl.this.playerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                        if (BridPlayerImpl.this.playerDoubleTapOverlay != null) {
                            BridPlayerImpl.this.playerDoubleTapOverlay.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                        }
                        return;
                    }
                    BridPlayerImpl.this.setPlayerBasicLoadControls();
                    if (BridPlayerImpl.this.playerVO.getBranding() != null) {
                        if (BridPlayerImpl.this.imaPlayer != null) {
                            BridPlayerImpl.this.visual.invisibleWatermark();
                        } else {
                            BridPlayerImpl.this.visual.setBranding(BridPlayerImpl.this.playerVO.getBranding().getPos(), BridPlayerImpl.this.playerVO.getBranding().getImg(), BridPlayerImpl.this.playerVO.getBranding().getUrl());
                        }
                        BridPlayerImpl.this.visual.setBranding(BridPlayerImpl.this.playerVO.getBranding().getPos(), BridPlayerImpl.this.playerVO.getBranding().getImg(), BridPlayerImpl.this.playerVO.getBranding().getUrl());
                    }
                    int requiredHeight = -1;
                    requiredHeight = BridPlayerImpl.this.playerVO.getMobileWidth() != null && BridPlayerImpl.this.playerVO.getMobileHeight() != null ? Math.round((float)width * Float.parseFloat(BridPlayerImpl.this.playerVO.getMobileHeight()) / Float.parseFloat(BridPlayerImpl.this.playerVO.getMobileWidth())) : Math.round(width * BridPlayerImpl.this.playerVO.getHeight() / BridPlayerImpl.this.playerVO.getWidth());
                    if (requiredHeight != BridPlayerImpl.this.playerView.getHeight() || height != BridPlayerImpl.this.playerView.getHeight()) {
                        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(width, requiredHeight);
                        BridPlayerImpl.this.playerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                        if (BridPlayerImpl.this.playerDoubleTapOverlay != null) {
                            BridPlayerImpl.this.playerDoubleTapOverlay.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                        }
                    }
                }
            }
        });
        this.playerHolder.addView((View)this.view);
    }

    private void setDoubleTapListener() {
        this.playerDoubleTapOverlay.performListener(new BridPlayerOverlay.PerformListener(){

            @Override
            @androidx.annotation.Nullable
            public Boolean shouldForward(@NonNull Player player, @NonNull BridStyledPlayerView playerView, float posX) {
                if (player.getPlaybackState() == 1 || player.getPlaybackState() == 4) {
                    return null;
                }
                if (player.getCurrentPosition() > 500L && (double)posX < (double)playerView.getWidth() * 0.35) {
                    return false;
                }
                if (player.getCurrentPosition() < player.getDuration() && (double)posX > (double)playerView.getWidth() * 0.65) {
                    return true;
                }
                return null;
            }

            @Override
            public void onAnimationStart() {
                BridPlayerImpl.this.playerDoubleTapOverlay.setVisibility(0);
            }

            @Override
            public void onAnimationEnd() {
                BridPlayerImpl.this.playerDoubleTapOverlay.setVisibility(8);
            }
        });
    }

    private void setPlayerCornerRadius(final int cornerRadius) {
        if (cornerRadius > 0) {
            this.playerView.setOutlineProvider(new ViewOutlineProvider(){

                public void getOutline(View view, Outline outline) {
                    outline.setRoundRect(0, 0, view.getWidth(), view.getHeight(), (float)cornerRadius);
                }
            });
            this.playerView.setClipToOutline(true);
        }
    }

    private void setPlayerBasicLoadControls() {
        if (this.playerVO.getControls() != null && !this.playerVO.getControls().booleanValue()) {
            this.visual.controlAllPlayerControls(this.playerVO.getControls());
        } else if (this.playerVO.getControls() != null && this.playerVO.getControls().booleanValue()) {
            this.visual.enableSingleButtonControl(this.playerVO);
        }
    }

    private void makeApiCall(final ApiCall apiCall) {
        this.resetPlayerBeforeFetchingData();
        if (apiCall == null) {
            return;
        }
        this.lastApiCall = apiCall;
        try {
            apiCall.call();
        }
        catch (Exception e) {
            this.networkParsingErrorHandler = new NetworkParsingErrorHandler(this.playerView);
            this.networkParsingErrorHandler.handleError(e.getMessage(), new Function0<Unit>(){

                public Unit invoke() {
                    apiCall.call();
                    if (mListener != null) {
                        mListener.onEvent("neterror", BridPlayerImpl.this.getPlayerReference());
                    }
                    return null;
                }
            });
        }
    }

    @Override
    public void loadVideo(int playerId, int videoId, @androidx.annotation.Nullable String token) {
        this.loadVideo(playerId, videoId, this, token);
    }

    @Override
    public void loadVideo(int playerId, int videoId) {
        this.loadVideo(playerId, videoId, null);
    }

    public void loadVideo(int playerId, int videoId, FetchData callback2, @androidx.annotation.Nullable String token) {
        Utils.log(this.getClass(), "loadVideo", new String[0]);
        GetVideoConfig getVideoConfig = new GetVideoConfig(playerId, callback2, videoId, token);
        ApiCall apiCall = this.sdkContainer.provide(GetVideo.class, getVideoConfig);
        this.makeApiCall(apiCall);
    }

    public void loadPlayerConfigForVideo(int playerId, Video video) {
        Utils.log(this.getClass(), "loadPlayerConfigForVideo", new String[0]);
        this.customVideo = video;
        GetPlayersConfig apiCall = new GetPlayersConfig(playerId, this);
        this.makeApiCall(apiCall);
    }

    @Override
    public void closeAdLoading() {
        if (this.pbLoadingPreroll != null) {
            this.pbLoadingPreroll.setVisibility(8);
        }
        if (this.loadingAdView != null) {
            this.loadingAdView.setVisibility(8);
        }
        if (this.isPlayerControlsEnabled) {
            this.playerView.setUseController(true);
        } else {
            this.playerView.setUseController(false);
        }
    }

    public void showAdLoading() {
        this.pbLoadingPreroll.setVisibility(0);
        this.loadingAdView.setVisibility(0);
        this.playerView.hideController();
        this.playerView.setUseController(false);
    }

    @Override
    public void loadPlaylist(int playerId, int playlistId) {
        this.loadPlaylist(playerId, playlistId, this);
    }

    @Override
    public void loadPlaylistPagination(int playerID, int playlistId, int page, int items) {
        this.loadPlaylistPagination(playerID, playlistId, page, items, this);
    }

    public void loadPlaylist(int playerId, int playlistId, FetchData callback2) {
        Utils.log(this.getClass(), "loadPlaylist", new String[0]);
        this.setPlaylistId(playlistId);
        GetPlaylist apiCall = new GetPlaylist(playerId, playlistId, callback2);
        this.makeApiCall(apiCall);
    }

    public void loadPlaylistPagination(int playerID, int playlistId, int page, int items, FetchData callback2) {
        Utils.log(this.getClass(), "loadPlaylistPagination", new String[0]);
        this.setPlaylistId(playlistId);
        this.resetPlayerBeforeFetchingData();
        GetPlaylistPagination apiCall = new GetPlaylistPagination(playerID, playlistId, page, items, callback2);
        this.makeApiCall(apiCall);
    }

    @Override
    public void loadFromConfig(String config) {
    }

    public void loadPlaylistForChannel(int playerId, int channelId, int page, int item) {
        this.loadPlaylistForChannel(playerId, channelId, page, item, this);
    }

    public void loadPlaylistForChannel(int playerId, int channelId, int page, int item, FetchData callback2) {
        Utils.log(this.getClass(), "loadPlaylist", new String[0]);
        GetPlaylistByChannel apiCall = new GetPlaylistByChannel(playerId, this, channelId);
        this.makeApiCall(apiCall);
    }

    public void loadLatestPlaylists(int playerId, int page, int item) {
        this.loadLatestPlaylists(playerId, page, item, this);
    }

    public void loadLatestPlaylists(int playerId, int page, int item, FetchData callback2) {
        Utils.log(this.getClass(), "loadPlaylist", new String[0]);
        GetLatestConfig getLatestConfig = new GetLatestConfig(playerId, callback2);
        ApiCall apiCall = this.sdkContainer.provide(GetLatest.class, getLatestConfig);
        this.makeApiCall(apiCall);
    }

    public void loadPlaylistForTag(int playerId, String tagType, int page, int item) {
        this.loadPlaylistForTag(playerId, tagType, page, item, this);
    }

    public void loadPlaylistForTag(int playerId, String tagType, int page, int item, FetchData callback2) {
        Utils.log(this.getClass(), "loadPlaylist", new String[0]);
        GetPlaylistByTag apiCall = new GetPlaylistByTag(playerId, callback2, tagType);
        this.makeApiCall(apiCall);
    }

    @Override
    public void setBridListener(BridPlayerListener l) {
        mListener = l;
    }

    @Override
    public void setBridLogListener(BridPlayerLogListener l) {
        mLogListener = l;
    }

    public void setLoadingIndicator(boolean loadingIndicator) {
        this.loadingIndicator = loadingIndicator;
    }

    @Override
    public boolean isPlayingAd() {
        if (this.imaPlayer == null) {
            return false;
        }
        return this.imaPlayer.isAdPlaying();
    }

    @Override
    public boolean isPaused() {
        if (this.player != null) {
            return !this.player.isPlaying();
        }
        return false;
    }

    @Override
    public boolean isRepeated() {
        return this.isRepeated;
    }

    @Override
    public long getCurrentPosition() {
        if (this.player != null) {
            return this.player.getCurrentPosition();
        }
        return 0L;
    }

    @Override
    public long getDuration() {
        if (this.player != null) {
            return this.player.getDuration();
        }
        return 0L;
    }

    @Override
    public View getPlayerView(boolean getPlayerView) {
        return getPlayerView ? this.playerView : this.view;
    }

    @Override
    @OptIn(markerClass={UnstableApi.class})
    public BridStyledPlayerView getPlayerView() {
        return this.playerView;
    }

    public int getCurrentVideoIndex() {
        return this.currentVideo;
    }

    @Override
    public Video getCurrentVideo() {
        Utils.log(this.getClass(), "getCurrentVideo", String.valueOf(this.currentVideo));
        if (this.currentVideo < 0 || this.currentVideo >= this.videoVOS.size()) {
            return null;
        }
        return this.videoVOS.get(this.currentVideo);
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    @Override
    public void setAutoPlay(boolean autoplay) {
        this.forceAutoplay = autoplay;
    }

    @Override
    public void setAd(String adTag, int adType, String adTimeType, String cuepoints, boolean addAdToStart) {
    }

    @Override
    public boolean isVpaidEnabled() {
        return this.useVPAID;
    }

    @Override
    public void enableAdControls(boolean isEnabled) {
        this.adControlsEnabled = isEnabled;
    }

    @Override
    public void enableAutoplay(boolean isAutoplay) {
        this.isAutoPlayEnabled = isAutoplay;
    }

    @Override
    public void enablePlayerControls(boolean isEnabled) {
        this.isPlayerControlsEnabled = isEnabled;
    }

    @Override
    public void setCornerRadius(int cornerRadius) {
        this.cornerRadius = cornerRadius;
    }

    @Override
    public void setCreditsLabelColor(String labelColor) {
        this.creditsLabelColor = labelColor;
    }

    @Override
    public boolean isAutoplay() {
        if (this.playerVO != null) {
            return this.playerVO.getAutoplay();
        }
        return false;
    }

    @Override
    public boolean isAutoplayEnabled() {
        return this.isAutoPlayEnabled;
    }

    @Override
    public boolean isAdControlsEnabled() {
        return this.adControlsEnabled && !UtilsKt.isSDKRunningOnTvDevice(this.context);
    }

    private void disableButtonsForTV() {
        this.tvMode = true;
    }

    @Override
    public void play() {
        Utils.log(this.getClass(), "play", new String[0]);
        if (this.isPlayingAd() && this.imaPlayer != null) {
            this.imaPlayer.onResumeEvent(1);
        } else if (this.player != null) {
            this.player.prepare();
            this.player.setPlayWhenReady(true);
            this.playerView.setPlayer((Player)this.player);
        }
        if (mListener != null) {
            mListener.onEvent("play", this.getPlayerReference());
        }
    }

    @Override
    public void clickPlay() {
        if (this.isFirstPlaying) {
            this.isFirstPlaying = false;
            this.bridPlayerEngine.startPlay();
        } else {
            this.playerView.setPlayer((Player)this.player);
            this.player.setPlayWhenReady(true);
        }
    }

    @Override
    public void setTvProgressBarEnable(Boolean isEnabled) {
        if (this.visual != null) {
            this.visual.setProgressBarTvShow(isEnabled);
        }
    }

    @Override
    @OptIn(markerClass={UnstableApi.class})
    public void enterPictureInPictureMode() {
        if (this.isPipEnabled) {
            if (this.playerView != null) {
                if (this.bridPoster.isPosterShowing()) {
                    this.hidePoster();
                }
                if (this.playlistHolder.getVisibility() == 0) {
                    this.hidePlaylistMobile();
                }
                this.playerView.enterPipMode();
            } else {
                Utils.log(this.getClass(), "enterPictureInPictureMode", "Ad is currently playing, you can't enter PIP mode");
            }
        } else {
            Utils.log(this.getClass(), "enterPictureInPictureMode", "PIP is not enabled, you need to enabled first in CMS");
        }
    }

    @Override
    @OptIn(markerClass={UnstableApi.class})
    public void onPictureInPictureModeChanged(boolean isInPictureInPictureMode, Configuration newConfig) {
        if (this.isPipEnabled) {
            if (this.playerView != null) {
                this.isInPipMode = isInPictureInPictureMode;
                this.playerView.onPictureInPictureModeChanged(isInPictureInPictureMode, newConfig);
                if (mListener != null) {
                    if (isInPictureInPictureMode) {
                        mListener.onEvent("enpip", this.getPlayerReference());
                    } else {
                        mListener.onEvent("expip", this.getPlayerReference());
                    }
                }
            } else {
                Utils.log(this.getClass(), "enterPictureInPictureMode", "PlayerView is null");
            }
        } else {
            Utils.log(this.getClass(), "enterPictureInPictureMode", "PIP is not enabled, you need to enabled first in CMS");
        }
    }

    @Override
    public void setCaptionsBottomOffset(int offsetInPixels) {
        this.ccBottomOffset = offsetInPixels;
    }

    @Override
    public void showProgressCountdownVideo() {
        this.countablePlayView = new CountablePlayView(this.context);
        this.countablePlayView.setCountFinishedListener(new CountFinishedListener(){

            @Override
            public void onCountdownFinished() {
                BridPlayerImpl.this.hideProgressCountdownVideo();
                BridPlayerImpl.this.bridPlayerEngine.onNextVideoCalled();
                BridPlayerImpl.this.bridPlayerEngine.startPlay();
            }

            @Override
            public void onCountdownCanceled() {
                BridPlayerImpl.this.hideProgressCountdownVideo();
                BridPlayerImpl.this.bridPlayerEngine.restart();
                BridPlayerImpl.this.bridPlayerEngine.startPlay();
            }
        });
        this.countablePlayView.setPoster(this.videoVOS.get(this.currentVideo + 1));
        ViewGroup.LayoutParams layoutParams = this.playerView.getLayoutParams();
        this.countablePlayView.setLayoutParams(layoutParams);
        ((ViewGroup)this.playerView.getParent()).addView((View)this.countablePlayView);
    }

    @Override
    public void setProgressCountdownVideo(int progress) {
    }

    @Override
    public void hideProgressCountdownVideo() {
        if (this.countablePlayView != null && this.countablePlayView.getParent() != null) {
            ((ViewGroup)this.countablePlayView.getParent()).removeView((View)this.countablePlayView);
        }
    }

    @Override
    public void pause() {
        Utils.log(this.getClass(), "pause", new String[0]);
        if (this.player != null && !this.isPlayingAd()) {
            this.player.setPlayWhenReady(false);
            this.sendAnalytics(new AnalyticData("pa", null));
            if (mListener != null) {
                mListener.onEvent("pause", this.getPlayerReference());
            }
        } else if (this.isPlayingAd()) {
            this.imaPlayer.pause();
        }
    }

    @Override
    public void setRenditionText(String rendition) {
        Utils.log(this.getClass(), "setRenditionText", rendition);
        if (this.txtResolutionSD != null) {
            this.txtResolutionSD.setText((CharSequence)rendition);
        }
    }

    @Override
    public void previous() {
        Utils.log(this.getClass(), "previous", new String[0]);
        if (this.currentVideo != 0 && !this.isPlayingAd()) {
            this.bridPlayerEngine.onPreviousVideoCalled();
        }
    }

    @Override
    public void next() {
        Utils.log(this.getClass(), "next", new String[0]);
        if (this.currentVideo != this.videoVOS.size() && !this.isPlayingAd() && !this.isPlayingAd()) {
            this.bridPlayerEngine.onNextVideoCalled();
        }
    }

    @Override
    public void setFullScreen(boolean on) {
        Utils.log(this.getClass(), "setFullScreen", new String[0]);
        if (this.player != null) {
            if (on && !this.playerFullscreen) {
                this.openFullscreenDialog();
            } else if (!on && this.playerFullscreen) {
                this.closeFullscreenDialog();
            }
        }
    }

    @Override
    public boolean isFullscreen() {
        return this.playerFullscreen;
    }

    @Override
    public boolean isMuted() {
        return this.isMuted;
    }

    @Override
    public void setMute(boolean mute) {
        Utils.log(this.getClass(), "setMute", String.valueOf(mute));
        this.changeMute(mute, false);
    }

    @Override
    public void onSeeked(long value) {
        Utils.log(this.getClass(), "seekTo", new String[0]);
        if (this.player != null && !this.isPlayingAd()) {
            this.player.seekTo(0, value);
        }
    }

    @Override
    public void resume() {
        Utils.log(this.getClass(), "resume", new String[0]);
    }

    @Override
    public void reset() {
        Utils.log(this.getClass(), "reset", new String[0]);
        if (this.mSession != null) {
            this.mSession.release();
            this.mSession = null;
        }
        this.releasePlayer();
        this.killAdPlayer();
    }

    @Override
    public void release() {
        Utils.log(this.getClass(), "release", new String[0]);
        this.reset();
    }

    @Override
    public void fastForward() {
        Utils.log(this.getClass(), "fastForward", new String[0]);
        this.player.seekForward();
        this.player.setPlayWhenReady(true);
    }

    @Override
    public void fastBack() {
        Utils.log(this.getClass(), "fastBack", new String[0]);
        this.player.seekBack();
        this.player.setPlayWhenReady(true);
    }

    @Override
    @OptIn(markerClass={UnstableApi.class})
    public void showControls() {
        Utils.log(this.getClass(), "showControls", new String[0]);
        this.playerView.showController();
        this.setFocusOnPlayButtonTV();
    }

    @Override
    @OptIn(markerClass={UnstableApi.class})
    public void hideControls() {
        Utils.log(this.getClass(), "hideControls", new String[0]);
        this.playerView.hideController();
    }

    @Override
    public void showNetworkErrorView() {
        ErrorViewConfig errorViewConfig = new ErrorViewConfig(null, null, null, R.drawable.wifi_off);
        ErrorView errorView = new ErrorView(this.context, errorViewConfig){};
        ViewGroup.LayoutParams layoutParams = this.playerView.getLayoutParams();
        if (Build.VERSION.SDK_INT >= 23) {
            this.networkErrorView = errorView.create();
        }
        this.playerView.addView(this.networkErrorView, layoutParams);
    }

    @Override
    public void dismissNetworkErrorView() {
        if (this.networkErrorView != null && this.networkErrorView.getParent() != null) {
            ((ViewGroup)this.networkErrorView.getParent()).removeView(this.networkErrorView);
            this.networkErrorView = null;
        }
    }

    @OptIn(markerClass={UnstableApi.class})
    public void onClick(View view) {
        Utils.log(this.getClass(), "onClick", view.toString());
        if (this.player == null) {
            return;
        }
        if (view.getId() == R.id.exo_resolution_SD) {
            this.bridPlayerEngine.renditionChangeCalled();
        } else if (view.getId() == R.id.exo_fullscreen_brid) {
            if (!this.playerFullscreen) {
                if (this.isVttEnabled == 2) {
                    this.progressBar.setPreviewEnabled(true);
                }
                this.openFullscreenDialog();
            } else {
                if (this.isVttEnabled == 2) {
                    this.progressBar.setPreviewEnabled(false);
                }
                this.closeFullscreenDialog();
            }
        } else if (view.getId() == R.id.exo_mute) {
            if (this.playerVO.getUnmute_button().booleanValue() && this.isMuted) {
                this.hideUnmuteButton();
            } else {
                this.changeMute(!this.isMuted, true);
            }
        } else if (view.getId() == R.id.exo_share) {
            this.sendAnalytics(new AnalyticData("sh", null));
            Intent i = new Intent("android.intent.action.SEND");
            i.setType("text/plain");
            i.putExtra("android.intent.extra.SUBJECT", this.videoVOS.get(this.currentVideo).getName());
            i.putExtra("android.intent.extra.TEXT", "https://btv.social/" + this.videoVOS.get(this.currentVideo).getId() + "_" + this.playerVO.getId() + "/#cp");
            this.context.startActivity(Intent.createChooser((Intent)i, (CharSequence)this.context.getString(R.string.share_video)));
        } else if (view.getId() == R.id.exo_playlist) {
            this.showPlaylist(false);
            this.playerView.hideController();
        } else if (view.getId() == R.id.exo_subtitle) {
            this.showPlaylist(false);
            this.playerView.hideController();
        } else if (view.getId() == R.id.exo_close_playlist) {
            this.hidePlaylistMobile();
        } else if (view.getId() == R.id.brid_replay) {
            this.reinitializePlayReplayButton();
            this.player.seekTo(0L);
            this.player.setPlayWhenReady(true);
        } else if (view.getId() == R.id.brid_exo_prev) {
            this.hideControlsParentMobile();
            this.bridPlayerEngine.onPreviousVideoCalled();
        } else if (view.getId() == R.id.brid_exo_next) {
            this.hideControlsParentMobile();
            this.bridPlayerEngine.onNextVideoCalled();
        } else if (view.getId() == R.id.exo_play_pause) {
            this.btnPlay.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)this.playIcon));
            this.bridPlayerEngine.onPlayPauseStatusChanged();
        } else if (view.getId() == R.id.exo_play_pause_tv) {
            this.btnPlayTV.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)this.playIcon));
            this.bridPlayerEngine.onPlayPauseStatusChanged();
        } else if (view.getId() == R.id.unmuteLayout) {
            this.hideUnmuteButton();
        } else if (view.getId() == R.id.brid_minimise) {
            this.playerView.enterPipMode();
        } else if (view.getId() == R.id.exo_settings) {
            this.openSettingsMenuOnTv();
        }
    }

    private void openSettingsMenuOnTv() {
        if (this.isTvPlaylistOpen) {
            this.closePlaylistTv();
        }
        AlphaAnimation clickAnimation = new AlphaAnimation(0.0f, 1.0f);
        this.visual.controlAllTvPlayerControls(false);
        this.settingsHolderTv.startAnimation((Animation)clickAnimation);
        this.settingsHolderTv.setVisibility(0);
        if (this.settingsTvViewManager == null) {
            this.settingsTvViewManager = new SettingsTvViewManager(this.settingsHolderTv, this.context, new BridTvFocusChangeListener(this, this.visual), this);
        } else {
            this.settingsTvViewManager.setSettingsMenuOnTvOpen(true);
        }
    }

    public void closeSettingsMenuOnTv() {
        if (this.settingsTvViewManager.getSettingsMenuOnTvOpen().booleanValue()) {
            AlphaAnimation clickAnimation = new AlphaAnimation(1.0f, 0.0f);
            this.visual.controlAllTvPlayerControls(true);
            this.playerView.showController();
            this.settingsHolderTv.startAnimation((Animation)clickAnimation);
            this.settingsHolderTv.setVisibility(8);
            this.settingsTvViewManager.setSettingsMenuOnTvOpen(false);
            if (this.btnSettings != null) {
                this.btnSettings.requestFocus();
            }
        }
    }

    private void hideControlsParentMobile() {
        if (!UtilsKt.isSDKRunningOnTvDevice(this.context)) {
            this.centerControllsParent.setVisibility(8);
        }
    }

    private void hidePlaylistMobile() {
        this.playlistHolder.setVisibility(8);
        this.playlist.setVisibility(8);
        this.player.setPlayWhenReady(this.player.getPlayWhenReady());
        this.playerView.showController();
    }

    public void closePlaylistTv() {
        this.isTvPlaylistOpen = false;
        this.tvPlaylistHolder.setVisibility(8);
        this.btnPlaylist.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)this.playlistIcon));
        this.setFocusOnPlaylist();
    }

    public void changeVideoSource(String option) {
        Utils.log(this.getClass(), "changeVideoSource", option);
        this.bridPlayerEngine.changeRendition(option, this.getCurrentPosition());
    }

    private void showHideTitleBar(int visibility) {
        if (!UtilsKt.isSDKRunningOnTvDevice(this.context) && this.txtTitle != null) {
            this.txtTitle.setVisibility(Boolean.TRUE.equals(this.playerVO.getTitleBar()) && visibility == 0 && this.playlistHolder.getVisibility() != 0 ? 0 : 8);
        }
    }

    private void createDRMSource(Video videoVO, BridPlayerListener bridPlayerListener) {
        Utils.log(this.getClass(), "createDRMSource", new String[0]);
        DRMPlayer drmConfig = new DRMPlayer(this.context, this.player, videoVO, bridPlayerListener);
        drmConfig.playDRMVideo();
    }

    public void stop() {
        if (this.player != null) {
            this.player.stop();
        }
    }

    public void restartStream() {
        this.player.prepare();
        this.player.setPlayWhenReady(true);
    }

    private void restartPlayer() {
        this.player = null;
        this.initializePlayer();
    }

    @OptIn(markerClass={UnstableApi.class})
    private void initializePlayer() {
        Utils.log(this.getClass(), "initializePlayer", new String[0]);
        if (this.videoVOS == null || this.videoVOS.isEmpty()) {
            return;
        }
        if (this.playerVO != null) {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(this.playerView.getWidth(), Math.round(this.calculateVideoHeight()));
            this.playerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            if (this.playerDoubleTapOverlay != null) {
                this.playerDoubleTapOverlay.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        }
        this.player = this.sdkContainer.provide(ExoPlayer.class);
        this.player.setVideoFrameMetadataListener((VideoFrameMetadataListener)this);
        this.player.addListener((Player.Listener)this.playerEventListener);
        this.player.setAudioAttributes(AudioAttributes.DEFAULT, true);
        this.playerView.setPlayer((Player)this.player);
        if (this.playerDoubleTapOverlay != null) {
            this.playerDoubleTapOverlay.player((Player)this.player);
        }
        this.adProvider = new AdProvider(this.playerVO.getAd_schedule_id() == null ? "" : this.playerVO.getAd_schedule_id(), this.partnerVO.getAd_schedule_id(), this, this.playerVO.getBackfill_monetize(), this.partnerVO != null && this.partnerVO.getAdScheduleBackfill() != null ? this.partnerVO.getAdScheduleBackfill().getPrerolls().get(0).getMobile().getAdSources() : null, this.dontStackMidrolls, Integer.parseInt(this.partnerVO.getBackfill_split()));
        if (this.playerFullscreen) {
            this.setFullScreen(true);
        } else {
            this.setFullScreen(false);
        }
        if (mListener != null) {
            mListener.onEvent("pinit", this.getPlayerReference());
        }
    }

    private void initializeMediaSession(Video videoVO) {
        if (!(this.context instanceof Activity)) {
            Log.e((String)TAG, (String)"Provided context is not an Activity.");
            return;
        }
        if (UtilsKt.isSDKRunningOnTvDevice(this.context)) {
            return;
        }
        if (this.mSession == null) {
            this.mSession = new MediaSessionCompat(this.context, TAG);
            this.mSession.setActive(true);
            MediaControllerCompat.setMediaController((Activity)((Activity)this.context), (MediaControllerCompat)this.mSession.getController());
        }
        MediaMetadataCompat metadata = new MediaMetadataCompat.Builder().putString("android.media.metadata.DISPLAY_TITLE", videoVO != null ? videoVO.getName() : "BridTv Video").putString("android.media.metadata.TITLE", videoVO != null ? videoVO.getName() : "BridTv Video").putString("android.media.metadata.DISPLAY_DESCRIPTION", videoVO != null ? videoVO.getDescription() : "BridTv Video").putLong("android.media.metadata.DURATION", videoVO.getDuration() != null ? Long.parseLong(Objects.requireNonNull(videoVO.getDuration())) * 1000L : -1000L).putString("android.media.metadata.ART_URI", videoVO != null ? Uri.parse((String)videoVO.getImage()).toString() : "").putString("android.media.metadata.DISPLAY_ICON_URI", videoVO != null ? Uri.parse((String)videoVO.getImage()).toString() : "").build();
        this.mSession.setMetadata(metadata);
        if (this.mMediaSessionCallback == null) {
            this.mMediaSessionCallback = new MediaSessionCallback(this.playerView);
            this.mSession.setCallback((MediaSessionCompat.Callback)this.mMediaSessionCallback);
        }
        this.updateMediaSessionPlaybackState(videoVO);
    }

    private void updateMediaSessionPlaybackState(Video videoVO) {
        int state;
        int n = state = this.player.isPlaying() ? 3 : 2;
        if (this.currentVideo > 0 && this.currentVideo < this.videoVOS.size()) {
            this.updatePlaybackState(state, 822L, (int)this.player.getCurrentPosition(), videoVO != null ? videoVO.getId() : 1);
        } else if (this.currentVideo < 1) {
            this.updatePlaybackState(state, 806L, (int)this.player.getCurrentPosition(), videoVO != null ? videoVO.getId() : 1);
        } else {
            this.updatePlaybackState(state, 790L, (int)this.player.getCurrentPosition(), videoVO != null ? videoVO.getId() : 1);
        }
    }

    private void updatePlaybackState(int state, int position, int mediaId) {
        if (UtilsKt.isSDKRunningOnTvDevice(this.context)) {
            return;
        }
        if (!(this.context instanceof Activity)) {
            Log.e((String)TAG, (String)"Provided context is not an Activity.");
            return;
        }
        long actions = this.mSession.getController().getPlaybackState().getActions();
        this.updatePlaybackState(state, actions, position, mediaId);
    }

    private void updatePlaybackState(int state, long playbackActions, int position, int mediaId) {
        if (UtilsKt.isSDKRunningOnTvDevice(this.context)) {
            return;
        }
        if (!(this.context instanceof Activity)) {
            Log.e((String)TAG, (String)"Provided context is not an Activity.");
            return;
        }
        PlaybackStateCompat.Builder builder = new PlaybackStateCompat.Builder().setActions(playbackActions).setActiveQueueItemId((long)mediaId).setState(state, (long)position, 1.0f);
        this.mSession.setPlaybackState(builder.build());
    }

    @androidx.annotation.Nullable
    public MediaBrowserServiceCompat.BrowserRoot onGetRoot(@NonNull String clientPackageName, int clientUid, @androidx.annotation.Nullable Bundle rootHints) {
        return null;
    }

    public void onLoadChildren(@NonNull String parentId, @NonNull MediaBrowserServiceCompat.Result<List<MediaBrowserCompat.MediaItem>> result) {
    }

    private List<MediaItem> createMediaItems(Video videoVO, String videoUrl) {
        Utils.log(this.getClass(), "createMediaItems", videoUrl);
        ArrayList<MediaItem> mediaItems = new ArrayList<MediaItem>();
        MediaItem.Builder mediaItem = new MediaItem.Builder().setUri(videoUrl).setMediaId(String.valueOf(videoVO.getId())).setMediaMetadata(new MediaMetadata.Builder().setTitle((CharSequence)videoVO.getName()).setArtist((CharSequence)videoVO.getDescription()).setArtworkUri(Uri.parse((String)videoVO.getImage())).build());
        mediaItems.add(mediaItem.build());
        return mediaItems;
    }

    private void releasePlayer() {
        Utils.log(this.getClass(), "releasePlayer", new String[0]);
        if (this.player != null) {
            this.player.pause();
            this.player.release();
            this.isFirstPlaying = true;
            this.player = null;
        }
    }

    private void resetPlayerBeforeFetchingData() {
        Utils.log(this.getClass(), "resetPlayerBeforeFetchingData", new String[0]);
        if (this.networkParsingErrorHandler != null) {
            this.networkParsingErrorHandler.dismissHandler();
        }
        this.dismissNetworkErrorView();
        this.timeCreated = System.currentTimeMillis() / 1000L;
        this.playerContentFrame.setVisibility(0);
        this.playEnded = false;
        this.shouldAutoPlay = false;
        this.playInitiated = false;
        this.vpaidInProgress = false;
        this.currentVideo = -1;
        this.buttonsInitiatedFor = -1;
        this.playerVO = null;
        this.playlistVO = null;
        this.partnerVO = null;
        this.videoVOS = null;
        this.playListAdapter = null;
        this.adProvider = null;
        if (this.player != null) {
            this.player.setPlayWhenReady(false);
            this.player.seekTo(0L);
            this.playerView.hideController();
        }
        if (this.txtTitle != null) {
            this.txtTitle.setVisibility(0);
        }
        if (this.playlist != null) {
            this.playlist.setVisibility(8);
        }
        if (this.playlistHolder != null) {
            this.playlistHolder.setVisibility(8);
        }
        if (this.bridPoster != null) {
            this.hidePoster();
            this.bridPoster = null;
        }
        this.reinitializePlayReplayButton();
        this.releasePlayer();
        this.killAdPlayer();
    }

    private AutoplayMode determineAutoplayMode() {
        Utils.log(this.getClass(), "determineAutoplayMode", new String[0]);
        if (this.playerVO == null) {
            return null;
        }
        if (this.playerVO.getAutoplay().booleanValue()) {
            if (!this.playerVO.getAutoplay_wifi_only().booleanValue() && !this.playerVO.getAutoplay_on_ad().booleanValue()) {
                return AutoplayMode.ONLY_AUTOPLAY;
            }
            if (!this.playerVO.getAutoplay_wifi_only().booleanValue() && this.playerVO.getAutoplay_on_ad().booleanValue()) {
                if (this.existAd) {
                    return AutoplayMode.AUTOPLAY_IF_AD_PRESENT;
                }
                return AutoplayMode.AUTOPLAY_NO_AD;
            }
            if (this.playerVO.getAutoplay_wifi_only().booleanValue() && !this.playerVO.getAutoplay_on_ad().booleanValue()) {
                if (UtilsKt.isWifiConnected(this.context)) {
                    return AutoplayMode.AUTOPLAY_ON_WIFI_ONLY;
                }
                return AutoplayMode.AUTOPLAY_NONE;
            }
            if (this.playerVO.getAutoplay_wifi_only().booleanValue() && this.playerVO.getAutoplay_on_ad().booleanValue()) {
                if (UtilsKt.isWifiConnected(this.context) && this.existAd) {
                    return AutoplayMode.AUTOPLAY_IF_AD_AND_WIFI;
                }
                return AutoplayMode.AUTOPLAY_NO_AD;
            }
            if (!this.playerVO.getAutoplay_wifi_only().booleanValue() && this.playerVO.getAutoplay_on_ad().booleanValue() && !this.existAd) {
                return AutoplayMode.AUTOPLAY_NO_AD;
            }
        }
        return AutoplayMode.AUTOPLAY_NONE;
    }

    private void openFullscreenDialog() {
        if (mListener != null) {
            mListener.onEvent("fsreq", this.getPlayerReference());
        }
        this.originalPlayerParams = this.playerView.getLayoutParams();
        this.playerView.setSystemUiVisibility(4102);
        ((ViewGroup)this.playerView.getParent()).removeView((View)this.playerView);
        ((ViewGroup)this.playerDoubleTapOverlay.getParent()).removeView((View)this.playerDoubleTapOverlay);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        this.fullScreenDialog.addContentView((View)this.playerView, params);
        this.fullScreenDialog.addContentView((View)this.playerDoubleTapOverlay, params);
        this.playerFullscreen = true;
        if (!this.isTablet) {
            if (!this.isPlayerVertical()) {
                ((Activity)this.context).setRequestedOrientation(6);
            } else {
                ((Activity)this.context).setRequestedOrientation(7);
            }
        } else {
            ((Activity)this.context).setRequestedOrientation(4);
        }
        this.fullScreenDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                if (BridPlayerImpl.this.imaPlayer == null) {
                    BridPlayerImpl.this.showControls();
                    if (!BridPlayerImpl.this.isVideoPlaying) {
                        BridPlayerImpl.this.player.setPlayWhenReady(false);
                    }
                } else if (!BridPlayerImpl.this.imaPlayer.isAdInProgress()) {
                    BridPlayerImpl.this.showControls();
                    if (!BridPlayerImpl.this.isVideoPlaying) {
                        BridPlayerImpl.this.player.setPlayWhenReady(false);
                    }
                } else {
                    BridPlayerImpl.this.playerView.hideController();
                }
                if (mListener != null) {
                    mListener.onEvent("fsendreq", BridPlayerImpl.this.getPlayerReference());
                }
                if (!BridPlayerImpl.this.isTablet) {
                    ((Activity)BridPlayerImpl.this.context).setRequestedOrientation(1);
                } else {
                    ((Activity)BridPlayerImpl.this.context).setRequestedOrientation(4);
                }
            }
        });
        if (this.imaPlayer != null) {
            if (!this.imaPlayer.isAdInProgress()) {
                this.setDrawableForButton(this.btnFullScreen, this.fullscreenOffDrawable, this.fullscreenCloseIcon, this.context);
            }
        } else {
            this.setDrawableForButton(this.btnFullScreen, this.fullscreenOffDrawable, this.fullscreenCloseIcon, this.context);
        }
        this.fullScreenDialog.show();
        this.sendAnalytics(new AnalyticData("fs", null));
    }

    private void closeFullscreenDialog() {
        this.isVideoPlaying = this.player.isPlaying();
        ((ViewGroup)this.playerView.getParent()).removeView((View)this.playerView);
        ((ViewGroup)this.playerDoubleTapOverlay.getParent()).removeView((View)this.playerDoubleTapOverlay);
        this.setTimelineVisibility(true);
        this.playerFullscreen = false;
        this.fullScreenDialog.dismiss();
        this.playerView.setSystemUiVisibility(0);
        this.playerHolder.post(new Runnable(){

            @Override
            public void run() {
                BridPlayerImpl.this.playerHolder.addView((View)BridPlayerImpl.this.playerView, BridPlayerImpl.this.originalPlayerParams);
                BridPlayerImpl.this.playerHolder.addView((View)BridPlayerImpl.this.playerDoubleTapOverlay, BridPlayerImpl.this.originalPlayerParams);
                BridPlayerImpl.this.playerView.layout(BridPlayerImpl.this.playerView.getLeft(), BridPlayerImpl.this.playerView.getTop(), BridPlayerImpl.this.playerView.getRight(), BridPlayerImpl.this.playerView.getBottom());
                BridPlayerImpl.this.playerDoubleTapOverlay.layout(BridPlayerImpl.this.playerView.getLeft(), BridPlayerImpl.this.playerView.getTop(), BridPlayerImpl.this.playerView.getRight(), BridPlayerImpl.this.playerView.getBottom());
            }
        });
        if (!this.isTablet) {
            ((Activity)this.context).setRequestedOrientation(1);
        } else {
            ((Activity)this.context).setRequestedOrientation(4);
        }
        this.btnFullScreen.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.exo_controls_brid_open_fullscreen));
        this.sendAnalytics(new AnalyticData("fs", null));
        if (mListener != null) {
            mListener.onEvent("fsendreq", this.getPlayerReference());
        }
    }

    public void dismissFullscreenDialog() {
        this.isVideoPlaying = this.player.isPlaying();
        ((ViewGroup)this.playerView.getParent()).removeView((View)this.playerView);
        this.playerFullscreen = false;
        this.fullScreenDialog.dismiss();
        this.playerView.setSystemUiVisibility(0);
        this.playerHolder.post(new Runnable(){

            @Override
            public void run() {
                BridPlayerImpl.this.playerHolder.addView((View)BridPlayerImpl.this.playerView, new ViewGroup.LayoutParams(-1, -1));
                BridPlayerImpl.this.playerView.layout(BridPlayerImpl.this.playerHolder.getLeft(), BridPlayerImpl.this.playerHolder.getTop(), BridPlayerImpl.this.playerHolder.getRight(), BridPlayerImpl.this.playerHolder.getBottom());
            }
        });
        if (!this.isTablet) {
            ((Activity)this.context).setRequestedOrientation(1);
        } else {
            ((Activity)this.context).setRequestedOrientation(4);
        }
        this.btnFullScreen.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)this.fullscreenCloseIcon));
        this.sendAnalytics(new AnalyticData("fs", null));
        this.setVisibilityToPlayerControlsLayout(false);
        if (mListener != null) {
            mListener.onEvent("fsendreq", this.getPlayerReference());
        }
    }

    public void setVisibilityToPlayerControlsLayout(boolean setVisible) {
        if (Boolean.TRUE.equals(this.playerVO.getControls()) && !UtilsKt.isSDKRunningOnTvDevice(this.context)) {
            this.visual.controlAllPlayerControls(setVisible);
        }
    }

    private void sendAnalytics(String event, String adErrorCode) {
        String devicePlatform;
        Utils.log(this.getClass(), "sendAnalytics", event);
        int playerVisiblePercentage = UtilsKt.getVisiblePercentage((View)this.playerView);
        int inView = playerVisiblePercentage >= 50 ? 1 : 0;
        String pub = "";
        if (this.adAnalyticDC != null) {
            pub = !this.adAnalyticDC.isPartnerAd() ? "p" : "b";
        }
        String at = "";
        if (this.adAnalyticDC != null) {
            at = String.valueOf(this.adAnalyticDC.getAdType());
        }
        String adPos = this.adAnalyticDC == null ? "" : String.valueOf(this.adAnalyticDC.getAdPosition());
        String wpPos = this.adAnalyticDC == null ? "" : String.valueOf(this.adAnalyticDC.getAdWaterfallPosition());
        String adId = this.adAnalyticDC == null ? "" : String.valueOf(this.adAnalyticDC.getAdSourceId());
        String adSchedule = this.adAnalyticDC == null ? "" : String.valueOf(this.adAnalyticDC.getAdScheduleId());
        Video v = this.getCurrentVideo();
        int videoId = v != null ? v.getId() : 0;
        String playerSize = this.playerView.getWidth() + "|" + Math.round(this.calculateVideoHeight());
        String isDrm = (v != null ? v.getDrmConfig() : null) == null ? "" : "d";
        String string2 = devicePlatform = UtilsKt.isSDKRunningOnTvDevice(this.context) ? "s" : "m";
        if (this.partnerVO == null || this.playerVO == null) {
            return;
        }
        Analytics analytics = new Analytics();
        String data = null;
        try {
            data = analytics.createLogStatData(String.valueOf(this.partnerVO.getId()), String.valueOf(this.playerVO.getOwner_id()), String.valueOf(this.playerVO.getId()), String.valueOf(videoId), event, playerSize, at, wpPos, adErrorCode, pub, devicePlatform, String.valueOf(inView), adPos, adId, isDrm, adSchedule, this.playlistId, v != null ? v.getChannel() : null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AnalyticService analyticService = this.sdkContainer.provide(AnalyticService.class);
        analyticService.sendAnalytics(data);
    }

    @Override
    public void sendAnalytics(AnalyticData event) {
        if (event.getEventCode() == null) {
            this.sendAnalytics(event.getEventTag(), "");
        } else {
            this.sendAnalytics(event.getEventTag(), String.valueOf(event.getEventCode()));
        }
    }

    public void sendAdAnalytics(String status, double timeOffset, String adErrorCode) {
        this.toast("Ad status: " + status + ", offset: " + timeOffset, 4);
        this.sendAnalytics(status, adErrorCode);
        if (mListener != null) {
            mListener.onEvent(status, this.getPlayerReference());
        }
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int position, long id2) {
        Utils.log(this.getClass(), "onItemClick", String.valueOf(position));
        if (adapterView == this.playlist) {
            this.playlist.setVisibility(8);
            this.playlistHolder.setVisibility(8);
            this.reinitializePoster(this.videoVOS, position);
            this.reinitializePlayReplayButton();
            this.gotoVideoIndex(position);
        }
    }

    @OptIn(markerClass={UnstableApi.class})
    private boolean isHlsVideo() {
        return this.player.getCurrentManifest() != null && this.player.getCurrentManifest() instanceof HlsManifest;
    }

    @OptIn(markerClass={UnstableApi.class})
    private boolean isLiveStreamVideo() {
        return this.isHlsVideo() && !((HlsManifest)this.player.getCurrentManifest()).mediaPlaylist.hasEndTag;
    }

    private void setFocusOnPlayButtonTV() {
        if (this.btnPlayTV != null) {
            this.btnPlayTV.requestFocus();
        }
    }

    private void gotoVideoIndex(int videoIndex) {
        Utils.log(this.getClass(), "gotoVideoIndex", String.valueOf(videoIndex));
        this.bridPlayerEngine.onVideoSeeked(videoIndex);
    }

    @Override
    public void playAd(String adUrl) {
        Utils.log(this.getClass(), "playAd", new String[0]);
        this.hidePoster();
        this.hideControlsParentMobile();
        this.hideControls();
    }

    private void setVideoName(Video video) {
        if (UtilsKt.isSDKRunningOnTvDevice(this.context)) {
            if (this.txtTVTitle != null) {
                this.txtTVTitle.setText((CharSequence)video.getName());
            }
            if (this.txtTitle != null) {
                this.txtTitle.setText((CharSequence)"");
            }
        } else {
            if (this.txtTitle != null) {
                this.txtTitle.setText((CharSequence)video.getName());
            }
            if (this.txtTVTitle != null) {
                this.txtTVTitle.setText((CharSequence)"");
            }
        }
    }

    @Override
    public void prepareVideo(Video videoVO, int videoIndex, String videoUrl) {
        Utils.log(this.getClass(), "prepareVideo", String.valueOf(this.currentVideo), String.valueOf(videoIndex));
        this.setShareOptionsVisibility(false);
        this.currentVideo = videoIndex;
        this.generateSeekCaption(this.isVttEnabled, videoVO);
        boolean currentPlayerState = false;
        if (this.player != null) {
            currentPlayerState = this.player.getPlayWhenReady();
            this.player.clearMediaItems();
        }
        this.setVideoName(videoVO);
        if (videoVO.getDrmConfigVO() != null && videoVO.getDrmConfigVO().getWidevine() != null) {
            this.createDRMSource(videoVO, mListener);
        } else if (videoUrl.contains(".m3u8")) {
            this.player.setMediaSource(this.sdkContainer.provide(MediaSource.class, Uri.parse((String)videoUrl)));
            if (mListener != null) {
                mListener.onEvent("pload", this.getPlayerReference());
            }
        } else {
            boolean haveResumePosition;
            this.mediaItems = this.createMediaItems(videoVO, videoUrl);
            if (this.mediaItems.isEmpty()) {
                return;
            }
            boolean bl = haveResumePosition = this.resumeWindow != -1;
            if (haveResumePosition && this.player != null) {
                this.player.seekTo(this.resumeWindow, this.resumePosition);
            }
            if (this.player != null) {
                this.player.setMediaItems(this.mediaItems, !haveResumePosition);
                this.player.prepare();
                this.player.setPlayWhenReady(currentPlayerState);
            }
            if (mListener != null) {
                mListener.onEvent("pload", this.getPlayerReference());
            }
            this.hideBigLoading();
        }
        if (this.currentVideo != this.buttonsInitiatedFor) {
            SharedPreferences prefs = this.context.getApplicationContext().getSharedPreferences("BridPlayer" + this.playerVO.getId(), 0);
            prefs.edit().putInt("videosPlayed", prefs.getInt("videosPlayed", 0) + 1).apply();
        }
        this.addTrackSubtitles(videoVO.getTracks(), this.autoplayCC);
        this.initializeMediaSession(videoVO);
    }

    @Override
    public void playTrack(int videoIndex, int minWidth, int minHeight, int maxWidth, int maxHeight) {
        Utils.log(this.getClass(), "playTrack", new String[0]);
        this.currentVideo = videoIndex;
        this.player.setTrackSelectionParameters(this.player.getTrackSelectionParameters().buildUpon().setMinVideoSize(minWidth, minHeight).setMaxVideoSize(maxHeight, maxHeight).build());
    }

    @Override
    public void setPreviousButtonVisibility(boolean visibility) {
        Utils.log(this.getClass(), "setPreviousButtonVisibility", String.valueOf(visibility));
        if (this.btnPrev == null) {
            return;
        }
        if (this.playerVO.getControls().booleanValue() && visibility) {
            this.btnPrev.setVisibility(0);
        } else {
            this.btnPrev.setVisibility(4);
        }
    }

    @Override
    public void setNextButtonVisibility(boolean visibility) {
        Utils.log(this.getClass(), "setNextButtonVisibility", String.valueOf(visibility));
        if (this.btnNext == null) {
            return;
        }
        if (this.playerVO.getControls().booleanValue() && visibility) {
            this.btnNext.setVisibility(0);
        } else {
            this.btnNext.setVisibility(4);
        }
    }

    @Override
    public void setTimelineVisibility(boolean visibility) {
        Utils.log(this.getClass(), "ShowController-BridPlayer-setTimelineVisibility", new String[0]);
        if (visibility && UtilsKt.isSDKRunningOnTvDevice(this.context)) {
            this.showControls();
        } else {
            this.hideControls();
        }
    }

    @Override
    public void setControllerVisibility(boolean visibility) {
        Utils.log(this.getClass(), "ShowController-BridPlayer-setControllerVisibility", new String[0]);
        if (UtilsKt.isSDKRunningOnTvDevice(this.context)) {
            this.hideControls();
        } else if (visibility) {
            this.showControls();
        } else {
            this.playerView.hideController();
        }
    }

    public boolean IsTV() {
        return UtilsKt.isSDKRunningOnTvDevice(this.context);
    }

    @Override
    public void setStartButtonVisibility(boolean visibility) {
        Utils.log(this.getClass(), "setStartButtonVisibility", String.valueOf(visibility));
        if (this.btnStart != null) {
            this.btnStart.setVisibility(visibility ? 0 : 8);
        }
    }

    @Override
    public void setPlayButtonVisiblity(boolean visiblity) {
        Utils.log(this.getClass(), "setPlayButtonVisiblity", String.valueOf(visiblity));
        if (this.btnPlay != null) {
            this.btnPlay.setVisibility(visiblity ? 0 : 8);
            if (!this.playerVO.getControls().booleanValue()) {
                this.btnPlay.setVisibility(4);
            }
        }
    }

    @Override
    public void seekToPosition(long position) {
        Utils.log(this.getClass(), "seekToPosition", String.valueOf(position));
        this.bridPlayerEngine.onPositionSeeked(position);
        if (mListener != null) {
            mListener.onEvent("vseek", this.getPlayerReference());
        }
    }

    @Override
    public void showRenditionOptions(Map<String, String> renditions, String selectedRendition) {
        Utils.log(this.getClass(), "showRenditionOptions", selectedRendition);
        this.resolutionView = this.isLiveStreamVideo() ? new HlsResolutionView(this.customController, () -> {}, option -> this.changeVideoSource(option), renditions, this.txtResolutionSD.getText().toString()) : new ResolutionView(this.customController, () -> {}, option -> this.changeVideoSource(option), renditions, this.txtResolutionSD.getText().toString());
    }

    @Override
    public void setShareOptionsVisibility(boolean visibility) {
        Utils.log(this.getClass(), "setShareOptionsVisibility", new String[0]);
        if (this.txtTitle != null) {
            this.txtTitle.setVisibility(4);
        }
        this.exoShareOverlay.setVisibility(visibility ? 0 : 8);
    }

    @Override
    public void hidePoster() {
        Utils.log(this.getClass(), "hidePoster", new String[0]);
        AlphaAnimation fadeOutAnimation = new AlphaAnimation(1.0f, 0.0f);
        fadeOutAnimation.setDuration(300L);
        fadeOutAnimation.setFillAfter(true);
        if (this.adProvider != null && this.adProvider.getCurrentAdType() != 1) {
            this.closeAdLoading();
        }
        if (this.bridPoster != null && this.bridPoster.getParent() != null) {
            this.bridPoster.startAnimation((Animation)fadeOutAnimation);
            ((ViewGroup)this.bridPoster.getParent()).removeView((View)this.bridPoster);
        }
    }

    @Override
    public void showPoster() {
        Utils.log(this.getClass(), "showPoster", new String[0]);
        if (this.bridPoster != null && !this.isInPipMode) {
            ViewGroup.LayoutParams layoutParams = this.playerView.getLayoutParams();
            this.bridPoster.setLayoutParams(layoutParams);
            ((ViewGroup)this.playerView.getParent()).addView((View)this.bridPoster);
            this.hideControls();
            if (UtilsKt.isSDKRunningOnTvDevice(this.context)) {
                this.bridPoster.getPlayButton().requestFocus();
            }
        }
    }

    @Override
    public void showPlaylist(boolean isPlayButtonChange) {
        if (!UtilsKt.isSDKRunningOnTvDevice(this.context)) {
            this.showPlaylistMobile(isPlayButtonChange);
        } else if (!this.isTvPlaylistOpen) {
            this.showPlaylistTv();
        } else {
            this.closePlaylistTv();
        }
    }

    public void setFocusOnPlaylist() {
        if (this.isTvPlaylistOpen) {
            this.btnPrev.setNextFocusUpId(R.id.video_list);
            this.btnNext.setNextFocusUpId(R.id.video_list);
            this.btnSettings.setNextFocusUpId(R.id.video_list);
            this.btnPlaylist.setNextFocusUpId(R.id.video_list);
            this.btnCC.setNextFocusUpId(R.id.video_list);
        } else {
            this.btnPrev.setNextFocusUpId(R.id.exo_progress);
            this.btnNext.setNextFocusUpId(R.id.exo_progress);
            this.btnSettings.setNextFocusUpId(R.id.exo_progress);
            this.btnPlaylist.setNextFocusUpId(R.id.exo_progress);
            this.btnCC.setNextFocusUpId(R.id.exo_progress);
        }
    }

    @Override
    @SuppressLint(value={"NotifyDataSetChanged"})
    public void showPlaylistTv() {
        this.isTvPlaylistOpen = true;
        this.btnPlaylist.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)this.exitIcon));
        this.tvPlaylistHolder.setVisibility(0);
        this.setFocusOnPlaylist();
        if (this.playlistTvAdapter == null) {
            this.playlistTvAdapter = new PlaylistTvAdapter(this.context, this.videoVOS, this.currentVideo, new PlaylistTvAdapter.OnItemClickListener(){

                @Override
                public void onItemClick(int position) {
                    BridPlayerImpl.this.closePlaylistTv();
                    BridPlayerImpl.this.reinitializePoster(BridPlayerImpl.this.videoVOS, position);
                    BridPlayerImpl.this.gotoVideoIndex(position);
                }

                @Override
                public void onItemBackClick() {
                    BridPlayerImpl.this.closePlaylistTv();
                }
            });
            this.playlistTvAdapter.setPlaceholderResId(this.placeholderPosterImageRes);
            this.rvPlaylistTv.setAdapter((RecyclerView.Adapter)this.playlistTvAdapter);
            this.setFocusOnElementTv();
        } else {
            this.playlistTvAdapter.setCurrentVideo(this.currentVideo);
            this.playlistTvAdapter.notifyDataSetChanged();
            this.setFocusOnElementTv();
        }
    }

    public void setFocusOnElementTv() {
        if (this.rvPlaylistTv == null) {
            return;
        }
        final LinearLayoutManager layoutManager = (LinearLayoutManager)this.rvPlaylistTv.getLayoutManager();
        this.rvPlaylistTv.post(new Runnable(){

            @Override
            public void run() {
                layoutManager.smoothScrollToPosition(BridPlayerImpl.this.rvPlaylistTv, new RecyclerView.State(), BridPlayerImpl.this.playlistTvAdapter.getLastSelectedPosition());
                RecyclerView.ViewHolder firstViewHolder = BridPlayerImpl.this.rvPlaylistTv.findViewHolderForAdapterPosition(BridPlayerImpl.this.playlistTvAdapter.getLastSelectedPosition());
                if (firstViewHolder != null) {
                    firstViewHolder.itemView.requestFocus();
                }
            }
        });
    }

    private void showPlaylistMobile(boolean isPlayButtonChange) {
        if (!this.isInPipMode) {
            Utils.log(this.getClass(), "showPlaylist", new String[0]);
            ViewGroup.LayoutParams params = this.playlist.getLayoutParams();
            params.height = this.playerOverlayWrapper.getHeight();
            this.playlist.setLayoutParams(params);
            if (this.playListAdapter == null) {
                this.playListAdapter = new PlaylistAdapter(this.context, this.videoVOS, this.currentVideo);
                this.playlist.setAdapter((ListAdapter)this.playListAdapter);
            } else {
                this.playListAdapter.setCurrentVideo(this.currentVideo);
                this.playListAdapter.notifyDataSetChanged();
            }
            this.playListAdapter.setPlaceholderResId(this.placeholderPosterImageRes);
            this.playlistHolder.setVisibility(0);
            this.playlist.setVisibility(0);
            this.playlist.bringToFront();
            this.playAfterPlaylistClosed = this.player.getPlayWhenReady();
            this.pause();
            this.sendAnalytics(new AnalyticData("pl", null));
            this.closeAdLoading();
            if (isPlayButtonChange) {
                if (Boolean.TRUE.equals(this.playerVO.getControls())) {
                    if (!UtilsKt.isSDKRunningOnTvDevice(this.context)) {
                        this.btnReplay.setVisibility(0);
                        this.btnPlay.setVisibility(8);
                    }
                } else {
                    this.btnClosePlaylist.setVisibility(8);
                }
            } else {
                this.btnClosePlaylist.setVisibility(0);
            }
        }
    }

    @Override
    public void releaseAdPlayer() {
        Utils.log(this.getClass(), "releaseAdPlayer", new String[0]);
        if (this.imaPlayer != null) {
            this.imaPlayer.releaseAdPlayer();
        }
    }

    @Override
    public void log(String message) {
        if (mListener != null) {
            mListener.onEvent("Log: " + message + "\n------------------------------\n", this.getPlayerReference());
        }
    }

    public void onVideoFrameAboutToBeRendered(long presentationTimeUs, long releaseTimeNs, Format format, @androidx.annotation.Nullable MediaFormat mediaFormat) {
    }

    @Override
    public void onResult(@NonNull Api api, @androidx.annotation.Nullable String token) {
        Utils.log(this.getClass(), "taskSuccess", "onResult");
        LifecycleTrackerKt.getResumablesSet().clear();
        LifecycleTrackerKt.getResumablesSet().addReplacing(this);
        this.playerVO = api.getPlayer();
        this.partnerVO = api.getPartner();
        this.playlistVO = api.getPlaylist();
        this.videoVOS = new ArrayList();
        this.existAd = api.getAdSchedule() != null;
        this.dontStackMidrolls = this.playerVO.getDont_stack_midrolls();
        boolean bl = this.adControlsEnabled = this.playerVO.getAutohide_ad_controls() == false;
        if (this.customVideo != null) {
            this.videoVOS.add(this.customVideo);
        } else {
            this.videoVOS.addAll(api.getVideo());
        }
        try {
            this.videoVOS.get(this.currentVideo + 1).setToken(token);
            this.ageGateId = Integer.parseInt(Objects.requireNonNull(this.videoVOS.get(this.currentVideo + 1).getAge_gate_id()));
        }
        catch (IndexOutOfBoundsException e) {
            this.error("IndexOutOfBoundsException");
        }
        if (api.getRelated() != null) {
            this.relatedVideos = new ArrayList();
            this.relatedVideos.addAll(api.getRelated());
        }
        if (mLogListener != null) {
            mLogListener.onLog("Auto play: " + this.playerVO.getAutoplay().toString());
        }
        this.updatePlaylistWithRelated();
        this.restartPlayer();
        this.isPipEnabled = Boolean.TRUE.equals(this.playerVO.getPip());
        if (this.isPipEnabled && !UtilsKt.isSDKRunningOnTvDevice(this.context)) {
            this.pipMinimise.setVisibility(0);
        }
        this.initializeBridPoster();
        if (!this.playerLoaded) {
            this.sendAnalytics(new AnalyticData("l", null));
            this.playerLoaded = true;
        }
        LayoutTransition lt = new LayoutTransition();
        lt.disableTransitionType(3);
        this.playerOverlayWrapper.setLayoutTransition(lt);
        this.setPlayerBasicLoadControls();
        this.visual.controlPlayerTitle(Objects.requireNonNull(this.playerVO.getTitleBar()));
        if (this.playerVO.getStart_volume() == 0) {
            this.changeMute(true, true);
        } else {
            this.changeMute(false, false);
        }
        this.useTouchPlayPause = Boolean.FALSE.equals(this.playerVO.getControls());
        if (api.getSkin() != null && api.getSkin().getId() != 1) {
            this.playerHaveSkin = true;
        }
        if (this.playerHaveSkin) {
            this.generateCustomPlayerSkin(api.getSkin());
        }
        if (this.playerDoubleTapOverlay != null) {
            if (this.seekSeconds > 0) {
                this.playerDoubleTapOverlay.seekSeconds(this.seekSeconds);
            } else if (this.seekSeconds == 0) {
                this.playerView.cancelDoubleTapMode();
            }
        }
        this.autoplayCC = this.playerVO.getAutoplay_cc();
        this.bridPlayerEngine = new BridPlayerEngineNew(this.sdkContainer, this.playerVO, this.partnerVO, api.getAdSchedule(), this.videoVOS, this, this.player, this.adProvider, this, this.context, this.determineAutoplayMode());
        this.bridPlayerEngine.start();
        if (mListener != null) {
            mListener.onEvent("STARTED", this.getPlayerReference());
        }
    }

    private void initializeBridPoster() {
        this.bridPoster = new BridPoster(this.context, this.playerVO.getCustomPlayButton());
        this.bridPoster.initializePoster(this.playerVO, this.videoVOS.get(0));
        this.bridPoster.setShowPlayButton(true);
        this.bridPoster.loadImage(this.cornerRadius, this.placeholderPosterImageRes);
        this.bridPoster.setBridPosterListener(new BridPoster.BridPosterListener(){

            @Override
            public void onBridPosterClicked(Video video) {
                BridPlayerImpl.this.bridPlayerEngine.startPlay();
            }
        });
    }

    private void setUpCreditsText(String creditsText) {
        if (creditsText != null && !creditsText.trim().isEmpty() && !UtilsKt.isSDKRunningOnTvDevice(this.context)) {
            ViewParent parent;
            if (this.creditsLayout == null) {
                this.creditsLayout = LayoutInflater.from((Context)this.context).inflate(R.layout.player_credits_holder, null);
                ViewGroup.MarginLayoutParams params = new ViewGroup.MarginLayoutParams(-1, 64);
                params.setMargins(0, (int)this.calculateVideoHeight(), 0, 0);
                this.creditsLayout.setLayoutParams((ViewGroup.LayoutParams)params);
                this.creditsTextView = (TextView)this.creditsLayout.findViewById(R.id.credits_text);
            }
            this.creditsTextView.setVisibility(0);
            this.creditsTextView.setText((CharSequence)creditsText);
            if (this.creditsLabelColor != null) {
                this.creditsTextView.setTextColor(Color.parseColor((String)("#" + this.creditsLabelColor)));
            }
            if ((parent = this.creditsLayout.getParent()) != null && parent instanceof ViewGroup && parent != this.playerHolder) {
                ((ViewGroup)parent).removeView(this.creditsLayout);
            }
            if (this.creditsLayout.getParent() == null) {
                this.playerHolder.addView(this.creditsLayout);
            }
            this.creditsLayout.setVisibility(0);
        } else if (this.creditsLayout != null) {
            this.creditsLayout.setVisibility(8);
            this.creditsTextView.setText((CharSequence)"");
        }
    }

    @Override
    @Nullable
    public void onLocation(@androidx.annotation.Nullable GeoLocation geoLocation) {
        this.location = new Location();
        this.location = geoLocation.getLocation();
    }

    @Override
    public void error(@NonNull String error) {
        Utils.log(this.getClass(), "error", error);
        this.networkParsingErrorHandler = new NetworkParsingErrorHandler(this.playerView);
        if (mListener != null) {
            mListener.onEvent("videoloadneterror", this.getPlayerReference());
        }
        this.networkParsingErrorHandler.handleError(Utils.getTranslationByCode(this.context, error, this.countryCode), new Function0<Unit>(){

            public Unit invoke() {
                BridPlayerImpl.this.lastApiCall.call();
                Utils.log(this.getClass(), "error", "invoke");
                BridPlayerImpl.this.networkParsingErrorHandler = null;
                if (mListener != null) {
                    mListener.onEvent("cmserror", BridPlayerImpl.this.getPlayerReference());
                }
                return null;
            }
        });
    }

    @Override
    public int defineType() {
        return 2;
    }

    @Override
    public void onPauseEvent() {
        Utils.log(this.getClass(), "onPauseEvent", new String[0]);
        if (!this.isInPipMode && this.player != null) {
            this.onPauseWhilePlaying = true;
            this.player.pause();
            if (mListener != null) {
                mListener.onEvent("pause", this.getPlayerReference());
            }
        }
    }

    @Override
    public void onResumeEvent(int resumeState) {
        Utils.log(this.getClass(), "onResumeEvent", new String[0]);
        if (this.isPipEnabled) {
            return;
        }
        if (resumeState == 1) {
            if (this.playlistHolder.getVisibility() == 0) {
                return;
            }
            if (this.bridPlayerEngine != null) {
                this.bridPlayerEngine.onContextResume();
            }
        }
        if (resumeState == 2) {
            return;
        }
        this.pause();
    }

    public void resumeEventSend() {
        if (mListener != null) {
            mListener.onEvent("play", this.getPlayerReference());
        }
    }

    private void playerStatusChanged(boolean playWhenReady, int playbackState) {
        Utils.log(this.getClass(), "playerStatusChanged", String.valueOf(playWhenReady), String.valueOf(playbackState));
        if (playbackState == 2) {
            if (mListener != null) {
                mListener.onEvent("buffering", this.getPlayerReference());
            }
            this.showLoader(true);
        }
        if (playbackState == 4) {
            if (mListener != null && this.getDuration() > 0L) {
                mListener.onEvent("end", this.getPlayerReference());
            }
            this.adAnalyticDC = null;
            this.playEnded = true;
            this.bridPlayerEngine.onVideoEnded(this.player.getDuration());
        }
        if (playbackState == 3) {
            Utils.log(this.getClass(), "Player.STATE_READY", String.valueOf(this.isHlsVideo()));
            this.playEnded = false;
            if (!this.vpaidInProgress) {
                this.showLoader(false);
            }
            if (playWhenReady) {
                this.hidePoster();
                this.playInitiated = true;
                if (mListener != null) {
                    mListener.onEvent("play", this.getPlayerReference());
                }
            } else if (this.playInitiated) {
                this.sendAnalytics(new AnalyticData("pa", null));
                if (mListener != null) {
                    mListener.onEvent("pause", this.getPlayerReference());
                }
            }
        }
    }

    @Override
    public boolean isTimelineFocused() {
        View progressView = this.playerView.findViewById(R.id.exo_progress);
        if (progressView != null) {
            return progressView.isFocused();
        }
        return false;
    }

    private void changeMute(boolean mute, boolean sendAnalytics) {
        Utils.log(this.getClass(), "changeMute", new String[0]);
        if (this.player == null) {
            return;
        }
        this.isMuted = mute;
        this.player.setVolume(mute ? 0.0f : 0.7f);
        if (this.imaPlayer != null) {
            this.imaPlayer.muteAdVideo(this.isMuted);
        }
        if (this.imaPlayer != null) {
            this.imaPlayer.muteAdVideo(this.isMuted);
        }
        this.changeMuteButton(this.isMuted);
        if (sendAnalytics) {
            if (mute) {
                this.sendAnalytics(new AnalyticData("m", null));
            } else {
                this.sendAnalytics(new AnalyticData("u", null));
            }
        }
    }

    public void changeMuteButton(boolean isMuted) {
        this.isMuted = isMuted;
        this.setDrawableForButton(this.btnMute, isMuted ? this.mutedDrawable : this.muteToggleDrawable, isMuted ? this.unmuteIcon : this.muteIcon, this.context);
    }

    private void initCaptions() {
    }

    private void showLoader(boolean show) {
        Utils.log(this.getClass(), "showLoader", new String[0]);
        if (!this.loadingIndicator) {
            return;
        }
        this.pbLoading.setVisibility(show ? 0 : 8);
    }

    private void toast(String message, int logType) {
        if (mLogListener != null) {
            mLogListener.onLog(message);
        } else if ((logType & this.debug) == logType) {
            Toast.makeText((Context)this.context.getApplicationContext(), (CharSequence)message, (int)0).show();
        }
    }

    private boolean checkOffsetAndFrequency() {
        SharedPreferences prefs = this.context.getApplicationContext().getSharedPreferences("BridPlayer" + this.playerVO.getId(), 0);
        int videosPlayed = prefs.getInt("videosPlayed", 0);
        return videosPlayed + 1 >= this.playerVO.getAdOffset() && (videosPlayed + 1 - this.playerVO.getAdOffset()) % this.playerVO.getAdFrequency() == 0;
    }

    private float calculateVideoHeight() {
        if (this.playerVO != null) {
            if (this.playerVO.getMobileWidth() != null && this.playerVO.getMobileHeight() != null) {
                return (float)this.playerView.getWidth() * Float.parseFloat(this.playerVO.getMobileHeight()) / Float.parseFloat(this.playerVO.getMobileWidth());
            }
            return this.playerView.getWidth() * this.playerVO.getHeight() / this.playerVO.getWidth();
        }
        return 1.0f;
    }

    private void sendDebug(String debugParams) {
        ((Builders.Any.B)Ion.with((Context)this.context).load("https://eoy48v2k9pmyk8o.m.pipedream.net/?p=" + debugParams.replace("ImaPlayer", "").replace("BridPlayer", "").replace(" ", "-") + "----" + System.currentTimeMillis())).asString().withResponse().setCallback((FutureCallback)new FutureCallback<Response<String>>(){

            public void onCompleted(Exception e, Response<String> result) {
            }
        });
    }

    @Override
    public void onAdsCompleted(int type, @androidx.annotation.Nullable Boolean isError) {
        Utils.log(this.getClass(), "onAdsCompleted", String.valueOf(type), String.valueOf(isError));
        if (!this.hasInternet && this.bridPlayerEngine != null) {
            this.bridPlayerEngine.onNetworkConnectionLost();
            return;
        }
        if (this.playerVO != null && this.playerVO.getBranding() != null) {
            this.visual.setBranding(this.playerVO.getBranding().getPos(), this.playerVO.getBranding().getImg(), this.playerVO.getBranding().getUrl());
        }
        if (isError != null && isError.booleanValue()) {
            switch (type) {
                case 0: {
                    if (!this.playerVO.getAutoplay_on_ad().booleanValue()) {
                        this.player.prepare();
                        this.player.setPlayWhenReady(true);
                        this.showControls();
                        break;
                    }
                    if (!this.playerVO.getAutoplay_wifi_only().booleanValue() || UtilsKt.isWifiConnected(this.context)) {
                        this.showPoster();
                        break;
                    }
                    this.player.prepare();
                    this.player.setPlayWhenReady(true);
                    this.sendAutoplayEvent();
                    break;
                }
                case 1: {
                    this.player.prepare();
                    this.player.setPlayWhenReady(this.player.getPlayWhenReady());
                    break;
                }
                case 2: {
                    if (this.bridPlayerEngine == null) break;
                    this.bridPlayerEngine.onAdsCompleted(type, isError);
                }
            }
            this.playerOverlayWrapper.setVisibility(0);
            return;
        }
        if (this.txtTitle != null) {
            this.txtTitle.setVisibility(0);
        }
        this.playerOverlayWrapper.setVisibility(0);
        if (!UtilsKt.isSDKRunningOnTvDevice(this.context)) {
            this.centerControllsParent.setVisibility(0);
        }
        this.adAnalyticDC = null;
        this.showLoader(false);
        this.vpaidInProgress = false;
        if (this.bridPlayerEngine != null) {
            this.log(this.getClass().getSimpleName() + " onAdsCompleted");
            this.bridPlayerEngine.onAdsCompleted(type, isError);
        }
        this.playerView.setPlayer((Player)this.player);
    }

    public void updatePlaylistWithRelated() {
        if (this.videoVOS.size() > 1 && Boolean.TRUE.equals(this.playerVO.getShuffle())) {
            Collections.shuffle(this.videoVOS);
        }
        if (this.relatedVideos != null) {
            if (this.videoVOS.size() <= 1 && !this.relatedVideos.isEmpty()) {
                this.playerVO.setPlaylistPlayback("single");
            }
            if (Boolean.TRUE.equals(this.playerVO.getShuffle())) {
                Collections.shuffle(this.relatedVideos);
            }
            this.videoVOS.addAll(this.relatedVideos);
        }
    }

    private void addAdMacrosToTargeting(Map<String, String> macroTargeting) {
        if (macroTargeting == null) {
            return;
        }
        try {
            AdvertisingIdClient.Info adInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.context);
            if (adInfo != null) {
                String rdid = adInfo.getId();
                boolean isLat = adInfo.isLimitAdTrackingEnabled();
                macroTargeting.put("rdid", rdid != null ? rdid : "");
                macroTargeting.put("is_lat", isLat ? "1" : "0");
                macroTargeting.put("idtype", "gaid");
            } else {
                macroTargeting.put("rdid", "");
                macroTargeting.put("is_lat", "0");
                macroTargeting.put("idtype", "gaid");
            }
        }
        catch (Exception e) {
            macroTargeting.put("rdid", "");
            macroTargeting.put("is_lat", "0");
            macroTargeting.put("idtype", "gaid");
        }
        macroTargeting.put("ip", "0.0.0.0");
    }

    @Override
    @SuppressLint(value={"ResourceType"})
    public void playAd(@NotNull ArrayList<Object> adTags, @Nullable AdAnalyticDC adAnalyticDC) {
        this.visual.invisibleWatermark();
        Utils.log(this.getClass(), "playAd", new String[0]);
        this.hideControls();
        this.adAnalyticDC = adAnalyticDC;
        if (this.txtTitle != null) {
            this.txtTitle.setVisibility(8);
        }
        this.hidePoster();
        if (this.imaPlayer != null) {
            this.imaPlayer.releaseAdPlayer();
            this.imaPlayer = null;
        }
        this.imaPlayer = new ImaPlayer(this.player, this.playerView, this.adProvider, this, adAnalyticDC.getAdType(), this, mListener, this.playerVO, this.countryCode);
        if (adAnalyticDC.getAdType() == 0 || adAnalyticDC.getAdType() == 2) {
            this.showAdLoading();
        }
        this.playerOverlayWrapper.setVisibility(8);
        for (Object adTag : adTags) {
            if (adTag instanceof AdTagVO) {
                this.currentAdTag = (AdTagVO)adTag;
                boolean hasBackfillfAd = false;
                if (this.partnerVO.getAdScheduleBackfill() != null) {
                    Objects.requireNonNull(this.partnerVO.getAdScheduleBackfill().getPrerolls()).get(0).getMobile();
                    if (this.currentAdTag != null) {
                        hasBackfillfAd = true;
                    }
                }
                adAnalyticDC.setPartnerAd(hasBackfillfAd);
                this.createAdString((AdTagVO)adTag, (Consumer<String>)((Consumer)adString -> {
                    this.imaPlayer.setAnalytics(adAnalyticDC);
                    this.imaPlayer.setAdRequest((String)adString);
                }));
                continue;
            }
            if (adTag instanceof PrebidData) {
                if (this.prebidPlayer == null) {
                    this.prebidPlayer = new PrebidPlayer(this.playerView, (PrebidData)adTag, this.imaPlayer);
                    continue;
                }
                this.prebidPlayer = null;
                this.prebidPlayer = new PrebidPlayer(this.playerView, (PrebidData)adTag, this.imaPlayer);
                continue;
            }
            System.out.println("Unknown ad type");
        }
    }

    public void createAdString(AdTagVO adTag, Consumer<String> onAdStringReady) {
        Video currentVideo;
        int playerHeight;
        int playerWidth;
        try {
            playerWidth = this.playerVO.getWidth();
        }
        catch (NullPointerException e) {
            playerWidth = 640;
        }
        try {
            playerHeight = this.playerVO.getHeight();
        }
        catch (NullPointerException e) {
            playerHeight = 480;
        }
        try {
            currentVideo = this.getCurrentVideo();
        }
        catch (NullPointerException e) {
            currentVideo = new Video();
        }
        int finalPlayerWidth = playerWidth;
        int finalPlayerHeight = playerHeight;
        Video finalCurrentVideo = currentVideo;
        Utils.loadAdvertisingIdAsync(this.context, adIdMacros -> {
            HashMap macroTargeting = new HashMap(adIdMacros);
            String adUrl = Utils.formatAdUrl(this.context, adTag.getUrl(), new HashMap<String, String>(macroTargeting), this.timeCreated, finalPlayerWidth, finalPlayerHeight, finalCurrentVideo, this.playerVO, this.location);
            adUrl = Utils.encodeString(adUrl);
            JSONObject jsAd = new JSONObject();
            try {
                jsAd.put("id", (Object)adTag.getId());
                jsAd.put("url", (Object)adUrl);
                this.toast("WebBridge: adTag " + jsAd.get("url"), 1);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            this.sendDebug(adUrl);
            this.currentAdTag = adTag;
            try {
                String adString = URLDecoder.decode(jsAd.optString("url"), "UTF-8");
                onAdStringReady.accept((Object)adString);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                onAdStringReady.accept((Object)adUrl);
            }
        });
    }

    @Override
    public void killAdPlayer() {
        Utils.log(this.getClass(), "killAdPlayer", new String[0]);
        if (this.imaPlayer != null) {
            this.imaPlayer.releaseAdPlayer();
        }
    }

    @Override
    public void setFullscreenIcon(@DrawableRes int fullscreenIcon) {
        this.fullscreenIcon = fullscreenIcon;
        this.btnFullScreen.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)fullscreenIcon));
    }

    @Override
    @SuppressLint(value={"ResourceType"})
    public void setPlayPauseIcon(int playIcon) {
        this.playIcon = playIcon;
        if (!UtilsKt.isSDKRunningOnTvDevice(this.context)) {
            PorterDuffColorFilter colorFilter = new PorterDuffColorFilter(ContextCompat.getColor((Context)this.context, (int)playIcon), PorterDuff.Mode.MULTIPLY);
            this.btnPlay.setColorFilter((ColorFilter)colorFilter);
        }
    }

    @Override
    public void setMuteIcon(@DrawableRes int muteIcon) {
        this.muteIcon = muteIcon;
        this.btnMute.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)(this.isMuted ? this.unmuteIcon : muteIcon)));
    }

    @Override
    public void setUnmuteIcon(@DrawableRes int unmuteIcon) {
        this.unmuteIcon = unmuteIcon;
        this.btnMute.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)(this.isMuted ? unmuteIcon : this.muteIcon)));
    }

    @Override
    public void setPlaylistIcon(int playlistIcon) {
        this.playlistIcon = playlistIcon;
        this.btnPlaylist.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)playlistIcon));
    }

    @Override
    public void setPlaylistCloseIcon(int exitIcon) {
        this.exitIcon = exitIcon;
        this.btnClosePlaylist.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)exitIcon));
    }

    @Override
    public void setShareIcon(int shareIcon) {
        this.shareIcon = shareIcon;
        this.btnShare.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)shareIcon));
    }

    @Override
    public void setSettingsIcon(int settingsIcon) {
        this.settingsIcon = settingsIcon;
    }

    @Override
    public void setTimelineColors(int playedColor, int unplayedColor, int bufferedColor, int scrubberColor) {
        this.playedColor = playedColor;
        this.unplayedColor = unplayedColor;
        this.bufferedColor = bufferedColor;
        this.scrubberColor = scrubberColor;
        this.progressBar.setPlayedColor(ContextCompat.getColor((Context)this.context, (int)playedColor));
        this.progressBar.setUnplayedColor(ContextCompat.getColor((Context)this.context, (int)unplayedColor));
        this.progressBar.setBufferedColor(ContextCompat.getColor((Context)this.context, (int)bufferedColor));
        this.progressBar.setScrubberColor(ContextCompat.getColor((Context)this.context, (int)scrubberColor));
    }

    @Override
    public void setFullscreenCloseIcon(int fullscreenCloseIcon) {
        this.fullscreenCloseIcon = fullscreenCloseIcon;
        if (this.playerFullscreen) {
            this.btnFullScreen.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)fullscreenCloseIcon));
        }
    }

    @Override
    public void setTVControls(int forwardIcon) {
        this.forwardIcon = forwardIcon;
        this.btnFastForward.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)forwardIcon));
        this.btnFastForward.setRotation(0.0f);
        this.btnFastBack.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)forwardIcon));
        this.btnFastBack.setRotation(180.0f);
    }

    @Override
    public void setFocusDrawable(int focusDrawable) {
        this.focusDrawable = focusDrawable;
        CustomColor customColor = CustomColor.getInstance();
        customColor.setColor(focusDrawable);
    }

    private IAdPlayer newAdPlayer() {
        return new IAdPlayer(){

            @Override
            public void releaseAdsLoader() {
            }

            @Override
            public void playAd(@NonNull ArrayList<AdTagVO> adTags, @NonNull AdAnalyticDC adAnalyticDC) {
            }

            @Override
            public void releaseAdPlayer() {
                if (BridPlayerImpl.this.imaPlayer != null) {
                    BridPlayerImpl.this.imaPlayer.releaseAdPlayer();
                }
            }

            @Override
            public void pause() {
                if (BridPlayerImpl.this.imaPlayer != null) {
                    BridPlayerImpl.this.imaPlayer.pause();
                }
            }

            @Override
            public void muteAdVideo(@androidx.annotation.Nullable Boolean isMuted) {
            }

            @Override
            @NonNull
            public AdPlayerType getAdPlayerType() {
                return null;
            }

            @Override
            public void setPlayerData(@NonNull tv.brid.domain.Player player, @NonNull Partner partner) {
            }

            @Override
            public void loadAdContent() {
            }

            @Override
            public boolean isAdInProgress() {
                return false;
            }

            @Override
            public void setAnalytics(@NonNull AdAnalyticDC adAnalyticDC) {
            }

            @Override
            public void setAdRequest(@NonNull String adString) {
            }
        };
    }

    public void setRepeated(boolean repeated) {
        this.isRepeated = repeated;
    }

    public IBridPlayerEngine getBridPlayerEngine() {
        return this.bridPlayerEngine;
    }

    public void setBridPlayerEngine(IBridPlayerEngine bridPlayerEngine) {
        this.bridPlayerEngine = bridPlayerEngine;
    }

    public void setPlaylistId(int playlistId) {
        this.playlistId = playlistId;
    }

    public int getPlaylistId() {
        return this.playlistId;
    }

    public Context getContext() {
        return this.context;
    }

    public FrameLayout getPlayerHolder() {
        return this.playerHolder;
    }

    public void setFullscreen(boolean isFullscreen) {
        this.playerFullscreen = isFullscreen;
    }

    public boolean dontStackMidrolls() {
        return this.dontStackMidrolls;
    }

    public void setDontStackMidrolls(boolean dontStackMidrolls) {
        this.dontStackMidrolls = dontStackMidrolls;
    }

    @Override
    public void reinitializePoster(ArrayList<Video> videoList, int index) {
        this.bridPoster.setPoster(videoList.get(index), this.cornerRadius);
        this.bridPoster.setShowPlayButton(true);
        this.ageGateId = Integer.parseInt(videoList.get(index).getAge_gate_id());
        if (UtilsKt.isSDKRunningOnTvDevice(this.context) && this.isTvPlaylistOpen) {
            this.closePlaylistTv();
        }
    }

    @Override
    public void setPlayerReference(String playerReference) {
        this.bridPlayerReference = playerReference;
    }

    @Override
    public String getPlayerReference() {
        return this.bridPlayerReference;
    }

    @Override
    public void setPlayerLanguage(String countryCode) {
        this.countryCode = Utils.isLanguageSupported(countryCode);
    }

    public String getPlayerLanguage() {
        return this.countryCode;
    }

    public void reinitializePlayReplayButton() {
        if (this.btnReplay != null) {
            this.btnReplay.setVisibility(8);
        }
        if (this.btnPlay != null && this.btnPlay.getVisibility() != 0) {
            this.btnPlay.setVisibility(0);
        }
    }

    public void showUnmuteButton() {
        if (this.unmuteLayout != null) {
            this.unmuteLayout.setVisibility(0);
        }
    }

    public void hideUnmuteButton() {
        AlphaAnimation clickAnimation = new AlphaAnimation(1.0f, 0.8f);
        if (this.unmuteLayout != null && this.unmuteLayout.getVisibility() == 0) {
            this.unmuteLayout.startAnimation((Animation)clickAnimation);
            this.unmuteLayout.setVisibility(4);
        }
        this.changeMute(false, false);
    }

    private void generateCustomPlayerSkin(Skin skin) {
        try {
            if (skin.getPlayToggle() != null) {
                Drawable playToggle = Utils.convertSvgToDrawable(skin.getPlayToggle(), this.context);
                this.btnPlay.setImageDrawable(playToggle);
            }
            if (skin.getPause() != null) {
                Drawable drawable2 = Utils.convertSvgToDrawable(skin.getPause(), this.context);
            }
            if (skin.getFullscreenToggle() != null) {
                this.fullscreenToggleDrawable = Utils.convertSvgToDrawable(skin.getFullscreenToggle(), this.context);
                this.setDrawableForButton(this.btnFullScreen, this.fullscreenToggleDrawable, 0, this.context);
            }
            if (skin.getFullscreenOff() != null) {
                this.fullscreenOffDrawable = Utils.convertSvgToDrawable(skin.getFullscreenOff(), this.context);
            }
            if (skin.getMuteToggle() != null) {
                this.muteToggleDrawable = Utils.convertSvgToDrawable(skin.getMuteToggle(), this.context);
                this.setDrawableForButton(this.btnMute, this.muteToggleDrawable, 0, this.context);
            }
            if (skin.getMuted() != null) {
                this.mutedDrawable = Utils.convertSvgToDrawable(skin.getMuted(), this.context);
            }
            if (skin.getOpenShare() != null) {
                Drawable openShare = Utils.convertSvgToDrawable(skin.getOpenShare(), this.context);
                this.btnShare.setImageDrawable(openShare);
            }
            if (skin.getOpenPlaylist() != null) {
                Drawable openPlaylist = Utils.convertSvgToDrawable(skin.getOpenPlaylist(), this.context);
                this.btnPlaylist.setImageDrawable(openPlaylist);
            }
            if (skin.getNext() != null) {
                Drawable next = Utils.convertSvgToDrawable(skin.getNext(), this.context);
                this.btnNext.setImageDrawable(next);
            }
            if (skin.getPrevious() != null) {
                Drawable previous = Utils.convertSvgToDrawable(skin.getPrevious(), this.context);
                this.btnPrev.setImageDrawable(previous);
            }
            if (skin.getRewind() != null) {
                Drawable drawable3 = Utils.convertSvgToDrawable(skin.getRewind(), this.context);
            }
            if (skin.getRepeat() != null) {
                Drawable repeat = Utils.convertSvgToDrawable(skin.getRepeat(), this.context);
                this.btnReplay.setImageDrawable(repeat);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setDrawableForButton(ImageButton btn, Drawable drawable2, @DrawableRes int drawableRes, Context context) {
        if (drawable2 == null) {
            if (drawableRes != 0) {
                btn.setImageDrawable(ContextCompat.getDrawable((Context)context, (int)drawableRes));
            }
        } else {
            btn.setImageDrawable(drawable2);
        }
    }

    public int getSeekSeconds() {
        return this.seekSeconds;
    }

    public boolean getVideoPlaying() {
        return this.isVideoPlaying;
    }

    public ExoPlayer getNativePlayer() {
        return this.player;
    }

    public BridStyledPlayerView getNativePlayerControler() {
        return this.playerView;
    }

    public void showBigLoading() {
        this.pbLoadingPreroll.setVisibility(0);
    }

    public void hideBigLoading() {
        if (this.pbLoadingPreroll != null) {
            this.pbLoadingPreroll.setVisibility(8);
        }
    }

    public void hideOverlayForAd() {
        this.loadingAdView.setVisibility(8);
    }

    public void hideControlsOnNetworkError() {
        if (this.exoBasicControls != null) {
            this.exoBasicControls.setVisibility(8);
            this.exoBottomNoNetwork.setVisibility(0);
            this.btnNextVisibility = this.btnNext.getVisibility();
            this.btnPrevVisibility = this.btnPrev.getVisibility();
            this.btnNext.setVisibility(8);
            this.btnPrev.setVisibility(8);
        }
    }

    @SuppressLint(value={"WrongConstant"})
    public void showControlsOnNetworkError() {
        if (this.exoBasicControls != null) {
            this.exoBasicControls.setVisibility(0);
            this.exoBottomNoNetwork.setVisibility(8);
            this.btnNext.setVisibility(this.btnNextVisibility);
            this.btnPrev.setVisibility(this.btnPrevVisibility);
        }
    }

    @Override
    public void setSeekSeconds(int seekSeconds) {
        if (seekSeconds > -1) {
            this.seekSeconds = seekSeconds;
        }
    }

    @Override
    public void setSeekPreview(int seekPreview) {
        if (seekPreview > 0 && seekPreview < 3) {
            this.isVttEnabled = seekPreview;
        }
    }

    @Override
    @OptIn(markerClass={UnstableApi.class})
    public void setControllerTimeoutMs(int controllerTimeoutMs) {
        if (controllerTimeoutMs > 1000) {
            this.controllerTimeoutMs = controllerTimeoutMs;
            this.playerView.setControllerShowTimeoutMs(controllerTimeoutMs);
        }
    }

    @Override
    public void setPosterPlaceholderRes(@DrawableRes int posterPlaceholderImage) {
        this.placeholderPosterImageRes = posterPlaceholderImage;
    }

    public void resetUI() {
        if (this.videoSupport == null) {
            if (!this.isFullscreen()) {
                if (this.shouldShowExtraControls() > 0) {
                    this.setupExtraLayout();
                }
            } else if (this.shouldShowExtraControls > 0) {
                this.reverseExtraLayout(this.playerVO, this.shouldShowExtraControls + 1);
            }
        } else {
            this.videoSupport.removeAdjustUI();
        }
    }

    @OptIn(markerClass={UnstableApi.class})
    private int shouldShowExtraControls() {
        if (!UtilsKt.isSDKRunningOnTvDevice(this.context)) {
            this.shouldShowExtraControls = this.playerView.numberOfBasicControls(this.playerVO) - this.playerView.numOfPossibleControlsToDisplay();
            return this.shouldShowExtraControls;
        }
        return 0;
    }

    private void setupExtraLayout() {
        if (this.isInPipMode) {
            return;
        }
        this.setupControlsExtraLayout(this.playerVO, this.shouldShowExtraControls + 1);
        if (this.hideExtraControls != null && this.hideExtraControls.getParent() == null) {
            this.extraControlsLayout.addView((View)this.hideExtraControls, this.extraControlsLayout.getChildCount());
        }
        this.btnExtraControls.setVisibility(0);
        this.exoBasicControls.removeView((View)this.btnExtraControls);
        this.exoBasicControls.addView((View)this.btnExtraControls);
    }

    private void setupControlsExtraLayout(tv.brid.domain.Player playerVO, int numToShowInExtraLayout) {
        if (playerVO.getShareScreen().booleanValue()) {
            ((ViewGroup)this.btnShare.getParent()).removeView((View)this.btnShare);
            this.extraControlsLayout.addView((View)this.btnShare);
            if (--numToShowInExtraLayout == 0) {
                return;
            }
        }
        if (playerVO.getCogwheel().booleanValue() && this.txtResolutionSD != null) {
            ((ViewGroup)this.txtResolutionSD.getParent()).removeView((View)this.txtResolutionSD);
            this.extraControlsLayout.addView((View)this.txtResolutionSD);
            if (--numToShowInExtraLayout == 0) {
                return;
            }
        }
        if (playerVO.getPlaylistScreen().booleanValue()) {
            ((ViewGroup)this.btnPlaylist.getParent()).removeView((View)this.btnPlaylist);
            this.extraControlsLayout.addView((View)this.btnPlaylist);
            if (--numToShowInExtraLayout == 0) {
                return;
            }
        }
        if (playerVO.getFullscreen().booleanValue()) {
            ((ViewGroup)this.btnFullScreen.getParent()).removeView((View)this.btnFullScreen);
            this.extraControlsLayout.addView((View)this.btnFullScreen);
            if (--numToShowInExtraLayout == 0) {
                return;
            }
        }
    }

    private void reverseExtraLayout(tv.brid.domain.Player playerVO, int numToShowInExtraLayout) {
        this.btnExtraControls.setVisibility(8);
        this.exoBasicControls.removeView(this.playerView.findViewById(R.id.exo_overflow_hide));
        if (playerVO.getShareScreen().booleanValue()) {
            ((ViewGroup)this.btnShare.getParent()).removeView((View)this.btnShare);
            this.exoBasicControls.addView((View)this.btnShare);
            if (--numToShowInExtraLayout == 0) {
                return;
            }
        }
        if (playerVO.getCogwheel().booleanValue() && this.txtResolutionSD != null) {
            ((ViewGroup)this.txtResolutionSD.getParent()).removeView((View)this.txtResolutionSD);
            this.exoBasicControls.addView((View)this.txtResolutionSD);
            if (--numToShowInExtraLayout == 0) {
                return;
            }
        }
        if (playerVO.getPlaylistScreen().booleanValue()) {
            ((ViewGroup)this.btnPlaylist.getParent()).removeView((View)this.btnPlaylist);
            this.exoBasicControls.addView((View)this.btnPlaylist);
            if (--numToShowInExtraLayout == 0) {
                return;
            }
        }
        if (playerVO.getFullscreen().booleanValue()) {
            ((ViewGroup)this.btnFullScreen.getParent()).removeView((View)this.btnFullScreen);
            this.exoBasicControls.addView((View)this.btnFullScreen);
            if (--numToShowInExtraLayout == 0) {
                return;
            }
        }
    }

    private boolean isPlayerVertical() {
        if (this.playerVO.getMobileWidth() == null || this.playerVO.getMobileHeight() == null) {
            return this.playerVO.getWidth() < this.playerVO.getHeight();
        }
        return Float.parseFloat(this.playerVO.getMobileWidth()) < Float.parseFloat(this.playerVO.getMobileHeight());
    }

    public void setSuppressSeekDiscontinuity(int flag) {
        this.suppressSeekDiscontinuity = flag;
    }

    public void sendAutoplayEvent() {
        if (mListener != null) {
            mListener.onEvent("videoautoplay", this.getPlayerReference());
        }
    }

    public void sendAutoplayEventIfAdExists(int adType) {
        if ((this.determineAutoplayMode() == AutoplayMode.AUTOPLAY_IF_AD_PRESENT || this.determineAutoplayMode() == AutoplayMode.AUTOPLAY_IF_AD_AND_WIFI) && adType == 0 && mListener != null) {
            mListener.onEvent("videoautoplay", this.getPlayerReference());
        }
    }

    public void turnOffLiveWhenAdsStarted(boolean isVisible) {
        if (this.videoSupport != null) {
            this.videoSupport.turnOffLiveIcon(isVisible);
        }
    }

    public boolean isInPipMode() {
        return this.isInPipMode;
    }

    public boolean isPipEnabled() {
        return this.isPipEnabled;
    }

    public boolean isAgeDialogNeeded() {
        return this.ageGateId != 1 && !this.isAgeVerified;
    }

    public void showAgeRestrictedDialog() {
        BridAgeRestricted bridAgeRestricted = new BridAgeRestricted(this.context, this.ageGateId, this);
        ViewGroup.LayoutParams layoutParams = this.playerView.getLayoutParams();
        bridAgeRestricted.setLayoutParams(layoutParams);
        ((ViewGroup)this.playerView.getParent()).addView((View)bridAgeRestricted);
    }

    public void confirmVerificationAndStartVideo() {
        this.isAgeVerified = true;
        if (this.bridPlayerEngine != null) {
            this.bridPlayerEngine.createVideoLoaderAfterVerification();
        }
    }

    public void onScrubStart(PreviewBar previewBar) {
        Log.d((String)"Test", (String)"TEST");
    }

    public void onScrubMove(PreviewBar previewBar, int progress, boolean fromUser) {
        Log.d((String)"Test", (String)"TEST");
    }

    public void onScrubStop(PreviewBar previewBar) {
        Log.d((String)"Test", (String)"TEST");
    }

    @RequiresApi(api=24)
    public void loadPreview(long currentPosition, long max) {
        if (this.isVttEnabled == 1 || this.isVttEnabled == 2 && this.playerFullscreen) {
            ((RequestBuilder)((RequestBuilder)Glide.with((View)this.previewImageView).load(Utils.convertVttToJpg(this.previewImageVTT)).override(Integer.MIN_VALUE, Integer.MIN_VALUE)).transform((Transformation)new GlideThumbnailTransformation(currentPosition, this.vttParser != null ? this.vttParser.getVttSegmentList() : null))).into(this.previewImageView);
        }
    }

    @OptIn(markerClass={UnstableApi.class})
    private void generateSeekCaption(int isVttEnabled, Video videoVO) {
        if (isVttEnabled > 0 && Build.VERSION.SDK_INT >= 24) {
            if (videoVO.getTracks() != null) {
                this.previewImageVTT = videoVO.getTracks().stream().filter(track -> "storyboard".equals(track.getKind())).map(Track::getSrc).findFirst().orElse("");
            }
            if (isVttEnabled == 1) {
                this.progressBar.setPreviewEnabled(true);
            } else {
                this.progressBar.setPreviewEnabled(false);
            }
            if (!this.previewImageVTT.equals("")) {
                this.vttParser = new VttParser(this.previewImageVTT);
            }
        }
    }

    public void addTrackSubtitles(List<Track> tracks, boolean autoplayCC) {
        TrackSelector trackSelector;
        if (tracks == null || tracks.isEmpty()) {
            this.btnCC.setVisibility(8);
            return;
        }
        MediaItem currentItem = this.player.getCurrentMediaItem();
        if (currentItem == null) {
            this.btnCC.setVisibility(8);
            return;
        }
        ArrayList<MediaItem.SubtitleConfiguration> subtitleConfigs = new ArrayList<MediaItem.SubtitleConfiguration>();
        for (Language lang : Utils.extractLanguagesForCaptions(tracks)) {
            if (lang.getSrc() == null) continue;
            MediaItem.SubtitleConfiguration subtitleConfiguration = new MediaItem.SubtitleConfiguration.Builder(Uri.parse((String)lang.getSrc())).setMimeType("text/vtt").setLanguage(lang.getLang()).setLabel(lang.getLabel()).build();
            subtitleConfigs.add(subtitleConfiguration);
        }
        if (subtitleConfigs.isEmpty()) {
            this.btnCC.setVisibility(8);
            return;
        }
        this.isCcEnabled = true;
        MediaItem newMediaItem = currentItem.buildUpon().setSubtitleConfigurations(subtitleConfigs).build();
        long currentPosition = this.player.getCurrentPosition();
        this.player.setMediaItem(newMediaItem, currentPosition);
        if (autoplayCC && (trackSelector = this.player.getTrackSelector()) instanceof DefaultTrackSelector) {
            DefaultTrackSelector trackSelector2 = (DefaultTrackSelector)trackSelector;
            String firstLanguage = ((MediaItem.SubtitleConfiguration)subtitleConfigs.get((int)0)).language;
            if (firstLanguage != null && !firstLanguage.isEmpty()) {
                trackSelector2.setParameters(trackSelector2.buildUponParameters().setPreferredTextLanguage(firstLanguage).setRendererDisabled(3, false));
            } else {
                trackSelector2.setParameters(trackSelector2.buildUponParameters().setSelectUndeterminedTextLanguage(true).setRendererDisabled(3, false));
            }
        }
        Utils.setSubtitleBottomOffset(this.playerView.getSubtitleView(), this.ccBottomOffset);
        this.btnCC.setVisibility(0);
        this.btnCC.setEnabled(true);
        this.initSubtitleButton();
    }

    private void initSubtitleButton() {
        this.btnCC.setOnClickListener(v -> this.showSubtitleSelectionDialog(this.context, this.player));
    }

    @UnstableApi
    private void showSubtitleSelectionDialog(Context context, ExoPlayer player) {
        TrackSelector trackSelector = player.getTrackSelector();
        if (!(trackSelector instanceof DefaultTrackSelector)) {
            return;
        }
        DefaultTrackSelector trackSelector2 = (DefaultTrackSelector)trackSelector;
        List<Format> formats = Utils.getAvailableSubtitleFormats(trackSelector2);
        ArrayList<String> labelList = new ArrayList<String>();
        for (int i = 0; i < formats.size(); ++i) {
            String label = formats.get((int)i).label;
            if (label == null) continue;
            labelList.add(label);
        }
        labelList.add(0, "Off");
        CharSequence[] labelsArray = labelList.toArray(new String[0]);
        new AlertDialog.Builder(context).setTitle((CharSequence)Utils.getTranslationByCode(context, "subtitle", this.getPlayerLanguage())).setSingleChoiceItems(labelsArray, this.captionSelectedIndex, (dialog, which) -> {
            dialog.dismiss();
            if (which == 0) {
                Utils.selectSubtitle(trackSelector2, null);
                this.btnCC.setAlpha(0.5f);
            } else {
                Format selected = (Format)formats.get(which - 1);
                Utils.selectSubtitle(trackSelector2, selected);
                this.btnCC.setAlpha(1.0f);
            }
        }).show();
    }

    @Override
    public List<String> getAvailableSubtitles() {
        ArrayList<String> subtitles = new ArrayList<String>();
        if (this.player == null) {
            Log.w((String)TAG, (String)"getAvailableSubtitles: player is null. Subtitle list is unavailable.");
            return subtitles;
        }
        TrackSelector trackSelector = this.player.getTrackSelector();
        if (!(trackSelector instanceof DefaultTrackSelector)) {
            return subtitles;
        }
        DefaultTrackSelector trackSelector2 = (DefaultTrackSelector)trackSelector;
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = trackSelector2.getCurrentMappedTrackInfo();
        if (mappedTrackInfo == null) {
            return subtitles;
        }
        for (int rendererIndex = 0; rendererIndex < mappedTrackInfo.getRendererCount(); ++rendererIndex) {
            if (mappedTrackInfo.getRendererType(rendererIndex) != 3) continue;
            TrackGroupArray trackGroups = mappedTrackInfo.getTrackGroups(rendererIndex);
            for (int groupIndex = 0; groupIndex < trackGroups.length; ++groupIndex) {
                TrackGroup trackGroup = trackGroups.get(groupIndex);
                for (int trackIndex = 0; trackIndex < trackGroup.length; ++trackIndex) {
                    Format format = trackGroup.getFormat(trackIndex);
                    if (format.label != null) {
                        subtitles.add(format.label);
                        continue;
                    }
                    if (format.language != null) {
                        subtitles.add(format.language);
                        continue;
                    }
                    subtitles.add("Subtitle " + (subtitles.size() + 1));
                }
            }
        }
        return subtitles;
    }

    @Override
    public void selectSubtitleLanguage(String label) {
        if (this.player == null) {
            Log.w((String)TAG, (String)"selectSubtitle: player is null. Cannot select subtitle.");
            return;
        }
        TrackSelector trackSelector = this.player.getTrackSelector();
        if (!(trackSelector instanceof DefaultTrackSelector)) {
            return;
        }
        DefaultTrackSelector trackSelector2 = (DefaultTrackSelector)trackSelector;
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = trackSelector2.getCurrentMappedTrackInfo();
        if (mappedTrackInfo == null) {
            return;
        }
        for (int rendererIndex = 0; rendererIndex < mappedTrackInfo.getRendererCount(); ++rendererIndex) {
            if (mappedTrackInfo.getRendererType(rendererIndex) != 3) continue;
            TrackGroupArray trackGroups = mappedTrackInfo.getTrackGroups(rendererIndex);
            for (int groupIndex = 0; groupIndex < trackGroups.length; ++groupIndex) {
                TrackGroup trackGroup = trackGroups.get(groupIndex);
                for (int trackIndex = 0; trackIndex < trackGroup.length; ++trackIndex) {
                    String formatLabel;
                    Format format = trackGroup.getFormat(trackIndex);
                    String string2 = formatLabel = format.label != null ? format.label : format.language;
                    if (label == null || !label.equals(formatLabel)) continue;
                    DefaultTrackSelector.SelectionOverride override = new DefaultTrackSelector.SelectionOverride(groupIndex, new int[]{trackIndex});
                    DefaultTrackSelector.Parameters parameters = trackSelector2.buildUponParameters().setRendererDisabled(rendererIndex, false).setSelectionOverride(rendererIndex, trackGroups, override).build();
                    trackSelector2.setParameters((TrackSelectionParameters)parameters);
                    return;
                }
            }
        }
    }

    @Override
    public List<Video> getCurrentVideoList() {
        return this.videoVOS;
    }

    @Override
    public void playSelectedVideo(Video video) {
        if (this.videoVOS != null && video != null) {
            int index = this.videoVOS.indexOf(video);
            if (index != -1) {
                this.bridPlayerEngine.playVideoWithIndex(index);
            } else {
                Log.w((String)"Player", (String)"Selected video not found in the list.");
            }
        }
    }

    private class PlayerEventListener
    implements Player.Listener {
        private PlayerEventListener() {
        }

        @SuppressLint(value={"SuspiciousIndentation"})
        public void onEvents(Player player, Player.Events events) {
            super.onEvents(player, events);
            String[] a = new String[events.size()];
            for (int i = 0; i < events.size(); ++i) {
                a[i] = String.valueOf(events.get(i));
            }
            Utils.log(this.getClass(), "onEvents", a);
        }

        public void onTimelineChanged(Timeline timeline, int reason) {
            super.onTimelineChanged(timeline, reason);
            if (BridPlayerImpl.this.videoSupport != null) {
                BridPlayerImpl.this.videoSupport.onTimelineChanged(timeline);
            }
        }

        public void onTracksChanged(Tracks tracks) {
            TrackSelector trackSelector = BridPlayerImpl.this.player.getTrackSelector();
            if (trackSelector instanceof DefaultTrackSelector) {
                DefaultTrackSelector trackSelector2 = (DefaultTrackSelector)trackSelector;
                Format activeSubtitle = Utils.getActiveSubtitleFormat(tracks);
                List<Format> formats = Utils.getAvailableSubtitleFormats(trackSelector2);
                BridPlayerImpl.this.captionSelectedIndex = Utils.getSubtitleFormatIndex(activeSubtitle, formats);
                if (BridPlayerImpl.this.captionSelectedIndex > 0) {
                    BridPlayerImpl.this.btnCC.setAlpha(1.0f);
                } else {
                    BridPlayerImpl.this.btnCC.setAlpha(0.5f);
                }
                Log.d((String)BridPlayerImpl.TAG, (String)("Selected subtitle index: " + BridPlayerImpl.this.captionSelectedIndex));
            }
        }

        public void onRenderedFirstFrame() {
            super.onRenderedFirstFrame();
            Utils.log(this.getClass(), "onRenderedFirstFrame", new String[0]);
            if (!UtilsKt.isSDKRunningOnTvDevice(BridPlayerImpl.this.context)) {
                this.handleLiveStreamVideo();
                this.handleMuteState();
                this.handlePipMode();
                BridPlayerImpl.this.progressBar.showScrubber();
            } else {
                this.handleTvDeviceLiveStream();
            }
            if (BridPlayerImpl.this.bridPlayerEngine != null) {
                BridPlayerImpl.this.bridPlayerEngine.onFirstFrameRendered();
            }
        }

        private void handleLiveStreamVideo() {
            if (BridPlayerImpl.this.isLiveStreamVideo()) {
                if (BridPlayerImpl.this.videoSupport == null) {
                    BridPlayerImpl.this.videoSupport = new HlsSupport(BridPlayerImpl.this);
                }
                BridPlayerImpl.this.videoSupport.adjustUI();
                if (BridPlayerImpl.this.videoSupport != null) {
                    BridPlayerImpl.this.videoSupport.continueSeek();
                }
            } else {
                BridPlayerImpl.this.resetUI();
            }
        }

        private void handleMuteState() {
            if (BridPlayerImpl.this.isMuted) {
                if (Boolean.TRUE.equals(BridPlayerImpl.this.playerVO.getUnmute_button())) {
                    BridPlayerImpl.this.showUnmuteButton();
                } else {
                    BridPlayerImpl.this.changeMute(true, false);
                }
            } else {
                BridPlayerImpl.this.changeMute(false, false);
            }
        }

        private void handlePipMode() {
            if (BridPlayerImpl.this.isInPipMode) {
                BridPlayerImpl.this.setVisibilityToPlayerControlsLayout(false);
            } else {
                BridPlayerImpl.this.updateMediaSessionPlaybackState(BridPlayerImpl.this.videoVOS.get(BridPlayerImpl.this.getCurrentVideoIndex()));
            }
        }

        private void handleTvDeviceLiveStream() {
            if (BridPlayerImpl.this.isLiveStreamVideo()) {
                if (BridPlayerImpl.this.videoSupport == null) {
                    BridPlayerImpl.this.videoSupport = new HlsSupport(BridPlayerImpl.this);
                }
                BridPlayerImpl.this.videoSupport.adjustUI();
            } else {
                BridPlayerImpl.this.resetUI();
            }
        }

        public void onPositionDiscontinuity(Player.PositionInfo oldPosition, Player.PositionInfo newPosition, int reason) {
            super.onPositionDiscontinuity(oldPosition, newPosition, reason);
            Utils.log(this.getClass(), "onPositionDiscontinuity", new String[0]);
            if (oldPosition.positionMs != newPosition.positionMs && mListener != null) {
                mListener.onEvent("vseek", BridPlayerImpl.this.getPlayerReference());
            }
            if (BridPlayerImpl.this.suppressSeekDiscontinuity > 0 && reason == 1) {
                --BridPlayerImpl.this.suppressSeekDiscontinuity;
                return;
            }
            if (reason == 1 && (oldPosition.contentPositionMs != newPosition.contentPositionMs || oldPosition.contentPositionMs != 0L)) {
                if (BridPlayerImpl.this.videoSupport != null) {
                    BridPlayerImpl.this.videoSupport.onSeekProcessed(BridPlayerImpl.this.player.getCurrentPosition());
                } else {
                    BridPlayerImpl.this.bridPlayerEngine.onPositionSeeked(BridPlayerImpl.this.player.getCurrentPosition());
                }
            }
        }

        public void onPlayWhenReadyChanged(boolean playWhenReady, int reason) {
            super.onPlayWhenReadyChanged(playWhenReady, reason);
            Utils.log(this.getClass(), "onPlayWhenReadyChanged", String.valueOf(playWhenReady), String.valueOf(reason));
            if (playWhenReady) {
                BridPlayerImpl.this.updatePlaybackState(3, (int)BridPlayerImpl.this.player.getCurrentPosition(), BridPlayerImpl.this.getCurrentVideo() != null ? BridPlayerImpl.this.getCurrentVideo().getId() : 1);
            } else {
                BridPlayerImpl.this.updatePlaybackState(2, (int)BridPlayerImpl.this.player.getCurrentPosition(), BridPlayerImpl.this.getCurrentVideo() != null ? BridPlayerImpl.this.getCurrentVideo().getId() : 1);
            }
            if (BridPlayerImpl.this.btnPlayTV != null && UtilsKt.isSDKRunningOnTvDevice(BridPlayerImpl.this.context)) {
                Utils.changePlayPauseWithAnimationTv(playWhenReady, BridPlayerImpl.this.context, BridPlayerImpl.this.btnPlayTV);
            }
            if (BridPlayerImpl.this.isLiveStreamVideo() && !playWhenReady && BridPlayerImpl.this.videoSupport != null) {
                BridPlayerImpl.this.videoSupport.manipulateLiveButton(false);
            }
            if (BridPlayerImpl.this.isLiveStreamVideo() && BridPlayerImpl.this.videoSupport != null) {
                ((BridPlayerEngineNew)BridPlayerImpl.this.bridPlayerEngine).resumeLivestreamVideo(playWhenReady);
            }
            BridPlayerImpl.this.playerView.setKeepScreenOn(playWhenReady);
        }

        public void onPlaybackStateChanged(int playbackState) {
            Utils.log(this.getClass(), "onPlaybackStateChanged", String.valueOf(playbackState));
            BridPlayerImpl.this.playerStatusChanged(BridPlayerImpl.this.player.getPlayWhenReady(), playbackState);
        }

        public void onPlayerError(PlaybackException e) {
            Utils.log(this.getClass(), "onPlayerError", e.getMessage());
            String errorString = e.getMessage();
            if (errorString != null) {
                BridPlayerImpl.this.toast(errorString, 2);
            }
            BridPlayerImpl.this.sendAnalytics(new AnalyticData("ve", null));
            if (!BridPlayerImpl.this.hasInternet) {
                BridPlayerImpl.this.showNetworkErrorView();
                BridPlayerImpl.this.playerView.setUseController(false);
                if (mListener != null) {
                    mListener.onEvent("neterror", BridPlayerImpl.this.getPlayerReference());
                }
            } else if (mListener != null) {
                if (BridPlayerImpl.this.isHlsVideo()) {
                    mListener.onEvent("liveerror", BridPlayerImpl.this.getPlayerReference());
                } else {
                    mListener.onEvent("error", BridPlayerImpl.this.getPlayerReference());
                }
            }
        }
    }

    private class MediaSessionCallback
    extends MediaSessionCompat.Callback {
        private BridStyledPlayerView playerView;

        public MediaSessionCallback(BridStyledPlayerView playerView) {
            this.playerView = playerView;
        }

        public void onSeekTo(long pos) {
            super.onSeekTo(pos);
            BridPlayerImpl.this.seekToPosition(pos);
            BridPlayerImpl.this.updatePlaybackState(3, 822L, (int)BridPlayerImpl.this.player.getCurrentPosition(), BridPlayerImpl.this.getCurrentVideo() != null ? BridPlayerImpl.this.getCurrentVideo().getId() : 1);
        }

        public void onFastForward() {
            super.onFastForward();
        }

        public void onPlay() {
            super.onPlay();
            if (!BridPlayerImpl.this.isPlayingAd()) {
                BridPlayerImpl.this.play();
            }
        }

        public void onPause() {
            super.onPause();
            if (!BridPlayerImpl.this.isPlayingAd()) {
                BridPlayerImpl.this.pause();
            }
        }

        public void onSkipToNext() {
            super.onSkipToNext();
            if (BridPlayerImpl.this.currentVideo < BridPlayerImpl.this.videoVOS.size() && !BridPlayerImpl.this.isPlayingAd()) {
                BridPlayerImpl.this.bridPlayerEngine.onNextVideoCalled();
                if (BridPlayerImpl.this.currentVideo + 1 < BridPlayerImpl.this.videoVOS.size()) {
                    BridPlayerImpl.this.updatePlaybackState(3, 822L, (int)BridPlayerImpl.this.player.getCurrentPosition(), BridPlayerImpl.this.getCurrentVideo() != null ? BridPlayerImpl.this.getCurrentVideo().getId() : 1);
                } else {
                    BridPlayerImpl.this.updatePlaybackState(3, 790L, (int)BridPlayerImpl.this.player.getCurrentPosition(), BridPlayerImpl.this.getCurrentVideo() != null ? BridPlayerImpl.this.getCurrentVideo().getId() : 1);
                }
            }
        }

        public void onSkipToPrevious() {
            super.onSkipToPrevious();
            if (BridPlayerImpl.this.currentVideo > 0 && !BridPlayerImpl.this.isPlayingAd()) {
                BridPlayerImpl.this.bridPlayerEngine.onPreviousVideoCalled();
                if (BridPlayerImpl.this.currentVideo - 1 > 0) {
                    BridPlayerImpl.this.updatePlaybackState(3, 822L, (int)BridPlayerImpl.this.player.getCurrentPosition(), BridPlayerImpl.this.getCurrentVideo() != null ? BridPlayerImpl.this.getCurrentVideo().getId() : 1);
                } else {
                    BridPlayerImpl.this.updatePlaybackState(3, 806L, (int)BridPlayerImpl.this.player.getCurrentPosition(), BridPlayerImpl.this.getCurrentVideo() != null ? BridPlayerImpl.this.getCurrentVideo().getId() : 1);
                }
            }
        }
    }
}

