/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.player.settings;

import android.content.Context;
import android.os.Build;
import android.view.View;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import androidx.media3.common.PlaybackParameters;
import androidx.media3.common.util.UnstableApi;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import tv.brid.sdk.R;
import tv.brid.sdk.api.BridPlayerImpl;
import tv.brid.sdk.player.adapters.RenditionOptionTvAdapter;
import tv.brid.sdk.player.adapters.SettingsOptionTvAdapter;
import tv.brid.sdk.player.settings.RenditionOption;
import tv.brid.sdk.player.settings.SpeedOption;
import tv.brid.sdk.player.ui.BridTvFocusChangeListener;

@UnstableApi
public class SettingsTvViewManager
implements View.OnClickListener {
    LinearLayout settingsHolder;
    View renditionSettingsTv;
    View speedSettingsTv;
    View captionsSettingsTv;
    Context context;
    TextView settingsTitle;
    Boolean isSettingsMenuOnTvOpen;
    RecyclerView settingsOptionsRv;
    BridPlayerImpl bridPlayer;
    private SettingsOptionTvAdapter settingsOptionTvAdapter;

    public SettingsTvViewManager(LinearLayout settingsHolder, Context context, BridTvFocusChangeListener bridTvFocusChangeListener, BridPlayerImpl bridPlayer) {
        this.settingsHolder = settingsHolder;
        this.context = context;
        this.bridPlayer = bridPlayer;
        this.isSettingsMenuOnTvOpen = true;
        this.settingsTitle = (TextView)settingsHolder.findViewById(R.id.tvSettingsHolderTitle);
        this.settingsOptionsRv = (RecyclerView)settingsHolder.findViewById(R.id.rv_options_list_tv);
        this.renditionSettingsTv = settingsHolder.findViewById(R.id.rendition_settings_tv);
        this.renditionSettingsTv.setOnClickListener((View.OnClickListener)this);
        this.speedSettingsTv = settingsHolder.findViewById(R.id.speed_settings_tv);
        this.speedSettingsTv.setOnClickListener((View.OnClickListener)this);
        this.captionsSettingsTv = settingsHolder.findViewById(R.id.captions_settings_tv);
        this.captionsSettingsTv.setOnClickListener((View.OnClickListener)this);
        this.changeFocusForSettingsTvMenu(this.renditionSettingsTv, R.drawable.icon_hd, R.drawable.icon_hd_selected);
        this.changeFocusForSettingsTvMenu(this.speedSettingsTv, R.drawable.icon_speed, R.drawable.icon_speed_selected);
        this.changeFocusForSettingsTvMenu(this.captionsSettingsTv, R.drawable.icon_captions, R.drawable.icon_captions_selected);
        this.renditionSettingsTv.setOnKeyListener((View.OnKeyListener)bridTvFocusChangeListener);
        this.speedSettingsTv.setOnKeyListener((View.OnKeyListener)bridTvFocusChangeListener);
        this.captionsSettingsTv.setOnKeyListener((View.OnKeyListener)bridTvFocusChangeListener);
        this.renditionSettingsTv.requestFocus();
    }

    private void changeFocusForSettingsTvMenu(View settingsItem, final @DrawableRes int icon, final @DrawableRes int iconSelected) {
        final TextView renditionSettingsTvText = (TextView)settingsItem.findViewById(R.id.tv_settings_text);
        final TextView renditionSettingsTvSubtitle = (TextView)settingsItem.findViewById(R.id.tv_settings_subtitle);
        final ImageButton renditionSettingsTvIcon = (ImageButton)settingsItem.findViewById(R.id.settings_icon_img);
        final ImageView renditionOpenSettingsTvIcon = (ImageView)settingsItem.findViewById(R.id.open_settings_btn);
        settingsItem.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            @RequiresApi(api=23)
            public void onFocusChange(View view, boolean b) {
                if (b) {
                    renditionSettingsTvText.setTextColor(ContextCompat.getColor((Context)SettingsTvViewManager.this.context, (int)R.color.tv_text_main_selected));
                    renditionSettingsTvSubtitle.setTextColor(ContextCompat.getColor((Context)SettingsTvViewManager.this.context, (int)R.color.tv_text_subtitle_selected));
                    renditionSettingsTvIcon.setImageDrawable(ContextCompat.getDrawable((Context)SettingsTvViewManager.this.context, (int)iconSelected));
                    renditionOpenSettingsTvIcon.setImageDrawable(ContextCompat.getDrawable((Context)SettingsTvViewManager.this.context, (int)R.drawable.icon_right_selected));
                } else {
                    renditionSettingsTvText.setTextColor(ContextCompat.getColor((Context)SettingsTvViewManager.this.context, (int)R.color.tv_text_main));
                    renditionSettingsTvSubtitle.setTextColor(ContextCompat.getColor((Context)SettingsTvViewManager.this.context, (int)R.color.tv_text_subtitle));
                    renditionSettingsTvIcon.setImageDrawable(ContextCompat.getDrawable((Context)SettingsTvViewManager.this.context, (int)icon));
                    renditionOpenSettingsTvIcon.setImageDrawable(ContextCompat.getDrawable((Context)SettingsTvViewManager.this.context, (int)R.drawable.icon_right));
                }
            }
        });
    }

    public Boolean getSettingsMenuOnTvOpen() {
        return this.isSettingsMenuOnTvOpen;
    }

    public void setSettingsMenuOnTvOpen(Boolean settingsMenuOnTvOpen) {
        this.isSettingsMenuOnTvOpen = settingsMenuOnTvOpen;
    }

    @RequiresApi(api=24)
    public void onClick(View view) {
        if (view.getId() == R.id.rendition_settings_tv) {
            this.handleVideoRenditionSettings(view);
        } else if (view.getId() == R.id.speed_settings_tv) {
            this.handleVideoSpeedSettings(view);
        } else if (view.getId() == R.id.captions_settings_tv) {
            this.handleVideoCaptionsSettings();
        }
    }

    private void handleVideoCaptionsSettings() {
    }

    private void handleVideoSpeedSettings(View view) {
        this.hideAllSettings();
        this.settingsTitle.setText((CharSequence)"Video playback speed");
        final TextView subtitleText = (TextView)view.findViewById(R.id.tv_settings_subtitle);
        ArrayList<SpeedOption> options = new ArrayList<SpeedOption>();
        int position = 0;
        for (float i = 0.25f; i <= 2.0f; i += 0.25f) {
            options.add(new SpeedOption(i, position++));
        }
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.context);
        this.settingsOptionTvAdapter = new SettingsOptionTvAdapter(this.context, options, new SettingsOptionTvAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(float speed, String displayText) {
                PlaybackParameters parameters = new PlaybackParameters(speed);
                SettingsTvViewManager.this.bridPlayer.getNativePlayer().setPlaybackParameters(parameters);
                subtitleText.setText((CharSequence)displayText);
                SettingsTvViewManager.this.bridPlayer.closeSettingsMenuOnTv();
                SettingsTvViewManager.this.settingsOptionsRv.setVisibility(8);
                SettingsTvViewManager.this.showAllSettings();
            }

            @Override
            public void onItemBackClick() {
                SettingsTvViewManager.this.settingsOptionsRv.setVisibility(8);
                SettingsTvViewManager.this.showAllSettings();
            }
        });
        this.settingsOptionsRv.setVisibility(0);
        this.settingsOptionsRv.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.settingsOptionsRv.setAdapter((RecyclerView.Adapter)this.settingsOptionTvAdapter);
        this.settingsOptionsRv.post(() -> {
            SettingsOptionTvAdapter.ViewHolder viewHolder = (SettingsOptionTvAdapter.ViewHolder)this.settingsOptionsRv.findViewHolderForAdapterPosition(this.getPositionByPlaybackSpeed(this.bridPlayer.getNativePlayer().getPlaybackParameters().speed, options));
            if (viewHolder != null) {
                this.settingsOptionTvAdapter.setCheckedPosition(this.getPositionByPlaybackSpeed(this.bridPlayer.getNativePlayer().getPlaybackParameters().speed, options));
                viewHolder.itemView.requestFocus();
            }
        });
    }

    @RequiresApi(api=24)
    private void handleVideoRenditionSettings(View view) {
        this.hideAllSettings();
        this.settingsTitle.setText((CharSequence)"Video playback speed");
        final TextView subtitleText = (TextView)view.findViewById(R.id.tv_settings_subtitle);
        List<RenditionOption> renditionOptions = this.bridPlayer.getBridPlayerEngine().returnRenditionMap().entrySet().stream().map(new Function<Map.Entry<String, String>, RenditionOption>(){
            private final AtomicInteger counter = new AtomicInteger(0);

            @Override
            public RenditionOption apply(Map.Entry<String, String> entry) {
                return new RenditionOption(entry.getKey(), entry.getValue(), this.counter.getAndIncrement());
            }
        }).collect(Collectors.toList());
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.context);
        RenditionOptionTvAdapter renditionOptionTvAdapter = new RenditionOptionTvAdapter(this.context, renditionOptions, new RenditionOptionTvAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(String rendition) {
                subtitleText.setText((CharSequence)rendition);
                SettingsTvViewManager.this.bridPlayer.changeVideoSource(rendition);
                SettingsTvViewManager.this.bridPlayer.closeSettingsMenuOnTv();
                SettingsTvViewManager.this.settingsOptionsRv.setVisibility(8);
                SettingsTvViewManager.this.showAllSettings();
            }

            @Override
            public void onItemBackClick() {
                SettingsTvViewManager.this.settingsOptionsRv.setVisibility(8);
                SettingsTvViewManager.this.showAllSettings();
            }
        });
        this.settingsOptionsRv.setVisibility(0);
        this.settingsOptionsRv.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.settingsOptionsRv.setAdapter((RecyclerView.Adapter)renditionOptionTvAdapter);
        this.settingsOptionsRv.post(() -> {
            RenditionOptionTvAdapter.ViewHolder viewHolder = (RenditionOptionTvAdapter.ViewHolder)this.settingsOptionsRv.findViewHolderForAdapterPosition(this.getPositionByRendition(this.bridPlayer.getBridPlayerEngine().currentRendition(), renditionOptions));
            if (viewHolder != null) {
                renditionOptionTvAdapter.setCheckedPosition(this.getPositionByRendition(this.bridPlayer.getBridPlayerEngine().currentRendition(), renditionOptions));
                viewHolder.itemView.requestFocus();
            }
        });
    }

    private void hideAllSettings() {
        this.renditionSettingsTv.setVisibility(8);
        this.speedSettingsTv.setVisibility(8);
    }

    private void showAllSettings() {
        this.renditionSettingsTv.setVisibility(0);
        this.speedSettingsTv.setVisibility(0);
    }

    private int getPositionByPlaybackSpeed(float speed, List<SpeedOption> options) {
        if (Build.VERSION.SDK_INT >= 24) {
            if (options.stream().anyMatch(x -> x.getSpeed() == speed)) {
                return options.stream().filter(x -> x.getSpeed() == speed).findFirst().get().getPosition();
            }
            return 0;
        }
        return 0;
    }

    private int getPositionByRendition(String rendition, List<RenditionOption> renditionOptionList) {
        if (Build.VERSION.SDK_INT >= 24) {
            if (renditionOptionList.stream().anyMatch(x -> x.getLabel().equals(rendition))) {
                return renditionOptionList.stream().filter(x -> x.getLabel().equals(rendition)).findFirst().get().getPosition();
            }
            return 0;
        }
        return 0;
    }
}

