/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.player.ui.glide_transformation;

import android.content.Context;
import android.graphics.Bitmap;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.renderscript.Type;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import java.security.MessageDigest;

public class GlideBlurTransformation
extends BitmapTransformation {
    private RenderScript rs;

    public GlideBlurTransformation(Context context) {
        this.rs = RenderScript.create((Context)context);
    }

    protected Bitmap transform(BitmapPool pool, Bitmap toTransform, int outWidth, int outHeight) {
        Bitmap blurredBitmap = toTransform.copy(Bitmap.Config.ARGB_8888, true);
        Allocation input = Allocation.createFromBitmap((RenderScript)this.rs, (Bitmap)blurredBitmap, (Allocation.MipmapControl)Allocation.MipmapControl.MIPMAP_FULL, (int)128);
        Allocation output = Allocation.createTyped((RenderScript)this.rs, (Type)input.getType());
        ScriptIntrinsicBlur script = ScriptIntrinsicBlur.create((RenderScript)this.rs, (Element)Element.U8_4((RenderScript)this.rs));
        script.setInput(input);
        script.setRadius(25.0f);
        script.forEach(output);
        output.copyTo(blurredBitmap);
        return blurredBitmap;
    }

    public void updateDiskCacheKey(MessageDigest messageDigest) {
        messageDigest.update("blur transformation".getBytes());
    }
}

