/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.player.adapters;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import tv.brid.domain.Video;
import tv.brid.sdk.R;
import tv.brid.sdk.Utils;
import tv.brid.sdk.player.ui.Image;

public class PlaylistTvAdapter
extends RecyclerView.Adapter<VideoViewHolder> {
    private static final int RESOURCE = R.layout.item_poster;
    private ArrayList<Video> videoList;
    private LayoutInflater inflater;
    private int currentVideo;
    private int selectedPosition = 0;
    private OnItemClickListener listener;
    @DrawableRes
    private int placeholderResId = 0;

    public PlaylistTvAdapter(Context context, ArrayList<Video> videoVOS, int currentVideo, OnItemClickListener listener) {
        this.inflater = LayoutInflater.from((Context)context);
        this.videoList = videoVOS;
        this.currentVideo = currentVideo;
        this.listener = listener;
    }

    @NonNull
    public VideoViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = this.inflater.inflate(RESOURCE, parent, false);
        return new VideoViewHolder(itemView);
    }

    public void onBindViewHolder(final VideoViewHolder holder, final @SuppressLint(value={"RecyclerView"}) int position) {
        Video videoItem = this.videoList.get(position);
        holder.titleTv.setText((CharSequence)videoItem.getName());
        holder.durationTv.setText((CharSequence)Utils.convertStringToInt(videoItem.getDuration()));
        holder.itemView.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    PlaylistTvAdapter.this.selectedPosition = holder.getAdapterPosition();
                    holder.focusFrame.setBackground(ContextCompat.getDrawable((Context)holder.itemView.getContext(), (int)R.drawable.focused_item_background));
                } else {
                    holder.focusFrame.setBackground(ContextCompat.getDrawable((Context)holder.itemView.getContext(), (int)R.drawable.default_item_background));
                }
            }
        });
        new Image().loadImageInTvList(videoItem.getImage(), holder.posterImage, 24, this.placeholderResId);
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PlaylistTvAdapter.this.listener.onItemClick(position);
            }
        });
        holder.itemView.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View view, int i, KeyEvent keyEvent) {
                if (i == 4 && keyEvent.getAction() == 0) {
                    PlaylistTvAdapter.this.listener.onItemBackClick();
                    return true;
                }
                return false;
            }
        });
    }

    public int getItemCount() {
        return this.videoList.size();
    }

    public void setCurrentVideo(int currentVideo) {
        this.currentVideo = currentVideo;
    }

    public void setPlaceholderResId(@DrawableRes int drawableRes) {
        this.placeholderResId = drawableRes;
    }

    public int getLastSelectedPosition() {
        return this.selectedPosition;
    }

    public static interface OnItemClickListener {
        public void onItemClick(int var1);

        public void onItemBackClick();
    }

    public static class VideoViewHolder
    extends RecyclerView.ViewHolder {
        public ImageView posterImage;
        public TextView titleTv;
        public TextView subtitleTv;
        public TextView durationTv;
        public View focusFrame;

        public VideoViewHolder(View itemView) {
            super(itemView);
            this.posterImage = (ImageView)itemView.findViewById(R.id.poster_image);
            this.titleTv = (TextView)itemView.findViewById(R.id.playlistTitleTv);
            this.subtitleTv = (TextView)itemView.findViewById(R.id.playlistSubtitleTv);
            this.durationTv = (TextView)itemView.findViewById(R.id.time_duration_tv);
            this.focusFrame = itemView.findViewById(R.id.focus_frame);
        }
    }
}

