/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.player.ui;

import android.view.View;
import android.widget.PopupWindow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import tv.brid.sdk.player.settings.OptionsList;
import tv.brid.sdk.player.settings.SettingViewClickedListener;

public class ResolutionView
extends OptionsList<String> {
    private SettingViewClickedListener settingViewClickedListener;

    public ResolutionView(View styledPlayerControlView, PopupWindow.OnDismissListener dismissListener, SettingViewClickedListener settingViewClickedListener, Map<String, String> sourcesMap, String currentValue) {
        super(styledPlayerControlView, dismissListener, sourcesMap, currentValue);
        this.settingViewClickedListener = settingViewClickedListener;
    }

    @Override
    public void onSettingClicked(String option) {
        this.settingViewClickedListener.onSettingViewClicked(option.toLowerCase(Locale.ROOT));
    }

    @Override
    public int setSelectedIndex() {
        for (int i = 0; i < this.sources.size(); ++i) {
            if (!((String)this.sources.get(i)).equals(this.currentValue)) continue;
            return i;
        }
        return 0;
    }

    public static String getRenditionOptionToNameSelected(String renditionName) {
        if (renditionName.equals("AUTO") || renditionName.equals("auto") || renditionName.equals("Auto")) {
            return "Auto";
        }
        return renditionName;
    }

    @Override
    protected List<String> convertMapToList(Map<String, String> sourcesMap) {
        ArrayList<Integer> sources = new ArrayList<Integer>();
        for (String s : sourcesMap.keySet()) {
            if (!ResolutionView.isInteger(s.split("p")[0], 10)) continue;
            sources.add(Integer.parseInt(s.split("p")[0]));
        }
        Collections.sort(sources);
        Collections.reverse(sources);
        ArrayList<String> finalList = new ArrayList<String>();
        if (sourcesMap.containsKey("AUTO")) {
            finalList.add("AUTO");
        }
        Iterator iterator = sources.iterator();
        while (iterator.hasNext()) {
            int item = (Integer)iterator.next();
            finalList.add(item + "p");
        }
        return finalList;
    }
}

