/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.player.ui;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.load.MultiTransformation;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import java.io.InputStream;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.brid.sdk.R;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J*\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\rJ*\u0010\u000f\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\r\u00a8\u0006\u0010"}, d2={"Ltv/brid/sdk/player/ui/Image;", "", "()V", "getBitmapFile", "Landroid/graphics/Bitmap;", "url", "", "loadImageInTvList", "", "imageUrl", "imageView", "Landroid/widget/ImageView;", "cornerRadius", "", "placeholderId", "loadImageInView", "bridsdk_release"})
public final class Image {
    @Nullable
    public final Bitmap getBitmapFile(@Nullable String url) {
        Bitmap bitmap = null;
        try {
            InputStream inputStream = new URL(url).openStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"URL(url).openStream()");
            InputStream in = inputStream;
            bitmap = BitmapFactory.decodeStream((InputStream)in);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bitmap;
    }

    public final void loadImageInView(@Nullable String imageUrl, @NotNull ImageView imageView, int cornerRadius, @DrawableRes int placeholderId) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        try {
            int videoPlaceholder = placeholderId != 0 ? placeholderId : R.drawable.video_placeholder;
            RequestManager requestManager = Glide.with((View)((View)imageView));
            Object object = imageUrl;
            if (object == null) {
                object = videoPlaceholder;
            }
            ((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)requestManager.load(object).centerCrop()).transform((Transformation)new RoundedCorners(cornerRadius))).placeholder(videoPlaceholder)).error(videoPlaceholder)).skipMemoryCache(true)).into(imageView);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
        }
    }

    public final void loadImageInTvList(@Nullable String imageUrl, @NotNull ImageView imageView, int cornerRadius, @DrawableRes int placeholderId) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        try {
            int videoPlaceholder = placeholderId != 0 ? placeholderId : R.drawable.video_placeholder;
            Transformation[] transformationArray = new Transformation[]{new CenterCrop(), new RoundedCorners(cornerRadius)};
            ((RequestBuilder)((RequestBuilder)((RequestBuilder)Glide.with((Context)imageView.getContext()).load(imageUrl).transform((Transformation)new MultiTransformation(transformationArray))).placeholder(videoPlaceholder)).error(videoPlaceholder)).into(imageView);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
        }
    }
}

