/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.player.ui;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import androidx.core.content.ContextCompat;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.brid.sdk.R;
import tv.brid.sdk.player.ui.CircleClipTapView;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u00105\u001a\u000203H\u0002J\u0010\u00106\u001a\u00020+2\u0006\u00107\u001a\u00020\u000eH\u0002J\u0010\u00108\u001a\u00020+2\u0006\u00109\u001a\u00020:H\u0014J(\u0010;\u001a\u00020+2\u0006\u0010<\u001a\u00020\u00182\u0006\u0010=\u001a\u00020\u00182\u0006\u0010>\u001a\u00020\u00182\u0006\u0010?\u001a\u00020\u0018H\u0014J\u0014\u0010@\u001a\u00020+2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020+0*J\b\u0010B\u001a\u00020+H\u0002J\u0016\u0010C\u001a\u00020+2\u0006\u0010D\u001a\u00020\u000e2\u0006\u0010E\u001a\u00020\u000eR$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\u00188F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR$\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\u00188F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u000e\u0010!\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010)\u001a\b\u0012\u0004\u0012\u00020+0*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u000e\u00100\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Ltv/brid/sdk/player/ui/CircleClipTapView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "value", "", "animationDuration", "getAnimationDuration", "()J", "setAnimationDuration", "(J)V", "", "arcSize", "getArcSize", "()F", "setArcSize", "(F)V", "backgroundPaint", "Landroid/graphics/Paint;", "cX", "cY", "", "circleBackgroundColor", "getCircleBackgroundColor", "()I", "setCircleBackgroundColor", "(I)V", "circleColor", "getCircleColor", "setCircleColor", "circlePaint", "currentRadius", "forceReset", "", "heightPx", "isLeft", "maxRadius", "minRadius", "performAtEnd", "Lkotlin/Function0;", "", "getPerformAtEnd", "()Lkotlin/jvm/functions/Function0;", "setPerformAtEnd", "(Lkotlin/jvm/functions/Function0;)V", "shapePath", "Landroid/graphics/Path;", "valueAnimator", "Landroid/animation/ValueAnimator;", "widthPx", "getCircleAnimator", "invalidateWithCurrentRadius", "factor", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "w", "h", "oldw", "oldh", "resetAnimation", "body", "updatePathShape", "updatePosition", "x", "y", "bridsdk_release"})
@SourceDebugExtension(value={"SMAP\nCircleClipTapView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CircleClipTapView.kt\ntv/brid/sdk/player/ui/CircleClipTapView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,221:1\n1#2:222\n*E\n"})
public final class CircleClipTapView
extends View {
    @NotNull
    private Paint backgroundPaint;
    @NotNull
    private Paint circlePaint;
    private int widthPx;
    private int heightPx;
    @NotNull
    private Path shapePath;
    private boolean isLeft;
    private float cX;
    private float cY;
    private float currentRadius;
    private int minRadius;
    private int maxRadius;
    @Nullable
    private ValueAnimator valueAnimator;
    private boolean forceReset;
    @NotNull
    private Function0<Unit> performAtEnd;
    private float arcSize;

    public CircleClipTapView(@Nullable Context context, @NotNull AttributeSet attrs) {
        Paint $i$a$-requireNotNull-CircleClipTapView$222;
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.backgroundPaint = new Paint();
        this.circlePaint = new Paint();
        this.shapePath = new Path();
        this.isLeft = true;
        if (context == null) {
            boolean $i$a$-requireNotNull-CircleClipTapView$222 = false;
            String $i$a$-requireNotNull-CircleClipTapView$222 = "Context is null.";
            throw new IllegalArgumentException($i$a$-requireNotNull-CircleClipTapView$222.toString());
        }
        Paint $this$_init__u24lambda_u241 = $i$a$-requireNotNull-CircleClipTapView$222 = this.backgroundPaint;
        boolean bl = false;
        $this$_init__u24lambda_u241.setStyle(Paint.Style.FILL);
        $this$_init__u24lambda_u241.setAntiAlias(true);
        $this$_init__u24lambda_u241.setColor(ContextCompat.getColor((Context)context, (int)R.color.dtpv_yt_background_circle_color));
        Paint $this$_init__u24lambda_u242 = $i$a$-requireNotNull-CircleClipTapView$222 = this.circlePaint;
        boolean bl2 = false;
        $this$_init__u24lambda_u242.setStyle(Paint.Style.FILL);
        $this$_init__u24lambda_u242.setAntiAlias(true);
        $this$_init__u24lambda_u242.setColor(ContextCompat.getColor((Context)context, (int)R.color.dtpv_yt_tap_circle_color));
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        this.widthPx = dm.widthPixels;
        this.heightPx = dm.heightPixels;
        this.minRadius = (int)(30.0f * dm.density);
        this.maxRadius = (int)(400.0f * dm.density);
        this.updatePathShape();
        this.valueAnimator = this.getCircleAnimator();
        this.performAtEnd = performAtEnd.1.INSTANCE;
        this.arcSize = 80.0f;
    }

    @NotNull
    public final Function0<Unit> getPerformAtEnd() {
        return this.performAtEnd;
    }

    public final void setPerformAtEnd(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.performAtEnd = function0;
    }

    public final float getArcSize() {
        return this.arcSize;
    }

    public final void setArcSize(float value) {
        this.arcSize = value;
        this.updatePathShape();
    }

    public final int getCircleBackgroundColor() {
        return this.backgroundPaint.getColor();
    }

    public final void setCircleBackgroundColor(int value) {
        this.backgroundPaint.setColor(value);
    }

    public final int getCircleColor() {
        return this.circlePaint.getColor();
    }

    public final void setCircleColor(int value) {
        this.circlePaint.setColor(value);
    }

    public final long getAnimationDuration() {
        ValueAnimator valueAnimator = this.valueAnimator;
        return valueAnimator != null ? valueAnimator.getDuration() : 650L;
    }

    public final void setAnimationDuration(long value) {
        this.getCircleAnimator().setDuration(value);
    }

    public final void updatePosition(float x, float y) {
        boolean newIsLeft;
        this.cX = x;
        this.cY = y;
        boolean bl = newIsLeft = x <= (float)(this.getResources().getDisplayMetrics().widthPixels / 2);
        if (this.isLeft != newIsLeft) {
            this.isLeft = newIsLeft;
            this.updatePathShape();
        }
    }

    private final void invalidateWithCurrentRadius(float factor) {
        this.currentRadius = (float)this.minRadius + (float)(this.maxRadius - this.minRadius) * factor;
        this.invalidate();
    }

    private final void updatePathShape() {
        float halfWidth = (float)this.widthPx * 0.5f;
        this.shapePath.reset();
        float w = this.isLeft ? 0.0f : (float)this.widthPx;
        int f = this.isLeft ? 1 : -1;
        this.shapePath.moveTo(w, 0.0f);
        this.shapePath.lineTo((float)f * (halfWidth - this.arcSize) + w, 0.0f);
        this.shapePath.quadTo((float)f * (halfWidth + this.arcSize) + w, (float)this.heightPx / (float)2, (float)f * (halfWidth - this.arcSize) + w, (float)this.heightPx);
        this.shapePath.lineTo(w, (float)this.heightPx);
        this.shapePath.close();
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    private final ValueAnimator getCircleAnimator() {
        if (this.valueAnimator == null) {
            void $this$getCircleAnimator_u24lambda_u244;
            Object object = new float[]{0.0f, 1.0f};
            Object object2 = object = (Object)ValueAnimator.ofFloat((float[])object);
            CircleClipTapView circleClipTapView = this;
            boolean bl = false;
            $this$getCircleAnimator_u24lambda_u244.setDuration(this.getAnimationDuration());
            $this$getCircleAnimator_u24lambda_u244.addUpdateListener(arg_0 -> CircleClipTapView.getCircleAnimator$lambda$4$lambda$3(this, arg_0));
            $this$getCircleAnimator_u24lambda_u244.addListener(new Animator.AnimatorListener(this){
                final /* synthetic */ CircleClipTapView this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onAnimationStart(@NotNull Animator animation) {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    this.this$0.setVisibility(0);
                }

                public void onAnimationEnd(@NotNull Animator animation) {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    if (!CircleClipTapView.access$getForceReset$p(this.this$0)) {
                        this.this$0.getPerformAtEnd().invoke();
                    }
                }

                public void onAnimationCancel(@NotNull Animator animation) {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    String string2 = "Not yet implemented";
                    throw new NotImplementedError("An operation is not implemented: " + string2);
                }

                public void onAnimationRepeat(@NotNull Animator animation) {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    String string2 = "Not yet implemented";
                    throw new NotImplementedError("An operation is not implemented: " + string2);
                }
            });
            circleClipTapView.valueAnimator = (ValueAnimator)object;
        }
        ValueAnimator valueAnimator = this.valueAnimator;
        Intrinsics.checkNotNull((Object)valueAnimator);
        return valueAnimator;
    }

    public final void resetAnimation(@NotNull Function0<Unit> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        this.forceReset = true;
        this.getCircleAnimator().end();
        body.invoke();
        this.forceReset = false;
        this.getCircleAnimator().start();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.widthPx = w;
        this.heightPx = h;
        this.updatePathShape();
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        canvas.clipPath(this.shapePath);
        canvas.drawPath(this.shapePath, this.backgroundPaint);
        canvas.drawCircle(this.cX, this.cY, this.currentRadius, this.circlePaint);
    }

    private static final void getCircleAnimator$lambda$4$lambda$3(CircleClipTapView this$0, ValueAnimator it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getAnimatedValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
        this$0.invalidateWithCurrentRadius(((Float)object).floatValue());
    }

    public static final /* synthetic */ boolean access$getForceReset$p(CircleClipTapView $this) {
        return $this.forceReset;
    }
}

