/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.player.drm;

import android.content.Context;
import androidx.annotation.OptIn;
import androidx.media3.common.MediaItem;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DefaultHttpDataSource;
import androidx.media3.exoplayer.drm.DefaultDrmSessionManager;
import androidx.media3.exoplayer.drm.DrmSessionManager;
import androidx.media3.exoplayer.drm.DrmSessionManagerProvider;
import androidx.media3.exoplayer.drm.ExoMediaDrm;
import androidx.media3.exoplayer.drm.HttpMediaDrmCallback;
import androidx.media3.exoplayer.drm.MediaDrmCallback;
import androidx.media3.exoplayer.drm.MediaDrmCallbackException;
import java.util.UUID;
import tv.brid.domain.Video;
import tv.brid.sdk.player.drm.store.BaseKeyStore;
import tv.brid.sdk.player.drm.store.DrmKeyVO;

@UnstableApi
public class BridDrmSessionManagerProvider
implements DrmSessionManagerProvider {
    private Context context;
    private Video videoVO;
    BaseKeyStore baseKeyStore;
    DrmKeyVO drmKeyVO;

    public BridDrmSessionManagerProvider(Context context, Video videoVO) {
        this.context = context;
        this.videoVO = videoVO;
        this.baseKeyStore = BaseKeyStore.INSTANCE(context);
        this.drmKeyVO = this.baseKeyStore.get(String.valueOf(videoVO.getId()));
    }

    @OptIn(markerClass={UnstableApi.class})
    public DrmSessionManager get(MediaItem mediaItem) {
        DefaultDrmSessionManager drmSessionManager = new DefaultDrmSessionManager.Builder().build(new MediaDrmCallback(){

            public byte[] executeProvisionRequest(UUID uuid, ExoMediaDrm.ProvisionRequest request) throws MediaDrmCallbackException {
                return request.getData();
            }

            public byte[] executeKeyRequest(UUID uuid, ExoMediaDrm.KeyRequest request) throws MediaDrmCallbackException {
                if (BridDrmSessionManagerProvider.this.drmKeyVO != null) {
                    return BridDrmSessionManagerProvider.this.baseKeyStore.get(String.valueOf(BridDrmSessionManagerProvider.this.videoVO.getId())).getKey();
                }
                String licenceUrl = BridDrmSessionManagerProvider.this.videoVO.getDrmConfigVO().getWidevine().getWidevineAlpha().getServerURL();
                ExoMediaDrm.KeyRequest updatedRequest = new ExoMediaDrm.KeyRequest(request.getData(), licenceUrl);
                HttpMediaDrmCallback httpMediaDrmCallback = new HttpMediaDrmCallback(licenceUrl, (DataSource.Factory)new DefaultHttpDataSource.Factory());
                byte[] licence = httpMediaDrmCallback.executeKeyRequest(uuid, updatedRequest);
                DrmKeyVO drmKeyVO = new DrmKeyVO();
                drmKeyVO.setKey(licence);
                drmKeyVO.setVideoid(BridDrmSessionManagerProvider.this.videoVO.getId());
                drmKeyVO.setExpirationTime(System.currentTimeMillis() + 3600000L);
                BaseKeyStore.INSTANCE(BridDrmSessionManagerProvider.this.context).store(drmKeyVO);
                return licence;
            }
        });
        if (this.drmKeyVO != null) {
            byte[] key = this.drmKeyVO.getKey();
            drmSessionManager.setMode(0, key);
        }
        return drmSessionManager;
    }
}

