/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.player.adapters;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import java.util.List;
import tv.brid.sdk.R;
import tv.brid.sdk.player.settings.RenditionOption;

public class RenditionOptionTvAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private static final int RESOURCE = R.layout.item_settings_child_tv;
    private List<RenditionOption> renditionOptionList;
    private LayoutInflater inflater;
    private int selectedPosition = 0;
    private Context currentContext;
    private OnItemClickListener listener;
    private View itemView;
    private int prevPosition = 0;

    public RenditionOptionTvAdapter(Context context, List<RenditionOption> renditionOption, OnItemClickListener listener) {
        this.inflater = LayoutInflater.from((Context)context);
        this.currentContext = context;
        this.listener = listener;
        this.renditionOptionList = renditionOption;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        this.itemView = this.inflater.inflate(RESOURCE, parent, false);
        return new ViewHolder(this.itemView);
    }

    public void onBindViewHolder(final ViewHolder holder, final @SuppressLint(value={"RecyclerView"}) int position) {
        RenditionOption renditionOption = this.renditionOptionList.get(position);
        holder.itemTitle.setText((CharSequence)renditionOption.getLabel());
        holder.itemView.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    RenditionOptionTvAdapter.this.selectedPosition = holder.getAdapterPosition();
                    holder.itemTitle.setTextColor(ContextCompat.getColor((Context)RenditionOptionTvAdapter.this.currentContext, (int)R.color.tv_text_main_selected));
                    if (!RenditionOptionTvAdapter.this.renditionOptionList.get(RenditionOptionTvAdapter.this.selectedPosition).isChecked()) {
                        holder.checkboxImage.setImageDrawable(ContextCompat.getDrawable((Context)RenditionOptionTvAdapter.this.currentContext, (int)R.drawable.icon_unchecked_selected));
                    } else {
                        holder.checkboxImage.setImageDrawable(ContextCompat.getDrawable((Context)RenditionOptionTvAdapter.this.currentContext, (int)R.drawable.icon_checked_selected));
                    }
                } else {
                    holder.itemTitle.setTextColor(ContextCompat.getColor((Context)RenditionOptionTvAdapter.this.currentContext, (int)R.color.tv_text_main));
                    if (!RenditionOptionTvAdapter.this.renditionOptionList.get(RenditionOptionTvAdapter.this.selectedPosition).isChecked()) {
                        holder.checkboxImage.setImageDrawable(ContextCompat.getDrawable((Context)RenditionOptionTvAdapter.this.currentContext, (int)R.drawable.icon_unchecked));
                    } else {
                        holder.checkboxImage.setImageDrawable(ContextCompat.getDrawable((Context)RenditionOptionTvAdapter.this.currentContext, (int)R.drawable.icon_checked));
                    }
                }
            }
        });
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (RenditionOptionTvAdapter.this.prevPosition != position) {
                    RenditionOptionTvAdapter.this.renditionOptionList.get(RenditionOptionTvAdapter.this.prevPosition).setChecked(false);
                    RenditionOptionTvAdapter.this.notifyItemChanged(RenditionOptionTvAdapter.this.prevPosition);
                }
                RenditionOptionTvAdapter.this.renditionOptionList.get(position).setChecked(true);
                RenditionOptionTvAdapter.this.notifyItemChanged(position);
                RenditionOptionTvAdapter.this.prevPosition = position;
                if (RenditionOptionTvAdapter.this.listener != null) {
                    RenditionOptionTvAdapter.this.listener.onItemClick(RenditionOptionTvAdapter.this.renditionOptionList.get(position).getLabel());
                }
            }
        });
        holder.itemView.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View view, int i, KeyEvent keyEvent) {
                if (i == 4 && keyEvent.getAction() == 0) {
                    RenditionOptionTvAdapter.this.listener.onItemBackClick();
                    return true;
                }
                return false;
            }
        });
    }

    public int getItemCount() {
        return this.renditionOptionList.size();
    }

    public int getLastSelectedPosition() {
        return this.selectedPosition;
    }

    public void setCheckedPosition(int checkedPosition) {
        this.renditionOptionList.get(checkedPosition).setChecked(true);
    }

    public static interface OnItemClickListener {
        public void onItemClick(String var1);

        public void onItemBackClick();
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        public ImageView checkboxImage;
        public TextView itemTitle;

        public ViewHolder(View itemView) {
            super(itemView);
            this.checkboxImage = (ImageView)itemView.findViewById(R.id.settings_check_btn);
            this.itemTitle = (TextView)itemView.findViewById(R.id.tv_settings_child_text);
        }
    }
}

