/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.player.adPlayer.ima;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.media.AudioManager;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.OptIn;
import androidx.core.content.ContextCompat;
import androidx.media3.common.AudioAttributes;
import androidx.media3.common.MediaItem;
import androidx.media3.common.PlaybackException;
import androidx.media3.common.Player;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.DefaultRenderersFactory;
import androidx.media3.exoplayer.ExoPlayer;
import androidx.media3.exoplayer.RenderersFactory;
import androidx.media3.ui.PlayerControlView;
import androidx.media3.ui.R;
import com.google.ads.interactivemedia.v3.api.Ad;
import com.google.ads.interactivemedia.v3.api.AdDisplayContainer;
import com.google.ads.interactivemedia.v3.api.AdErrorEvent;
import com.google.ads.interactivemedia.v3.api.AdEvent;
import com.google.ads.interactivemedia.v3.api.AdPodInfo;
import com.google.ads.interactivemedia.v3.api.AdsLoader;
import com.google.ads.interactivemedia.v3.api.AdsManager;
import com.google.ads.interactivemedia.v3.api.AdsManagerLoadedEvent;
import com.google.ads.interactivemedia.v3.api.AdsRenderingSettings;
import com.google.ads.interactivemedia.v3.api.AdsRequest;
import com.google.ads.interactivemedia.v3.api.FriendlyObstruction;
import com.google.ads.interactivemedia.v3.api.FriendlyObstructionPurpose;
import com.google.ads.interactivemedia.v3.api.ImaSdkFactory;
import com.google.ads.interactivemedia.v3.api.ImaSdkSettings;
import com.google.ads.interactivemedia.v3.api.player.AdMediaInfo;
import com.google.ads.interactivemedia.v3.api.player.ContentProgressProvider;
import com.google.ads.interactivemedia.v3.api.player.VideoAdPlayer;
import com.google.ads.interactivemedia.v3.api.player.VideoProgressUpdate;
import java.util.ArrayList;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import tv.brid.domain.Partner;
import tv.brid.sdk.R;
import tv.brid.sdk.Utils;
import tv.brid.sdk.api.BridPlayer;
import tv.brid.sdk.api.BridPlayerImpl;
import tv.brid.sdk.brid_network.domain.AdTagVO;
import tv.brid.sdk.engine.AnalyticData;
import tv.brid.sdk.engine.AnalyticsSender;
import tv.brid.sdk.engine.ads.AdAnalyticDC;
import tv.brid.sdk.engine.ads.AdProvider;
import tv.brid.sdk.lifecycle.LifecycleTrackerKt;
import tv.brid.sdk.lifecycle.Resumable;
import tv.brid.sdk.player.BridStyledPlayerView;
import tv.brid.sdk.player.ViewabilityAnalyticsRunner;
import tv.brid.sdk.player.adPlayer.AdPlayerType;
import tv.brid.sdk.player.adPlayer.IAdPlayer;
import tv.brid.sdk.player.listeners.BridPlayerListener;
import tv.brid.sdk.player.ui.UtilsKt;

@UnstableApi
public class ImaPlayer
extends IAdPlayer
implements Resumable,
PlayerControlView.VisibilityListener {
    private final ExoPlayer imaPlayer;
    private ExoPlayer originPlayer;
    private Context context;
    private BridStyledPlayerView playerView;
    private AdsLoader adsLoader;
    private AdProvider adProvider;
    private TextView exoTitle;
    private AnalyticsSender analyticsSender;
    private int adType;
    private ViewabilityAnalyticsRunner var;
    private boolean viewabilityAnalyticSent = false;
    private BridPlayerImpl bridPlayer;
    private boolean isLifecycleInitiatedPause = false;
    private ProgressBar adProgressBar;
    private ProgressBar exoLoadingBar;
    private tv.brid.domain.Player videoCmsSettings;
    public boolean isAdPlaying = true;
    private BridPlayerListener mListener;
    private String currentAdTag;
    private Resumable previousResumable;
    private ViewGroup exoAdOverlay;
    private VideoAdPlayer videoAdPlayer;
    private AdsManager adsManager;
    private AdDisplayContainer adDisplayContainer;
    private ImaSdkFactory sdkFactory;
    private AdMediaInfo adMediaInfo;
    private ContentProgressProvider contentProgressProvider;
    private int adDuration;
    private int savedAdPosition;
    private static final long INITIAL_DELAY_MS = 250L;
    private AdAnalyticDC adAnalyticDC;
    private AudioManager audioManager;
    private ImageView adPlayButton;
    private ImageView adFullscreenButton;
    private ImageView adMuteButton;
    Handler handler;
    Runnable runnable;
    MediaItem contentMediaItem;
    RelativeLayout overlay;
    private VideoAdPlayer.VideoAdPlayerCallback adCallbacks;
    private long timeWhenTapped = 0L;
    private final long timeAfterTapped = 2700L;
    private int fullscreenIcon;
    private int fullscreenCloseIcon;
    private boolean isMuted;
    private ImaSdkSettings imaSdkSettings;
    private AdsLoaderListener adsLoaderListener;
    private BridPlayerImpl bridPlayerImpl;
    @DrawableRes
    private int muteAdIcon;
    @DrawableRes
    private int unmuteAdIcon;
    @DrawableRes
    private int adPlayIcon;
    @DrawableRes
    private int adFullscreenIcon;
    @DrawableRes
    private int adPauseIcon;

    @OptIn(markerClass={UnstableApi.class})
    public ImaPlayer(ExoPlayer originPlayer, BridStyledPlayerView playerView, AdProvider adProvider, final AnalyticsSender analyticsSender, int adType, BridPlayer bridPlayer, BridPlayerListener mListener, tv.brid.domain.Player videoCmsSettings, String countryCode) {
        this.bridPlayer = (BridPlayerImpl)bridPlayer;
        this.mListener = mListener;
        this.adType = adType;
        this.analyticsSender = analyticsSender;
        this.exoTitle = (TextView)playerView.findViewById(R.id.exo_title);
        this.exoTitle.setVisibility(4);
        this.adProvider = adProvider;
        this.originPlayer = originPlayer;
        this.context = playerView.getContext();
        this.playerView = playerView;
        this.videoCmsSettings = videoCmsSettings;
        this.muteAdIcon = R.drawable.exo_controls_brid_mute;
        this.unmuteAdIcon = R.drawable.exo_controls_brid_muted;
        this.adPlayIcon = R.drawable.exo_icon_play;
        this.adPauseIcon = R.drawable.exo_icon_pause;
        this.fullscreenIcon = R.drawable.ad_controls_brid_open_fullscreen;
        this.fullscreenCloseIcon = R.drawable.ad_controls_brid_close_fullscreen;
        if (originPlayer.getCurrentMediaItem() != null) {
            this.contentMediaItem = originPlayer.getCurrentMediaItem();
        }
        this.exoAdOverlay = (ViewGroup)playerView.findViewById(R.id.exo_ad_overlay);
        this.exoLoadingBar = (ProgressBar)playerView.findViewById(R.id.exo_loading);
        DefaultRenderersFactory defaultRenderersFactory = new DefaultRenderersFactory(this.context);
        defaultRenderersFactory.setEnableDecoderFallback(true);
        this.sdkFactory = ImaSdkFactory.getInstance();
        this.imaSdkSettings = this.sdkFactory.createImaSdkSettings();
        if (countryCode.equals("bs") || countryCode.equals("me")) {
            countryCode = "sr";
        }
        this.imaSdkSettings.setLanguage(countryCode);
        this.imaPlayer = new ExoPlayer.Builder(this.context).setRenderersFactory((RenderersFactory)defaultRenderersFactory).build();
        this.videoAdPlayer = this.getVideoAdPlayer();
        this.adDisplayContainer = ImaSdkFactory.createAdDisplayContainer((ViewGroup)this.exoAdOverlay, (VideoAdPlayer)this.videoAdPlayer);
        this.imaPlayer.addListener(new Player.Listener(){

            public void onPlayerError(PlaybackException error) {
                super.onPlayerError(error);
                ImaPlayer.this.onAdAfterError();
            }
        });
        if (mListener != null) {
            mListener.onEvent("r", bridPlayer.getPlayerReference());
        }
        this.imaPlayer.setAudioAttributes(AudioAttributes.DEFAULT, true);
        this.audioManager = (AudioManager)this.context.getSystemService("audio");
        this.previousResumable = LifecycleTrackerKt.getResumablesSet().addReplacing(this);
        this.adsLoader = this.sdkFactory.createAdsLoader(this.context, this.imaSdkSettings, this.adDisplayContainer);
        this.adsLoader.addAdErrorListener(new AdErrorEvent.AdErrorListener(){

            public void onAdError(AdErrorEvent adErrorEvent) {
                adErrorEvent.getError();
                ImaPlayer.this.onAdAfterError();
                int ec = adErrorEvent.getError().getErrorCode().getErrorNumber();
                analyticsSender.sendAnalytics(new AnalyticData("ae", ec));
            }
        });
        this.adsLoaderListener = new AdsLoaderListener();
        this.adsLoader.addAdsLoadedListener((AdsLoader.AdsLoadedListener)this.adsLoaderListener);
        this.bridPlayerImpl = (BridPlayerImpl)bridPlayer;
        if (bridPlayer.isAdControlsEnabled() && !UtilsKt.isSDKRunningOnTvDevice(this.context)) {
            this.initAdControls();
            if (originPlayer.getVolume() == 0.0f) {
                this.imaPlayer.setVolume(0.0f);
                this.adMuteButton.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)this.unmuteAdIcon));
            } else {
                this.imaPlayer.setVolume(0.7f);
                this.adMuteButton.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)this.muteAdIcon));
            }
            this.var = new ViewabilityAnalyticsRunner((View)playerView, new Function0<Unit>(){

                public Unit invoke() {
                    analyticsSender.sendAnalytics(new AnalyticData("vi", null));
                    ImaPlayer.this.viewabilityAnalyticSent = true;
                    return null;
                }
            });
        }
    }

    private void initAdControls() {
        this.adPlayButton = (ImageView)this.playerView.findViewById(R.id.ad_play_button);
        this.adMuteButton = (ImageView)this.playerView.findViewById(R.id.ad_mute);
        this.adFullscreenButton = (ImageView)this.playerView.findViewById(R.id.ad_fullscreen);
        this.overlay = (RelativeLayout)this.playerView.findViewById(R.id.overlay);
        this.adProgressBar = (ProgressBar)this.playerView.findViewById(R.id.ad_progress_bar);
        if (!UtilsKt.isSDKRunningOnTvDevice(this.context)) {
            if (this.bridPlayer.isFullscreen()) {
                this.adFullscreenButton.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)this.fullscreenCloseIcon));
                this.bridPlayer.setFullscreenIcon(this.fullscreenCloseIcon);
            } else if (this.adFullscreenButton != null) {
                this.adFullscreenButton.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)this.fullscreenIcon));
                this.bridPlayer.setFullscreenIcon(this.fullscreenIcon);
            }
        }
        this.adPlayButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ImaPlayer.this.imaPlayer.isPlaying()) {
                    ImaPlayer.this.adPlayButton.setImageResource(ImaPlayer.this.adPlayIcon);
                    ImaPlayer.this.imaPlayer.pause();
                    if (ImaPlayer.this.mListener != null) {
                        ImaPlayer.this.mListener.onEvent("p", ImaPlayer.this.bridPlayer.getPlayerReference());
                    }
                } else {
                    ImaPlayer.this.adPlayButton.setImageResource(ImaPlayer.this.adPauseIcon);
                    ImaPlayer.this.imaPlayer.play();
                    if (ImaPlayer.this.mListener != null) {
                        ImaPlayer.this.mListener.onEvent("res", ImaPlayer.this.bridPlayer.getPlayerReference());
                    }
                }
            }
        });
        this.adMuteButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ImaPlayer.this.isMuted) {
                    ImaPlayer.this.imaPlayer.setVolume(0.0f);
                    ImaPlayer.this.originPlayer.setVolume(0.0f);
                    ImaPlayer.this.adMuteButton.setImageDrawable(ContextCompat.getDrawable((Context)ImaPlayer.this.context, (int)ImaPlayer.this.unmuteAdIcon));
                    ImaPlayer.this.bridPlayer.changeMuteButton(ImaPlayer.this.isMuted);
                    ImaPlayer.this.isMuted = false;
                } else {
                    ImaPlayer.this.imaPlayer.setVolume(0.7f);
                    ImaPlayer.this.originPlayer.setVolume(0.7f);
                    ImaPlayer.this.adMuteButton.setImageDrawable(ContextCompat.getDrawable((Context)ImaPlayer.this.context, (int)ImaPlayer.this.muteAdIcon));
                    ImaPlayer.this.bridPlayer.changeMuteButton(ImaPlayer.this.isMuted);
                    ImaPlayer.this.isMuted = true;
                }
            }
        });
        this.adFullscreenButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ImaPlayer.this.fullscreenIcon = R.drawable.exo_controls_brid_open_fullscreen;
                ImaPlayer.this.fullscreenCloseIcon = R.drawable.exo_controls_brid_close_fullscreen;
                if (ImaPlayer.this.bridPlayer.isFullscreen()) {
                    ImaPlayer.this.overlay.setVisibility(8);
                    ImaPlayer.this.closeAdFullscreen();
                    ImaPlayer.this.adFullscreenButton.setImageDrawable(ContextCompat.getDrawable((Context)ImaPlayer.this.context, (int)ImaPlayer.this.fullscreenIcon));
                    ImaPlayer.this.bridPlayer.setFullscreenIcon(ImaPlayer.this.fullscreenIcon);
                } else {
                    ImaPlayer.this.bridPlayer.setFullScreen(true);
                    ImaPlayer.this.adFullscreenButton.setImageDrawable(ContextCompat.getDrawable((Context)ImaPlayer.this.context, (int)ImaPlayer.this.fullscreenCloseIcon));
                    ImaPlayer.this.bridPlayer.setFullscreenIcon(ImaPlayer.this.fullscreenCloseIcon);
                }
            }
        });
        this.registerFriendlyObstruction((ViewGroup)this.overlay, this.adProgressBar, this.adPlayButton, this.adDisplayContainer, this.adFullscreenButton, this.adMuteButton);
    }

    public void onAdAfterError() {
        Utils.log(this.getClass(), "onAdErrorHappened", new String[0]);
        this.adProvider.checkAdForParamsAfterError();
        this.bridPlayer.closeAdLoading();
        this.hideAdUiElements();
    }

    private void onAdCompleted() {
        Utils.log(this.getClass(), "onAdCompleted", new String[0]);
        this.adProvider.checkAdForParamsAfterCompleted();
        this.hideAdUiElements();
    }

    @Override
    public void releaseAdPlayer() {
        this.isAdPlaying = false;
        this.releaseImaPlayer();
        Utils.log(this.getClass(), "releaseAdPlayer", new String[0]);
        if (this.adsManager != null) {
            this.adsManager.destroy();
            this.adsManager = null;
        }
    }

    private void releaseImaPlayer() {
        Utils.log(this.getClass(), "releaseImaPlayer", new String[0]);
        this.isAdPlaying = false;
        this.imaPlayer.release();
        this.stopAdTracking();
        if (this.adDisplayContainer != null) {
            this.adDisplayContainer.unregisterAllFriendlyObstructions();
        }
        if (this.previousResumable != null) {
            LifecycleTrackerKt.getResumablesSet().addReplacing(this.previousResumable);
        }
        this.hideAdUiElements();
        this.adsManager = null;
        this.releaseAdsLoader();
    }

    public void revertPlayer() {
        Utils.log(this.getClass(), "revertPlayer", new String[0]);
        this.playerView.setPlayer((Player)this.originPlayer);
    }

    public void requestImaAd(String imaAdUrl) {
        if (imaAdUrl == null || imaAdUrl == "") {
            this.resumeVideoContent();
            return;
        }
        this.currentAdTag = imaAdUrl;
        this.bridPlayer.setVisibilityToPlayerControlsLayout(false);
        AdsRequest request = this.sdkFactory.createAdsRequest();
        request.setAdTagUrl(imaAdUrl);
        request.setContentProgressProvider(() -> {
            if (this.imaPlayer.getDuration() <= 0L) {
                return VideoProgressUpdate.VIDEO_TIME_NOT_READY;
            }
            return new VideoProgressUpdate(this.imaPlayer.getCurrentPosition(), this.imaPlayer.getDuration());
        });
        if (this.adsLoader != null) {
            this.adsLoader.requestAds(request);
        }
        if (this.analyticsSender != null) {
            this.analyticsSender.sendAnalytics(new AnalyticData("r", null));
        }
    }

    private VideoAdPlayer getVideoAdPlayer() {
        return new VideoAdPlayer(){

            public void loadAd(AdMediaInfo info, AdPodInfo adPodInfo) {
                ImaPlayer.this.adMediaInfo = info;
                ImaPlayer.this.prepareVideoAd(info);
            }

            public void playAd(AdMediaInfo adMediaInfo) {
                ImaPlayer.this.playAdVideo();
                ImaPlayer.this.startAdTracking();
                ImaPlayer.this.bridPlayer.hideControls();
                ImaPlayer.this.playerView.hideController();
            }

            public void pauseAd(AdMediaInfo adMediaInfo) {
                ImaPlayer.this.savedAdPosition = (int)ImaPlayer.this.imaPlayer.getCurrentPosition();
                if (ImaPlayer.this.imaPlayer.isPlaying()) {
                    ImaPlayer.this.imaPlayer.pause();
                } else {
                    ImaPlayer.this.imaPlayer.play();
                }
            }

            public void release() {
                ImaPlayer.this.releaseAdPlayer();
            }

            public void stopAd(AdMediaInfo adMediaInfo) {
                ImaPlayer.this.stopAdTracking();
            }

            public VideoProgressUpdate getAdProgress() {
                long adPosition = ImaPlayer.this.imaPlayer.getCurrentPosition();
                if (ImaPlayer.this.bridPlayer.isAdControlsEnabled()) {
                    ImaPlayer.this.hideAdOverlay(adPosition);
                }
                return new VideoProgressUpdate(adPosition, (long)ImaPlayer.this.adDuration);
            }

            public int getVolume() {
                return ImaPlayer.this.imaPlayer.getDeviceVolume();
            }

            public void addCallback(VideoAdPlayer.VideoAdPlayerCallback videoAdPlayerCallback) {
                ImaPlayer.this.adCallbacks = videoAdPlayerCallback;
            }

            public void removeCallback(VideoAdPlayer.VideoAdPlayerCallback videoAdPlayerCallback) {
                ImaPlayer.this.adCallbacks = videoAdPlayerCallback;
            }
        };
    }

    private void hideAdOverlay(long adPosition) {
        if (adPosition - this.timeWhenTapped > 2700L && this.overlay.getVisibility() == 0) {
            this.overlay.setVisibility(4);
            this.hideAdControls();
        }
    }

    @Override
    public void pause() {
        Utils.log(this.getClass(), "pause", new String[0]);
        this.isLifecycleInitiatedPause = true;
        this.imaPlayer.setPlayWhenReady(false);
    }

    public void stop() {
        this.imaPlayer.release();
    }

    private void prepareVideoAd(AdMediaInfo info) {
        MediaItem mediaItem = new MediaItem.Builder().setUri(info.getUrl()).build();
        this.imaPlayer.setMediaItem(mediaItem);
        this.imaPlayer.addListener(this.getPlayerEventListener());
        this.playerView.setResizeMode(0);
        this.imaPlayer.prepare();
    }

    private void playAdVideo() {
        this.imaPlayer.setPlayWhenReady(true);
        this.playerView.setPlayer((Player)this.imaPlayer);
        this.playerView.setUseController(false);
    }

    @Override
    public void playAd(@NonNull ArrayList<AdTagVO> adTags, @NonNull AdAnalyticDC adAnalyticDC) {
        this.playAdVideo();
    }

    public boolean getIsAdPlaying() {
        return this.isAdPlaying;
    }

    @Override
    public int defineType() {
        return 2;
    }

    @Override
    public void onPauseEvent() {
        Utils.log(this.getClass(), "onPauseEvent", new String[0]);
        if (this.bridPlayerImpl.isInPipMode()) {
            return;
        }
        if (this.imaPlayer == null) {
            return;
        }
        this.imaPlayer.pause();
        if (this.mListener != null) {
            this.mListener.onEvent("adcpreq", this.bridPlayer.getPlayerReference());
        }
    }

    @Override
    public void release() {
        this.releaseAdPlayer();
    }

    @Override
    public boolean isAdInProgress() {
        return this.isAdPlaying;
    }

    @Override
    public void setAnalytics(@NonNull AdAnalyticDC adAnalyticDC) {
        this.adAnalyticDC = adAnalyticDC;
    }

    @Override
    public void setAdRequest(@NonNull String adString) {
        this.requestImaAd(adString);
    }

    public void onVisibilityChange(int visibility) {
        this.playerView.setUseController(true);
    }

    @Override
    @OptIn(markerClass={UnstableApi.class})
    public void onResumeEvent(int resumeStatus) {
        Utils.log(this.getClass(), "onResumeEvent", new String[0]);
        if (this.bridPlayerImpl.isInPipMode()) {
            this.playerView.setUseController(false);
            this.playerView.hideController();
            return;
        }
        if (resumeStatus == 1) {
            if (this.imaPlayer == null) {
                return;
            }
            this.imaPlayer.setPlayWhenReady(true);
            if (this.adPlayButton != null) {
                this.adPlayButton.setImageResource(this.adPauseIcon);
            }
            if (this.mListener != null) {
                this.mListener.onEvent("ares", this.bridPlayer.getPlayerReference());
            }
        } else {
            if (resumeStatus == 2) {
                return;
            }
            this.imaPlayer.pause();
            if (this.adPlayButton != null) {
                this.adPlayButton.setImageResource(this.adPlayIcon);
            }
            if (this.mListener != null) {
                this.mListener.onEvent("adcpreq", this.bridPlayer.getPlayerReference());
            }
        }
    }

    private void adjustAdUI() {
        if (this.overlay.getVisibility() != 0) {
            this.overlay.setVisibility(0);
        } else {
            this.overlay.setVisibility(4);
        }
        if (this.overlay.getVisibility() == 0) {
            this.showAdControls();
        } else {
            this.hideAdControls();
        }
        if (this.imaPlayer.isPlaying()) {
            this.adPlayButton.setImageResource(this.adPauseIcon);
        } else {
            this.adPlayButton.setImageResource(this.adPlayIcon);
        }
    }

    private void resumeVideoContent() {
        Log.i((String)"NIO", (String)"resumeContent");
        if (Boolean.TRUE.equals(this.adProvider.isThereNextPod())) {
            this.bridPlayer.showAdLoading();
        } else {
            this.playerView.setUseController(true);
        }
    }

    private void resumeVideoContentAfterError() {
        Log.i((String)"NIO", (String)"resumeContent");
        if (Boolean.TRUE.equals(this.adProvider.isThereNextWaterfall()) || Boolean.TRUE.equals(this.adProvider.isThereNextPod())) {
            this.bridPlayer.showAdLoading();
        } else {
            this.playerView.setUseController(true);
        }
    }

    private boolean isViewTapped(MotionEvent event, View view) {
        if (event == null) {
            return false;
        }
        int[] viewLocation = new int[2];
        view.getLocationOnScreen(viewLocation);
        int viewX = viewLocation[0];
        int viewY = viewLocation[1];
        int touchX = (int)event.getRawX();
        int touchY = (int)event.getRawY();
        Rect viewRect = new Rect(viewX, viewY, viewX + view.getWidth(), viewY + view.getHeight());
        return viewRect.contains(touchX, touchY);
    }

    private void startAdTracking() {
        Log.i((String)"NIO", (String)"startAdTracking");
        this.handler = new Handler(Looper.getMainLooper());
        this.runnable = new Runnable(){

            @Override
            public void run() {
                VideoProgressUpdate progressUpdate = ImaPlayer.this.videoAdPlayer.getAdProgress();
                ImaPlayer.this.notifyImaSdkAboutAdProgress(progressUpdate);
                ImaPlayer.this.handler.postDelayed((Runnable)this, 250L);
                ImaPlayer.this.updateCustomUi();
            }
        };
        this.handler.postDelayed(this.runnable, 250L);
    }

    private void pauseVideoContent() {
        this.isAdPlaying = true;
        if (this.analyticsSender != null && this.adAnalyticDC.getAdType() == 1) {
            this.analyticsSender.sendAnalytics(new AnalyticData("pa", null));
        }
    }

    private Player.Listener getPlayerEventListener() {
        return new Player.Listener(){

            public void onPlaybackStateChanged(int playbackState) {
                super.onPlaybackStateChanged(playbackState);
                switch (playbackState) {
                    case 3: {
                        ImaPlayer.this.adDuration = (int)ImaPlayer.this.imaPlayer.getDuration();
                        if (ImaPlayer.this.savedAdPosition > 0) {
                            ImaPlayer.this.imaPlayer.seekTo((long)ImaPlayer.this.savedAdPosition);
                        }
                        ImaPlayer.this.imaPlayer.setPlayWhenReady(true);
                        break;
                    }
                    case 4: {
                        ImaPlayer.this.savedAdPosition = 0;
                        ImaPlayer.this.notifyImaSdkAboutAdEnded();
                        ImaPlayer.this.imaPlayer.removeListener((Player.Listener)this);
                        break;
                    }
                }
            }
        };
    }

    private void notifyImaSdkAboutAdEnded() {
        this.savedAdPosition = 0;
        this.adCallbacks.onEnded(this.adMediaInfo);
    }

    private void notifyImaSdkAboutAdProgress(VideoProgressUpdate adProgress) {
        this.adCallbacks.onAdProgress(this.adMediaInfo, adProgress);
    }

    private void stopAdTracking() {
        if (this.handler != null) {
            this.handler.removeCallbacks(this.runnable);
        }
    }

    private void updateCustomUi() {
        Ad ad = this.adsManager.getCurrentAd();
        if (ad != null && this.bridPlayer.isAdControlsEnabled()) {
            VideoProgressUpdate update = this.adsManager.getAdProgress();
            if (this.adProgressBar != null) {
                this.adProgressBar.setVisibility(0);
            }
            int adProgress = (int)(update.getCurrentTime() / update.getDuration() * 100.0f);
            this.updateAdUiElements(adProgress);
        } else if (this.adProgressBar != null) {
            this.adProgressBar.setVisibility(4);
        }
    }

    public void adjustVolume(boolean increase) {
        int direction = increase ? 1 : -1;
        this.audioManager.adjustStreamVolume(3, direction, 1);
    }

    public void muteAdVideo() {
        this.imaPlayer.setVolume(0.0f);
    }

    @Override
    public void muteAdVideo(Boolean isMuted) {
        this.muteAd(isMuted);
    }

    private boolean isMuted() {
        return this.isMuted;
    }

    @Override
    @NonNull
    public AdPlayerType getAdPlayerType() {
        return AdPlayerType.ImaPlayer;
    }

    @Override
    public void setPlayerData(@NonNull tv.brid.domain.Player player, @NonNull Partner partner) {
    }

    @Override
    public void loadAdContent() {
    }

    public void registerFriendlyObstruction(ViewGroup adOverlay, ProgressBar adProgress, ImageView adPlay, AdDisplayContainer adContainer, ImageView adFullscreenButton, ImageView adMuteButton) {
        if (adContainer != null && adOverlay != null) {
            FriendlyObstruction overlayObstruction = this.sdkFactory.createFriendlyObstruction((View)adOverlay, FriendlyObstructionPurpose.NOT_VISIBLE, "This overlay is transparent");
            adContainer.registerFriendlyObstruction(overlayObstruction);
        }
        if (this.bridPlayer.isAdControlsEnabled()) {
            if (adContainer != null && adProgress != null) {
                FriendlyObstruction progressObstruction1 = this.sdkFactory.createFriendlyObstruction((View)adProgress, FriendlyObstructionPurpose.VIDEO_CONTROLS, "This is the video player progress bar");
                adContainer.registerFriendlyObstruction(progressObstruction1);
            }
            if (adContainer != null && adPlay != null) {
                FriendlyObstruction overlayObstruction2 = this.sdkFactory.createFriendlyObstruction((View)adPlay, FriendlyObstructionPurpose.VIDEO_CONTROLS, "This is the custom layout for skip ad");
                adContainer.registerFriendlyObstruction(overlayObstruction2);
            }
            if (adContainer != null && adFullscreenButton != null) {
                FriendlyObstruction overlayObstruction3 = this.sdkFactory.createFriendlyObstruction((View)adFullscreenButton, FriendlyObstructionPurpose.VIDEO_CONTROLS, "This is the fullscreen button");
                adContainer.registerFriendlyObstruction(overlayObstruction3);
            }
            if (adContainer != null && adMuteButton != null) {
                FriendlyObstruction overlayObstruction4 = this.sdkFactory.createFriendlyObstruction((View)adFullscreenButton, FriendlyObstructionPurpose.VIDEO_CONTROLS, "This is the mute button");
                adContainer.registerFriendlyObstruction(overlayObstruction4);
            }
        }
    }

    private void muteAd(boolean mute) {
        Utils.log(this.getClass(), "muteAd", new String[0]);
        if (this.imaPlayer == null) {
            return;
        }
        this.isMuted = mute;
        this.imaPlayer.setVolume(this.isMuted ? 0.0f : 1.0f);
        try {
            if (this.isMuted) {
                if (this.bridPlayer.isAdControlsEnabled() && this.adMuteButton != null) {
                    this.adMuteButton.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)this.unmuteAdIcon));
                }
            } else if (this.bridPlayer.isAdControlsEnabled() && this.adMuteButton != null) {
                this.adMuteButton.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)this.muteAdIcon));
            }
        }
        catch (Resources.NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private void closeAdFullscreen() {
        if (this.isAdPlaying) {
            this.bridPlayerImpl.dismissFullscreenDialog();
            if (this.bridPlayerImpl.isAdControlsEnabled()) {
                this.hideAdControls();
                this.overlay.setVisibility(8);
            }
            this.playerView.setSystemUiVisibility(0);
        }
    }

    private void showAdControls() {
        this.adPlayButton.setVisibility(0);
        this.adPlayButton.bringToFront();
        this.adFullscreenButton.setVisibility(0);
        this.adFullscreenButton.bringToFront();
        this.adMuteButton.setVisibility(0);
        this.adMuteButton.bringToFront();
    }

    private void hideAdControls() {
        this.adMuteButton.setVisibility(4);
        this.adFullscreenButton.setVisibility(4);
        this.adPlayButton.setVisibility(4);
    }

    private void updateAdUiElements(int adProgress) {
        if (this.adProgressBar != null) {
            this.adProgressBar.setProgress(adProgress);
        }
    }

    private void hideAdUiElements() {
        if (this.adProgressBar != null) {
            this.adProgressBar.setVisibility(8);
        }
        if (this.adPlayButton != null) {
            this.adPlayButton.setVisibility(8);
        }
        if (this.adFullscreenButton != null) {
            this.adFullscreenButton.setVisibility(8);
        }
        if (this.adMuteButton != null) {
            this.adMuteButton.setVisibility(8);
        }
        if (this.overlay != null) {
            this.overlay.setVisibility(8);
        }
        if (this.exoAdOverlay != null && !UtilsKt.isSDKRunningOnTvDevice(this.context) && this.overlay != null) {
            this.overlay.setVisibility(8);
        }
        if (this.adProgressBar != null) {
            this.adProgressBar.setProgress(0);
        }
    }

    @Override
    public void releaseAdsLoader() {
        if (this.adsLoader != null) {
            this.adsLoader.release();
            this.adsLoader = null;
        }
    }

    private class AdsLoaderListener
    implements AdsLoader.AdsLoadedListener {
        private AdsLoaderListener() {
        }

        public void onAdsManagerLoaded(AdsManagerLoadedEvent adsManagerLoadedEvent) {
            ImaPlayer.this.adsManager = adsManagerLoadedEvent.getAdsManager();
            ImaPlayer.this.adsManager.addAdErrorListener(new AdErrorEvent.AdErrorListener(){

                public void onAdError(AdErrorEvent adErrorEvent) {
                    if (ImaPlayer.this.var != null) {
                        ImaPlayer.this.var.stop();
                    }
                    ImaPlayer.this.onAdAfterError();
                }
            });
            ImaPlayer.this.adsManager.addAdEventListener(new AdEvent.AdEventListener(){

                public void onAdEvent(AdEvent adEvent) {
                    if (adEvent.getType() != AdEvent.AdEventType.AD_PROGRESS) {
                        Utils.log(this.getClass(), "adEvent = " + adEvent.getType(), new String[0]);
                    }
                    switch (adEvent.getType()) {
                        case LOADED: {
                            ImaPlayer.this.adsManager.start();
                            ImaPlayer.this.bridPlayer.sendAutoplayEventIfAdExists(ImaPlayer.this.adType);
                            ImaPlayer.this.bridPlayer.turnOffLiveWhenAdsStarted(true);
                            ImaPlayer.this.playerView.setUseController(false);
                            if (ImaPlayer.this.mListener == null) break;
                            ImaPlayer.this.mListener.onEvent("r", ImaPlayer.this.bridPlayer.getPlayerReference());
                            break;
                        }
                        case CONTENT_PAUSE_REQUESTED: {
                            ImaPlayer.this.isAdPlaying = true;
                            if (ImaPlayer.this.var != null) {
                                ImaPlayer.this.var.start();
                            }
                            if (ImaPlayer.this.mListener == null) break;
                            ImaPlayer.this.mListener.onEvent("adstart", ImaPlayer.this.bridPlayer.getPlayerReference());
                            break;
                        }
                        case CONTENT_RESUME_REQUESTED: {
                            ImaPlayer.this.isAdPlaying = false;
                            ImaPlayer.this.resumeVideoContent();
                            if (ImaPlayer.this.mListener == null) break;
                            ImaPlayer.this.mListener.onEvent("ares", ImaPlayer.this.bridPlayer.getPlayerReference());
                            break;
                        }
                        case PAUSED: {
                            ImaPlayer.this.isAdPlaying = false;
                            ImaPlayer.this.adsManager.pause();
                            if (ImaPlayer.this.bridPlayer.isAdControlsEnabled()) {
                                ImaPlayer.this.overlay.setVisibility(0);
                                ImaPlayer.this.showAdControls();
                            }
                            if (!ImaPlayer.this.viewabilityAnalyticSent && ImaPlayer.this.var != null) {
                                ImaPlayer.this.var.stop();
                                ImaPlayer.this.var.start();
                            }
                            if (ImaPlayer.this.mListener == null) break;
                            ImaPlayer.this.mListener.onEvent("p", ImaPlayer.this.bridPlayer.getPlayerReference());
                            break;
                        }
                        case RESUMED: {
                            ImaPlayer.this.isAdPlaying = true;
                            ImaPlayer.this.adsManager.resume();
                            if (ImaPlayer.this.bridPlayer.isAdControlsEnabled()) {
                                ImaPlayer.this.overlay.setVisibility(4);
                                ImaPlayer.this.hideAdControls();
                            }
                            if (ImaPlayer.this.mListener == null) break;
                            ImaPlayer.this.mListener.onEvent("res", ImaPlayer.this.bridPlayer.getPlayerReference());
                            break;
                        }
                        case ALL_ADS_COMPLETED: {
                            ImaPlayer.this.onAdCompleted();
                            if (ImaPlayer.this.mListener != null) {
                                ImaPlayer.this.mListener.onEvent("v", ImaPlayer.this.bridPlayer.getPlayerReference());
                            }
                            if (ImaPlayer.this.bridPlayer.isAdControlsEnabled()) {
                                ImaPlayer.this.overlay.setVisibility(8);
                                ImaPlayer.this.hideAdControls();
                            }
                            ImaPlayer.this.bridPlayer.turnOffLiveWhenAdsStarted(true);
                            break;
                        }
                        case AD_BREAK_FETCH_ERROR: {
                            ImaPlayer.this.isAdPlaying = false;
                            ImaPlayer.this.resumeVideoContentAfterError();
                            if (ImaPlayer.this.var != null) {
                                ImaPlayer.this.var.start();
                            }
                            if (ImaPlayer.this.mListener == null) break;
                            ImaPlayer.this.mListener.onEvent("adbferror", ImaPlayer.this.bridPlayer.getPlayerReference());
                            break;
                        }
                        case TAPPED: {
                            ImaPlayer.this.timeWhenTapped = ImaPlayer.this.imaPlayer.getCurrentPosition();
                            if (ImaPlayer.this.mListener != null) {
                                ImaPlayer.this.mListener.onEvent("adtap", ImaPlayer.this.bridPlayer.getPlayerReference());
                            }
                            if (ImaPlayer.this.bridPlayer.isAdControlsEnabled()) {
                                ImaPlayer.this.adjustAdUI();
                                break;
                            }
                            if (ImaPlayer.this.imaPlayer.isPlaying()) {
                                if (ImaPlayer.this.mListener != null) {
                                    ImaPlayer.this.mListener.onEvent("p", ImaPlayer.this.bridPlayer.getPlayerReference());
                                }
                                ImaPlayer.this.imaPlayer.pause();
                                break;
                            }
                            if (ImaPlayer.this.mListener != null) {
                                ImaPlayer.this.mListener.onEvent("res", ImaPlayer.this.bridPlayer.getPlayerReference());
                            }
                            ImaPlayer.this.imaPlayer.play();
                            break;
                        }
                        case CLICKED: {
                            if (ImaPlayer.this.mListener == null) break;
                            ImaPlayer.this.mListener.onEvent("adc", ImaPlayer.this.bridPlayer.getPlayerReference());
                            break;
                        }
                        case STARTED: {
                            ImaPlayer.this.bridPlayer.closeAdLoading();
                            ImaPlayer.this.playerView.setUseController(false);
                            if (ImaPlayer.this.mListener != null) {
                                ImaPlayer.this.mListener.onEvent("adstart", ImaPlayer.this.bridPlayer.getPlayerReference());
                            }
                            if (ImaPlayer.this.analyticsSender == null) break;
                            ImaPlayer.this.analyticsSender.sendAnalytics(new AnalyticData("i", null));
                            break;
                        }
                        case MIDPOINT: {
                            if (ImaPlayer.this.mListener == null) break;
                            ImaPlayer.this.mListener.onEvent("admid", ImaPlayer.this.bridPlayer.getPlayerReference());
                            break;
                        }
                        case SKIPPED: {
                            if (ImaPlayer.this.mListener == null) break;
                            ImaPlayer.this.mListener.onEvent("s", ImaPlayer.this.bridPlayer.getPlayerReference());
                            break;
                        }
                        case COMPLETED: {
                            if (ImaPlayer.this.bridPlayer.isAdControlsEnabled()) {
                                ImaPlayer.this.overlay.setVisibility(4);
                                ImaPlayer.this.hideAdControls();
                            }
                            ImaPlayer.this.bridPlayer.turnOffLiveWhenAdsStarted(true);
                            if (ImaPlayer.this.mListener != null) {
                                ImaPlayer.this.mListener.onEvent("v", ImaPlayer.this.bridPlayer.getPlayerReference());
                            }
                            if (ImaPlayer.this.analyticsSender == null) break;
                            ImaPlayer.this.analyticsSender.sendAnalytics(new AnalyticData("v", null));
                            break;
                        }
                        case AD_PROGRESS: {
                            if (ImaPlayer.this.mListener == null || !ImaPlayer.this.imaPlayer.isPlaying()) break;
                            ImaPlayer.this.mListener.onEvent("adprogres", ImaPlayer.this.bridPlayer.getPlayerReference());
                            break;
                        }
                        case AD_BUFFERING: {
                            if (ImaPlayer.this.mListener == null) break;
                            ImaPlayer.this.mListener.onEvent("adbuff", ImaPlayer.this.bridPlayer.getPlayerReference());
                            break;
                        }
                        case AD_BREAK_ENDED: {
                            if (ImaPlayer.this.mListener == null) break;
                            ImaPlayer.this.mListener.onEvent("adbend", ImaPlayer.this.bridPlayer.getPlayerReference());
                            break;
                        }
                        case AD_BREAK_READY: {
                            if (ImaPlayer.this.mListener == null) break;
                            ImaPlayer.this.mListener.onEvent("adbread", ImaPlayer.this.bridPlayer.getPlayerReference());
                            break;
                        }
                        case FIRST_QUARTILE: {
                            if (ImaPlayer.this.mListener == null) break;
                            ImaPlayer.this.mListener.onEvent("adfirstq", ImaPlayer.this.bridPlayer.getPlayerReference());
                            break;
                        }
                        case THIRD_QUARTILE: {
                            if (ImaPlayer.this.mListener == null) break;
                            ImaPlayer.this.mListener.onEvent("adthirdq", ImaPlayer.this.bridPlayer.getPlayerReference());
                            break;
                        }
                        case AD_PERIOD_ENDED: {
                            if (ImaPlayer.this.mListener == null) break;
                            ImaPlayer.this.mListener.onEvent("adperend", ImaPlayer.this.bridPlayer.getPlayerReference());
                            break;
                        }
                        case AD_BREAK_STARTED: {
                            if (ImaPlayer.this.mListener == null) break;
                            ImaPlayer.this.mListener.onEvent("adbstart", ImaPlayer.this.bridPlayer.getPlayerReference());
                            break;
                        }
                        case AD_PERIOD_STARTED: {
                            if (ImaPlayer.this.mListener == null) break;
                            ImaPlayer.this.mListener.onEvent("adperstart", ImaPlayer.this.bridPlayer.getPlayerReference());
                            break;
                        }
                    }
                }
            });
            AdsRenderingSettings adsRenderingSettings = ImaSdkFactory.getInstance().createAdsRenderingSettings();
            adsRenderingSettings.setPlayAdsAfterTime(5000.0);
            adsRenderingSettings.setEnablePreloading(true);
            ImaPlayer.this.adsManager.init(adsRenderingSettings);
        }
    }
}

