/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.hls;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.SuppressLint;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.TextView;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.media3.common.util.UnstableApi;
import com.airbnb.lottie.LottieAnimationView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.brid.sdk.R;
import tv.brid.sdk.api.BridPlayer;
import tv.brid.sdk.hls.SeekSupport;
import tv.brid.sdk.hls.State;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010%\u001a\u00020&H\u0017J\u0018\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0018H\u0002J\u0010\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020)H\u0016J\u0010\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020\fH\u0016J\u0017\u0010/\u001a\u00020&2\b\u0010.\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u00100J\b\u00101\u001a\u00020&H\u0017J\u0010\u00102\u001a\u00020&2\u0006\u00103\u001a\u00020)H\u0016J\b\u00104\u001a\u00020&H\u0007J\u0006\u00105\u001a\u00020&R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u00066"}, d2={"Ltv/brid/sdk/hls/WithoutSeekSupportTv;", "Ltv/brid/sdk/hls/SeekSupport;", "player", "Ltv/brid/sdk/api/BridPlayer;", "(Ltv/brid/sdk/api/BridPlayer;)V", "btnLiveStream", "Landroid/widget/FrameLayout;", "getBtnLiveStream", "()Landroid/widget/FrameLayout;", "setBtnLiveStream", "(Landroid/widget/FrameLayout;)V", "currentPosition", "", "getCurrentPosition", "()J", "setCurrentPosition", "(J)V", "currentState", "Ltv/brid/sdk/hls/State;", "getCurrentState", "()Ltv/brid/sdk/hls/State;", "setCurrentState", "(Ltv/brid/sdk/hls/State;)V", "goToLiveAnim", "Lcom/airbnb/lottie/LottieAnimationView;", "getGoToLiveAnim", "()Lcom/airbnb/lottie/LottieAnimationView;", "setGoToLiveAnim", "(Lcom/airbnb/lottie/LottieAnimationView;)V", "livestreamBtn", "Landroid/widget/ImageButton;", "getLivestreamBtn", "()Landroid/widget/ImageButton;", "setLivestreamBtn", "(Landroid/widget/ImageButton;)V", "getPlayer", "()Ltv/brid/sdk/api/BridPlayer;", "adjustUI", "", "changeAnimationForLiveTv", "isGoToLive", "", "animationView", "onPlayPauseStatusChange", "isEnabled", "onSeek", "pos", "onTimeline", "(Ljava/lang/Long;)V", "removeAdjustUI", "removeTvLiveIcon", "isVisible", "setLiveStreamButtonDisabled", "setLiveStreamButtonEnabled", "bridsdk_release"})
public final class WithoutSeekSupportTv
implements SeekSupport {
    @NotNull
    private final BridPlayer player;
    public FrameLayout btnLiveStream;
    public ImageButton livestreamBtn;
    public LottieAnimationView goToLiveAnim;
    @NotNull
    private State currentState;
    private long currentPosition;

    public WithoutSeekSupportTv(@NotNull BridPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.player = player;
        this.currentState = State.LIVE;
        this.currentPosition = this.player.getCurrentPosition();
    }

    @NotNull
    public final BridPlayer getPlayer() {
        return this.player;
    }

    @NotNull
    public final FrameLayout getBtnLiveStream() {
        FrameLayout frameLayout = this.btnLiveStream;
        if (frameLayout != null) {
            return frameLayout;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"btnLiveStream");
        return null;
    }

    public final void setBtnLiveStream(@NotNull FrameLayout frameLayout) {
        Intrinsics.checkNotNullParameter((Object)frameLayout, (String)"<set-?>");
        this.btnLiveStream = frameLayout;
    }

    @NotNull
    public final ImageButton getLivestreamBtn() {
        ImageButton imageButton = this.livestreamBtn;
        if (imageButton != null) {
            return imageButton;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"livestreamBtn");
        return null;
    }

    public final void setLivestreamBtn(@NotNull ImageButton imageButton) {
        Intrinsics.checkNotNullParameter((Object)imageButton, (String)"<set-?>");
        this.livestreamBtn = imageButton;
    }

    @NotNull
    public final LottieAnimationView getGoToLiveAnim() {
        LottieAnimationView lottieAnimationView = this.goToLiveAnim;
        if (lottieAnimationView != null) {
            return lottieAnimationView;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"goToLiveAnim");
        return null;
    }

    public final void setGoToLiveAnim(@NotNull LottieAnimationView lottieAnimationView) {
        Intrinsics.checkNotNullParameter((Object)lottieAnimationView, (String)"<set-?>");
        this.goToLiveAnim = lottieAnimationView;
    }

    @NotNull
    public final State getCurrentState() {
        return this.currentState;
    }

    public final void setCurrentState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"<set-?>");
        this.currentState = state;
    }

    public final long getCurrentPosition() {
        return this.currentPosition;
    }

    public final void setCurrentPosition(long l) {
        this.currentPosition = l;
    }

    @Override
    @RequiresApi(value=26)
    @OptIn(markerClass={UnstableApi.class})
    public void adjustUI() {
        ConstraintLayout progressBar = (ConstraintLayout)this.player.getPlayerView(true).findViewById(R.id.timeline_progress_tv);
        View view = this.player.getPlayerView(true).findViewById(R.id.exo_live_tv_btn);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"player.getPlayerView(tru\u2026on>(R.id.exo_live_tv_btn)");
        this.setLivestreamBtn((ImageButton)view);
        View view2 = this.player.getPlayerView(true).findViewById(R.id.go_to_live_anim);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"player.getPlayerView(tru\u2026ew>(R.id.go_to_live_anim)");
        this.setGoToLiveAnim((LottieAnimationView)view2);
        View view3 = this.player.getPlayerView(true).findViewById(R.id.liveStreamFrameTv);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"player.getPlayerView(tru\u2026>(R.id.liveStreamFrameTv)");
        this.setBtnLiveStream((FrameLayout)view3);
        progressBar.setVisibility(8);
        progressBar.setFocusable(0);
        this.getBtnLiveStream().setVisibility(0);
        this.getLivestreamBtn().setOnClickListener(arg_0 -> WithoutSeekSupportTv.adjustUI$lambda$0(this, arg_0));
    }

    @Override
    public void onSeek(long pos) {
        if (pos > this.currentPosition) {
            this.setLiveStreamButtonDisabled();
        } else {
            this.setLiveStreamButtonEnabled();
        }
    }

    @Override
    public void onTimeline(@Nullable Long pos) {
    }

    @Override
    public void onPlayPauseStatusChange(boolean isEnabled) {
        if (isEnabled) {
            this.setLiveStreamButtonEnabled();
        } else {
            this.setLiveStreamButtonDisabled();
        }
    }

    public final void setLiveStreamButtonEnabled() {
        LottieAnimationView dot = (LottieAnimationView)this.getBtnLiveStream().findViewById(R.id.ls_dot);
        TextView lbl = (TextView)this.getBtnLiveStream().findViewById(R.id.ls_lbl);
        lbl.setText((CharSequence)"Live");
        Intrinsics.checkNotNullExpressionValue((Object)dot, (String)"dot");
        this.changeAnimationForLiveTv(true, dot);
        this.currentState = State.LIVE;
        this.player.seekToPosition(this.currentPosition);
        this.player.play();
    }

    @SuppressLint(value={"ResourceAsColor"})
    public final void setLiveStreamButtonDisabled() {
        LottieAnimationView dot = (LottieAnimationView)this.getBtnLiveStream().findViewById(R.id.ls_dot);
        TextView lbl = (TextView)this.getBtnLiveStream().findViewById(R.id.ls_lbl);
        Intrinsics.checkNotNullExpressionValue((Object)dot, (String)"dot");
        this.changeAnimationForLiveTv(false, dot);
        lbl.setText((CharSequence)"");
        this.currentState = State.NOT_LIVE;
    }

    private final void changeAnimationForLiveTv(boolean isGoToLive, LottieAnimationView animationView) {
        if (isGoToLive) {
            animationView.cancelAnimation();
            animationView.setAnimation("live_dot.json");
            animationView.playAnimation();
            this.getGoToLiveAnim().setVisibility(0);
            this.getLivestreamBtn().setVisibility(8);
            this.getGoToLiveAnim().setRepeatCount(0);
            this.getGoToLiveAnim().playAnimation();
            this.getGoToLiveAnim().addAnimatorListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this){
                final /* synthetic */ WithoutSeekSupportTv this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onAnimationEnd(@NotNull Animator animation) {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    this.this$0.getGoToLiveAnim().setVisibility(8);
                }
            });
        } else {
            this.getLivestreamBtn().setVisibility(0);
            animationView.cancelAnimation();
            animationView.setAnimation("not_live_icon.json");
            animationView.playAnimation();
        }
    }

    @Override
    @RequiresApi(value=26)
    @OptIn(markerClass={UnstableApi.class})
    public void removeAdjustUI() {
        ConstraintLayout progressBar = (ConstraintLayout)this.player.getPlayerView(true).findViewById(R.id.timeline_progress_tv);
        View view = this.player.getPlayerView(true).findViewById(R.id.liveStreamFrameTv);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"player.getPlayerView(tru\u2026>(R.id.liveStreamFrameTv)");
        this.setBtnLiveStream((FrameLayout)view);
        progressBar.setVisibility(0);
        progressBar.setFocusable(1);
        this.getBtnLiveStream().setVisibility(8);
        this.getLivestreamBtn().setVisibility(8);
    }

    @Override
    public void removeTvLiveIcon(boolean isVisible) {
        if (!isVisible) {
            this.getBtnLiveStream().setVisibility(0);
        } else {
            this.getBtnLiveStream().setVisibility(8);
        }
    }

    private static final void adjustUI$lambda$0(WithoutSeekSupportTv this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.setLiveStreamButtonEnabled();
    }
}

