/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.engine;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.brid.common.BridPlayerException;
import tv.brid.domain.Source;
import tv.brid.domain.Video;
import tv.brid.sdk.engine.IRenditionProvider;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\u0016\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004H\u0016R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Ltv/brid/sdk/engine/RenditionProvider;", "Ltv/brid/sdk/engine/IRenditionProvider;", "()V", "renditionMap", "", "", "getRenditionMap", "()Ljava/util/Map;", "video", "Ltv/brid/domain/Video;", "getVideo", "()Ltv/brid/domain/Video;", "setVideo", "(Ltv/brid/domain/Video;)V", "getCorrespondingRenditionName", "renditionOption", "provideDefaultRenditionTag", "provideDefaultRenditionUrl", "provideRenditionsList", "bridsdk_release"})
public final class RenditionProvider
implements IRenditionProvider {
    @Nullable
    private Video video;
    @NotNull
    private final Map<String, String> renditionMap;

    public RenditionProvider() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ld", (Object)"240p"), TuplesKt.to((Object)"sd", (Object)"360p"), TuplesKt.to((Object)"hsd", (Object)"480p"), TuplesKt.to((Object)"hd", (Object)"720p"), TuplesKt.to((Object)"fhd", (Object)"1080"), TuplesKt.to((Object)"streaming", (Object)"AUTO")};
        this.renditionMap = MapsKt.mapOf((Pair[])pairArray);
    }

    @Nullable
    public final Video getVideo() {
        return this.video;
    }

    public final void setVideo(@Nullable Video video) {
        this.video = video;
    }

    @NotNull
    public final Map<String, String> getRenditionMap() {
        return this.renditionMap;
    }

    @Override
    @NotNull
    public String provideDefaultRenditionTag() {
        Object object = this.video;
        if (object != null && (object = ((Video)object).getSource()) != null) {
            Object it = object;
            boolean bl = false;
            if (((Source)it).getStreaming() != null) {
                String string2 = this.renditionMap.get("streaming");
                Intrinsics.checkNotNull((Object)string2);
                return string2;
            }
            if (((Source)it).getHd() != null) {
                String string3 = this.renditionMap.get("hd");
                Intrinsics.checkNotNull((Object)string3);
                return string3;
            }
            if (((Source)it).getSd() != null) {
                String string4 = this.renditionMap.get("sd");
                Intrinsics.checkNotNull((Object)string4);
                return string4;
            }
            if (((Source)it).getLd() != null) {
                String string5 = this.renditionMap.get("ld");
                Intrinsics.checkNotNull((Object)string5);
                return string5;
            }
            if (((Source)it).getFhd() != null) {
                String string6 = this.renditionMap.get("fhd");
                Intrinsics.checkNotNull((Object)string6);
                return string6;
            }
            if (((Source)it).getHsd() != null) {
                String string7 = this.renditionMap.get("hsd");
                Intrinsics.checkNotNull((Object)string7);
                return string7;
            }
        }
        throw new BridPlayerException(2, "can't get rendition when video is null");
    }

    @Override
    @NotNull
    public String provideDefaultRenditionUrl() {
        Video video = this.video;
        if (video != null) {
            Video it = video;
            boolean bl = false;
            Source source = it.getSource();
            if ((source != null ? source.getStreaming() : null) != null) {
                Source source2 = it.getSource();
                String string2 = source2 != null ? source2.getStreaming() : null;
                Intrinsics.checkNotNull((Object)string2);
                return string2;
            }
            String string3 = it.getDefaultVideoUrl();
            Intrinsics.checkNotNull((Object)string3);
            return string3;
        }
        throw new BridPlayerException(2, "can't get rendition when video is null");
    }

    @Override
    @NotNull
    public Map<String, String> provideRenditionsList() {
        Video video = this.video;
        if (video != null) {
            boolean isHLSVideo;
            Video it = video;
            boolean bl = false;
            Map dataMap = new HashMap();
            Source source = it.getSource();
            boolean bl2 = isHLSVideo = (source != null ? source.getStreaming() : null) != null;
            if (isHLSVideo) {
                String string2;
                String string3;
                Map map;
                dataMap.put("AUTO", "streaming");
                Source source2 = it.getSource();
                if ((source2 != null ? source2.getLd() : null) != null) {
                    map = dataMap;
                    string3 = this.getCorrespondingRenditionName("LD");
                    Source source3 = it.getSource();
                    string2 = source3 != null ? source3.getLd() : null;
                    map.put(string3, string2);
                }
                Source source4 = it.getSource();
                if ((source4 != null ? source4.getSd() : null) != null) {
                    map = dataMap;
                    string3 = this.getCorrespondingRenditionName("SD");
                    Source source5 = it.getSource();
                    string2 = source5 != null ? source5.getLd() : null;
                    map.put(string3, string2);
                }
                Source source6 = it.getSource();
                if ((source6 != null ? source6.getHd() : null) != null) {
                    map = dataMap;
                    string3 = this.getCorrespondingRenditionName("HD");
                    Source source7 = it.getSource();
                    string2 = source7 != null ? source7.getLd() : null;
                    map.put(string3, string2);
                }
                Source source8 = it.getSource();
                if ((source8 != null ? source8.getHsd() : null) != null) {
                    map = dataMap;
                    string3 = this.getCorrespondingRenditionName("HSD");
                    Source source9 = it.getSource();
                    string2 = source9 != null ? source9.getLd() : null;
                    map.put(string3, string2);
                }
                Source source10 = it.getSource();
                if ((source10 != null ? source10.getFhd() : null) != null) {
                    map = dataMap;
                    string3 = this.getCorrespondingRenditionName("FHD");
                    Source source11 = it.getSource();
                    string2 = source11 != null ? source11.getLd() : null;
                    map.put(string3, string2);
                }
            } else {
                String string4;
                String string5;
                Map map;
                Source source12 = it.getSource();
                if ((source12 != null ? source12.getLd() : null) != null) {
                    map = dataMap;
                    string5 = this.getCorrespondingRenditionName("LD");
                    Source source13 = it.getSource();
                    string4 = source13 != null ? source13.getLd() : null;
                    map.put(string5, string4);
                }
                Source source14 = it.getSource();
                if ((source14 != null ? source14.getSd() : null) != null) {
                    map = dataMap;
                    string5 = this.getCorrespondingRenditionName("SD");
                    Source source15 = it.getSource();
                    string4 = source15 != null ? source15.getLd() : null;
                    map.put(string5, string4);
                }
                Source source16 = it.getSource();
                if ((source16 != null ? source16.getHd() : null) != null) {
                    map = dataMap;
                    string5 = this.getCorrespondingRenditionName("HD");
                    Source source17 = it.getSource();
                    string4 = source17 != null ? source17.getLd() : null;
                    map.put(string5, string4);
                }
                Source source18 = it.getSource();
                if ((source18 != null ? source18.getHsd() : null) != null) {
                    map = dataMap;
                    string5 = this.getCorrespondingRenditionName("HSD");
                    Source source19 = it.getSource();
                    string4 = source19 != null ? source19.getLd() : null;
                    map.put(string5, string4);
                }
                Source source20 = it.getSource();
                if ((source20 != null ? source20.getFhd() : null) != null) {
                    map = dataMap;
                    string5 = this.getCorrespondingRenditionName("FHD");
                    Source source21 = it.getSource();
                    string4 = source21 != null ? source21.getLd() : null;
                    map.put(string5, string4);
                }
            }
            return MapsKt.toMap((Map)dataMap);
        }
        throw new BridPlayerException(2, "can't get rendition when video is null");
    }

    @NotNull
    public final String getCorrespondingRenditionName(@NotNull String renditionOption) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)renditionOption, (String)"renditionOption");
        String string3 = renditionOption;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string4 = string3.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
        if (Intrinsics.areEqual((Object)string4, (Object)"LD")) {
            string2 = "240p";
        } else {
            string3 = renditionOption;
            Locale locale2 = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"ROOT");
            Locale locale3 = locale2;
            String string5 = string3.toUpperCase(locale3);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
            if (Intrinsics.areEqual((Object)string5, (Object)"SD")) {
                string2 = "360p";
            } else {
                string3 = renditionOption;
                Locale locale4 = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue((Object)locale4, (String)"ROOT");
                String string6 = string3.toUpperCase(locale4);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toUpperCase(...)");
                if (Intrinsics.areEqual((Object)string6, (Object)"HSD")) {
                    string2 = "480p";
                } else {
                    string3 = renditionOption;
                    Locale locale5 = Locale.ROOT;
                    Intrinsics.checkNotNullExpressionValue((Object)locale5, (String)"ROOT");
                    locale3 = locale5;
                    String string7 = string3.toUpperCase(locale3);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toUpperCase(...)");
                    if (Intrinsics.areEqual((Object)string7, (Object)"HD")) {
                        string2 = "720p";
                    } else {
                        string3 = renditionOption;
                        Locale locale6 = Locale.ROOT;
                        Intrinsics.checkNotNullExpressionValue((Object)locale6, (String)"ROOT");
                        String string8 = string3.toUpperCase(locale6);
                        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toUpperCase(...)");
                        string2 = Intrinsics.areEqual((Object)string8, (Object)"FHD") ? "1080p" : "";
                    }
                }
            }
        }
        return string2;
    }
}

