/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.api;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.DatePicker;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.media3.common.util.UnstableApi;
import tv.brid.sdk.R;
import tv.brid.sdk.Utils;
import tv.brid.sdk.api.BridPlayerImpl;
import tv.brid.sdk.player.ui.UtilsKt;

@UnstableApi
public class BridAgeRestricted
extends RelativeLayout {
    private DatePicker datePicker;
    private TextView txtTitle;
    private TextView txtTitleTv;
    private Button btnConfirm;
    private Button btnDeclineTv;
    private Button btnConfirmAgeTv;
    private int ageGate = 0;
    private BridPlayerImpl bridPlayer;
    private RelativeLayout layoutMobile;
    private RelativeLayout layoutTv;

    public BridAgeRestricted(@NonNull Context context, int ageGateId, BridPlayerImpl bridPlayer) {
        super(context);
        this.bridPlayer = bridPlayer;
        if (ageGateId == 2) {
            this.ageGate = 17;
        } else if (ageGateId == 3) {
            this.ageGate = 18;
        }
        this.initAttributes(context, null);
    }

    public BridAgeRestricted(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initAttributes(context, attrs);
    }

    public BridAgeRestricted(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttributes(context, attrs);
    }

    private void initAttributes(final Context context, AttributeSet attrs) {
        BridAgeRestricted.inflate((Context)context, (int)R.layout.brid_age_restricted, (ViewGroup)this);
        this.layoutMobile = (RelativeLayout)this.findViewById(R.id.restricted_layout_mobile);
        this.layoutTv = (RelativeLayout)this.findViewById(R.id.restricted_layout_tv);
        this.btnConfirmAgeTv = (Button)this.findViewById(R.id.btnConfirmAgeTv);
        this.btnConfirm = (Button)this.findViewById(R.id.btnConfimAge);
        this.btnDeclineTv = (Button)this.findViewById(R.id.btnDeclineAgeTv);
        this.btnConfirm.setText((CharSequence)Utils.getTranslationByCode(context, "confirm", this.bridPlayer != null ? this.bridPlayer.getPlayerLanguage() : "en"));
        this.btnConfirmAgeTv.setText((CharSequence)Utils.getTranslationByCode(context, "confirm", this.bridPlayer != null ? this.bridPlayer.getPlayerLanguage() : "en"));
        this.datePicker = (DatePicker)this.findViewById(R.id.datePicker);
        this.txtTitle = (TextView)this.findViewById(R.id.age_restricted_title);
        this.txtTitleTv = (TextView)this.findViewById(R.id.age_restricted_title_tv);
        this.txtTitle.setText((CharSequence)Utils.getTranslationByCode(context, "age_verification_msg", this.bridPlayer != null ? this.bridPlayer.getPlayerLanguage() : "en"));
        this.txtTitleTv.setText((CharSequence)Utils.getTranslationByCode(context, "age_verification_msg_tv", this.bridPlayer != null ? this.bridPlayer.getPlayerLanguage() : "en"));
        this.btnDeclineTv.setText((CharSequence)Utils.getTranslationByCode(context, "decline", this.bridPlayer != null ? this.bridPlayer.getPlayerLanguage() : "en"));
        this.btnConfirmAgeTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                BridAgeRestricted.this.setVisibility(8);
                if (BridAgeRestricted.this.bridPlayer != null) {
                    BridAgeRestricted.this.bridPlayer.confirmVerificationAndStartVideo();
                }
            }
        });
        this.btnDeclineTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                BridAgeRestricted.this.txtTitleTv.setText((CharSequence)Utils.getTranslationByCode(context, "verification_failed", BridAgeRestricted.this.bridPlayer != null ? BridAgeRestricted.this.bridPlayer.getPlayerLanguage() : "en"));
                BridAgeRestricted.this.txtTitleTv.setTextColor(context.getResources().getColor(R.color.brid));
                BridAgeRestricted.this.btnConfirmAgeTv.setVisibility(8);
                BridAgeRestricted.this.btnDeclineTv.setVisibility(8);
            }
        });
        this.btnConfirm.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (Utils.isOlderThan(BridAgeRestricted.this.datePicker, BridAgeRestricted.this.ageGate)) {
                    BridAgeRestricted.this.setVisibility(8);
                    if (BridAgeRestricted.this.bridPlayer != null) {
                        BridAgeRestricted.this.bridPlayer.confirmVerificationAndStartVideo();
                    }
                } else {
                    BridAgeRestricted.this.txtTitle.setText((CharSequence)Utils.getTranslationByCode(context, "verification_failed", BridAgeRestricted.this.bridPlayer != null ? BridAgeRestricted.this.bridPlayer.getPlayerLanguage() : "en"));
                    BridAgeRestricted.this.txtTitle.setTextColor(context.getResources().getColor(R.color.brid));
                }
            }
        });
        if (!UtilsKt.isSDKRunningOnTvDevice(context)) {
            this.layoutMobile.setVisibility(0);
            this.layoutTv.setVisibility(8);
        } else {
            this.layoutMobile.setVisibility(8);
            this.layoutTv.setVisibility(0);
            this.btnConfirmAgeTv.requestFocus();
        }
    }

    public boolean isAgeRestrictedShowing() {
        return this.getVisibility() == 0;
    }
}

