/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.player.ui.glide_transformation;

import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import tv.brid.sdk.brid_network.domain.VttSegment;
import tv.brid.sdk.player.ui.glide_transformation.CallbackVtt;
import tv.brid.sdk.player.ui.glide_transformation.VttDownloader;

public class VttParser {
    private VttDownloader vttDownloader = new VttDownloader();
    private String contentVTT;
    private List<VttSegment> vttSegmentList;

    public VttParser(String vttFileUrl) {
        this.vttDownloader.downloadVttFile(vttFileUrl, new CallbackVtt(){

            @Override
            public void onSuccess(String content) {
                VttParser.this.contentVTT = content;
                VttParser.this.vttSegmentList = VttParser.parseVttContent(VttParser.this.contentVTT);
            }

            @Override
            public void onError(Exception e) {
                Log.d((String)"Error Happend", (String)"Error Happend while parsing VTT file");
            }
        });
    }

    public static List<VttSegment> parseVttContent(String vttContent) {
        ArrayList<VttSegment> segments = new ArrayList<VttSegment>();
        String[] lines = vttContent.split("\n");
        String currentTimeLine = null;
        for (String line : lines) {
            if (line.trim().isEmpty()) continue;
            if (currentTimeLine == null && line.contains("-->")) {
                currentTimeLine = line;
                continue;
            }
            if (currentTimeLine == null || !line.contains(".jpg")) continue;
            String[] timeStamps = currentTimeLine.split(" --> ");
            String startTime = timeStamps[0];
            String endTime = timeStamps[1];
            String[] parts = line.split("#xywh=");
            String imagePath = parts[0];
            String[] coords = parts[1].split(",");
            int x = Integer.parseInt(coords[0]);
            int y = Integer.parseInt(coords[1]);
            int width = Integer.parseInt(coords[2]);
            int height = Integer.parseInt(coords[3]);
            segments.add(new VttSegment(startTime, endTime, imagePath, x, y, width, height, VttParser.convertTimeToMillis(startTime), VttParser.convertTimeToMillis(endTime)));
            currentTimeLine = null;
        }
        return segments;
    }

    private static long convertTimeToMillis(String time) {
        String[] hms = time.split(":");
        String[] secMillis = hms[2].split("\\.");
        long hours = Long.parseLong(hms[0]);
        long minutes = Long.parseLong(hms[1]);
        long seconds = Long.parseLong(secMillis[0]);
        long millis = Long.parseLong(secMillis[1]);
        return (hours * 3600L + minutes * 60L + seconds) * 1000L + millis;
    }

    public List<VttSegment> getVttSegmentList() {
        return this.vttSegmentList;
    }
}

