/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.player.ui.glide_transformation;

import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.List;
import tv.brid.sdk.brid_network.domain.VttSegment;
import tv.brid.sdk.player.ui.glide_transformation.VttParser;

public class GlideThumbnailTransformation
extends BitmapTransformation {
    private static VttParser vttParser;
    private List<VttSegment> vttSegments;
    private int x;
    private int y;

    @RequiresApi(api=24)
    public GlideThumbnailTransformation(long position, List<VttSegment> vttSegments) {
        if (vttSegments != null && vttSegments.size() > 0) {
            this.vttSegments = vttSegments;
            vttSegments.stream().filter(x -> x.getStartTimeMillis() < position && x.getEndTimeMillis() > position).findFirst().ifPresent(x -> {
                this.x = x.getX();
                this.y = x.getY();
            });
        }
    }

    private int getX() {
        return this.x;
    }

    private int getY() {
        return this.y;
    }

    protected Bitmap transform(@NonNull BitmapPool pool, @NonNull Bitmap toTransform, int outWidth, int outHeight) {
        int width = 120;
        int height = 68;
        return Bitmap.createBitmap((Bitmap)toTransform, (int)this.x, (int)this.y, (int)width, (int)height);
    }

    public void updateDiskCacheKey(MessageDigest messageDigest) {
        byte[] data = ByteBuffer.allocate(8).putInt(this.x).putInt(this.y).array();
        messageDigest.update(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GlideThumbnailTransformation that = (GlideThumbnailTransformation)((Object)o);
        if (this.x != that.x) {
            return false;
        }
        return this.y == that.y;
    }

    public int hashCode() {
        int result = this.x;
        result = 31 * result + this.y;
        return result;
    }
}

