/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.player.ui.double_tap_layout;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.brid.sdk.player.ui.double_tap_layout.PlayerDoubleTapListener;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 $2\u00020\u0001:\u0001$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001bJ\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Ltv/brid/sdk/player/ui/double_tap_layout/DoubleTapGestureListener;", "Landroid/view/GestureDetector$SimpleOnGestureListener;", "rootView", "Landroid/view/View;", "(Landroid/view/View;)V", "controls", "Ltv/brid/sdk/player/ui/double_tap_layout/PlayerDoubleTapListener;", "getControls", "()Ltv/brid/sdk/player/ui/double_tap_layout/PlayerDoubleTapListener;", "setControls", "(Ltv/brid/sdk/player/ui/double_tap_layout/PlayerDoubleTapListener;)V", "doubleTapDelay", "", "getDoubleTapDelay", "()J", "setDoubleTapDelay", "(J)V", "isDoubleTapping", "", "()Z", "setDoubleTapping", "(Z)V", "mHandler", "Landroid/os/Handler;", "mRunnable", "Ljava/lang/Runnable;", "cancelInDoubleTapMode", "", "keepInDoubleTapMode", "onDoubleTap", "e", "Landroid/view/MotionEvent;", "onDoubleTapEvent", "onDown", "onSingleTapConfirmed", "onSingleTapUp", "Companion", "bridsdk_release"})
public final class DoubleTapGestureListener
extends GestureDetector.SimpleOnGestureListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final View rootView;
    @NotNull
    private final Handler mHandler;
    @NotNull
    private final Runnable mRunnable;
    @Nullable
    private PlayerDoubleTapListener controls;
    private boolean isDoubleTapping;
    private long doubleTapDelay;
    @NotNull
    private static final String TAG = ".DTGListener";
    private static boolean DEBUG = true;

    public DoubleTapGestureListener(@NotNull View rootView) {
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        this.rootView = rootView;
        this.mHandler = new Handler(Looper.getMainLooper());
        this.mRunnable = () -> DoubleTapGestureListener.mRunnable$lambda$0(this);
        this.doubleTapDelay = 650L;
    }

    @Nullable
    public final PlayerDoubleTapListener getControls() {
        return this.controls;
    }

    public final void setControls(@Nullable PlayerDoubleTapListener playerDoubleTapListener) {
        this.controls = playerDoubleTapListener;
    }

    public final boolean isDoubleTapping() {
        return this.isDoubleTapping;
    }

    public final void setDoubleTapping(boolean bl) {
        this.isDoubleTapping = bl;
    }

    public final long getDoubleTapDelay() {
        return this.doubleTapDelay;
    }

    public final void setDoubleTapDelay(long l) {
        this.doubleTapDelay = l;
    }

    public final void keepInDoubleTapMode() {
        this.isDoubleTapping = true;
        this.mHandler.removeCallbacks(this.mRunnable);
        this.mHandler.postDelayed(this.mRunnable, this.doubleTapDelay);
    }

    public final void cancelInDoubleTapMode() {
        block0: {
            this.mHandler.removeCallbacks(this.mRunnable);
            this.isDoubleTapping = false;
            PlayerDoubleTapListener playerDoubleTapListener = this.controls;
            if (playerDoubleTapListener == null) break block0;
            playerDoubleTapListener.onDoubleTapFinished();
        }
    }

    public boolean onDown(@NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.isDoubleTapping) {
            PlayerDoubleTapListener playerDoubleTapListener = this.controls;
            if (playerDoubleTapListener != null) {
                playerDoubleTapListener.onDoubleTapProgressDown(e.getX(), e.getY());
            }
            return true;
        }
        return super.onDown(e);
    }

    public boolean onSingleTapUp(@NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.isDoubleTapping) {
            if (DEBUG) {
                Log.d((String)TAG, (String)"onSingleTapUp: isDoubleTapping = true");
            }
            PlayerDoubleTapListener playerDoubleTapListener = this.controls;
            if (playerDoubleTapListener != null) {
                playerDoubleTapListener.onDoubleTapProgressUp(e.getX(), e.getY());
            }
            return true;
        }
        return super.onSingleTapUp(e);
    }

    public boolean onSingleTapConfirmed(@NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.isDoubleTapping) {
            return true;
        }
        if (DEBUG) {
            Log.d((String)TAG, (String)"onSingleTapConfirmed: isDoubleTap = false");
        }
        return this.rootView.performClick();
    }

    public boolean onDoubleTap(@NotNull MotionEvent e) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (DEBUG) {
                Log.d((String)TAG, (String)"onDoubleTap");
            }
            if (this.isDoubleTapping) break block2;
            this.isDoubleTapping = true;
            this.keepInDoubleTapMode();
            PlayerDoubleTapListener playerDoubleTapListener = this.controls;
            if (playerDoubleTapListener != null) {
                playerDoubleTapListener.onDoubleTapStarted(e.getX(), e.getY());
            }
        }
        return true;
    }

    public boolean onDoubleTapEvent(@NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getActionMasked() == 1 && this.isDoubleTapping) {
            if (DEBUG) {
                Log.d((String)TAG, (String)"onDoubleTapEvent, ACTION_UP");
            }
            PlayerDoubleTapListener playerDoubleTapListener = this.controls;
            if (playerDoubleTapListener != null) {
                playerDoubleTapListener.onDoubleTapProgressUp(e.getX(), e.getY());
            }
            return true;
        }
        return super.onDoubleTapEvent(e);
    }

    private static final void mRunnable$lambda$0(DoubleTapGestureListener this$0) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            if (DEBUG) {
                Log.d((String)TAG, (String)"Runnable called");
            }
            this$0.isDoubleTapping = false;
            PlayerDoubleTapListener playerDoubleTapListener = this$0.controls;
            if (playerDoubleTapListener == null) break block1;
            playerDoubleTapListener.onDoubleTapFinished();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ltv/brid/sdk/player/ui/double_tap_layout/DoubleTapGestureListener$Companion;", "", "()V", "DEBUG", "", "TAG", "", "bridsdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

