/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.player.ui;

import android.app.UiModeManager;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.text.SpannableStringBuilder;
import android.text.style.StyleSpan;
import android.view.Display;
import android.view.View;
import android.widget.Button;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import tv.brid.domain.Player;
import tv.brid.domain.Video;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\r\u001a\n\u0010\u000e\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u000f\u001a\u00020\u0001*\u00020\u0003\u001a\u001e\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\b\b\u0003\u0010\u0013\u001a\u00020\f2\b\b\u0001\u0010\u0014\u001a\u00020\f\u00a8\u0006\u0015"}, d2={"isWifiConnected", "", "context", "Landroid/content/Context;", "showStatistic", "Landroid/text/SpannableStringBuilder;", "playerVO", "Ltv/brid/domain/Player;", "videoVOS", "", "Ltv/brid/domain/Video;", "getVisiblePercentage", "", "Landroid/view/View;", "isLandscape", "isSDKRunningOnTvDevice", "leftDrawable", "", "Landroid/widget/Button;", "id", "sizeRes", "bridsdk_release"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ntv/brid/sdk/player/ui/UtilsKt\n+ 2 SpannableStringBuilder.kt\nandroidx/core/text/SpannableStringBuilderKt\n*L\n1#1,105:1\n87#2:106\n74#2,4:107\n87#2:111\n74#2,4:112\n87#2:116\n74#2,4:117\n87#2:121\n74#2,4:122\n*S KotlinDebug\n*F\n+ 1 Utils.kt\ntv/brid/sdk/player/ui/UtilsKt\n*L\n54#1:106\n54#1:107,4\n56#1:111\n56#1:112,4\n58#1:116\n58#1:117,4\n61#1:121\n61#1:122,4\n*E\n"})
public final class UtilsKt {
    public static final int getVisiblePercentage(@NotNull View $this$getVisiblePercentage) {
        boolean viewIsPartiallyHiddenTop;
        Intrinsics.checkNotNullParameter((Object)$this$getVisiblePercentage, (String)"<this>");
        Rect mCurrentViewRect = new Rect();
        int percents = 100;
        $this$getVisiblePercentage.getLocalVisibleRect(mCurrentViewRect);
        int height = $this$getVisiblePercentage.getHeight();
        boolean viewIsPartiallyHiddenBottom = mCurrentViewRect.bottom > 0 && mCurrentViewRect.bottom < height;
        boolean bl = viewIsPartiallyHiddenTop = mCurrentViewRect.top > 0;
        if (viewIsPartiallyHiddenTop) {
            percents = (height - mCurrentViewRect.top) * 100 / height;
        } else if (viewIsPartiallyHiddenBottom) {
            percents = mCurrentViewRect.bottom * 100 / height;
        }
        return percents;
    }

    public static final boolean isWifiConnected(@NotNull Context context) {
        NetworkInfo activeNetwork;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("connectivity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
        ConnectivityManager connManager = (ConnectivityManager)object;
        NetworkInfo networkInfo = activeNetwork = connManager.getActiveNetworkInfo();
        return networkInfo != null ? networkInfo.getType() == 1 : false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SpannableStringBuilder showStatistic(@NotNull Player playerVO, @NotNull List<Video> videoVOS) {
        void $this$inSpans$iv$iv;
        void $this$inSpans$iv$iv2;
        void $this$bold$iv;
        void $this$inSpans$iv$iv3;
        void $this$bold$iv2;
        void $this$inSpans$iv$iv4;
        void $this$bold$iv3;
        Intrinsics.checkNotNullParameter((Object)playerVO, (String)"playerVO");
        Intrinsics.checkNotNullParameter(videoVOS, (String)"videoVOS");
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder();
        boolean $i$f$bold22 = false;
        void var8_8 = $this$bold$iv3;
        StyleSpan span$iv$iv = new StyleSpan(1);
        boolean $i$f$inSpans = false;
        int start$iv$iv = $this$inSpans$iv$iv4.length();
        void $this$showStatistic_u24lambda_u240 = $this$inSpans$iv$iv4;
        boolean bl = false;
        $this$showStatistic_u24lambda_u240.append((CharSequence)"Player: ");
        $this$inSpans$iv$iv4.setSpan((Object)span$iv$iv, start$iv$iv, $this$inSpans$iv$iv4.length(), 17);
        SpannableStringBuilder spannableStringBuilder2 = $this$inSpans$iv$iv4.append((CharSequence)(playerVO.getId() + "\n"));
        Intrinsics.checkNotNullExpressionValue((Object)spannableStringBuilder2, (String)"SpannableStringBuilder()\u2026rVO.id.toString() + \"\\n\")");
        SpannableStringBuilder spannableStringBuilder3 = spannableStringBuilder2;
        boolean $i$f$bold32 = false;
        void $i$f$bold22 = $this$bold$iv2;
        StyleSpan span$iv$iv2 = new StyleSpan(1);
        boolean $i$f$inSpans2 = false;
        int start$iv$iv2 = $this$inSpans$iv$iv3.length();
        void $this$showStatistic_u24lambda_u241 = $this$inSpans$iv$iv3;
        boolean bl2 = false;
        $this$showStatistic_u24lambda_u241.append((CharSequence)"Autoplay: ");
        $this$inSpans$iv$iv3.setSpan((Object)span$iv$iv2, start$iv$iv2, $this$inSpans$iv$iv3.length(), 17);
        SpannableStringBuilder spannableStringBuilder4 = $this$inSpans$iv$iv3.append((CharSequence)(playerVO.getAutoplay() + "\n"));
        Intrinsics.checkNotNullExpressionValue((Object)spannableStringBuilder4, (String)"SpannableStringBuilder()\u2026toplay.toString() + \"\\n\")");
        boolean $i$f$bold42 = false;
        void $i$f$bold32 = $this$bold$iv;
        StyleSpan span$iv$iv3 = new StyleSpan(1);
        boolean $i$f$inSpans3 = false;
        int start$iv$iv3 = $this$inSpans$iv$iv2.length();
        void $this$showStatistic_u24lambda_u242 = $this$inSpans$iv$iv2;
        boolean bl3 = false;
        $this$showStatistic_u24lambda_u242.append((CharSequence)"Backfill monetize: ");
        $this$inSpans$iv$iv2.setSpan((Object)span$iv$iv3, start$iv$iv3, $this$inSpans$iv$iv2.length(), 17);
        SpannableStringBuilder spannableStringBuilder5 = $this$inSpans$iv$iv2.append((CharSequence)(playerVO.getBackfill_monetize() + "\n")).append((CharSequence)"----------------------------------\n");
        Intrinsics.checkNotNullExpressionValue((Object)spannableStringBuilder5, (String)"SpannableStringBuilder()\u2026---------------------\\n\")");
        SpannableStringBuilder $this$bold$iv4 = spannableStringBuilder5;
        boolean $i$f$bold = false;
        SpannableStringBuilder $i$f$bold42 = $this$bold$iv4;
        StyleSpan span$iv$iv4 = new StyleSpan(1);
        boolean $i$f$inSpans4 = false;
        int start$iv$iv4 = $this$inSpans$iv$iv.length();
        void $this$showStatistic_u24lambda_u243 = $this$inSpans$iv$iv;
        boolean bl4 = false;
        $this$showStatistic_u24lambda_u243.append((CharSequence)"Prerolls: ");
        $this$inSpans$iv$iv.setSpan((Object)span$iv$iv4, start$iv$iv4, $this$inSpans$iv$iv.length(), 17);
        void s = $this$inSpans$iv$iv;
        return s;
    }

    public static final boolean isSDKRunningOnTvDevice(@NotNull Context $this$isSDKRunningOnTvDevice) {
        Intrinsics.checkNotNullParameter((Object)$this$isSDKRunningOnTvDevice, (String)"<this>");
        Object object = $this$isSDKRunningOnTvDevice.getSystemService("uimode");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.UiModeManager");
        UiModeManager uiModeManager = (UiModeManager)object;
        return uiModeManager.getCurrentModeType() == 4;
    }

    public static final boolean isLandscape(@NotNull Context $this$isLandscape) {
        Display display;
        Intrinsics.checkNotNullParameter((Object)$this$isLandscape, (String)"<this>");
        if (Build.VERSION.SDK_INT >= 30) {
            display = $this$isLandscape.getDisplay();
        } else {
            return $this$isLandscape.getResources().getConfiguration().orientation == 2;
        }
        return display != null ? display.getRotation() == 1 : false;
    }

    public static final void leftDrawable(@NotNull Button $this$leftDrawable, @DrawableRes int id2, @DimenRes int sizeRes) {
        Intrinsics.checkNotNullParameter((Object)$this$leftDrawable, (String)"<this>");
        Drawable drawable2 = ContextCompat.getDrawable((Context)$this$leftDrawable.getContext(), (int)id2);
        int size = $this$leftDrawable.getResources().getDimensionPixelSize(sizeRes);
        Drawable drawable3 = drawable2;
        if (drawable3 != null) {
            drawable3.setBounds(0, 0, size, size);
        }
        $this$leftDrawable.setCompoundDrawables(drawable2, null, null, null);
    }

    public static /* synthetic */ void leftDrawable$default(Button button, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        UtilsKt.leftDrawable(button, n, n2);
    }
}

