/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.player.ui;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.media3.ui.R;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import tv.brid.domain.Player;
import tv.brid.sdk.R;
import tv.brid.sdk.player.ui.UtilsKt;

public class UIVisibilityCustomization {
    private FrameLayout view;
    private FrameLayout exoBottomBar;
    private Context context;
    private TextView txtTitle;
    private ImageView watermark;
    private ImageView settings;
    private TextView renditionView;
    private LinearLayout exoCentralControls;
    private RelativeLayout unMuteLayout;
    private ViewGroup mobileControls;
    private TextView txtTVTitle;
    private View exoControlsBackgound;
    private ImageButton btnVolume;
    private ImageButton btnFullscreen;
    private ImageButton btnPlaylist;
    private ImageButton btnShare;
    private ImageButton btnSettings;
    private ImageButton btnCC;
    private View allPlayerControls;

    public UIVisibilityCustomization(Context context, FrameLayout view, View allPlayerControls) {
        this.context = context;
        this.view = view;
        this.watermark = (ImageView)view.findViewById(R.id.watermark);
        this.renditionView = (TextView)view.findViewById(R.id.exo_resolution_SD);
        this.txtTitle = (TextView)view.findViewById(R.id.exo_title);
        this.allPlayerControls = allPlayerControls;
        this.btnPlaylist = (ImageButton)view.findViewById(R.id.exo_playlist);
        if (!UtilsKt.isSDKRunningOnTvDevice(context)) {
            this.btnVolume = (ImageButton)view.findViewById(R.id.exo_mute);
            this.btnFullscreen = (ImageButton)view.findViewById(R.id.exo_fullscreen_brid);
            this.btnShare = (ImageButton)view.findViewById(R.id.exo_share);
            this.exoBottomBar = (FrameLayout)allPlayerControls.findViewById(R.id.exo_bottom_bar);
            this.exoCentralControls = (LinearLayout)allPlayerControls.findViewById(R.id.exo_center_controls);
        } else {
            this.txtTVTitle = (TextView)view.findViewById(R.id.txtTitleTV);
            this.btnSettings = (ImageButton)view.findViewById(R.id.exo_settings);
            this.exoControlsBackgound = allPlayerControls.findViewById(R.id.exo_controls_background);
        }
    }

    public void setBranding(int pos, String img, final String url) {
        Glide.with((Context)this.context).load(img).apply(new RequestOptions().override(150, 150)).into(this.watermark);
        FrameLayout.LayoutParams watermarkLayout = new FrameLayout.LayoutParams(-2, -2);
        this.watermark.setVisibility(0);
        switch (pos) {
            case 0: {
                watermarkLayout.gravity = 51;
                watermarkLayout.setMargins(25, 25, 25, 25);
                this.watermark.setLayoutParams((ViewGroup.LayoutParams)watermarkLayout);
                break;
            }
            case 1: {
                watermarkLayout.gravity = 53;
                watermarkLayout.setMargins(25, 25, 25, 25);
                this.watermark.setLayoutParams((ViewGroup.LayoutParams)watermarkLayout);
                break;
            }
            case 2: {
                watermarkLayout.gravity = 83;
                watermarkLayout.setMargins(25, 25, 25, 25);
                this.watermark.setLayoutParams((ViewGroup.LayoutParams)watermarkLayout);
                break;
            }
            case 3: {
                watermarkLayout.gravity = 85;
                watermarkLayout.setMargins(25, 25, 25, 25);
                this.watermark.setLayoutParams((ViewGroup.LayoutParams)watermarkLayout);
                break;
            }
            default: {
                this.invisibleWatermark();
            }
        }
        this.watermark.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (url != null) {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)url));
                    UIVisibilityCustomization.this.context.startActivity(intent);
                }
            }
        });
    }

    public void invisibleWatermark() {
        this.watermark.setVisibility(8);
    }

    public void enableSingleButtonControl(Player playerVO) {
        if (!UtilsKt.isSDKRunningOnTvDevice(this.context)) {
            if (playerVO.getVolume() != null) {
                this.setButtonVisibility(playerVO.getVolume(), (ImageView)this.btnVolume);
            }
            if (playerVO.getFullscreen() != null) {
                this.setButtonVisibility(playerVO.getFullscreen(), (ImageView)this.btnFullscreen);
            }
            if (playerVO.getPlaylistScreen() != null) {
                this.setButtonVisibility(playerVO.getPlaylistScreen(), (ImageView)this.btnPlaylist);
            }
            if (playerVO.getShareScreen() != null) {
                this.setButtonVisibility(playerVO.getShareScreen(), (ImageView)this.btnShare);
            }
            if (Boolean.TRUE.equals(playerVO.getCogwheel())) {
                this.renditionView.setVisibility(0);
            } else {
                this.renditionView.setVisibility(8);
            }
        } else {
            this.setButtonVisibility(false, (ImageView)this.btnFullscreen);
            this.setButtonVisibility(false, (ImageView)this.btnVolume);
            this.setButtonVisibility(false, (ImageView)this.btnShare);
            if (playerVO.getPlaylistScreen() != null) {
                this.setButtonVisibility(playerVO.getPlaylistScreen(), (ImageView)this.btnPlaylist);
            }
            if (playerVO.getCogwheel() != null) {
                this.setButtonVisibility(playerVO.getCogwheel(), (ImageView)this.btnSettings);
            }
        }
    }

    public void setButtonVisibility(Boolean isVisible, ImageView btn) {
        if (btn != null) {
            btn.setVisibility(isVisible != false ? 0 : 8);
        }
    }

    public void controlAllPlayerControls(Boolean isEnabled) {
        if (!UtilsKt.isSDKRunningOnTvDevice(this.context)) {
            if (isEnabled.booleanValue()) {
                this.exoCentralControls.setVisibility(0);
                this.exoBottomBar.setVisibility(0);
            } else {
                this.exoCentralControls.setVisibility(8);
                this.exoBottomBar.setVisibility(8);
            }
        } else if (!isEnabled.booleanValue()) {
            this.allPlayerControls.findViewById(R.id.timeline_progress_tv).setVisibility(8);
            this.btnPlaylist.setVisibility(8);
            this.btnSettings.setVisibility(8);
        }
    }

    public void activateBottomControlsIfPlayExists() {
        if (!UtilsKt.isSDKRunningOnTvDevice(this.context)) {
            this.exoBottomBar.setVisibility(this.exoCentralControls.getVisibility());
        }
    }

    public void controlAllTvPlayerControls(Boolean isEnabled) {
        if (UtilsKt.isSDKRunningOnTvDevice(this.context)) {
            if (isEnabled.booleanValue()) {
                this.allPlayerControls.setVisibility(0);
                this.allPlayerControls.findViewById(R.id.exo_play_pause_tv).setVisibility(0);
                this.allPlayerControls.findViewById(R.id.exo_progress).setVisibility(0);
            } else {
                this.allPlayerControls.setVisibility(8);
                this.allPlayerControls.findViewById(R.id.exo_play_pause_tv).setVisibility(8);
                this.allPlayerControls.findViewById(R.id.exo_progress).setVisibility(8);
            }
        }
    }

    public void setProgressBarTvShow(Boolean isEnabled) {
        if (UtilsKt.isSDKRunningOnTvDevice(this.context)) {
            if (isEnabled.booleanValue()) {
                this.allPlayerControls.findViewById(R.id.exo_bottom_bar).setVisibility(0);
                this.allPlayerControls.findViewById(R.id.timeline_progress_tv).setVisibility(0);
            } else {
                this.allPlayerControls.findViewById(R.id.exo_bottom_bar).setVisibility(8);
                this.allPlayerControls.findViewById(R.id.timeline_progress_tv).setVisibility(8);
            }
        }
    }

    public void controlPlayerTitle(@NonNull Boolean isEnabled) {
        boolean isTv = UtilsKt.isSDKRunningOnTvDevice(this.context);
        if (isEnabled.booleanValue()) {
            if (this.txtTVTitle != null && isTv) {
                this.txtTVTitle.setVisibility(0);
            } else if (this.txtTitle != null && !isTv) {
                this.txtTitle.setVisibility(0);
            }
        } else if (this.txtTVTitle != null && isTv) {
            this.txtTVTitle.setVisibility(8);
        } else if (this.txtTitle != null && !isTv) {
            this.txtTitle.setVisibility(8);
        }
    }
}

