/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.player.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.OptIn;
import androidx.core.content.ContextCompat;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.ui.DefaultTimeBar;
import androidx.media3.ui.R;
import androidx.media3.ui.TimeBar;
import com.github.rubensousa.previewseekbar.PreviewBar;
import com.github.rubensousa.previewseekbar.PreviewDelegate;
import com.github.rubensousa.previewseekbar.PreviewLoader;
import com.github.rubensousa.previewseekbar.animator.PreviewAnimator;
import tv.brid.sdk.R;

@UnstableApi
public class BridPreviewTimeBar
extends DefaultTimeBar
implements PreviewBar {
    private final PreviewDelegate delegate;
    private int scrubProgress;
    private int duration;
    private int scrubberColor;
    private int previewId;
    private final int scrubberPadding;

    @OptIn(markerClass={UnstableApi.class})
    public BridPreviewTimeBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.DefaultTimeBar, 0, 0);
        this.scrubberColor = typedArray.getInt(R.styleable.DefaultTimeBar_scrubber_color, -1);
        Drawable scrubberDrawable = typedArray.getDrawable(R.styleable.DefaultTimeBar_scrubber_drawable);
        int scrubberEnabledSize = typedArray.getDimensionPixelSize(R.styleable.DefaultTimeBar_scrubber_enabled_size, this.dpToPx(context.getResources().getDisplayMetrics(), 12));
        int scrubberDisabledSize = typedArray.getDimensionPixelSize(R.styleable.DefaultTimeBar_scrubber_disabled_size, this.dpToPx(context.getResources().getDisplayMetrics(), 0));
        int scrubberDraggedSize = typedArray.getDimensionPixelSize(R.styleable.DefaultTimeBar_scrubber_dragged_size, this.dpToPx(context.getResources().getDisplayMetrics(), 16));
        this.scrubberPadding = scrubberDrawable != null ? (scrubberDrawable.getMinimumWidth() + 1) / 2 : (Math.max(scrubberDisabledSize, Math.max(scrubberEnabledSize, scrubberDraggedSize)) + 1) / 2;
        typedArray.recycle();
        typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.BridPreviewTimeBar, 0, 0);
        this.previewId = typedArray.getResourceId(R.styleable.BridPreviewTimeBar_previewFrameLayout, -1);
        this.delegate = new PreviewDelegate((PreviewBar)this);
        this.delegate.setPreviewEnabled(this.isEnabled());
        this.delegate.setAnimationEnabled(typedArray.getBoolean(R.styleable.BridPreviewTimeBar_previewAnimationEnabled, true));
        this.delegate.setPreviewEnabled(typedArray.getBoolean(R.styleable.BridPreviewTimeBar_previewEnabled, false));
        this.delegate.setAutoHidePreview(typedArray.getBoolean(R.styleable.BridPreviewTimeBar_previewAutoHide, true));
        typedArray.recycle();
        this.addListener(new TimeBarDefaultOnScrubListener());
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        FrameLayout previewView;
        super.onLayout(changed, left, top, right, bottom);
        if (!this.delegate.isPreviewViewAttached() && !this.isInEditMode() && (previewView = PreviewDelegate.findPreviewView((ViewGroup)((ViewGroup)this.getParent()), (int)this.previewId)) != null) {
            this.delegate.attachPreviewView(previewView);
        }
    }

    public void setPreviewThumbTint(int color2) {
        this.setScrubberColor(color2);
        this.scrubberColor = color2;
    }

    public void setPreviewThumbTintResource(int colorResource) {
        this.setPreviewThumbTint(ContextCompat.getColor((Context)this.getContext(), (int)colorResource));
    }

    public void setPreviewLoader(PreviewLoader previewLoader) {
        this.delegate.setPreviewLoader(previewLoader);
    }

    public void attachPreviewView(@NonNull FrameLayout previewView) {
        this.delegate.attachPreviewView(previewView);
    }

    @OptIn(markerClass={UnstableApi.class})
    public void setDuration(long duration) {
        super.setDuration(duration);
        int newDuration = (int)duration;
        if (newDuration != this.duration) {
            this.duration = newDuration;
            this.delegate.updateProgress(this.getProgress(), newDuration);
        }
    }

    public void setPosition(long position) {
        super.setPosition(position);
        int newPosition = (int)position;
        if (newPosition != this.scrubProgress) {
            this.scrubProgress = newPosition;
            this.delegate.updateProgress(newPosition, this.duration);
        }
    }

    public boolean isShowingPreview() {
        return this.delegate.isShowingPreview();
    }

    public boolean isPreviewEnabled() {
        return this.delegate.isPreviewEnabled();
    }

    public void setPreviewEnabled(boolean enabled) {
        this.delegate.setPreviewEnabled(enabled);
    }

    public void showPreview() {
        this.delegate.show();
    }

    public void hidePreview() {
        this.delegate.hide();
    }

    public void setAutoHidePreview(boolean autoHide) {
        this.delegate.setAutoHidePreview(autoHide);
    }

    public int getProgress() {
        return this.scrubProgress;
    }

    public int getMax() {
        return this.duration;
    }

    public int getThumbOffset() {
        return this.scrubberPadding;
    }

    public int getScrubberColor() {
        return this.scrubberColor;
    }

    public void setScrubberColor(int scrubberColor) {
        super.setScrubberColor(scrubberColor);
        this.scrubberColor = scrubberColor;
    }

    public void addOnPreviewVisibilityListener(PreviewBar.OnPreviewVisibilityListener listener) {
        this.delegate.addOnPreviewVisibilityListener(listener);
    }

    public void removeOnPreviewVisibilityListener(PreviewBar.OnPreviewVisibilityListener listener) {
        this.delegate.removeOnPreviewVisibilityListener(listener);
    }

    public void setPreviewAnimator(@NonNull PreviewAnimator animator) {
        this.delegate.setAnimator(animator);
    }

    public void setPreviewAnimationEnabled(boolean enable) {
        this.delegate.setAnimationEnabled(enable);
    }

    private int dpToPx(DisplayMetrics displayMetrics, int dps) {
        return (int)((float)dps * displayMetrics.density + 0.5f);
    }

    public void addOnScrubListener(PreviewBar.OnScrubListener listener) {
        this.delegate.addOnScrubListener(listener);
    }

    public void removeOnScrubListener(PreviewBar.OnScrubListener listener) {
        this.delegate.removeOnScrubListener(listener);
    }

    private class TimeBarDefaultOnScrubListener
    implements TimeBar.OnScrubListener {
        private TimeBarDefaultOnScrubListener() {
        }

        public void onScrubStart(@NonNull TimeBar timeBar, long position) {
            BridPreviewTimeBar.this.scrubProgress = (int)position;
            BridPreviewTimeBar.this.delegate.onScrubStart();
        }

        public void onScrubMove(@NonNull TimeBar timeBar, long position) {
            BridPreviewTimeBar.this.scrubProgress = (int)position;
            BridPreviewTimeBar.this.delegate.onScrubMove((int)position, true);
        }

        public void onScrubStop(@NonNull TimeBar timeBar, long position, boolean canceled) {
            BridPreviewTimeBar.this.scrubProgress = (int)position;
            BridPreviewTimeBar.this.delegate.onScrubStop();
        }
    }
}

