/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.player.ui;

import android.content.Context;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.media3.common.MediaItem;
import androidx.media3.exoplayer.ExoPlayer;
import tv.brid.sdk.R;
import tv.brid.sdk.api.BridPlayer;
import tv.brid.sdk.api.BridPlayerBuilder;

public class BridPlayerInView
extends View {
    private BridPlayer bridPlayer;
    private Context mContext;
    private BridPlayerBuilder bridPlayerBuilder;
    private FrameLayout playerHolder;
    private ExoPlayer exoPlayer;
    private SurfaceView surfaceView;

    public BridPlayerInView(@NonNull Context context) {
        super(context);
        this.mContext = context;
        this.init(context);
    }

    public BridPlayerInView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.init(context);
    }

    public BridPlayerInView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.init(context);
    }

    @RequiresApi(api=21)
    public BridPlayerInView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mContext = context;
        this.init(context);
    }

    private void init(Context context) {
        this.playerHolder = (FrameLayout)LayoutInflater.from((Context)context).inflate(R.layout.exo_player_holder, null);
        this.playerHolder.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.surfaceView = new SurfaceView(context);
        this.surfaceView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        if (this.getParent() instanceof ViewGroup) {
            ((ViewGroup)this.getParent()).addView((View)this.surfaceView);
        }
        if (this.getParent() instanceof ViewGroup) {
            ((ViewGroup)this.getParent()).addView((View)this.surfaceView);
        }
        this.exoPlayer = new ExoPlayer.Builder(context).build();
        this.exoPlayer.setVideoSurfaceView(this.surfaceView);
        MediaItem mediaItem = MediaItem.fromUri((Uri)Uri.parse((String)"http://commondatastorage.googleapis.com/gtv-videos-bucket/sample/BigBuckBunny.mp4"));
        this.exoPlayer.setMediaItem(mediaItem);
        this.exoPlayer.prepare();
        this.exoPlayer.play();
    }

    public void attachToParent(FrameLayout parent) {
        parent.addView((View)this.playerHolder);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.surfaceView != null) {
            this.surfaceView.measure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.surfaceView != null) {
            this.surfaceView.layout(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public BridPlayer getBridPlayer() {
        return this.bridPlayer;
    }

    public void loadVideo(int playerId, int videoId) {
        this.bridPlayerBuilder = new BridPlayerBuilder(this.mContext, this.playerHolder);
        this.bridPlayer = this.bridPlayerBuilder.build();
        if (this.bridPlayer != null) {
            this.bridPlayer.loadVideo(playerId, videoId);
        }
    }

    public void loadPlaylist(int playerId, int playlistId) {
        if (this.bridPlayer != null) {
            this.bridPlayer.loadPlaylist(playerId, playlistId);
        }
    }
}

