/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.player.settings;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.media3.ui.R;
import androidx.recyclerview.widget.RecyclerView;
import tv.brid.sdk.player.settings.SettingViewClickedListener;
import tv.brid.sdk.player.settings.SettingViewHolder;

class SettingsAdapter
extends RecyclerView.Adapter<SettingViewHolder> {
    private final String[] mainTexts;
    private final String[] subTexts;
    private final Drawable[] iconIds;
    private final SettingViewClickedListener settingViewClickedListener;

    public SettingsAdapter(String[] mainTexts, Drawable[] iconIds, SettingViewClickedListener settingViewClickedListener) {
        this.settingViewClickedListener = settingViewClickedListener;
        this.mainTexts = mainTexts;
        this.subTexts = new String[mainTexts.length];
        this.iconIds = iconIds;
    }

    public SettingViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.exo_styled_settings_list_item, parent, false);
        return new SettingViewHolder(v);
    }

    public void onBindViewHolder(SettingViewHolder holder, int position) {
        holder.mainTextView.setText((CharSequence)this.mainTexts[position]);
        if (this.subTexts[position] == null) {
            holder.subTextView.setVisibility(8);
        } else {
            holder.subTextView.setText((CharSequence)this.subTexts[position]);
        }
        if (this.iconIds[position] == null) {
            holder.iconView.setVisibility(4);
        } else {
            holder.iconView.setImageDrawable(this.iconIds[position]);
        }
        holder.itemRoot.setOnClickListener(view -> this.settingViewClickedListener.onSettingViewClicked(this.mainTexts[position]));
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemCount() {
        return this.mainTexts.length;
    }

    public void setSubTextAtPosition(int position, String subText) {
        this.subTexts[position] = subText;
    }
}

