/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.player.playback.playlist;

import tv.brid.domain.Player;
import tv.brid.domain.Video;
import tv.brid.sdk.Utils;
import tv.brid.sdk.api.BridPlayer;
import tv.brid.sdk.api.SdkContainer;
import tv.brid.sdk.engine.IBridPlayerEngine;
import tv.brid.sdk.player.playback.AfterPlaylistEndStrategy;
import tv.brid.sdk.player.playback.PlaylistEndStrategy;
import tv.brid.sdk.player.playback.playlist.StopAfterPlaylistEndStrategy;
import tv.brid.sdk.player.playback.playlist.loop.LoopAfterPlaylistEndStrategy;

public class ContinuePlaylistEndStrategy
implements PlaylistEndStrategy {
    private final IBridPlayerEngine engine;
    private final Player player;
    private final boolean isLastVideo;
    private final SdkContainer sdkContainer;
    private final Video video;
    private final BridPlayer bridPlayer;

    public ContinuePlaylistEndStrategy(SdkContainer sdkContainer, Video videoVO, Player playerVO, BridPlayer bridPlayer, IBridPlayerEngine engine, boolean isLastVideo) {
        this.engine = engine;
        this.player = playerVO;
        this.isLastVideo = isLastVideo;
        this.sdkContainer = sdkContainer;
        this.video = videoVO;
        this.bridPlayer = bridPlayer;
    }

    @Override
    public void onPlaylistEnded() {
        Utils.log(this.getClass(), "onPlaylistEnded", String.valueOf(this.player.getContinueWithPreview()));
        if (!this.isLastVideo) {
            if (Boolean.FALSE.equals(this.player.getContinueWithPreview())) {
                this.engine.onNextVideoCalled();
            } else {
                this.bridPlayer.showProgressCountdownVideo();
            }
        } else {
            AfterPlaylistEndStrategy afterPlaylistEndStrategy = null;
            if (this.player.getAfterPlaylistEnd().equals("stop")) {
                afterPlaylistEndStrategy = new StopAfterPlaylistEndStrategy(this.sdkContainer, this.video, this.player, this.bridPlayer, this.engine);
            } else if (this.player.getAfterPlaylistEnd().equals("loop")) {
                afterPlaylistEndStrategy = new LoopAfterPlaylistEndStrategy(this.engine, this.player);
            }
            if (afterPlaylistEndStrategy != null) {
                afterPlaylistEndStrategy.onAfterPlaylistEnded();
            }
        }
    }
}

