/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.player.drm.store;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.preference.PreferenceManager;
import java.util.Arrays;
import tv.brid.sdk.player.drm.store.DrmKeyVO;
import tv.brid.sdk.player.drm.store.Store;

public class BaseKeyStore
implements Store<DrmKeyVO> {
    private SharedPreferences.Editor sharedPreferencesEditor;
    private SharedPreferences sharedPreferences;
    private static final String FIELD_KEY = "drm_store_field_key";
    private static final String FIELD_EXPIRATION = "drm_store_field_expiration";
    private static BaseKeyStore store;

    private BaseKeyStore(Context context) {
        this.sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        this.sharedPreferencesEditor = this.sharedPreferences.edit();
    }

    public static BaseKeyStore INSTANCE(Context context) {
        if (store == null) {
            store = new BaseKeyStore(context);
        }
        return store;
    }

    @Override
    public void store(DrmKeyVO value) {
        String keyStoreText = FIELD_KEY + Arrays.toString(value.getKey()) + FIELD_EXPIRATION + value.getExpirationTime();
        this.sharedPreferencesEditor.putString(String.valueOf(value.getVideoid()), keyStoreText);
        this.sharedPreferencesEditor.commit();
    }

    @Override
    public DrmKeyVO get(String identifier) {
        DrmKeyVO drmKeyVO = new DrmKeyVO();
        String keyStoreText = this.sharedPreferences.getString(identifier, null);
        if (keyStoreText == null) {
            return null;
        }
        String[] drmExpirationTime = keyStoreText.split(FIELD_EXPIRATION);
        if (drmExpirationTime.length != 2) {
            throw new IllegalStateException();
        }
        long expirationTime = Long.parseLong(drmExpirationTime[1]);
        int videoId = Integer.parseInt(identifier);
        String[] drmKey = drmExpirationTime[0].split(FIELD_KEY);
        if (drmKey.length != 2) {
            throw new IllegalStateException();
        }
        byte[] key = this.convertStringToByteArray(drmKey[1]);
        drmKeyVO.setKey(key);
        drmKeyVO.setVideoid(videoId);
        drmKeyVO.setExpirationTime(expirationTime);
        return drmKeyVO;
    }

    private boolean keyExistsForVideo(int videoId) {
        return this.sharedPreferences.contains(String.valueOf(videoId));
    }

    private byte[] convertStringToByteArray(String keyAsText) {
        String[] split = keyAsText.substring(1, keyAsText.length() - 1).split(", ");
        byte[] key = new byte[split.length];
        for (int i = 0; i < split.length; ++i) {
            key[i] = Byte.parseByte(split[i]);
        }
        return key;
    }
}

