/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.player.adPlayer.PrebidPlayer;

import android.content.Context;
import android.util.Log;
import androidx.media3.common.util.UnstableApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.prebid.mobile.AdSize;
import org.prebid.mobile.Host;
import org.prebid.mobile.InStreamVideoAdUnit;
import org.prebid.mobile.PrebidMobile;
import org.prebid.mobile.ResultCode;
import org.prebid.mobile.Signals;
import org.prebid.mobile.Util;
import org.prebid.mobile.VideoParameters;
import org.prebid.mobile.api.data.BidInfo;
import org.prebid.mobile.api.data.InitializationStatus;
import org.prebid.mobile.rendering.listeners.SdkInitializationListener;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import tv.brid.sdk.brid_network.domain.Bid;
import tv.brid.sdk.brid_network.domain.BidParams;
import tv.brid.sdk.brid_network.domain.MediaTypes;
import tv.brid.sdk.brid_network.domain.MobilePrebid;
import tv.brid.sdk.brid_network.domain.PrebidAdResponse;
import tv.brid.sdk.brid_network.domain.PrebidData;
import tv.brid.sdk.brid_network.network.PrebidAdService;
import tv.brid.sdk.player.BridStyledPlayerView;
import tv.brid.sdk.player.adPlayer.PrebidPlayer.PrebidPlayer;
import tv.brid.sdk.player.adPlayer.ima.ImaPlayer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005JB\u0010\u001d\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u001ej\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f`\u001f2\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0018\u00010!2\u0006\u0010\"\u001a\u00020\fH\u0002J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\fH\u0002J \u0010%\u001a\u0004\u0018\u00010\f2\u0014\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0018\u00010!H\u0002J \u0010'\u001a\u0004\u0018\u00010\f2\u0014\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0018\u00010!H\u0002J\b\u0010(\u001a\u00020\u001cH\u0002J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020.H\u0002J\b\u00100\u001a\u00020\u001cH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Ltv/brid/sdk/player/adPlayer/PrebidPlayer/PrebidPlayer;", "", "playerView", "Ltv/brid/sdk/player/BridStyledPlayerView;", "prebidData", "Ltv/brid/sdk/brid_network/domain/PrebidData;", "imaPlayer", "Ltv/brid/sdk/player/adPlayer/ima/ImaPlayer;", "(Ltv/brid/sdk/player/BridStyledPlayerView;Ltv/brid/sdk/brid_network/domain/PrebidData;Ltv/brid/sdk/player/adPlayer/ima/ImaPlayer;)V", "adUnit", "Lorg/prebid/mobile/InStreamVideoAdUnit;", "gamUi", "", "listener", "Lorg/prebid/mobile/rendering/listeners/SdkInitializationListener;", "prebidAdService", "Ltv/brid/sdk/brid_network/network/PrebidAdService;", "getPrebidAdService", "()Ltv/brid/sdk/brid_network/network/PrebidAdService;", "prebidAdService$delegate", "Lkotlin/Lazy;", "useGam", "", "configureVideoParameters", "Lorg/prebid/mobile/VideoParameters;", "mediaTypes", "Ltv/brid/sdk/brid_network/domain/MediaTypes;", "createVideoAd", "", "extractAndMapValues", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "inputMap", "", "selectedType", "fetchAdFromServer", "adUrl", "getHighestBidder", "keywords", "getWinningCacheId", "onPrebidError", "playPrebidAd", "prebidAdResponse", "Ltv/brid/sdk/brid_network/domain/PrebidAdResponse;", "prepareAdVideo", "bidInfo", "Lorg/prebid/mobile/api/data/BidInfo;", "prepareAdVideoForGam", "setupPrebid", "bridsdk_release"})
@UnstableApi
@SourceDebugExtension(value={"SMAP\nPrebidPlayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrebidPlayer.kt\ntv/brid/sdk/player/adPlayer/PrebidPlayer/PrebidPlayer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,312:1\n1#2:313\n1#2:324\n1#2:337\n1603#3,9:314\n1855#3:323\n1856#3:325\n1612#3:326\n1603#3,9:327\n1855#3:336\n1856#3:338\n1612#3:339\n766#3:340\n857#3,2:341\n1963#3,14:343\n766#3:357\n857#3,2:358\n1963#3,14:360\n*S KotlinDebug\n*F\n+ 1 PrebidPlayer.kt\ntv/brid/sdk/player/adPlayer/PrebidPlayer/PrebidPlayer\n*L\n179#1:324\n202#1:337\n179#1:314,9\n179#1:323\n179#1:325\n179#1:326\n202#1:327,9\n202#1:336\n202#1:338\n202#1:339\n219#1:340\n219#1:341,2\n220#1:343,14\n231#1:357\n231#1:358,2\n232#1:360,14\n*E\n"})
public final class PrebidPlayer {
    @NotNull
    private final BridStyledPlayerView playerView;
    @Nullable
    private final PrebidData prebidData;
    @NotNull
    private final ImaPlayer imaPlayer;
    @NotNull
    private String gamUi;
    private InStreamVideoAdUnit adUnit;
    @Nullable
    private SdkInitializationListener listener;
    private int useGam;
    @NotNull
    private final Lazy prebidAdService$delegate;

    public PrebidPlayer(@NotNull BridStyledPlayerView playerView, @Nullable PrebidData prebidData, @NotNull ImaPlayer imaPlayer) {
        Intrinsics.checkNotNullParameter((Object)((Object)playerView), (String)"playerView");
        Intrinsics.checkNotNullParameter((Object)imaPlayer, (String)"imaPlayer");
        this.playerView = playerView;
        this.prebidData = prebidData;
        this.imaPlayer = imaPlayer;
        this.gamUi = "";
        this.useGam = -1;
        this.setupPrebid();
        this.prebidAdService$delegate = LazyKt.lazy((Function0)prebidAdService.2.INSTANCE);
    }

    private final void setupPrebid() {
        this.listener = arg_0 -> PrebidPlayer.setupPrebid$lambda$0(this, arg_0);
        PrebidMobile.setLogLevel((PrebidMobile.LogLevel)PrebidMobile.LogLevel.DEBUG);
        PrebidMobile.setPrebidServerAccountId((String)"999");
        PrebidMobile.setPrebidServerHost((Host)Host.createCustomHost((String)"https://pbs.prebrid.tv/openrtb2/auction"));
        PrebidMobile.setIncludeBidderKeysFlag((boolean)true);
        PrebidMobile.setIncludeWinnersFlag((boolean)true);
        if (!PrebidMobile.isSdkInitialized()) {
            PrebidMobile.initializeSdk((Context)this.playerView.getContext(), (SdkInitializationListener)this.listener);
        } else {
            this.createVideoAd(this.prebidData);
        }
    }

    public final void createVideoAd(@Nullable PrebidData prebidData) {
        Object object;
        Object v2;
        block5: {
            PrebidData prebidData2 = prebidData;
            MobilePrebid mobilePrebid = prebidData2 != null ? prebidData2.getMobile() : null;
            Intrinsics.checkNotNull((Object)mobilePrebid);
            Iterable iterable = mobilePrebid.getBids();
            for (Object t : iterable) {
                Bid it = (Bid)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getBidder(), (Object)"targetvideo") || Intrinsics.areEqual((Object)it.getBidder(), (Object)"brid"))) continue;
                v2 = t;
                break block5;
            }
            v2 = null;
        }
        String configId = (object = (Bid)v2) != null && (object = ((Bid)object).getParams()) != null ? ((BidParams)object).getPlacementId() : null;
        PrebidData prebidData3 = prebidData;
        Intrinsics.checkNotNull((Object)prebidData3);
        this.useGam = prebidData3.getMediationLayer();
        MobilePrebid mobilePrebid = prebidData.getMobile();
        Intrinsics.checkNotNull((Object)mobilePrebid);
        this.gamUi = mobilePrebid.getIu();
        if (configId != null) {
            this.adUnit = new InStreamVideoAdUnit(configId, 640, 480);
            InStreamVideoAdUnit inStreamVideoAdUnit = this.adUnit;
            if (inStreamVideoAdUnit == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adUnit");
                inStreamVideoAdUnit = null;
            }
            MobilePrebid mobilePrebid2 = prebidData.getMobile();
            Intrinsics.checkNotNull((Object)mobilePrebid2);
            inStreamVideoAdUnit.setVideoParameters(this.configureVideoParameters(mobilePrebid2.getMediaTypes()));
            InStreamVideoAdUnit inStreamVideoAdUnit2 = this.adUnit;
            if (inStreamVideoAdUnit2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adUnit");
                inStreamVideoAdUnit2 = null;
            }
            inStreamVideoAdUnit2.fetchDemand(arg_0 -> PrebidPlayer.createVideoAd$lambda$2(this, arg_0));
        } else {
            this.onPrebidError();
        }
    }

    private final void prepareAdVideo(BidInfo bidInfo) {
        String hbCacheId = this.getWinningCacheId(bidInfo.getTargetingKeywords());
        String adUrl = "https://pbc.prebrid.tv/cache?uuid=" + hbCacheId;
        this.fetchAdFromServer(adUrl);
    }

    private final void prepareAdVideoForGam(BidInfo bidInfo) {
        HashSet<AdSize> sizes = new HashSet<AdSize>();
        sizes.add(new AdSize(640, 480));
        Map map = bidInfo.getTargetingKeywords();
        String string2 = this.getHighestBidder(bidInfo.getTargetingKeywords());
        Intrinsics.checkNotNull((Object)string2);
        this.imaPlayer.requestImaAd(Util.generateInstreamUriForGam((String)this.gamUi, sizes, (Map)this.extractAndMapValues(map, string2)));
    }

    private final void playPrebidAd(PrebidAdResponse prebidAdResponse) {
        String adVastTag = "data:text/xml;charset=utf-8," + prebidAdResponse.getAdm();
        this.imaPlayer.setAdRequest(adVastTag);
    }

    private final void onPrebidError() {
        this.imaPlayer.onAdAfterError();
    }

    private final VideoParameters configureVideoParameters(MediaTypes mediaTypes) {
        boolean bl;
        Signals.Api it$iv$iv;
        int id2;
        boolean bl2;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        VideoParameters videoParameters;
        VideoParameters $this$configureVideoParameters_u24lambda_u245 = videoParameters = new VideoParameters(mediaTypes.getMimes());
        boolean bl3 = false;
        if (((Object)mediaTypes.getPlacement()).equals("instream")) {
            $this$configureVideoParameters_u24lambda_u245.setPlacement(Signals.Placement.InStream);
        }
        Iterable iterable = mediaTypes.getApi();
        VideoParameters videoParameters2 = $this$configureVideoParameters_u24lambda_u245;
        boolean $i$f$mapNotNull = false;
        void var8_8 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Signals.Api api;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            id2 = ((Number)element$iv$iv).intValue();
            boolean bl4 = false;
            switch (id2) {
                case 1: {
                    api = Signals.Api.VPAID_1;
                    break;
                }
                case 2: {
                    api = Signals.Api.VPAID_2;
                    break;
                }
                case 3: {
                    api = Signals.Api.MRAID_1;
                    break;
                }
                case 4: {
                    api = Signals.Api.ORMMA;
                    break;
                }
                case 5: {
                    api = Signals.Api.MRAID_2;
                    break;
                }
                case 6: {
                    api = Signals.Api.MRAID_3;
                    break;
                }
                default: {
                    api = null;
                }
            }
            if (api == null) continue;
            it$iv$iv = api;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        videoParameters2.setApi((List)destination$iv$iv);
        $this$configureVideoParameters_u24lambda_u245.setMaxBitrate(Integer.valueOf(1500));
        $this$configureVideoParameters_u24lambda_u245.setMinBitrate(Integer.valueOf(300));
        $this$configureVideoParameters_u24lambda_u245.setMaxDuration(Integer.valueOf(mediaTypes.getMaxduration()));
        $this$configureVideoParameters_u24lambda_u245.setMinDuration(Integer.valueOf(mediaTypes.getMinduration()));
        $this$configureVideoParameters_u24lambda_u245.setStartDelay(new Signals.StartDelay(mediaTypes.getStartdelay()));
        $this$configureVideoParameters_u24lambda_u245.setPlacement(new Signals.Placement(mediaTypes.getPlacement()));
        $this$configureVideoParameters_u24lambda_u245.setPlaybackMethod(CollectionsKt.listOf((Object)new Signals.PlaybackMethod(((Number)mediaTypes.getPlaybackMethod().get(0)).intValue())));
        $this$configureVideoParameters_u24lambda_u245.setPlaybackMethod(CollectionsKt.listOf((Object)Signals.PlaybackMethod.AutoPlaySoundOn));
        $this$mapNotNull$iv = mediaTypes.getProtocols();
        videoParameters2 = $this$configureVideoParameters_u24lambda_u245;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Signals.Protocols protocols;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            id2 = ((Number)element$iv$iv).intValue();
            boolean bl5 = false;
            switch (id2) {
                case 1: {
                    protocols = Signals.Protocols.VAST_1_0;
                    break;
                }
                case 2: {
                    protocols = Signals.Protocols.VAST_2_0;
                    break;
                }
                case 3: {
                    protocols = Signals.Protocols.VAST_3_0;
                    break;
                }
                case 4: {
                    protocols = Signals.Protocols.VAST_1_0_Wrapper;
                    break;
                }
                case 6: {
                    protocols = Signals.Protocols.VAST_2_0_Wrapper;
                    break;
                }
                case 7: {
                    protocols = Signals.Protocols.VAST_3_0_Wrapper;
                    break;
                }
                case 8: {
                    protocols = Signals.Protocols.VAST_4_0_Wrapper;
                    break;
                }
                default: {
                    protocols = null;
                }
            }
            if (protocols == null) continue;
            it$iv$iv = protocols;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        videoParameters2.setProtocols((List)destination$iv$iv);
        return videoParameters;
    }

    /*
     * WARNING - void declaration
     */
    private final String getWinningCacheId(Map<String, String> keywords) {
        String string2;
        String highestBidder;
        Object v1;
        String $this$maxByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Map<String, String> map = keywords;
        Intrinsics.checkNotNull(map);
        Iterable iterable = map.entrySet();
        boolean $i$f$filter = false;
        void var6_4 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)((String)it.getKey()), (String)"hb_pb", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = maxElem$iv;
            } else {
                Map.Entry it = (Map.Entry)maxElem$iv;
                boolean bl = false;
                Double d = StringsKt.toDoubleOrNull((String)((String)it.getValue()));
                double maxValue$iv = d != null ? d : 0.0;
                do {
                    double v$iv;
                    Object e$iv = iterator$iv.next();
                    Map.Entry it2 = (Map.Entry)e$iv;
                    $i$a$-maxByOrNull-PrebidPlayer$getWinningCacheId$highestBidder$2 = false;
                    Double d2 = StringsKt.toDoubleOrNull((String)((String)it2.getValue()));
                    double d3 = v$iv = d2 != null ? d2 : 0.0;
                    if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = maxElem$iv;
            }
        }
        Map.Entry entry = v1;
        String string3 = highestBidder = entry != null && ($this$maxByOrNull$iv = (String)entry.getKey()) != null ? StringsKt.replace$default((String)$this$maxByOrNull$iv, (String)"hb_pb_", (String)"", (boolean)false, (int)4, null) : null;
        if (string3 != null) {
            String bidder = string3;
            boolean bl = false;
            string2 = keywords.get("hb_cache_id_" + bidder);
        } else {
            string2 = null;
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final String getHighestBidder(Map<String, String> keywords) {
        Object v1;
        void $this$maxByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Map<String, String> map = keywords;
        Intrinsics.checkNotNull(map);
        Object object = map.entrySet();
        boolean $i$f$filter = false;
        void var6_4 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)((String)it.getKey()), (String)"hb_pb", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = maxElem$iv;
            } else {
                Map.Entry it = (Map.Entry)maxElem$iv;
                boolean bl = false;
                Double d = StringsKt.toDoubleOrNull((String)((String)it.getValue()));
                double maxValue$iv = d != null ? d : 0.0;
                do {
                    double v$iv;
                    Object e$iv = iterator$iv.next();
                    Map.Entry it2 = (Map.Entry)e$iv;
                    $i$a$-maxByOrNull-PrebidPlayer$getHighestBidder$highestBidder$2 = false;
                    Double d2 = StringsKt.toDoubleOrNull((String)((String)it2.getValue()));
                    double d3 = v$iv = d2 != null ? d2 : 0.0;
                    if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = maxElem$iv;
            }
        }
        Map.Entry entry = v1;
        String highestBidder = entry != null && (object = (String)entry.getKey()) != null ? StringsKt.replace$default((String)object, (String)"hb_pb_", (String)"", (boolean)false, (int)4, null) : null;
        return highestBidder;
    }

    private final PrebidAdService getPrebidAdService() {
        Lazy lazy = this.prebidAdService$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-prebidAdService>(...)");
        return (PrebidAdService)object;
    }

    private final void fetchAdFromServer(String adUrl) {
        Call<PrebidAdResponse> call2 = this.getPrebidAdService().fetchAd(adUrl);
        call2.enqueue((Callback)new Callback<PrebidAdResponse>(this){
            final /* synthetic */ PrebidPlayer this$0;
            {
                this.this$0 = $receiver;
            }

            public void onResponse(@NotNull Call<PrebidAdResponse> call2, @NotNull Response<PrebidAdResponse> response) {
                Intrinsics.checkNotNullParameter(call2, (String)"call");
                Intrinsics.checkNotNullParameter(response, (String)"response");
                if (response.isSuccessful()) {
                    PrebidAdResponse prebidAdResponse = (PrebidAdResponse)response.body();
                    if (prebidAdResponse != null) {
                        PrebidAdResponse prebidAdResponse2 = prebidAdResponse;
                        PrebidPlayer prebidPlayer = this.this$0;
                        PrebidAdResponse it = prebidAdResponse2;
                        boolean bl = false;
                        PrebidPlayer.access$playPrebidAd(prebidPlayer, it);
                    }
                } else {
                    Log.e((String)"ContentValues", (String)("Server error: " + response.code()));
                    PrebidPlayer.access$onPrebidError(this.this$0);
                }
            }

            public void onFailure(@NotNull Call<PrebidAdResponse> call2, @NotNull Throwable t) {
                Intrinsics.checkNotNullParameter(call2, (String)"call");
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                Log.e((String)"ContentValues", (String)("Error fetching ad: " + t.getMessage()));
                PrebidPlayer.access$onPrebidError(this.this$0);
            }
        });
    }

    private final HashMap<String, String> extractAndMapValues(Map<String, String> inputMap, String selectedType) {
        Object[] objectArray = new String[]{"hb_size", "hb_uuid", "hb_bidder", "hb_format", "hb_env", "hb_deal", "hb_cache_id", "hb_pb"};
        List keys = CollectionsKt.listOf((Object[])objectArray);
        HashMap<String, String> outputMap = new HashMap<String, String>();
        for (String key : keys) {
            String value;
            if (Intrinsics.areEqual((Object)key, (Object)"hb_bidder")) {
                ((Map)outputMap).put(key, "targetvideo");
                continue;
            }
            String fullKey = key + "_" + selectedType;
            Map<String, String> map = inputMap;
            String string2 = value = map != null ? map.get(fullKey) : null;
            if (value != null) {
                ((Map)outputMap).put(key, value);
                continue;
            }
            ((Map)outputMap).put(key, "N/A");
        }
        return outputMap;
    }

    private static final void setupPrebid$lambda$0(PrebidPlayer this$0, InitializationStatus status) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        if (status == InitializationStatus.SUCCEEDED) {
            Log.d((String)"ContentValues", (String)"SDK initialized successfully!");
            this$0.createVideoAd(this$0.prebidData);
        } else if (status == InitializationStatus.SERVER_STATUS_WARNING) {
            Log.e((String)"ContentValues", (String)("Prebid Server status checking failed: " + status + "\n" + status.getDescription()));
        } else {
            Log.e((String)"ContentValues", (String)("SDK initialization error: " + status + "\n" + status.getDescription()));
        }
    }

    private static final void createVideoAd$lambda$2(PrebidPlayer this$0, BidInfo bidInfo) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)bidInfo, (String)"bidInfo");
        switch (WhenMappings.$EnumSwitchMapping$0[bidInfo.getResultCode().ordinal()]) {
            case 1: {
                Map map = bidInfo.getTargetingKeywords();
                Intrinsics.checkNotNull((Object)map);
                if (map.size() > 0) {
                    if (this$0.useGam == 0) {
                        this$0.prepareAdVideo(bidInfo);
                        break;
                    }
                    if (this$0.useGam == 1) {
                        this$0.prepareAdVideoForGam(bidInfo);
                        break;
                    }
                    this$0.onPrebidError();
                    break;
                }
                this$0.onPrebidError();
                break;
            }
            case 2: {
                Log.e((String)"PREBID", (String)("There is no available bids: " + bidInfo.getResultCode()));
                this$0.onPrebidError();
                break;
            }
            case 3: {
                Log.e((String)"PREBID", (String)("Request timeout: " + bidInfo.getResultCode()));
                this$0.onPrebidError();
                break;
            }
            case 4: {
                Log.e((String)"PREBID", (String)("Invalid size: " + bidInfo.getResultCode()));
                this$0.onPrebidError();
                break;
            }
            case 5: {
                Log.e((String)"PREBID", (String)("Invalid config ID: " + bidInfo.getResultCode()));
                this$0.onPrebidError();
                break;
            }
            case 6: {
                Log.e((String)"PREBID", (String)("Invalid account ID: " + bidInfo.getResultCode()));
                this$0.onPrebidError();
                break;
            }
            case 7: {
                Log.e((String)"PREBID", (String)("Invalid AD object: " + bidInfo.getResultCode()));
                this$0.onPrebidError();
                break;
            }
            default: {
                Log.e((String)"PREBID", (String)("Error Prebid Server ->  " + bidInfo.getResultCode()));
                this$0.onPrebidError();
            }
        }
    }

    public static final /* synthetic */ void access$onPrebidError(PrebidPlayer $this) {
        $this.onPrebidError();
    }

    public static final /* synthetic */ void access$playPrebidAd(PrebidPlayer $this, PrebidAdResponse prebidAdResponse) {
        $this.playPrebidAd(prebidAdResponse);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResultCode.values().length];
            try {
                nArray[ResultCode.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResultCode.NO_BIDS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResultCode.TIMEOUT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResultCode.INVALID_SIZE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResultCode.INVALID_CONFIG_ID.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResultCode.INVALID_ACCOUNT_ID.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResultCode.INVALID_AD_OBJECT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

