/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.hls;

import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.OptIn;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.ui.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.brid.sdk.R;
import tv.brid.sdk.api.BridPlayer;
import tv.brid.sdk.hls.SeekSupport;
import tv.brid.sdk.hls.State;
import tv.brid.sdk.player.ui.BridPreviewTimeBar;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001f\u001a\u00020 H\u0017J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020\"H\u0016J\u0010\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\u0012H\u0016J\u0017\u0010'\u001a\u00020 2\b\u0010&\u001a\u0004\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020 H\u0017J\u0010\u0010*\u001a\u00020 2\u0006\u0010$\u001a\u00020\"H\u0016J\u0006\u0010+\u001a\u00020 J\u000e\u0010,\u001a\u00020 2\u0006\u0010-\u001a\u00020\"J\u000e\u0010.\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020/J\u0006\u00100\u001a\u00020 R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00061"}, d2={"Ltv/brid/sdk/hls/WithSeekSupport;", "Ltv/brid/sdk/hls/SeekSupport;", "player", "Ltv/brid/sdk/api/BridPlayer;", "(Ltv/brid/sdk/api/BridPlayer;)V", "btnLiveStream", "Landroid/widget/FrameLayout;", "getBtnLiveStream", "()Landroid/widget/FrameLayout;", "setBtnLiveStream", "(Landroid/widget/FrameLayout;)V", "colorAnimator", "Landroid/animation/ValueAnimator;", "getColorAnimator", "()Landroid/animation/ValueAnimator;", "setColorAnimator", "(Landroid/animation/ValueAnimator;)V", "currentPosition", "", "getCurrentPosition", "()J", "setCurrentPosition", "(J)V", "currentState", "Ltv/brid/sdk/hls/State;", "getCurrentState", "()Ltv/brid/sdk/hls/State;", "setCurrentState", "(Ltv/brid/sdk/hls/State;)V", "getPlayer", "()Ltv/brid/sdk/api/BridPlayer;", "adjustUI", "", "isLive", "", "onPlayPauseStatusChange", "isEnabled", "onSeek", "pos", "onTimeline", "(Ljava/lang/Long;)V", "removeAdjustUI", "removeTvLiveIcon", "setLiveStreamButtonDisabled", "setLiveStreamButtonEnabled", "isAlreadyPlaying", "startBlinkingButton", "Landroid/view/View;", "stopBlinkingButton", "bridsdk_release"})
public final class WithSeekSupport
implements SeekSupport {
    @NotNull
    private final BridPlayer player;
    public FrameLayout btnLiveStream;
    @NotNull
    private State currentState;
    private long currentPosition;
    @Nullable
    private ValueAnimator colorAnimator;

    public WithSeekSupport(@NotNull BridPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.player = player;
        this.currentState = State.LIVE;
        this.currentPosition = this.player.getCurrentPosition();
        this.adjustUI();
    }

    @NotNull
    public final BridPlayer getPlayer() {
        return this.player;
    }

    @NotNull
    public final FrameLayout getBtnLiveStream() {
        FrameLayout frameLayout = this.btnLiveStream;
        if (frameLayout != null) {
            return frameLayout;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"btnLiveStream");
        return null;
    }

    public final void setBtnLiveStream(@NotNull FrameLayout frameLayout) {
        Intrinsics.checkNotNullParameter((Object)frameLayout, (String)"<set-?>");
        this.btnLiveStream = frameLayout;
    }

    @NotNull
    public final State getCurrentState() {
        return this.currentState;
    }

    public final void setCurrentState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"<set-?>");
        this.currentState = state;
    }

    public final long getCurrentPosition() {
        return this.currentPosition;
    }

    public final void setCurrentPosition(long l) {
        this.currentPosition = l;
    }

    @Nullable
    public final ValueAnimator getColorAnimator() {
        return this.colorAnimator;
    }

    public final void setColorAnimator(@Nullable ValueAnimator valueAnimator) {
        this.colorAnimator = valueAnimator;
    }

    @Override
    @OptIn(markerClass={UnstableApi.class})
    public void adjustUI() {
        LinearLayout exoTimeViewGroup = (LinearLayout)this.player.getPlayerView(true).findViewById(R.id.exo_time);
        BridPreviewTimeBar progressBar = (BridPreviewTimeBar)this.player.getPlayerView(true).findViewById(R.id.exo_progress);
        View view = exoTimeViewGroup.findViewById(R.id.liveStreamFrame);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"exoTimeViewGroup.findVie\u2026ut>(R.id.liveStreamFrame)");
        this.setBtnLiveStream((FrameLayout)view);
        this.getBtnLiveStream().setVisibility(0);
        this.getBtnLiveStream().setOnClickListener(arg_0 -> WithSeekSupport.adjustUI$lambda$0(this, arg_0));
        int i = 0;
        int n = exoTimeViewGroup.getChildCount();
        if (i <= n) {
            while (true) {
                if (exoTimeViewGroup.getChildAt(i) instanceof TextView) {
                    exoTimeViewGroup.getChildAt(i).setVisibility(8);
                }
                if (i == n) break;
                ++i;
            }
        }
        progressBar.setVisibility(0);
    }

    private final boolean isLive(long currentPosition) {
        return currentPosition == this.player.getDuration();
    }

    public final void setLiveStreamButtonEnabled(boolean isAlreadyPlaying) {
        PorterDuffColorFilter greyFilter = new PorterDuffColorFilter(-1, PorterDuff.Mode.MULTIPLY);
        this.getBtnLiveStream().getBackground().setColorFilter((ColorFilter)greyFilter);
        View dot = this.getBtnLiveStream().findViewById(R.id.ls_dot);
        dot.setBackgroundResource(R.drawable.circle);
        TextView lbl = (TextView)this.getBtnLiveStream().findViewById(R.id.ls_lbl);
        lbl.setTextColor(-1);
        lbl.setText((CharSequence)"Live");
        this.currentState = State.NOT_LIVE;
        this.player.seekToPosition(this.currentPosition);
        this.stopBlinkingButton();
        if (isAlreadyPlaying) {
            this.player.play();
        }
    }

    public final void setLiveStreamButtonDisabled() {
        PorterDuffColorFilter greyFilter = new PorterDuffColorFilter(-7829368, PorterDuff.Mode.MULTIPLY);
        this.getBtnLiveStream().getBackground().setColorFilter((ColorFilter)greyFilter);
        View dot = this.getBtnLiveStream().findViewById(R.id.ls_dot);
        dot.setBackgroundResource(R.drawable.circle_gray);
        TextView lbl = (TextView)this.getBtnLiveStream().findViewById(R.id.ls_lbl);
        lbl.setTextColor(-8947849);
        lbl.setText((CharSequence)"Back to Live");
        this.startBlinkingButton((View)this.getBtnLiveStream());
        this.currentState = State.LIVE;
    }

    public final void stopBlinkingButton() {
        ValueAnimator valueAnimator = this.colorAnimator;
        if (valueAnimator != null) {
            valueAnimator.cancel();
        }
        this.colorAnimator = null;
    }

    /*
     * WARNING - void declaration
     */
    public final void startBlinkingButton(@NotNull View btnLiveStream) {
        block1: {
            void $this$startBlinkingButton_u24lambda_u241;
            Intrinsics.checkNotNullParameter((Object)btnLiveStream, (String)"btnLiveStream");
            Object[] objectArray = new Object[]{-65536, -7829368};
            Object[] objectArray2 = objectArray = ValueAnimator.ofObject((TypeEvaluator)((TypeEvaluator)new ArgbEvaluator()), (Object[])objectArray);
            WithSeekSupport withSeekSupport = this;
            boolean bl = false;
            $this$startBlinkingButton_u24lambda_u241.setDuration(1000L);
            $this$startBlinkingButton_u24lambda_u241.setRepeatMode(2);
            $this$startBlinkingButton_u24lambda_u241.setRepeatCount(-1);
            withSeekSupport.colorAnimator = objectArray;
            ValueAnimator valueAnimator = this.colorAnimator;
            if (valueAnimator != null) {
                valueAnimator.addUpdateListener(arg_0 -> WithSeekSupport.startBlinkingButton$lambda$2(btnLiveStream, arg_0));
            }
            ValueAnimator valueAnimator2 = this.colorAnimator;
            if (valueAnimator2 == null) break block1;
            valueAnimator2.start();
        }
    }

    @Override
    public void onSeek(long pos) {
        if (pos > this.currentPosition) {
            this.setLiveStreamButtonDisabled();
        } else {
            this.setLiveStreamButtonEnabled(true);
        }
    }

    @Override
    public void onTimeline(@Nullable Long pos) {
    }

    @Override
    public void onPlayPauseStatusChange(boolean isEnabled) {
        if (isEnabled) {
            this.setLiveStreamButtonEnabled(false);
        } else {
            this.setLiveStreamButtonDisabled();
        }
    }

    @Override
    @OptIn(markerClass={UnstableApi.class})
    public void removeAdjustUI() {
        LinearLayout exoTimeView = (LinearLayout)this.player.getPlayerView(true).findViewById(R.id.exo_time);
        BridPreviewTimeBar progressBar = (BridPreviewTimeBar)this.player.getPlayerView(true).findViewById(R.id.exo_progress);
        LinearLayout exoTimeViewGroup = exoTimeView;
        View view = exoTimeViewGroup.findViewById(R.id.liveStreamFrame);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"exoTimeViewGroup.findVie\u2026ut>(R.id.liveStreamFrame)");
        this.setBtnLiveStream((FrameLayout)view);
        this.getBtnLiveStream().setVisibility(8);
        exoTimeView.setVisibility(0);
        progressBar.setVisibility(0);
        int i = 0;
        int n = exoTimeViewGroup.getChildCount();
        if (i <= n) {
            while (true) {
                if (exoTimeViewGroup.getChildAt(i) instanceof TextView) {
                    exoTimeViewGroup.getChildAt(i).setVisibility(0);
                }
                if (i == n) break;
                ++i;
            }
        }
    }

    @Override
    public void removeTvLiveIcon(boolean isEnabled) {
    }

    private static final void adjustUI$lambda$0(WithSeekSupport this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.setLiveStreamButtonEnabled(false);
    }

    private static final void startBlinkingButton$lambda$2(View $btnLiveStream, ValueAnimator animator) {
        Intrinsics.checkNotNullParameter((Object)$btnLiveStream, (String)"$btnLiveStream");
        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
        Object object = animator.getAnimatedValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        int animatedValue = (Integer)object;
        PorterDuffColorFilter colorFilter = new PorterDuffColorFilter(animatedValue, PorterDuff.Mode.MULTIPLY);
        View dot = $btnLiveStream.findViewById(R.id.ls_dot);
        dot.setBackgroundResource(R.drawable.circle_gray);
        dot.getBackground().setColorFilter((ColorFilter)colorFilter);
    }
}

