/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.hls;

import android.content.Context;
import androidx.media3.common.Timeline;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tv.brid.sdk.api.BridPlayer;
import tv.brid.sdk.hls.SeekSupport;
import tv.brid.sdk.hls.VideoSupport;
import tv.brid.sdk.hls.WithSeekSupport;
import tv.brid.sdk.hls.WithSeekSupportTv;
import tv.brid.sdk.hls.WithoutSeekSupport;
import tv.brid.sdk.hls.WithoutSeekSupportTv;
import tv.brid.sdk.player.ui.UtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u0006\u0010\u0016\u001a\u00020\u0014J\u0006\u0010\u0017\u001a\u00020\u0014J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0006H\u0016J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001aH\u0016J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0014H\u0016J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0006H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Ltv/brid/sdk/hls/HlsSupport;", "Ltv/brid/sdk/hls/VideoSupport;", "player", "Ltv/brid/sdk/api/BridPlayer;", "(Ltv/brid/sdk/api/BridPlayer;)V", "haveSupport", "", "getHaveSupport", "()Z", "setHaveSupport", "(Z)V", "getPlayer", "()Ltv/brid/sdk/api/BridPlayer;", "seekSupport", "Ltv/brid/sdk/hls/SeekSupport;", "getSeekSupport", "()Ltv/brid/sdk/hls/SeekSupport;", "setSeekSupport", "(Ltv/brid/sdk/hls/SeekSupport;)V", "adjustUI", "", "continueSeek", "goAtStart", "goLive", "isLive", "currentPosition", "", "manipulateLiveButton", "isEnabled", "onSeekProcessed", "seek", "onTimelineChanged", "timeline", "Landroidx/media3/common/Timeline;", "removeAdjustUI", "turnOffLiveIcon", "bridsdk_release"})
public final class HlsSupport
implements VideoSupport {
    @NotNull
    private final BridPlayer player;
    @NotNull
    private SeekSupport seekSupport;
    private boolean haveSupport;

    public HlsSupport(@NotNull BridPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.player = player;
        Context context = this.player.getPlayerView(true).getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"player.getPlayerView(true).context");
        if (!UtilsKt.isSDKRunningOnTvDevice(context)) {
            if (this.player.getDuration() < 60000L) {
                this.haveSupport = false;
                this.seekSupport = new WithoutSeekSupport(this.player);
            } else {
                this.haveSupport = true;
                this.seekSupport = new WithSeekSupport(this.player);
            }
        } else if (this.player.getDuration() < 60000L) {
            this.haveSupport = false;
            this.seekSupport = new WithoutSeekSupportTv(this.player);
        } else {
            this.haveSupport = true;
            this.seekSupport = new WithSeekSupportTv(this.player);
        }
    }

    @NotNull
    public final BridPlayer getPlayer() {
        return this.player;
    }

    @NotNull
    public final SeekSupport getSeekSupport() {
        return this.seekSupport;
    }

    public final void setSeekSupport(@NotNull SeekSupport seekSupport) {
        Intrinsics.checkNotNullParameter((Object)seekSupport, (String)"<set-?>");
        this.seekSupport = seekSupport;
    }

    public final boolean getHaveSupport() {
        return this.haveSupport;
    }

    public final void setHaveSupport(boolean bl) {
        this.haveSupport = bl;
    }

    private final boolean isLive(long currentPosition) {
        return currentPosition == this.player.getDuration();
    }

    @Override
    public void adjustUI() {
        this.seekSupport.adjustUI();
    }

    @Override
    public void continueSeek() {
    }

    @Override
    public void removeAdjustUI() {
        this.seekSupport.removeAdjustUI();
    }

    @Override
    public void manipulateLiveButton(boolean isEnabled) {
        this.seekSupport.onPlayPauseStatusChange(isEnabled);
    }

    @Override
    public void turnOffLiveIcon(boolean isEnabled) {
        if (this.seekSupport instanceof WithoutSeekSupportTv || this.seekSupport instanceof WithSeekSupportTv) {
            this.seekSupport.removeTvLiveIcon(isEnabled);
        }
    }

    @Override
    public void onTimelineChanged(@NotNull Timeline timeline) {
        Intrinsics.checkNotNullParameter((Object)timeline, (String)"timeline");
    }

    @Override
    public void onSeekProcessed(long seek) {
        if (!this.isLive(this.player.getCurrentPosition())) {
            this.player.seekToPosition(seek);
        }
        this.seekSupport.onSeek(seek);
    }

    public final void goAtStart() {
        this.player.onSeeked(0L);
    }

    public final void goLive() {
        this.onSeekProcessed(this.player.getDuration());
    }
}

