/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.engine;

import android.content.Context;
import androidx.annotation.OptIn;
import androidx.media3.common.util.UnstableApi;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tv.brid.domain.Player;
import tv.brid.domain.Video;
import tv.brid.sdk.AutoplayMode;
import tv.brid.sdk.Utils;
import tv.brid.sdk.api.BridPlayer;
import tv.brid.sdk.api.BridPlayerImpl;
import tv.brid.sdk.brid_network.domain.AdSlot;
import tv.brid.sdk.engine.BridPlayerEngineNewKt;
import tv.brid.sdk.engine.ControllsUiStatesManager;
import tv.brid.sdk.engine.IBridPlayerEngine;
import tv.brid.sdk.player.ui.UtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u00104\u001a\u00020+H\u0003J\u0006\u00105\u001a\u00020+J\u0006\u00106\u001a\u00020+R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\"R\u001a\u0010#\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\"\"\u0004\b$\u0010%R)\u0010&\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b(\u0012\b\b)\u0012\u0004\b\b(*\u0012\u0004\u0012\u00020+0'X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103\u00a8\u00067"}, d2={"Ltv/brid/sdk/engine/VideoLoader;", "", "video", "Ltv/brid/domain/Video;", "videoIndex", "", "playerVO", "Ltv/brid/domain/Player;", "engine", "Ltv/brid/sdk/engine/IBridPlayerEngine;", "prerolls", "", "Ltv/brid/sdk/brid_network/domain/AdSlot;", "bridPlayer", "Ltv/brid/sdk/api/BridPlayer;", "isFirstVideo", "", "controllerUiStatesManager", "Ltv/brid/sdk/engine/ControllsUiStatesManager;", "context", "Landroid/content/Context;", "autoplayMode", "Ltv/brid/sdk/AutoplayMode;", "(Ltv/brid/domain/Video;ILtv/brid/domain/Player;Ltv/brid/sdk/engine/IBridPlayerEngine;Ljava/util/List;Ltv/brid/sdk/api/BridPlayer;ZLtv/brid/sdk/engine/ControllsUiStatesManager;Landroid/content/Context;Ltv/brid/sdk/AutoplayMode;)V", "getAutoplayMode", "()Ltv/brid/sdk/AutoplayMode;", "getBridPlayer", "()Ltv/brid/sdk/api/BridPlayer;", "getContext", "()Landroid/content/Context;", "getControllerUiStatesManager", "()Ltv/brid/sdk/engine/ControllsUiStatesManager;", "getEngine", "()Ltv/brid/sdk/engine/IBridPlayerEngine;", "()Z", "isRepeating", "setRepeating", "(Z)V", "playVideoStrategy", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "player", "", "getPlayerVO", "()Ltv/brid/domain/Player;", "getPrerolls", "()Ljava/util/List;", "getVideo", "()Ltv/brid/domain/Video;", "getVideoIndex", "()I", "init", "restart", "start", "bridsdk_release"})
public final class VideoLoader {
    @NotNull
    private final Video video;
    private final int videoIndex;
    @NotNull
    private final Player playerVO;
    @NotNull
    private final IBridPlayerEngine engine;
    @NotNull
    private final List<AdSlot> prerolls;
    @NotNull
    private final BridPlayer bridPlayer;
    private final boolean isFirstVideo;
    @NotNull
    private final ControllsUiStatesManager controllerUiStatesManager;
    @NotNull
    private final Context context;
    @NotNull
    private final AutoplayMode autoplayMode;
    private boolean isRepeating;
    private Function1<? super IBridPlayerEngine, Unit> playVideoStrategy;

    public VideoLoader(@NotNull Video video, int videoIndex, @NotNull Player playerVO, @NotNull IBridPlayerEngine engine, @NotNull List<AdSlot> prerolls2, @NotNull BridPlayer bridPlayer, boolean isFirstVideo, @NotNull ControllsUiStatesManager controllerUiStatesManager, @NotNull Context context, @NotNull AutoplayMode autoplayMode) {
        Intrinsics.checkNotNullParameter((Object)video, (String)"video");
        Intrinsics.checkNotNullParameter((Object)playerVO, (String)"playerVO");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter(prerolls2, (String)"prerolls");
        Intrinsics.checkNotNullParameter((Object)bridPlayer, (String)"bridPlayer");
        Intrinsics.checkNotNullParameter((Object)controllerUiStatesManager, (String)"controllerUiStatesManager");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)autoplayMode), (String)"autoplayMode");
        this.video = video;
        this.videoIndex = videoIndex;
        this.playerVO = playerVO;
        this.engine = engine;
        this.prerolls = prerolls2;
        this.bridPlayer = bridPlayer;
        this.isFirstVideo = isFirstVideo;
        this.controllerUiStatesManager = controllerUiStatesManager;
        this.context = context;
        this.autoplayMode = autoplayMode;
        this.init();
    }

    @NotNull
    public final Video getVideo() {
        return this.video;
    }

    public final int getVideoIndex() {
        return this.videoIndex;
    }

    @NotNull
    public final Player getPlayerVO() {
        return this.playerVO;
    }

    @NotNull
    public final IBridPlayerEngine getEngine() {
        return this.engine;
    }

    @NotNull
    public final List<AdSlot> getPrerolls() {
        return this.prerolls;
    }

    @NotNull
    public final BridPlayer getBridPlayer() {
        return this.bridPlayer;
    }

    public final boolean isFirstVideo() {
        return this.isFirstVideo;
    }

    @NotNull
    public final ControllsUiStatesManager getControllerUiStatesManager() {
        return this.controllerUiStatesManager;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final AutoplayMode getAutoplayMode() {
        return this.autoplayMode;
    }

    public final boolean isRepeating() {
        return this.isRepeating;
    }

    public final void setRepeating(boolean bl) {
        this.isRepeating = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @OptIn(markerClass={UnstableApi.class})
    private final void init() {
        Utils.log(this.getClass(), "init", new String[0]);
        this.bridPlayer.prepareVideo(this.video, this.videoIndex, this.video.getDefaultVideoUrl());
        BridPlayer bridPlayer = this.bridPlayer;
        BridPlayerImpl bridPlayerImplInstance = bridPlayer instanceof BridPlayerImpl ? (BridPlayerImpl)bridPlayer : null;
        Function1 function1 = this.playVideoStrategy = Intrinsics.areEqual((Object)this.playerVO.getMonetize(), (Object)true) && Intrinsics.areEqual((Object)this.video.getMonetize(), (Object)true) ? (Function1)new Function1<IBridPlayerEngine, Unit>(this){
            final /* synthetic */ VideoLoader this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull IBridPlayerEngine it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                BridPlayerEngineNewKt.getPlayVideoWithAdsStrategy().invoke((Object)this.this$0.getEngine());
            }
        } : (Function1)new Function1<IBridPlayerEngine, Unit>(this){
            final /* synthetic */ VideoLoader this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull IBridPlayerEngine it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                BridPlayerEngineNewKt.getPlayVideoWithoutAdsStrategy().invoke((Object)this.this$0.getEngine());
            }
        };
        if (this.isFirstVideo) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.autoplayMode.ordinal()]) {
                case 1: {
                    this.start();
                    BridPlayerImpl bridPlayerImpl = bridPlayerImplInstance;
                    if (bridPlayerImpl == null) return;
                    bridPlayerImpl.sendAutoplayEvent();
                    return;
                }
                case 2: {
                    if (!((Collection)this.prerolls).isEmpty()) {
                        this.start();
                        return;
                    }
                    this.bridPlayer.showPoster();
                    return;
                }
                case 3: {
                    if (UtilsKt.isWifiConnected(this.context)) {
                        this.start();
                        BridPlayerImpl bridPlayerImpl = bridPlayerImplInstance;
                        if (bridPlayerImpl == null) return;
                        bridPlayerImpl.sendAutoplayEvent();
                        return;
                    }
                    this.bridPlayer.showPoster();
                    return;
                }
                case 4: {
                    if (UtilsKt.isWifiConnected(this.context) && !((Collection)this.prerolls).isEmpty()) {
                        this.start();
                        return;
                    }
                    this.bridPlayer.showPoster();
                    return;
                }
                case 5: {
                    this.bridPlayer.showPoster();
                    return;
                }
                default: {
                    this.bridPlayer.showPoster();
                    return;
                }
            }
        }
        if (!this.isRepeating) return;
        BridPlayer $this$init_u24lambda_u240 = this.bridPlayer;
        boolean bl = false;
        $this$init_u24lambda_u240.setStartButtonVisibility(false);
        $this$init_u24lambda_u240.setPlayButtonVisiblity(true);
        $this$init_u24lambda_u240.setNextButtonVisibility(false);
        $this$init_u24lambda_u240.setPreviousButtonVisibility(false);
        this.bridPlayer.pause();
    }

    public final void start() {
        Utils.log(this.getClass(), "start", new String[0]);
        Function1<? super IBridPlayerEngine, Unit> function1 = this.playVideoStrategy;
        if (function1 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"playVideoStrategy");
            function1 = null;
        }
        function1.invoke((Object)this.engine);
    }

    public final void restart() {
        this.isRepeating = true;
        this.init();
        this.controllerUiStatesManager.updateUI();
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AutoplayMode.values().length];
            try {
                nArray[AutoplayMode.ONLY_AUTOPLAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AutoplayMode.AUTOPLAY_IF_AD_PRESENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AutoplayMode.AUTOPLAY_ON_WIFI_ONLY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AutoplayMode.AUTOPLAY_IF_AD_AND_WIFI.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AutoplayMode.AUTOPLAY_NO_AD.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

