/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.api;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import tv.brid.domain.Player;
import tv.brid.domain.Video;
import tv.brid.sdk.R;
import tv.brid.sdk.player.ui.Image;
import tv.brid.sdk.player.ui.glide_transformation.GlideBlurTransformation;

public class BridPoster
extends FrameLayout
implements View.OnClickListener {
    private ImageView poster;
    private ImageButton playButton;
    private TextView txtTitle;
    private boolean showPlayButton;
    private BridPosterListener bridPosterListener;
    private Video video;

    public BridPoster(@NonNull Context context, String customPlayBtnUrl) {
        super(context);
        this.initAttributes(context, customPlayBtnUrl, null);
    }

    public BridPoster(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initAttributes(context, null, attrs);
    }

    public BridPoster(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttributes(context, null, attrs);
    }

    public BridPoster(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initAttributes(context, null, attrs);
    }

    private void initAttributes(Context context, String customPlayBtnUrl, AttributeSet attrs) {
        BridPoster.inflate((Context)context, (int)R.layout.brid_poster, (ViewGroup)this);
        this.playButton = (ImageButton)this.findViewById(R.id.play_button_poster);
        this.playButton.setOnClickListener((View.OnClickListener)this);
        this.poster = (ImageView)this.findViewById(R.id.exo_poster);
        this.txtTitle = (TextView)this.findViewById(R.id.exo_title);
        ((RequestBuilder)((RequestBuilder)Glide.with((View)this).load(customPlayBtnUrl).placeholder(R.drawable.exo_controls_brid_play_button_overlay)).error(R.drawable.exo_controls_brid_play_button_overlay)).into((ImageView)this.playButton);
    }

    public void setPoster(Video video, int cornerRadius) {
        this.txtTitle.setText((CharSequence)video.getName());
        ((RequestBuilder)Glide.with((View)this.poster).load(video.getThumbnail()).transform(new Transformation[]{new GlideBlurTransformation(this.getContext()), new RoundedCorners(cornerRadius < 1 ? 1 : cornerRadius)})).into(this.poster);
    }

    public void initializePoster(Player player, Video video) {
        this.video = video;
        if (this.showPlayButton) {
            this.playButton.setVisibility(0);
        } else {
            this.playButton.setVisibility(0);
        }
    }

    public void setShowPlayButton(boolean showPlayButton) {
        this.showPlayButton = showPlayButton;
    }

    public void setBridPosterListener(BridPosterListener listener) {
        this.bridPosterListener = listener;
    }

    public void loadImage(int cornerRadius, @DrawableRes int placeholderId) {
        if (cornerRadius < 1) {
            cornerRadius = 1;
        }
        this.txtTitle.setText((CharSequence)this.video.getName());
        if (this.video.getImage() != null) {
            new Image().loadImageInView(this.video.getImage(), this.poster, cornerRadius, placeholderId);
        } else if (this.video.getThumbnail() != null) {
            new Image().loadImageInView(this.video.getThumbnail(), this.poster, cornerRadius, placeholderId);
        } else if (this.video.getSnapshots() != null) {
            new Image().loadImageInView(this.video.getSnapshots().getLd(), this.poster, cornerRadius, placeholderId);
        }
    }

    public void onClick(View v) {
        if (this.bridPosterListener != null) {
            this.bridPosterListener.onBridPosterClicked(this.video);
        }
    }

    public boolean isPosterShowing() {
        return this.getVisibility() == 0;
    }

    public ImageButton getPlayButton() {
        return this.playButton;
    }

    public static interface BridPosterListener {
        public void onBridPosterClicked(Video var1);
    }
}

