/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.api;

import android.annotation.SuppressLint;
import android.content.Context;
import android.widget.FrameLayout;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.media3.common.util.UnstableApi;
import tv.brid.sdk.api.BridPlayer;
import tv.brid.sdk.api.BridPlayerImpl;
import tv.brid.sdk.player.ui.UtilsKt;

public final class BridPlayerBuilder {
    private final Context context;
    private FrameLayout frameLayout;
    private boolean fullscreen;
    private boolean useVpaidSupport;
    private boolean enableAdControls = false;
    private boolean enableAutoplay = true;
    private boolean isPlayerControlsEnabled = true;
    private boolean play;
    private boolean pause;
    private boolean mute;
    private BridPlayer player;
    private String colorHex;
    private String playerReference = null;
    private String countryCode = "en";
    private int cornerRadius = 0;
    private int seekSeconds = -1;
    private int seekPreview = 0;
    private int controllerTimeoutMs = 4000;
    private int ccBottomOfset = 0;
    @DrawableRes
    private int fullscreenIcon;
    @ColorRes
    private int playPauseIcon;
    @DrawableRes
    private int pauseIcon;
    @DrawableRes
    private int muteIcon;
    @DrawableRes
    private int unmuteIcon;
    @DrawableRes
    private int playlistIcon;
    @DrawableRes
    private int shareIcon;
    @DrawableRes
    private int settingsIcon;
    @DrawableRes
    private int forwardIcon;
    @DrawableRes
    private int exitIcon;
    @ColorRes
    private int playedColor;
    @ColorRes
    private int unplayedColor;
    @ColorRes
    private int bufferedColor;
    @ColorRes
    private int scrubberColor;
    @DrawableRes
    private int fullscreenCloseIcon;
    @DrawableRes
    public int focusDrawable;
    @DrawableRes
    public int posterPlaceholderImgRes = 0;

    public BridPlayerBuilder(Context context) {
        this.context = context;
        this.frameLayout = null;
    }

    public BridPlayerBuilder(Context context, FrameLayout frameLayout) {
        this.context = context;
        this.frameLayout = frameLayout;
    }

    public BridPlayerBuilder setPlayerHolder(FrameLayout frameLayout) {
        this.frameLayout = frameLayout;
        return this;
    }

    public BridPlayerBuilder fullscreen(boolean fullscreen) {
        this.fullscreen = fullscreen;
        return this;
    }

    public BridPlayerBuilder play(boolean play) {
        this.play = play;
        return this;
    }

    public BridPlayerBuilder pause(boolean pause) {
        this.pause = pause;
        return this;
    }

    public BridPlayerBuilder mute() {
        this.mute = true;
        return this;
    }

    public BridPlayerBuilder unmute() {
        this.mute = false;
        return this;
    }

    public BridPlayerBuilder useVpaidSupport(boolean useVpaidSupport) {
        this.useVpaidSupport = useVpaidSupport;
        return this;
    }

    public BridPlayerBuilder enableAdControls(boolean isEnabled) {
        this.enableAdControls = isEnabled;
        return this;
    }

    public BridPlayerBuilder enableAutoplay(boolean isAutoplay) {
        this.enableAutoplay = isAutoplay;
        return this;
    }

    public BridPlayerBuilder setPlayerControlsEnabled(boolean isEnabled) {
        this.isPlayerControlsEnabled = isEnabled;
        return this;
    }

    public BridPlayerBuilder setCreditsLabelColor(String color2) {
        this.colorHex = color2;
        return this;
    }

    public BridPlayerBuilder setPlayerReference(String playerReference) {
        this.playerReference = playerReference;
        return this;
    }

    public BridPlayerBuilder setPlayerSkin(@Nullable @ColorRes Integer playPauseButtonColor, @Nullable @DrawableRes Integer fullscreenIcon, @Nullable @DrawableRes Integer fullscreenCloseIcon, @Nullable @DrawableRes Integer unmuteIcon, @Nullable @DrawableRes Integer muteIcon, @Nullable @DrawableRes Integer playlistIcon, @Nullable @DrawableRes Integer exitIcon, @Nullable @DrawableRes Integer shareIcon, @Nullable @DrawableRes Integer settingsIcon) {
        if (playPauseButtonColor != null) {
            this.playPauseIcon = playPauseButtonColor;
        }
        if (fullscreenIcon != null) {
            this.fullscreenIcon = fullscreenIcon;
        }
        if (fullscreenCloseIcon != null) {
            this.fullscreenCloseIcon = fullscreenCloseIcon;
        }
        if (unmuteIcon != null) {
            this.unmuteIcon = unmuteIcon;
        }
        if (muteIcon != null) {
            this.muteIcon = muteIcon;
        }
        if (playlistIcon != null) {
            this.playlistIcon = playlistIcon;
        }
        if (exitIcon != null) {
            this.exitIcon = exitIcon;
        }
        if (shareIcon != null) {
            this.shareIcon = shareIcon;
        }
        if (settingsIcon != null) {
            this.settingsIcon = settingsIcon;
        }
        return this;
    }

    public BridPlayerBuilder setPosterPlaceholderRes(@DrawableRes Integer posterPlaceholderRes) {
        this.posterPlaceholderImgRes = posterPlaceholderRes;
        return this;
    }

    public BridPlayerBuilder setTvPlayerSkin(@Nullable @DrawableRes Integer circle_button, @Nullable @DrawableRes Integer forward) {
        if (circle_button != null) {
            this.focusDrawable = circle_button;
        }
        if (forward != null) {
            this.forwardIcon = forward;
        }
        return this;
    }

    public BridPlayerBuilder setPlayPauseButtonColor(@ColorRes int playPauseButtonCustom) {
        this.playPauseIcon = playPauseButtonCustom;
        return this;
    }

    public BridPlayerBuilder setFullscreenIcon(@DrawableRes int fullscreenIcon) {
        this.fullscreenIcon = fullscreenIcon;
        return this;
    }

    public BridPlayerBuilder setCloseFullscreenIcon(@DrawableRes int fullscreenCloseIcon) {
        this.fullscreenCloseIcon = fullscreenCloseIcon;
        return this;
    }

    public BridPlayerBuilder setUnmuteIcon(@DrawableRes int unmuteIcon) {
        this.unmuteIcon = unmuteIcon;
        return this;
    }

    public BridPlayerBuilder setMuteIcon(@DrawableRes int muteIcon) {
        this.muteIcon = muteIcon;
        return this;
    }

    public BridPlayerBuilder setPlaylistIcon(@DrawableRes int playlistIcon) {
        this.playlistIcon = playlistIcon;
        return this;
    }

    public BridPlayerBuilder setPlaylistExitIcon(@DrawableRes int exitIcon) {
        this.exitIcon = exitIcon;
        return this;
    }

    public BridPlayerBuilder setShareIcon(@DrawableRes int shareIcon) {
        this.shareIcon = shareIcon;
        return this;
    }

    public BridPlayerBuilder setSettingsIcon(@DrawableRes int settingsIcon) {
        this.settingsIcon = settingsIcon;
        return this;
    }

    public BridPlayerBuilder setTimelineColors(@ColorRes int playedColor, @ColorRes int unplayedColor, @ColorRes int bufferedColor, @ColorRes int scrubberColor) {
        this.playedColor = playedColor;
        this.unplayedColor = unplayedColor;
        this.bufferedColor = bufferedColor;
        this.scrubberColor = scrubberColor;
        return this;
    }

    public BridPlayerBuilder setTVControls(int forwardIcon) {
        this.forwardIcon = forwardIcon;
        return this;
    }

    public BridPlayerBuilder setTVFocusColor(int focusDrawable) {
        this.focusDrawable = focusDrawable;
        return this;
    }

    public BridPlayerBuilder setCornerRadius(int cornerRadius) {
        this.cornerRadius = cornerRadius;
        return this;
    }

    public BridPlayerBuilder setSeekSeconds(int seekSeconds) {
        this.seekSeconds = seekSeconds;
        return this;
    }

    public BridPlayerBuilder setPlayerLanguage(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    public BridPlayerBuilder setSeekPreviewEnabled(int type) {
        this.seekPreview = type;
        return this;
    }

    public BridPlayerBuilder setCaptionsBottomOffset(int type) {
        this.ccBottomOfset = type;
        return this;
    }

    public BridPlayerBuilder setControllerTimeoutMs(int timeoutMS) {
        this.controllerTimeoutMs = timeoutMS;
        return this;
    }

    @OptIn(markerClass={UnstableApi.class})
    public BridPlayer build() {
        if (this.frameLayout == null) {
            throw new IllegalStateException("FrameLayout for player view must be set before calling build(). Use setPlayerHolder().");
        }
        this.player = new BridPlayerImpl(this.context, this.frameLayout, this.cornerRadius);
        this.validate(this.player);
        return this.player;
    }

    public BridPlayer rebuild() {
        this.validate(this.player);
        return this.player;
    }

    @SuppressLint(value={"ResourceType"})
    private void validate(BridPlayer bridPlayer) {
        bridPlayer.setFullScreen(this.fullscreen);
        if (this.fullscreenIcon > 0) {
            bridPlayer.setFullscreenIcon(this.fullscreenIcon);
        }
        if (this.fullscreenCloseIcon > 0) {
            bridPlayer.setFullscreenCloseIcon(this.fullscreenCloseIcon);
        }
        if (this.playPauseIcon > 0) {
            bridPlayer.setPlayPauseIcon(this.playPauseIcon);
        }
        if (this.muteIcon > 0) {
            bridPlayer.setMuteIcon(this.muteIcon);
        }
        if (this.unmuteIcon > 0) {
            bridPlayer.setUnmuteIcon(this.unmuteIcon);
        }
        if (this.playlistIcon > 0) {
            bridPlayer.setPlaylistIcon(this.playlistIcon);
        }
        if (this.exitIcon > 0) {
            bridPlayer.setPlaylistCloseIcon(this.exitIcon);
        }
        if (this.shareIcon > 0) {
            bridPlayer.setShareIcon(this.shareIcon);
        }
        if (this.settingsIcon > 0) {
            bridPlayer.setSettingsIcon(this.settingsIcon);
        }
        if (this.playedColor > 0 && this.unplayedColor > 0 && this.bufferedColor > 0 && this.scrubberColor > 0) {
            bridPlayer.setTimelineColors(this.playedColor, this.unplayedColor, this.bufferedColor, this.scrubberColor);
        }
        if (UtilsKt.isSDKRunningOnTvDevice(this.context) && this.forwardIcon > 0) {
            bridPlayer.setTVControls(this.forwardIcon);
        }
        if (UtilsKt.isSDKRunningOnTvDevice(this.context) && this.focusDrawable > 0) {
            bridPlayer.setFocusDrawable(this.focusDrawable);
        }
        bridPlayer.enableAdControls(this.enableAdControls);
        bridPlayer.enableAutoplay(this.enableAutoplay);
        bridPlayer.enablePlayerControls(this.isPlayerControlsEnabled);
        bridPlayer.setCreditsLabelColor(this.colorHex);
        bridPlayer.setPlayerLanguage(this.countryCode);
        bridPlayer.setPlayerReference(this.playerReference);
        bridPlayer.setSeekSeconds(this.seekSeconds);
        bridPlayer.setSeekPreview(this.seekPreview);
        bridPlayer.setCaptionsBottomOffset(this.ccBottomOfset);
        bridPlayer.setControllerTimeoutMs(this.controllerTimeoutMs);
        bridPlayer.setPosterPlaceholderRes(this.posterPlaceholderImgRes);
    }
}

