/*
 * Decompiled with CFR 0.152.
 */
package tv.blademaker.slash.ratelimit;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tv.blademaker.slash.context.SlashCommandContext;
import tv.blademaker.slash.ratelimit.Bucket;
import tv.blademaker.slash.ratelimit.RateLimit;
import tv.blademaker.slash.ratelimit.RateLimitHandler;
import tv.blademaker.slash.ratelimit.RateLimitThreadFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0002\"#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0002\u0010\u001eJ\u0018\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010 \u001a\u00020!H\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000RF\u0010\b\u001a4\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0015\u0012\u0013\u0018\u00010\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Ltv/blademaker/slash/ratelimit/RateLimitHandler;", "", "configuration", "Ltv/blademaker/slash/ratelimit/RateLimitHandler$Configuration;", "(Ltv/blademaker/slash/ratelimit/RateLimitHandler$Configuration;)V", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "onRateLimitHit", "Lkotlin/Function2;", "Ltv/blademaker/slash/context/SlashCommandContext;", "Lkotlin/ParameterName;", "name", "ctx", "Ltv/blademaker/slash/ratelimit/RateLimit;", "rateLimit", "", "getOnRateLimitHit$Slash", "()Lkotlin/jvm/functions/Function2;", "registry", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ltv/blademaker/slash/ratelimit/Bucket;", "task", "Ljava/util/concurrent/ScheduledFuture;", "acquire", "", "annotation", "event", "Lnet/dv8tion/jda/api/events/interaction/command/SlashCommandInteractionEvent;", "(Ltv/blademaker/slash/ratelimit/RateLimit;Lnet/dv8tion/jda/api/events/interaction/command/SlashCommandInteractionEvent;)Ljava/lang/Long;", "createKey", "purgeExpired", "Ljava/lang/Runnable;", "Companion", "Configuration", "Slash"})
public final class RateLimitHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScheduledFuture<?> task;
    @NotNull
    private final ConcurrentHashMap<String, Bucket> registry;
    private final ScheduledExecutorService executor;
    @NotNull
    private final Function2<SlashCommandContext, RateLimit, Unit> onRateLimitHit;
    private static final Logger log = LoggerFactory.getLogger(RateLimitHandler.class);

    public RateLimitHandler(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.registry = new ConcurrentHashMap();
        ScheduledExecutorService scheduledExecutorService = configuration.getExecutor();
        if (scheduledExecutorService == null) {
            scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new RateLimitThreadFactory());
        }
        this.executor = scheduledExecutorService;
        log.info("Initializing RateLimitHandler...");
        ScheduledFuture<?> scheduledFuture = this.executor.scheduleAtFixedRate(this.purgeExpired(), configuration.getPurgeDelay(), configuration.getPurgeDelay(), configuration.getPurgeUnit());
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"executor.scheduleAtFixed\u2026 configuration.purgeUnit)");
        this.task = scheduledFuture;
        this.onRateLimitHit = configuration.getOnRateLimitHit();
    }

    @NotNull
    public final Function2<SlashCommandContext, RateLimit, Unit> getOnRateLimitHit$Slash() {
        return this.onRateLimitHit;
    }

    private final Runnable purgeExpired() {
        return () -> RateLimitHandler.purgeExpired$lambda-0(this);
    }

    private final String createKey(RateLimit annotation, SlashCommandInteractionEvent event) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[annotation.target().ordinal()]) {
            case 1: {
                String string2;
                Guild guild = event.getGuild();
                if (guild == null) {
                    string2 = "***";
                } else {
                    string2 = guild.getId();
                    if (string2 == null) {
                        string2 = "***";
                    }
                }
                string = "G:" + string2 + ":" + event.getCommandPath();
                break;
            }
            case 2: {
                string = "C:" + event.getChannel().getId() + ":" + event.getCommandPath();
                break;
            }
            case 3: {
                string = "U:" + event.getUser().getId() + ":" + event.getCommandPath();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Nullable
    public final Long acquire(@Nullable RateLimit annotation, @NotNull SlashCommandInteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (annotation == null) {
            return null;
        }
        String key = this.createKey(annotation, event);
        log.debug("Fetching ratelimit for key " + key);
        Bucket bucket = this.registry.get(key);
        if (bucket == null) {
            log.debug("Ratelimit for " + key + " not found, creating new one.");
            Map map = this.registry;
            Bucket bucket2 = new Bucket(annotation);
            map.put(key, bucket2);
            return null;
        }
        long now = System.currentTimeMillis();
        int remaining = bucket.getRemaining().getAndDecrement();
        long resetAfter = bucket.getResetAfter();
        if (resetAfter <= now) {
            this.registry.remove(key);
            return null;
        }
        if (remaining <= 0) {
            return resetAfter - now;
        }
        return null;
    }

    private static final void purgeExpired$lambda-0(RateLimitHandler this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.registry.isEmpty()) {
            return;
        }
        log.debug("Purging expired RateLimit Buckets...");
        int count = 0;
        long now = System.currentTimeMillis();
        for (Map.Entry bucket : ((Map)this$0.registry).entrySet()) {
            String key = (String)bucket.getKey();
            long resetAfter = ((Bucket)bucket.getValue()).getResetAfter();
            if (resetAfter >= now) continue;
            this$0.registry.remove(key);
            int n = count;
            count = n + 1;
        }
        log.debug("Purge task done with a total of " + count + " buckets expired.");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bRL\u0010\t\u001a4\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0015\u0012\u0013\u0018\u00010\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00110\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006\""}, d2={"Ltv/blademaker/slash/ratelimit/RateLimitHandler$Configuration;", "", "()V", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "getExecutor", "()Ljava/util/concurrent/ScheduledExecutorService;", "setExecutor", "(Ljava/util/concurrent/ScheduledExecutorService;)V", "onRateLimitHit", "Lkotlin/Function2;", "Ltv/blademaker/slash/context/SlashCommandContext;", "Lkotlin/ParameterName;", "name", "ctx", "Ltv/blademaker/slash/ratelimit/RateLimit;", "rateLimit", "", "getOnRateLimitHit", "()Lkotlin/jvm/functions/Function2;", "setOnRateLimitHit", "(Lkotlin/jvm/functions/Function2;)V", "purgeDelay", "", "getPurgeDelay", "()J", "setPurgeDelay", "(J)V", "purgeUnit", "Ljava/util/concurrent/TimeUnit;", "getPurgeUnit", "()Ljava/util/concurrent/TimeUnit;", "setPurgeUnit", "(Ljava/util/concurrent/TimeUnit;)V", "Slash"})
    public static final class Configuration {
        @NotNull
        private TimeUnit purgeUnit = TimeUnit.MINUTES;
        private long purgeDelay = 10L;
        @Nullable
        private ScheduledExecutorService executor;
        @NotNull
        private Function2<? super SlashCommandContext, ? super RateLimit, Unit> onRateLimitHit = onRateLimitHit.1.INSTANCE;

        @NotNull
        public final TimeUnit getPurgeUnit() {
            return this.purgeUnit;
        }

        public final void setPurgeUnit(@NotNull TimeUnit timeUnit) {
            Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"<set-?>");
            this.purgeUnit = timeUnit;
        }

        public final long getPurgeDelay() {
            return this.purgeDelay;
        }

        public final void setPurgeDelay(long l) {
            this.purgeDelay = l;
        }

        @Nullable
        public final ScheduledExecutorService getExecutor() {
            return this.executor;
        }

        public final void setExecutor(@Nullable ScheduledExecutorService scheduledExecutorService) {
            this.executor = scheduledExecutorService;
        }

        @NotNull
        public final Function2<SlashCommandContext, RateLimit, Unit> getOnRateLimitHit() {
            return this.onRateLimitHit;
        }

        public final void setOnRateLimitHit(@NotNull Function2<? super SlashCommandContext, ? super RateLimit, Unit> function2) {
            Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
            this.onRateLimitHit = function2;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ltv/blademaker/slash/ratelimit/RateLimitHandler$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Slash"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RateLimit.Target.values().length];
            nArray[RateLimit.Target.GUILD.ordinal()] = 1;
            nArray[RateLimit.Target.CHANNEL.ordinal()] = 2;
            nArray[RateLimit.Target.USER.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

