/*
 * Decompiled with CFR 0.152.
 */
package tv.blademaker.slash.exceptions;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.requests.restaction.interactions.ReplyCallbackAction;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tv.blademaker.slash.BaseSlashCommand;
import tv.blademaker.slash.PermissionTarget;
import tv.blademaker.slash.SlashUtils;
import tv.blademaker.slash.annotations.InteractionTarget;
import tv.blademaker.slash.exceptions.ExceptionHandler;
import tv.blademaker.slash.exceptions.InteractionTargetMismatch;
import tv.blademaker.slash.exceptions.PermissionsLackException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tj\u0002`\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J$\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tj\u0002`\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0013H\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ltv/blademaker/slash/exceptions/ExceptionHandlerImpl;", "Ltv/blademaker/slash/exceptions/ExceptionHandler;", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "onException", "", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "command", "Ltv/blademaker/slash/BaseSlashCommand;", "event", "Lnet/dv8tion/jda/api/events/interaction/command/CommandAutoCompleteInteractionEvent;", "Lnet/dv8tion/jda/api/events/interaction/command/SlashCommandInteractionEvent;", "onInteractionTargetMismatch", "Ltv/blademaker/slash/exceptions/InteractionTargetMismatch;", "onPermissionLackException", "Ltv/blademaker/slash/exceptions/PermissionsLackException;", "Slash"})
public final class ExceptionHandlerImpl
implements ExceptionHandler {
    private final Logger log = LoggerFactory.getLogger((String)"ExceptionHandler");

    @Override
    public void onException(@NotNull Exception ex, @NotNull BaseSlashCommand command, @NotNull SlashCommandInteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String message = "Exception executing handler for slash command `" + event.getCommandPath() + "`:\n```\n" + ex.getMessage() + "\n```";
        this.log.error(message, (Throwable)ex);
        if (event.isAcknowledged()) {
            event.getHook().sendMessage(message).setEphemeral(true).queue();
        } else {
            event.reply(message).setEphemeral(true).queue();
        }
    }

    @Override
    public void onException(@NotNull Exception ex, @NotNull BaseSlashCommand command, @NotNull CommandAutoCompleteInteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String message = "Exception executing handler for auto-complete interaction `" + event.getCommandPath() + "`:\n```\n" + ex.getMessage() + "\n```";
        this.log.error(message, (Throwable)ex);
    }

    @Override
    public void onPermissionLackException(@NotNull PermissionsLackException ex) {
        ReplyCallbackAction replyCallbackAction;
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        switch (WhenMappings.$EnumSwitchMapping$0[ex.getTarget().ordinal()]) {
            case 1: {
                String perms = SlashUtils.toHuman$default(SlashUtils.INSTANCE, ex.getPermissions(), false, 1, null);
                this.log.warn("Bot doesn't have the required permissions to execute '" + ((SlashCommandInteractionEvent)ex.getContext().getEvent()).getCommandString() + "'.");
                replyCallbackAction = ex.getContext().replyMessage("\ud83d\udeab The bot does not have the necessary permissions to carry out this action.\nRequired permissions: **" + perms + "**.");
                break;
            }
            case 2: {
                String perms = SlashUtils.toHuman$default(SlashUtils.INSTANCE, ex.getPermissions(), false, 1, null);
                this.log.warn("User " + ex.getContext().getUser() + " doesn't have the required permissions to execute '" + ((SlashCommandInteractionEvent)ex.getContext().getEvent()).getCommandString() + "'.");
                replyCallbackAction = ex.getContext().replyMessage("\ud83d\udeab You do not have the necessary permissions to carry out this action.\nRequired permissions: **" + perms + "**.");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        replyCallbackAction.setEphemeral(true).queue();
    }

    @Override
    public void onInteractionTargetMismatch(@NotNull InteractionTargetMismatch ex) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        switch (WhenMappings.$EnumSwitchMapping$1[ex.getTarget().ordinal()]) {
            case 1: {
                ex.getContext().replyMessage("This command cannot be used outside of a **space**.").queue();
                break;
            }
            case 2: {
                ex.getContext().replyMessage("This command cannot be used on a **space**.").queue();
                break;
            }
            default: {
                throw new IllegalStateException("Received InteractionTargetMismatch on a command with target InteractionTarget.ALL, report this to developer.");
            }
        }
    }

    @Override
    public void wrap(@NotNull Exception e, @NotNull BaseSlashCommand command, @NotNull SlashCommandInteractionEvent event) {
        ExceptionHandler.DefaultImpls.wrap((ExceptionHandler)this, e, command, event);
    }

    @Override
    public void wrap(@NotNull Exception e, @NotNull BaseSlashCommand command, @NotNull CommandAutoCompleteInteractionEvent event) {
        ExceptionHandler.DefaultImpls.wrap((ExceptionHandler)this, e, command, event);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PermissionTarget.values().length];
            nArray[PermissionTarget.BOT.ordinal()] = 1;
            nArray[PermissionTarget.USER.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[InteractionTarget.values().length];
            nArray[InteractionTarget.GUILD.ordinal()] = 1;
            nArray[InteractionTarget.DM.ordinal()] = 2;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

