/*
 * Decompiled with CFR 0.152.
 */
package tv.blademaker.slash.api;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.dv8tion.jda.api.events.interaction.SlashCommandEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ltv/blademaker/slash/api/Metrics;", "", "()V", "EXECUTED_COMMANDS", "Lio/prometheus/client/Counter;", "FAILED_EXECUTED_COMMANDS", "MEASURED_COMMAND_EXECUTION", "Lio/prometheus/client/Gauge;", "SUCCESSFUL_EXECUTED_COMMANDS", "incFailedCommand", "", "event", "Lnet/dv8tion/jda/api/events/interaction/SlashCommandEvent;", "incHandledCommand", "incSuccessCommand", "measuredTime", "", "register", "Slash"})
public final class Metrics {
    @NotNull
    public static final Metrics INSTANCE = new Metrics();
    @NotNull
    private static final Counter EXECUTED_COMMANDS;
    @NotNull
    private static final Counter SUCCESSFUL_EXECUTED_COMMANDS;
    @NotNull
    private static final Counter FAILED_EXECUTED_COMMANDS;
    @NotNull
    private static final Gauge MEASURED_COMMAND_EXECUTION;

    private Metrics() {
    }

    public final void register() {
        EXECUTED_COMMANDS.register();
        SUCCESSFUL_EXECUTED_COMMANDS.register();
        FAILED_EXECUTED_COMMANDS.register();
    }

    public final void incHandledCommand(@NotNull SlashCommandEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String[] stringArray = new String[]{event.getCommandPath()};
        ((Counter.Child)EXECUTED_COMMANDS.labels(stringArray)).inc();
    }

    public final void incSuccessCommand(@NotNull SlashCommandEvent event, long measuredTime) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String[] stringArray = new String[]{event.getCommandPath()};
        ((Counter.Child)SUCCESSFUL_EXECUTED_COMMANDS.labels(stringArray)).inc();
        stringArray = new String[]{event.getCommandPath()};
        ((Gauge.Child)MEASURED_COMMAND_EXECUTION.labels(stringArray)).set((double)measuredTime);
    }

    public final void incFailedCommand(@NotNull SlashCommandEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String[] stringArray = new String[]{event.getCommandPath()};
        ((Counter.Child)FAILED_EXECUTED_COMMANDS.labels(stringArray)).inc();
    }

    static {
        String[] stringArray = new String[]{"pathName"};
        Counter counter = ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("slash_command_counter")).help("Slash commands handled.")).labelNames(stringArray)).create();
        Intrinsics.checkNotNullExpressionValue((Object)counter, (String)"build()\n        .name(\"s\u2026hName\")\n        .create()");
        EXECUTED_COMMANDS = counter;
        stringArray = new String[]{"pathName"};
        counter = ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("slash_commands_success")).help("Slash commands handled that ends successfully.")).labelNames(stringArray)).create();
        Intrinsics.checkNotNullExpressionValue((Object)counter, (String)"build()\n        .name(\"s\u2026hName\")\n        .create()");
        SUCCESSFUL_EXECUTED_COMMANDS = counter;
        stringArray = new String[]{"pathName"};
        counter = ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("slash_commands_failed")).help("Slash commands handled that ends on a Exception.")).labelNames(stringArray)).create();
        Intrinsics.checkNotNullExpressionValue((Object)counter, (String)"build()\n        .name(\"s\u2026hName\")\n        .create()");
        FAILED_EXECUTED_COMMANDS = counter;
        stringArray = new String[]{"pathName"};
        counter = ((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("slash_measured_execution_time")).help("The time in milliseconds require to execute the command.")).labelNames(stringArray)).create();
        Intrinsics.checkNotNullExpressionValue((Object)counter, (String)"build()\n        .name(\"s\u2026hName\")\n        .create()");
        MEASURED_COMMAND_EXECUTION = counter;
    }
}

