/*
 * Decompiled with CFR 0.152.
 */
package tv.blademaker.slash.internal;

import io.sentry.Sentry;
import io.sentry.SentryEvent;
import io.sentry.protocol.Message;
import io.sentry.protocol.User;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.WebhookMessageAction;
import net.dv8tion.jda.api.requests.restaction.interactions.ReplyAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tv.blademaker.slash.api.BaseSlashCommand;
import tv.blademaker.slash.api.PermissionTarget;
import tv.blademaker.slash.api.SlashCommandContext;
import tv.blademaker.slash.api.annotations.Permissions;
import tv.blademaker.slash.api.exceptions.PermissionsLackException;
import tv.blademaker.slash.internal.SlashUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b\rJ\u001f\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016J\u0012\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018*\u0006\u0012\u0002\b\u00030\u0018J#\u0010\u0019\u001a\u00020\u0016*\b\u0012\u0004\u0012\u00020\u001b0\u001a2\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ltv/blademaker/slash/internal/SlashUtils;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "captureSlashCommandException", "", "ctx", "Ltv/blademaker/slash/api/SlashCommandContext;", "e", "", "logger", "captureSlashCommandException$Slash", "checkPermissions", "permissions", "Ltv/blademaker/slash/api/annotations/Permissions;", "checkPermissions$Slash", "discoverSlashCommands", "", "Ltv/blademaker/slash/api/BaseSlashCommand;", "packageName", "", "asEphemeral", "Lnet/dv8tion/jda/api/requests/RestAction;", "toHuman", "", "Lnet/dv8tion/jda/api/Permission;", "jump", "", "toHuman$Slash", "([Lnet/dv8tion/jda/api/Permission;Z)Ljava/lang/String;", "Slash"})
public final class SlashUtils {
    @NotNull
    public static final SlashUtils INSTANCE = new SlashUtils();
    private static final Logger LOGGER = LoggerFactory.getLogger(SlashUtils.class);

    private SlashUtils() {
    }

    @NotNull
    public final String toHuman$Slash(@NotNull Permission[] $this$toHuman, boolean jump) {
        Intrinsics.checkNotNullParameter((Object)$this$toHuman, (String)"<this>");
        return ArraysKt.joinToString$default((Object[])$this$toHuman, (CharSequence)(jump ? "\n" : ", "), null, null, (int)0, null, (Function1)toHuman.1.INSTANCE, (int)30, null);
    }

    public static /* synthetic */ String toHuman$Slash$default(SlashUtils slashUtils, Permission[] permissionArray, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return slashUtils.toHuman$Slash(permissionArray, bl);
    }

    public final void checkPermissions$Slash(@NotNull SlashCommandContext ctx, @Nullable Permissions permissions) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (permissions == null || permissions.bot().length == 0 && permissions.user().length == 0) {
            return;
        }
        Member member = ctx.getMember();
        boolean guildPerms = member.hasPermission((Collection)ArraysKt.toList((Object[])permissions.user()));
        boolean channelPerms = member.hasPermission((GuildChannel)ctx.getChannel(), (Collection)ArraysKt.toList((Object[])permissions.user()));
        if (!guildPerms || !channelPerms) {
            throw new PermissionsLackException(ctx, PermissionTarget.USER, permissions.user());
        }
        member = ctx.getSelfMember();
        guildPerms = member.hasPermission((Collection)ArraysKt.toList((Object[])permissions.bot()));
        channelPerms = member.hasPermission((GuildChannel)ctx.getChannel(), (Collection)ArraysKt.toList((Object[])permissions.bot()));
        if (!guildPerms || !channelPerms) {
            throw new PermissionsLackException(ctx, PermissionTarget.BOT, permissions.bot());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void captureSlashCommandException$Slash(@NotNull SlashCommandContext ctx, @NotNull Throwable e, @Nullable Logger logger) {
        void $this$captureSlashCommandException_u24lambda_u2d2_u24lambda_u2d1;
        Message $this$captureSlashCommandException_u24lambda_u2d2_u24lambda_u2d0;
        Message message;
        SentryEvent sentryEvent;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String message2 = "Exception executing handler for `" + ctx.getEvent().getCommandPath() + "` -> **" + e.getMessage() + "**";
        if (ctx.getEvent().isAcknowledged()) {
            ctx.sendMessage(message2).setEphemeral(true).queue();
        } else {
            ctx.reply(message2).setEphemeral(true).queue();
        }
        String errorMessage = "Exception executing handler for " + ctx.getEvent().getCommandPath() + ", " + e.getMessage();
        String userType = ctx.getAuthor().isSystem() ? "System" : (ctx.getAuthor().isBot() ? "Bot" : "User");
        SentryEvent $this$captureSlashCommandException_u24lambda_u2d2 = sentryEvent = new SentryEvent();
        boolean bl = false;
        Message message3 = message = new Message();
        SentryEvent sentryEvent2 = $this$captureSlashCommandException_u24lambda_u2d2;
        boolean bl2 = false;
        $this$captureSlashCommandException_u24lambda_u2d2_u24lambda_u2d0.setMessage(errorMessage);
        sentryEvent2.setMessage(message);
        $this$captureSlashCommandException_u24lambda_u2d2_u24lambda_u2d0 = message = new User();
        sentryEvent2 = $this$captureSlashCommandException_u24lambda_u2d2;
        boolean bl3 = false;
        $this$captureSlashCommandException_u24lambda_u2d2_u24lambda_u2d1.setId(ctx.getAuthor().getId());
        $this$captureSlashCommandException_u24lambda_u2d2_u24lambda_u2d1.setUsername(ctx.getAuthor().getAsTag());
        $this$captureSlashCommandException_u24lambda_u2d2_u24lambda_u2d1.setOthers(MapsKt.mapOf((Pair)TuplesKt.to((Object)"type", (Object)userType)));
        sentryEvent2.setUser((User)message);
        $this$captureSlashCommandException_u24lambda_u2d2.setExtra("Guild", (Object)(ctx.getGuild().getName() + " (" + ctx.getGuild().getId() + ")"));
        $this$captureSlashCommandException_u24lambda_u2d2.setExtra("Command Path", (Object)ctx.getEvent().getCommandString());
        $this$captureSlashCommandException_u24lambda_u2d2.setThrowable(e);
        Sentry.captureEvent((SentryEvent)sentryEvent);
        Logger logger2 = logger;
        if (logger2 != null) {
            logger2.error(errorMessage, e);
        }
    }

    public static /* synthetic */ void captureSlashCommandException$Slash$default(SlashUtils slashUtils, SlashCommandContext slashCommandContext, Throwable throwable, Logger logger, int n, Object object) {
        if ((n & 4) != 0) {
            logger = null;
        }
        slashUtils.captureSlashCommandException$Slash(slashCommandContext, throwable, logger);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<BaseSlashCommand> discoverSlashCommands(@NotNull String packageName) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Scanner[] scannerArray = new Scanner[]{(Scanner)Scanners.SubTypes};
        Set set = new Reflections(packageName, scannerArray).getSubTypesOf(BaseSlashCommand.class);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"Reflections(packageName,\u2026SlashCommand::class.java)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Class it = (Class)element$iv$iv;
            boolean bl = false;
            if (!(!Modifier.isAbstract(it.getModifiers()) && BaseSlashCommand.class.isAssignableFrom(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List classes = (List)destination$iv$iv;
        LOGGER.info("Discovered a total of " + classes.size() + " slash commands in package " + packageName);
        List commands = new ArrayList();
        for (Class clazz : classes) {
            boolean bl;
            String commandName;
            BaseSlashCommand instance;
            block6: {
                instance = (BaseSlashCommand)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                String element$iv$iv = instance.getCommandName().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)element$iv$iv, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                commandName = element$iv$iv;
                Iterable $this$any$iv = commands;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        BaseSlashCommand it = (BaseSlashCommand)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.equals((String)it.getCommandName(), (String)commandName, (boolean)true)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                throw new IllegalStateException(("Command with name " + commandName + " is already registered.").toString());
            }
            Intrinsics.checkNotNullExpressionValue((Object)instance, (String)"instance");
            commands.add(instance);
        }
        return commands;
    }

    @NotNull
    public final RestAction<?> asEphemeral(@NotNull RestAction<?> $this$asEphemeral) {
        Intrinsics.checkNotNullParameter($this$asEphemeral, (String)"<this>");
        RestAction<?> restAction = $this$asEphemeral;
        if (restAction instanceof ReplyAction) {
            ((ReplyAction)$this$asEphemeral).setEphemeral(true);
        } else if (restAction instanceof WebhookMessageAction) {
            ((WebhookMessageAction)$this$asEphemeral).setEphemeral(true);
        }
        return $this$asEphemeral;
    }
}

