/*
 * Decompiled with CFR 0.152.
 */
package tv.blademaker.slash.metrics;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.dv8tion.jda.api.events.interaction.command.GenericCommandInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import org.jetbrains.annotations.NotNull;
import tv.blademaker.slash.extensions.InteractionsKt;
import tv.blademaker.slash.metrics.MetricsStrategy;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ltv/blademaker/slash/metrics/Metrics;", "", "strategy", "Ltv/blademaker/slash/metrics/MetricsStrategy;", "(Ltv/blademaker/slash/metrics/MetricsStrategy;)V", "executedCommandsCounter", "Lio/prometheus/client/Counter;", "failedCommandsCounter", "measureTimeGauge", "Lio/prometheus/client/Gauge;", "successfulCommandsCounter", "incFailedCommand", "", "event", "Lnet/dv8tion/jda/api/events/interaction/command/SlashCommandInteractionEvent;", "incHandledCommand", "incSuccessCommand", "measuredTime", "", "Slash"})
public final class Metrics {
    @NotNull
    private final Counter executedCommandsCounter;
    @NotNull
    private final Counter successfulCommandsCounter;
    @NotNull
    private final Counter failedCommandsCounter;
    @NotNull
    private final Gauge measureTimeGauge;

    public Metrics(@NotNull MetricsStrategy strategy) {
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        String[] stringArray = new String[]{"pathName"};
        Counter counter = ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name(strategy.getBaseName() + "_command_counter")).help("Slash commands handled.")).labelNames(stringArray)).create();
        Intrinsics.checkNotNullExpressionValue((Object)counter, (String)"create(...)");
        this.executedCommandsCounter = counter;
        stringArray = new String[]{"pathName"};
        Counter counter2 = ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name(strategy.getBaseName() + "_commands_success")).help("Slash commands handled that ends successfully.")).labelNames(stringArray)).create();
        Intrinsics.checkNotNullExpressionValue((Object)counter2, (String)"create(...)");
        this.successfulCommandsCounter = counter2;
        stringArray = new String[]{"pathName"};
        Counter counter3 = ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name(strategy.getBaseName() + "_commands_failed")).help("Slash commands handled that ends on a Exception.")).labelNames(stringArray)).create();
        Intrinsics.checkNotNullExpressionValue((Object)counter3, (String)"create(...)");
        this.failedCommandsCounter = counter3;
        stringArray = new String[]{"pathName"};
        Gauge gauge = ((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name(strategy.getBaseName() + "_measured_execution_time")).help("The time in milliseconds require to execute the command.")).labelNames(stringArray)).create();
        Intrinsics.checkNotNullExpressionValue((Object)gauge, (String)"create(...)");
        this.measureTimeGauge = gauge;
        if (strategy.getExecutedCommands()) {
            this.executedCommandsCounter.register();
        }
        if (strategy.getSuccessfulCommands()) {
            this.successfulCommandsCounter.register();
        }
        if (strategy.getFailedCommands()) {
            this.failedCommandsCounter.register();
        }
        if (strategy.getMeasureTime()) {
            this.measureTimeGauge.register();
        }
    }

    public final void incHandledCommand(@NotNull SlashCommandInteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String[] stringArray = new String[]{InteractionsKt.getCommandPath((GenericCommandInteractionEvent)event)};
        ((Counter.Child)this.executedCommandsCounter.labels(stringArray)).inc();
    }

    public final void incSuccessCommand(@NotNull SlashCommandInteractionEvent event, long measuredTime) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String[] stringArray = new String[]{InteractionsKt.getCommandPath((GenericCommandInteractionEvent)event)};
        ((Counter.Child)this.successfulCommandsCounter.labels(stringArray)).inc();
        stringArray = new String[]{InteractionsKt.getCommandPath((GenericCommandInteractionEvent)event)};
        ((Gauge.Child)this.measureTimeGauge.labels(stringArray)).set((double)measuredTime);
    }

    public final void incFailedCommand(@NotNull SlashCommandInteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String[] stringArray = new String[]{InteractionsKt.getCommandPath((GenericCommandInteractionEvent)event)};
        ((Counter.Child)this.failedCommandsCounter.labels(stringArray)).inc();
    }
}

