/*
 * Decompiled with CFR 0.152.
 */
package com.turki.vectoranalogclockview;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.DrawableRes;
import android.support.annotation.RequiresApi;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.content.res.AppCompatResources;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.turki.vectoranalogclockview.R;
import java.util.Calendar;

public abstract class VectorAnalogClock
extends RelativeLayout {
    private AppCompatImageView analogFace;
    private AppCompatImageView analogHour;
    private AppCompatImageView analogMinute;
    private AppCompatImageView analogSecond;
    @DrawableRes
    private int faceId;
    @DrawableRes
    private int hourId;
    @DrawableRes
    private int minuteId;
    @DrawableRes
    private int secondId;
    private Context ctx;
    private boolean showSeconds = true;
    private int color = -16777216;
    private float scale = 1.0f;
    private float opacity = 1.0f;
    private Calendar calendar;
    private int dp;
    private int sizeInDp;
    private int sizeInPixels;
    private int diameterInPixels = 0;
    private float diameterInDp = 0.0f;
    private float scaleMultiplier = 1.0f;
    ViewTreeObserver.OnGlobalLayoutListener layoutListener;

    public VectorAnalogClock(Context ctx) {
        super(ctx);
        this.ctx = ctx;
    }

    public VectorAnalogClock(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.ctx = context;
    }

    public VectorAnalogClock(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.ctx = context;
    }

    @RequiresApi(api=21)
    public VectorAnalogClock(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.ctx = context;
    }

    public void initializeSimple() {
        this.faceId = R.drawable.clock_face;
        this.hourId = R.drawable.hours_hand;
        this.minuteId = R.drawable.minutes_hand;
        this.secondId = R.drawable.second_hand;
        this.main(this.ctx);
    }

    public void initializeCustom(@DrawableRes int faceId, @DrawableRes int hourId, @DrawableRes int minuteId, @DrawableRes int secondId) {
        this.faceId = faceId;
        this.hourId = hourId;
        this.minuteId = minuteId;
        this.secondId = secondId;
        this.main(this.ctx);
    }

    public Calendar getCalendar() {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance();
        }
        return this.calendar;
    }

    public int getDiameterInPixels() {
        return this.diameterInPixels;
    }

    public float getDiameterInDp() {
        return this.diameterInDp;
    }

    public float getScale() {
        return this.scale;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public int getColor() {
        return this.color;
    }

    public boolean isShowingSeconds() {
        return this.showSeconds;
    }

    public VectorAnalogClock setCalendar(Calendar calendar) {
        this.calendar = calendar;
        this.tickTick();
        return this;
    }

    public VectorAnalogClock setScale(float scale) {
        this.scale = scale;
        this.setScaleY(scale * this.scaleMultiplier);
        this.setScaleX(scale * this.scaleMultiplier);
        return this;
    }

    public VectorAnalogClock setDiameterInDp(float diameterInDp) {
        this.diameterInDp = diameterInDp;
        this.scaleMultiplier = diameterInDp / (float)this.sizeInDp;
        this.setScale(this.scale);
        return this;
    }

    public VectorAnalogClock setDiameterInPixels(int diameterInPixels) {
        this.diameterInPixels = diameterInPixels;
        this.scaleMultiplier = ((float)diameterInPixels + 0.0f) / ((float)this.sizeInPixels + 0.0f);
        Log.d((String)"xx", (String)(this.scaleMultiplier + ""));
        this.setScale(this.scale);
        return this;
    }

    public VectorAnalogClock setOpacity(float opacity) {
        this.opacity = opacity;
        this.main(this.ctx);
        return this;
    }

    public VectorAnalogClock setColor(int color) {
        this.color = color;
        this.main(this.ctx);
        return this;
    }

    public VectorAnalogClock setShowSeconds(boolean showSeconds) {
        this.showSeconds = showSeconds;
        this.main(this.ctx);
        return this;
    }

    private void main(Context ctx) {
        Drawable face = AppCompatResources.getDrawable((Context)ctx, (int)this.faceId);
        Drawable hour = AppCompatResources.getDrawable((Context)ctx, (int)this.hourId);
        Drawable minute = AppCompatResources.getDrawable((Context)ctx, (int)this.minuteId);
        Drawable second = AppCompatResources.getDrawable((Context)ctx, (int)this.secondId);
        int alpha255 = (int)(this.opacity * 255.0f);
        face.setAlpha(alpha255);
        hour.setAlpha(alpha255);
        minute.setAlpha(alpha255);
        second.setAlpha(alpha255);
        face = DrawableCompat.wrap((Drawable)face);
        hour = DrawableCompat.wrap((Drawable)hour);
        minute = DrawableCompat.wrap((Drawable)minute);
        second = DrawableCompat.wrap((Drawable)second);
        DrawableCompat.setTint((Drawable)face.mutate(), (int)this.color);
        DrawableCompat.setTint((Drawable)hour.mutate(), (int)this.color);
        DrawableCompat.setTint((Drawable)minute.mutate(), (int)this.color);
        DrawableCompat.setTint((Drawable)second.mutate(), (int)this.color);
        VectorAnalogClock.inflate((Context)ctx, (int)R.layout.analog_clock, (ViewGroup)this);
        this.analogFace = (AppCompatImageView)this.findViewById(R.id.face);
        this.analogHour = (AppCompatImageView)this.findViewById(R.id.hour);
        this.analogMinute = (AppCompatImageView)this.findViewById(R.id.minute);
        this.analogSecond = (AppCompatImageView)this.findViewById(R.id.second);
        if (!this.showSeconds) {
            this.analogSecond.setVisibility(8);
        }
        this.analogFace.setAdjustViewBounds(true);
        this.analogHour.setAdjustViewBounds(true);
        this.analogMinute.setAdjustViewBounds(true);
        this.analogSecond.setAdjustViewBounds(true);
        this.analogHour.setScaleType(ImageView.ScaleType.FIT_END);
        this.analogMinute.setScaleType(ImageView.ScaleType.FIT_END);
        this.analogSecond.setScaleType(ImageView.ScaleType.FIT_END);
        this.sizeInDp = 40;
        this.sizeInDp = (this.sizeInDp + 25) * 4;
        this.sizeInPixels = (int)TypedValue.applyDimension((int)1, (float)this.sizeInDp, (DisplayMetrics)this.getResources().getDisplayMetrics());
        ViewGroup.LayoutParams layoutParams = this.analogFace.getLayoutParams();
        layoutParams.width = this.sizeInPixels;
        layoutParams.height = this.sizeInPixels;
        this.analogFace.setLayoutParams(layoutParams);
        layoutParams = this.analogSecond.getLayoutParams();
        float minutesHeight = (float)(this.sizeInPixels / 2) - (float)this.sizeInPixels / 5.5f;
        layoutParams.height = (int)minutesHeight;
        this.analogSecond.setLayoutParams(layoutParams);
        layoutParams = this.analogMinute.getLayoutParams();
        layoutParams.height = (int)minutesHeight;
        this.analogMinute.setLayoutParams(layoutParams);
        layoutParams = this.analogHour.getLayoutParams();
        layoutParams.height = this.sizeInPixels / 5;
        this.analogHour.setLayoutParams(layoutParams);
        this.analogFace.setImageDrawable(face);
        this.analogHour.setImageDrawable(hour);
        this.analogMinute.setImageDrawable(minute);
        this.analogSecond.setImageDrawable(second);
        this.dp = (int)TypedValue.applyDimension((int)1, (float)3.5f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.layoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                VectorAnalogClock.this.setPositionFor((View)VectorAnalogClock.this.analogSecond);
                VectorAnalogClock.this.setPositionFor((View)VectorAnalogClock.this.analogMinute);
                VectorAnalogClock.this.setPositionFor((View)VectorAnalogClock.this.analogHour);
                VectorAnalogClock.this.tickTick();
                if (Build.VERSION.SDK_INT >= 16) {
                    VectorAnalogClock.this.getViewTreeObserver().removeOnGlobalLayoutListener(VectorAnalogClock.this.layoutListener);
                } else {
                    VectorAnalogClock.this.getViewTreeObserver().removeGlobalOnLayoutListener(VectorAnalogClock.this.layoutListener);
                }
            }
        };
        this.getViewTreeObserver().addOnGlobalLayoutListener(this.layoutListener);
    }

    private void setPositionFor(View v) {
        v.setTranslationY((float)(-v.getHeight() / 2 + this.dp));
    }

    private void tickTick() {
        Calendar calendar = this.getCalendar();
        long curMillis = calendar.get(14);
        int curSecond = calendar.get(13);
        int curMinute = calendar.get(12);
        int curHour = calendar.get(10);
        float degrees = (float)(curSecond * 6) + 0.006f * (float)curMillis;
        long duration = 60000L;
        RotateAnimation positioner = new RotateAnimation(0.0f, degrees, 1, 0.5f, 1, 0.5f);
        positioner.setFillAfter(true);
        positioner.setDuration(0L);
        RotateAnimation rotator = new RotateAnimation(0.0f, 360.0f, 1, 0.5f, 1, 0.5f);
        rotator.setDuration(duration);
        rotator.setRepeatMode(1);
        rotator.setRepeatCount(-1);
        AnimationSet animationSet = new AnimationSet(true);
        animationSet.addAnimation((Animation)positioner);
        animationSet.addAnimation((Animation)rotator);
        animationSet.setInterpolator((Interpolator)new LinearInterpolator());
        this.analogSecond.startAnimation((Animation)animationSet);
        degrees = (float)(6 * curMinute) + 0.1f * (float)curSecond + 1.0E-5f * (float)curMillis;
        positioner = new RotateAnimation(0.0f, degrees, 1, 0.5f, 1, 0.5f);
        positioner.setFillAfter(true);
        positioner.setDuration(0L);
        rotator = new RotateAnimation(0.0f, 360.0f, 1, 0.5f, 1, 0.5f);
        rotator.setDuration(duration *= 60L);
        rotator.setRepeatMode(1);
        rotator.setRepeatCount(-1);
        animationSet = new AnimationSet(true);
        animationSet.addAnimation((Animation)positioner);
        animationSet.addAnimation((Animation)rotator);
        animationSet.setInterpolator((Interpolator)new LinearInterpolator());
        this.analogMinute.startAnimation((Animation)animationSet);
        degrees = 1.66667E-6f * (float)curMillis + 0.00166667f * (float)curSecond + 0.5f * (float)curMinute + (float)(30 * curHour);
        positioner = new RotateAnimation(0.0f, degrees, 1, 0.5f, 1, 0.5f);
        positioner.setFillAfter(true);
        positioner.setDuration(0L);
        rotator = new RotateAnimation(0.0f, 360.0f, 1, 0.5f, 1, 0.5f);
        rotator.setDuration(duration *= 12L);
        rotator.setRepeatMode(1);
        rotator.setRepeatCount(-1);
        animationSet = new AnimationSet(true);
        animationSet.addAnimation((Animation)positioner);
        animationSet.addAnimation((Animation)rotator);
        animationSet.setInterpolator((Interpolator)new LinearInterpolator());
        this.analogHour.startAnimation((Animation)animationSet);
    }
}

