/*
 * Copyright (C) 2014 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.sdk.model.enumeration;

import travel.izi.sdk.model.IZITravelEnumeration;

import java.util.HashMap;
import java.util.Map;

/**
 * Tour placement.
 */
public enum Placement implements IZITravelEnumeration {

    /**
     * Indoor placement.
     */
    Indoor("indoor"),

    /**
     * Outdoor placement.
     */
    Outdoor("outdoor");

    private final String value;

    @SuppressWarnings("UnnecessaryEnumModifier")
    private Placement(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    private static final Map<String, Placement> STRING_MAPPING = new HashMap<String, Placement>();

    static {
        for (Placement via : Placement.values()) {
            STRING_MAPPING.put(via.toString(), via);
        }
    }

    public static Placement fromValue(String value) {
        return STRING_MAPPING.get(value);
    }

}