/*
 * Copyright (C) 2014 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.sdk.model.entity;

import travel.izi.sdk.model.IZITravelEntity;

/**
 * The quiz.
 */
@SuppressWarnings("unused")
public class Quiz implements IZITravelEntity {
    private static final long serialVersionUID = 5027440801077553005L;

    /**
     * The answer to the quiz.
     */
    public static class Answer implements IZITravelEntity {
        private static final long serialVersionUID = 6937351629954453992L;

        /**
         * The answer's content.
         */
        public String content;

        /**
         * Mark of correctness.
         */
        public boolean correct;

    }

    /**
     * Quiz's question.
     */
    public String question;

    /**
     * The comment for a correct answer.
     */
    public String comment;

    /**
     * Array of answers. The correct answer is marked.
     */
    public Answer[] answers;

}