/*
 * Copyright (C) 2014 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.sdk.model.entity;

import com.google.gson.annotations.SerializedName;

/**
 * The full version of {@link MtgObject}. Used to display details of particular content object.
 */
@SuppressWarnings("unused")
public class FullMtgObject extends MtgObject {
    private static final long serialVersionUID = -8905964278900400446L;

    /**
     * Array of language specific MtgObject content: texts, descriptions, media. Everything
     * displayed to end-user come within this array.
     */
    @SerializedName("content")
    public Content[] contents;

    /**
     * The UUID of parent MtgObject. For example, tour’s uuid of a tourist attraction,
     * museum’s uuid of an exhibit.
     */
    public String parentUuid;

    /**
     * Schedule details (typical for museum).
     */
    public Schedule schedule;

    /**
     * Contacts (typical for museum/publisher).
     */
    public Contacts contacts;

    /**
     * Sponsors (typical for museum/tour).
     */
    public Sponsor[] sponsors;

    /**
     * The size of the media content (audio + video + images) for the object and all its children.
     * Typical for museum/tour/collection.
     */
    public Long size;

}