/*
 * Decompiled with CFR 0.152.
 */
package tr.com.mobilex.transactions.network;

import com.google.gson.Gson;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.mobilex.core.SystemInfo;
import tr.com.mobilex.core.logging.Logger;
import tr.com.mobilex.core.network.HttpClient;
import tr.com.mobilex.core.utils.ExceptionUtilsKt;
import tr.com.mobilex.core.utils.StringUtilsKt;
import tr.com.mobilex.transactions.network.PurchaseInformation;
import tr.com.mobilex.transactions.network.TransactionsApi;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J>\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0011\u001a\u0012\u0012\b\u0012\u00060\u0013j\u0002`\u0014\u0012\u0004\u0012\u00020\u000e0\u00122\u0014\u0010\u0015\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\u000e0\u0012H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Ltr/com/mobilex/transactions/network/ImplTransactionsApi;", "Ltr/com/mobilex/transactions/network/TransactionsApi;", "systemInfo", "Ltr/com/mobilex/core/SystemInfo;", "httpClient", "Ltr/com/mobilex/core/network/HttpClient;", "(Ltr/com/mobilex/core/SystemInfo;Ltr/com/mobilex/core/network/HttpClient;)V", "apiUrl", "", "baseHeaders", "", "getSystemInfo", "()Ltr/com/mobilex/core/SystemInfo;", "validate", "", "purchaseInfo", "Ltr/com/mobilex/transactions/network/PurchaseInformation;", "onFailure", "Lkotlin/Function1;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onResponse", "revenuex-android-sdk_release"})
public final class ImplTransactionsApi
implements TransactionsApi {
    @NotNull
    private final SystemInfo systemInfo;
    @NotNull
    private final HttpClient httpClient;
    @NotNull
    private final String apiUrl;
    @NotNull
    private final Map<String, String> baseHeaders;

    public ImplTransactionsApi(@NotNull SystemInfo systemInfo, @NotNull HttpClient httpClient) {
        Intrinsics.checkNotNullParameter((Object)systemInfo, (String)"systemInfo");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        this.systemInfo = systemInfo;
        this.httpClient = httpClient;
        this.apiUrl = StringUtilsKt.getConcatenatedUrl(this.getSystemInfo().getRootUrl(), "api/transactions/");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"clientid", (Object)this.getSystemInfo().getClientId()), TuplesKt.to((Object)"user-revenueXId", (Object)this.getSystemInfo().getRevenueXUserId()), TuplesKt.to((Object)"platform", (Object)this.getSystemInfo().getPlatform()), TuplesKt.to((Object)"platform-version", (Object)this.getSystemInfo().getPlatformVersion()), TuplesKt.to((Object)"application-version", (Object)this.getSystemInfo().getApplicationVersion()), TuplesKt.to((Object)"device-name", (Object)this.getSystemInfo().getDeviceName()), TuplesKt.to((Object)"sandbox", (Object)String.valueOf(this.getSystemInfo().isSandbox())), TuplesKt.to((Object)"region", (Object)this.getSystemInfo().getRegion()), TuplesKt.to((Object)"Content-Type", (Object)"application/json")};
        this.baseHeaders = MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @NotNull
    public SystemInfo getSystemInfo() {
        return this.systemInfo;
    }

    @Override
    public void validate(@NotNull PurchaseInformation purchaseInfo, @NotNull Function1<? super Exception, Unit> onFailure, @NotNull Function1<? super String, Unit> onResponse) {
        Intrinsics.checkNotNullParameter((Object)purchaseInfo, (String)"purchaseInfo");
        Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
        Intrinsics.checkNotNullParameter(onResponse, (String)"onResponse");
        String validateUrl = StringUtilsKt.getConcatenatedUrl(this.apiUrl, "validate");
        String body = new Gson().toJson((Object)purchaseInfo);
        Intrinsics.checkNotNullExpressionValue((Object)body, (String)"body");
        HttpClient.DefaultImpls.post$default(this.httpClient, validateUrl, body, null, this.baseHeaders, (Function1)new Function1<Exception, Unit>(onFailure){
            final /* synthetic */ Function1<Exception, Unit> $onFailure;
            {
                this.$onFailure = $onFailure;
                super(1);
            }

            public final void invoke(@NotNull Exception exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                Logger.INSTANCE.error(ExceptionUtilsKt.getExceptionMessage(exception), exception);
                this.$onFailure.invoke((Object)exception);
            }
        }, (Function1)new Function1<String, Unit>(onResponse){
            final /* synthetic */ Function1<String, Unit> $onResponse;
            {
                this.$onResponse = $onResponse;
                super(1);
            }

            public final void invoke(@Nullable String response) {
                Logger.debug$default(Logger.INSTANCE, Intrinsics.stringPlus((String)"TransactionsApi validate server response: ", (Object)response), null, 2, null);
                this.$onResponse.invoke((Object)response);
            }
        }, String.class, 4, null);
    }
}

