/*
 * Decompiled with CFR 0.152.
 */
package tr.com.mobilex.transactions.manager;

import android.app.Activity;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.mobilex.core.billing.ProductType;
import tr.com.mobilex.core.billing.ProductTypeKt;
import tr.com.mobilex.core.billing.PurchaseInformationProvider;
import tr.com.mobilex.core.billing.RevXProduct;
import tr.com.mobilex.core.billing.RevXPurchase;
import tr.com.mobilex.core.billing.RevXPurchaseHistory;
import tr.com.mobilex.core.logging.Logger;
import tr.com.mobilex.core.sharedpref.EncryptedSharedPrefManager;
import tr.com.mobilex.core.utils.ExceptionUtilsKt;
import tr.com.mobilex.core.utils.LongUtilsKt;
import tr.com.mobilex.core.utils.StringUtilsKt;
import tr.com.mobilex.products.manager.ProductsManager;
import tr.com.mobilex.transactions.manager.TransactionsManager;
import tr.com.mobilex.transactions.network.ProductInformation;
import tr.com.mobilex.transactions.network.PurchaseInformation;
import tr.com.mobilex.transactions.network.TransactionsApi;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ2\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000b2\u000e\b\u0002\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\u000f2\b\b\u0002\u0010\"\u001a\u00020\u000bH\u0002J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u0012H\u0016J8\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010)2\u0014\u0010+\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014H\u0016J\b\u0010,\u001a\u00020\u0015H\u0016J\b\u0010-\u001a\u00020\u0015H\u0016JF\u0010.\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000b2\u000e\b\u0002\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\u000f2\b\b\u0002\u0010\"\u001a\u00020\u000b2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0016\u00100\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0016\u00101\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fH\u0002R\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u000f0\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Ltr/com/mobilex/transactions/manager/ImplTransactionsManager;", "Ltr/com/mobilex/transactions/manager/TransactionsManager;", "transactionsApi", "Ltr/com/mobilex/transactions/network/TransactionsApi;", "purchaseInfoProvider", "Ltr/com/mobilex/core/billing/PurchaseInformationProvider;", "productsManager", "Ltr/com/mobilex/products/manager/ProductsManager;", "securePreferences", "Ltr/com/mobilex/core/sharedpref/EncryptedSharedPrefManager;", "observerMode", "", "(Ltr/com/mobilex/transactions/network/TransactionsApi;Ltr/com/mobilex/core/billing/PurchaseInformationProvider;Ltr/com/mobilex/products/manager/ProductsManager;Ltr/com/mobilex/core/sharedpref/EncryptedSharedPrefManager;Z)V", "_purchaseHistory", "Landroidx/lifecycle/MutableLiveData;", "", "Ltr/com/mobilex/core/billing/RevXPurchaseHistory;", "_purchases", "Ltr/com/mobilex/core/billing/RevXPurchase;", "purchaseCallback", "Lkotlin/Function1;", "", "purchaseHistory", "Landroidx/lifecycle/LiveData;", "getPurchaseHistory", "()Landroidx/lifecycle/LiveData;", "purchases", "getPurchases", "getPurchaseInformation", "Ltr/com/mobilex/transactions/network/PurchaseInformation;", "purchaseToken", "", "isSubscription", "productIds", "isHistoryRecord", "onNewPurchaseComplete", "purchase", "purchaseProduct", "activity", "Landroid/app/Activity;", "product", "Ltr/com/mobilex/core/billing/RevXProduct;", "upgradedProduct", "callback", "sendActivePurchases", "sendPurchaseHistory", "validatePurchase", "onComplete", "validatePurchaseHistory", "validatePurchases", "revenuex-android-sdk_release"})
public final class ImplTransactionsManager
implements TransactionsManager {
    @NotNull
    private final TransactionsApi transactionsApi;
    @NotNull
    private final PurchaseInformationProvider purchaseInfoProvider;
    @NotNull
    private final ProductsManager productsManager;
    @NotNull
    private final EncryptedSharedPrefManager securePreferences;
    private final boolean observerMode;
    @Nullable
    private Function1<? super RevXPurchase, Unit> purchaseCallback;
    @NotNull
    private final MutableLiveData<List<RevXPurchaseHistory>> _purchaseHistory;
    @NotNull
    private final LiveData<List<RevXPurchaseHistory>> purchaseHistory;
    @NotNull
    private final MutableLiveData<List<RevXPurchase>> _purchases;
    @NotNull
    private final LiveData<List<RevXPurchase>> purchases;

    public ImplTransactionsManager(@NotNull TransactionsApi transactionsApi, @NotNull PurchaseInformationProvider purchaseInfoProvider, @NotNull ProductsManager productsManager2, @NotNull EncryptedSharedPrefManager securePreferences, boolean observerMode) {
        Intrinsics.checkNotNullParameter((Object)transactionsApi, (String)"transactionsApi");
        Intrinsics.checkNotNullParameter((Object)purchaseInfoProvider, (String)"purchaseInfoProvider");
        Intrinsics.checkNotNullParameter((Object)productsManager2, (String)"productsManager");
        Intrinsics.checkNotNullParameter((Object)securePreferences, (String)"securePreferences");
        this.transactionsApi = transactionsApi;
        this.purchaseInfoProvider = purchaseInfoProvider;
        this.productsManager = productsManager2;
        this.securePreferences = securePreferences;
        this.observerMode = observerMode;
        this.purchaseInfoProvider.setNewPurchaseListener(this);
        this._purchaseHistory = new MutableLiveData();
        this.purchaseHistory = (LiveData)this._purchaseHistory;
        this._purchases = new MutableLiveData();
        this.purchases = (LiveData)this._purchases;
    }

    @Override
    @NotNull
    public LiveData<List<RevXPurchaseHistory>> getPurchaseHistory() {
        return this.purchaseHistory;
    }

    @Override
    @NotNull
    public LiveData<List<RevXPurchase>> getPurchases() {
        return this.purchases;
    }

    @Override
    public void sendPurchaseHistory() {
        this.purchaseInfoProvider.queryPurchaseHistory(ProductType.Subs, (Function1<? super List<RevXPurchaseHistory>, Unit>)((Function1)new Function1<List<? extends RevXPurchaseHistory>, Unit>(this){
            final /* synthetic */ ImplTransactionsManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull List<RevXPurchaseHistory> subscriptions) {
                Intrinsics.checkNotNullParameter(subscriptions, (String)"subscriptions");
                ImplTransactionsManager.access$getPurchaseInfoProvider$p(this.this$0).queryPurchaseHistory(ProductType.InApp, (Function1<? super List<RevXPurchaseHistory>, Unit>)((Function1)new Function1<List<? extends RevXPurchaseHistory>, Unit>(subscriptions, this.this$0){
                    final /* synthetic */ List<RevXPurchaseHistory> $subscriptions;
                    final /* synthetic */ ImplTransactionsManager this$0;
                    {
                        this.$subscriptions = $subscriptions;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull List<RevXPurchaseHistory> inApps) {
                        Intrinsics.checkNotNullParameter(inApps, (String)"inApps");
                        List totalHistory = CollectionsKt.plus((Collection)this.$subscriptions, (Iterable)inApps);
                        Logger.debug$default(Logger.INSTANCE, Intrinsics.stringPlus((String)"Purchase history: ", (Object)totalHistory), null, 2, null);
                        ImplTransactionsManager.access$get_purchaseHistory$p(this.this$0).postValue((Object)totalHistory);
                        ImplTransactionsManager.access$validatePurchaseHistory(this.this$0, totalHistory);
                    }
                }));
            }
        }));
    }

    @Override
    public void sendActivePurchases() {
        this.purchaseInfoProvider.queryPurchases(ProductType.Subs, (Function1<? super List<RevXPurchase>, Unit>)((Function1)new Function1<List<? extends RevXPurchase>, Unit>(this){
            final /* synthetic */ ImplTransactionsManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull List<RevXPurchase> subscriptions) {
                Intrinsics.checkNotNullParameter(subscriptions, (String)"subscriptions");
                ImplTransactionsManager.access$getPurchaseInfoProvider$p(this.this$0).queryPurchases(ProductType.InApp, (Function1<? super List<RevXPurchase>, Unit>)((Function1)new Function1<List<? extends RevXPurchase>, Unit>(subscriptions, this.this$0){
                    final /* synthetic */ List<RevXPurchase> $subscriptions;
                    final /* synthetic */ ImplTransactionsManager this$0;
                    {
                        this.$subscriptions = $subscriptions;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull List<RevXPurchase> inApps) {
                        Intrinsics.checkNotNullParameter(inApps, (String)"inApps");
                        List totalPurchases = CollectionsKt.plus((Collection)this.$subscriptions, (Iterable)inApps);
                        Logger.debug$default(Logger.INSTANCE, Intrinsics.stringPlus((String)"Active purchases: ", (Object)totalPurchases), null, 2, null);
                        ImplTransactionsManager.access$get_purchases$p(this.this$0).postValue((Object)totalPurchases);
                        ImplTransactionsManager.access$validatePurchases(this.this$0, totalPurchases);
                    }
                }));
            }
        }));
    }

    @Override
    public void purchaseProduct(@NotNull Activity activity, @NotNull RevXProduct product, @Nullable RevXProduct upgradedProduct, @Nullable Function1<? super RevXPurchase, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)product, (String)"product");
        if (!this.observerMode) {
            this.purchaseCallback = callback;
            this.purchaseInfoProvider.purchaseProduct(activity, product, upgradedProduct);
        } else {
            Logger.warning$default(Logger.INSTANCE, "Tried to launch purchase flow in observer mode!", null, 2, null);
        }
    }

    @Override
    public void onNewPurchaseComplete(@NotNull RevXPurchase purchase) {
        Intrinsics.checkNotNullParameter((Object)purchase, (String)"purchase");
        Ref.ObjectRef syncedTokens = new Ref.ObjectRef();
        String[] stringArray = this.securePreferences.read("validated_purchase_tokens", String[].class);
        if (stringArray == null) {
            stringArray = syncedTokens.element = new String[]{};
        }
        if (ArraysKt.contains((Object[])((Object[])syncedTokens.element), (Object)purchase.getPurchaseToken())) {
            Function1<? super RevXPurchase, Unit> function1 = this.purchaseCallback;
            if (function1 != null) {
                function1.invoke((Object)purchase);
            }
            return;
        }
        ImplTransactionsManager.validatePurchase$default(this, purchase.getPurchaseToken(), ProductTypeKt.isSubscription(purchase.getType()), purchase.getProductIds(), false, (Function1)new Function1<Boolean, Unit>((Ref.ObjectRef<String[]>)syncedTokens, purchase, this){
            final /* synthetic */ Ref.ObjectRef<String[]> $syncedTokens;
            final /* synthetic */ RevXPurchase $purchase;
            final /* synthetic */ ImplTransactionsManager this$0;
            {
                this.$syncedTokens = $syncedTokens;
                this.$purchase = $purchase;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(boolean isSynced) {
                Object object = this.$syncedTokens.element;
                Ref.ObjectRef<String[]> objectRef = this.$syncedTokens;
                RevXPurchase revXPurchase = this.$purchase;
                ImplTransactionsManager implTransactionsManager = this.this$0;
                synchronized (object) {
                    boolean bl = false;
                    if (isSynced) {
                        objectRef.element = ArraysKt.plus((Object[])((Object[])objectRef.element), (Object)revXPurchase.getPurchaseToken());
                        ImplTransactionsManager.access$getSecurePreferences$p(implTransactionsManager).write("validated_purchase_tokens", (Serializable)objectRef.element);
                    }
                    Function1 function1 = ImplTransactionsManager.access$getPurchaseCallback$p(implTransactionsManager);
                    if (function1 != null) {
                        function1.invoke((Object)revXPurchase);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        }, 8, null);
    }

    private final void validatePurchaseHistory(List<RevXPurchaseHistory> purchaseHistory) {
        Ref.ObjectRef syncedTokens = new Ref.ObjectRef();
        String[] stringArray = this.securePreferences.read("validated_purchase_tokens", String[].class);
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        syncedTokens.element = stringArray;
        for (RevXPurchaseHistory history : purchaseHistory) {
            if (ArraysKt.contains((Object[])((Object[])syncedTokens.element), (Object)history.getPurchaseToken())) continue;
            this.validatePurchase(history.getPurchaseToken(), ProductTypeKt.isSubscription(history.getType()), history.getProductIds(), true, (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>((Ref.ObjectRef<String[]>)syncedTokens, history, this){
                final /* synthetic */ Ref.ObjectRef<String[]> $syncedTokens;
                final /* synthetic */ RevXPurchaseHistory $history;
                final /* synthetic */ ImplTransactionsManager this$0;
                {
                    this.$syncedTokens = $syncedTokens;
                    this.$history = $history;
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(boolean isSynced) {
                    Object object = this.$syncedTokens.element;
                    Ref.ObjectRef<String[]> objectRef = this.$syncedTokens;
                    RevXPurchaseHistory revXPurchaseHistory = this.$history;
                    ImplTransactionsManager implTransactionsManager = this.this$0;
                    synchronized (object) {
                        boolean bl = false;
                        if (isSynced) {
                            objectRef.element = ArraysKt.plus((Object[])((Object[])objectRef.element), (Object)revXPurchaseHistory.getPurchaseToken());
                            ImplTransactionsManager.access$getSecurePreferences$p(implTransactionsManager).write("validated_purchase_tokens", (Serializable)objectRef.element);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }));
        }
    }

    private final void validatePurchases(List<RevXPurchase> purchases) {
        Ref.ObjectRef syncedTokens = new Ref.ObjectRef();
        String[] stringArray = this.securePreferences.read("validated_purchase_tokens", String[].class);
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        syncedTokens.element = stringArray;
        for (RevXPurchase purchase : purchases) {
            if (ArraysKt.contains((Object[])((Object[])syncedTokens.element), (Object)purchase.getPurchaseToken())) continue;
            ImplTransactionsManager.validatePurchase$default(this, purchase.getPurchaseToken(), ProductTypeKt.isSubscription(purchase.getType()), purchase.getProductIds(), false, (Function1)new Function1<Boolean, Unit>((Ref.ObjectRef<String[]>)syncedTokens, purchase, this){
                final /* synthetic */ Ref.ObjectRef<String[]> $syncedTokens;
                final /* synthetic */ RevXPurchase $purchase;
                final /* synthetic */ ImplTransactionsManager this$0;
                {
                    this.$syncedTokens = $syncedTokens;
                    this.$purchase = $purchase;
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(boolean isSynced) {
                    Object object = this.$syncedTokens.element;
                    Ref.ObjectRef<String[]> objectRef = this.$syncedTokens;
                    RevXPurchase revXPurchase = this.$purchase;
                    ImplTransactionsManager implTransactionsManager = this.this$0;
                    synchronized (object) {
                        boolean bl = false;
                        if (isSynced) {
                            objectRef.element = ArraysKt.plus((Object[])((Object[])objectRef.element), (Object)revXPurchase.getPurchaseToken());
                            ImplTransactionsManager.access$getSecurePreferences$p(implTransactionsManager).write("validated_purchase_tokens", (Serializable)objectRef.element);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }, 8, null);
        }
    }

    private final void validatePurchase(String purchaseToken, boolean isSubscription, List<String> productIds, boolean isHistoryRecord, Function1<? super Boolean, Unit> onComplete) {
        PurchaseInformation purchaseInfo = this.getPurchaseInformation(purchaseToken, isSubscription, productIds, isHistoryRecord);
        Logger.debug$default(Logger.INSTANCE, Intrinsics.stringPlus((String)"Purchase information to validate: ", (Object)purchaseInfo), null, 2, null);
        this.transactionsApi.validate(purchaseInfo, (Function1<? super Exception, Unit>)((Function1)new Function1<Exception, Unit>(onComplete){
            final /* synthetic */ Function1<Boolean, Unit> $onComplete;
            {
                this.$onComplete = $onComplete;
                super(1);
            }

            public final void invoke(@NotNull Exception it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger.INSTANCE.error(ExceptionUtilsKt.getExceptionMessage(it), it);
                this.$onComplete.invoke((Object)false);
            }
        }), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(onComplete){
            final /* synthetic */ Function1<Boolean, Unit> $onComplete;
            {
                this.$onComplete = $onComplete;
                super(1);
            }

            public final void invoke(@Nullable String response) {
                Logger.debug$default(Logger.INSTANCE, Intrinsics.stringPlus((String)"validatePurchase response: ", (Object)response), null, 2, null);
                this.$onComplete.invoke((Object)true);
            }
        }));
    }

    static /* synthetic */ void validatePurchase$default(ImplTransactionsManager implTransactionsManager, String string, boolean bl, List list, boolean bl2, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        implTransactionsManager.validatePurchase(string, bl, list, bl2, (Function1<? super Boolean, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    private final PurchaseInformation getPurchaseInformation(String purchaseToken, boolean isSubscription, List<String> productIds, boolean isHistoryRecord) {
        List list;
        Collection collection;
        Collection destination$iv$iv;
        if (isHistoryRecord) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = productIds;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void id;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new ProductInformation((String)id, null, null, null, 14, null));
            }
            list = (List)destination$iv$iv;
        } else {
            void $this$mapTo$iv$iv;
            RevXProduct it;
            Iterable $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable $i$f$map = this.productsManager.getProducts();
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (RevXProduct)element$iv$iv;
                boolean bl = false;
                if (!productIds.contains(it.getProductId())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List productList = (List)destination$iv$iv2;
            Iterable $this$map$iv = productList;
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (RevXProduct)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(new ProductInformation(it.getProductId(), StringUtilsKt.toRevXPeriod(it.getSubscriptionPeriod()), LongUtilsKt.toPrice(it.getPriceAmountMicros()), it.getPriceCurrencyCode()));
            }
            list = (List)destination$iv$iv2;
        }
        List purchasedProducts = list;
        return new PurchaseInformation(purchaseToken, isSubscription, purchasedProducts);
    }

    static /* synthetic */ PurchaseInformation getPurchaseInformation$default(ImplTransactionsManager implTransactionsManager, String string, boolean bl, List list, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return implTransactionsManager.getPurchaseInformation(string, bl, list, bl2);
    }

    public static final /* synthetic */ PurchaseInformationProvider access$getPurchaseInfoProvider$p(ImplTransactionsManager $this) {
        return $this.purchaseInfoProvider;
    }

    public static final /* synthetic */ MutableLiveData access$get_purchaseHistory$p(ImplTransactionsManager $this) {
        return $this._purchaseHistory;
    }

    public static final /* synthetic */ void access$validatePurchaseHistory(ImplTransactionsManager $this, List purchaseHistory) {
        $this.validatePurchaseHistory(purchaseHistory);
    }

    public static final /* synthetic */ MutableLiveData access$get_purchases$p(ImplTransactionsManager $this) {
        return $this._purchases;
    }

    public static final /* synthetic */ void access$validatePurchases(ImplTransactionsManager $this, List purchases) {
        $this.validatePurchases(purchases);
    }

    public static final /* synthetic */ EncryptedSharedPrefManager access$getSecurePreferences$p(ImplTransactionsManager $this) {
        return $this.securePreferences;
    }

    public static final /* synthetic */ Function1 access$getPurchaseCallback$p(ImplTransactionsManager $this) {
        return $this.purchaseCallback;
    }
}

