/*
 * Decompiled with CFR 0.152.
 */
package tr.com.mobilex.products.network;

import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.mobilex.core.SystemInfo;
import tr.com.mobilex.core.logging.Logger;
import tr.com.mobilex.core.network.HttpClient;
import tr.com.mobilex.core.utils.ExceptionUtilsKt;
import tr.com.mobilex.core.utils.StringUtilsKt;
import tr.com.mobilex.products.network.ProductInfoDto;
import tr.com.mobilex.products.network.ProductsApi;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J<\u0010\r\u001a\u00020\u000e2\u0016\u0010\u000f\u001a\u0012\u0012\b\u0012\u00060\u0011j\u0002`\u0012\u0012\u0004\u0012\u00020\u000e0\u00102\u001a\u0010\u0013\u001a\u0016\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014\u0012\u0004\u0012\u00020\u000e0\u0010H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Ltr/com/mobilex/products/network/ImplProductsApi;", "Ltr/com/mobilex/products/network/ProductsApi;", "systemInfo", "Ltr/com/mobilex/core/SystemInfo;", "httpClient", "Ltr/com/mobilex/core/network/HttpClient;", "(Ltr/com/mobilex/core/SystemInfo;Ltr/com/mobilex/core/network/HttpClient;)V", "apiUrl", "", "baseHeaders", "", "getSystemInfo", "()Ltr/com/mobilex/core/SystemInfo;", "getAll", "", "onFailure", "Lkotlin/Function1;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onResponse", "", "Ltr/com/mobilex/products/network/ProductInfoDto;", "revenuex-android-sdk_release"})
public final class ImplProductsApi
implements ProductsApi {
    @NotNull
    private final SystemInfo systemInfo;
    @NotNull
    private final HttpClient httpClient;
    @NotNull
    private final String apiUrl;
    @NotNull
    private final Map<String, String> baseHeaders;

    public ImplProductsApi(@NotNull SystemInfo systemInfo, @NotNull HttpClient httpClient) {
        Intrinsics.checkNotNullParameter((Object)systemInfo, (String)"systemInfo");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        this.systemInfo = systemInfo;
        this.httpClient = httpClient;
        this.apiUrl = StringUtilsKt.getConcatenatedUrl(this.getSystemInfo().getRootUrl(), "api/products/");
        this.baseHeaders = MapsKt.emptyMap();
    }

    @Override
    @NotNull
    public SystemInfo getSystemInfo() {
        return this.systemInfo;
    }

    @Override
    public void getAll(@NotNull Function1<? super Exception, Unit> onFailure, @NotNull Function1<? super ProductInfoDto[], Unit> onResponse) {
        Map map;
        Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
        Intrinsics.checkNotNullParameter(onResponse, (String)"onResponse");
        String allProductsUrl = StringUtilsKt.getConcatenatedUrl(this.apiUrl, "all");
        Map newMap = map = MapsKt.toMutableMap(this.baseHeaders);
        boolean bl = false;
        newMap.put("clientid", this.getSystemInfo().getClientId());
        Map headers = map;
        HttpClient.DefaultImpls.get$default(this.httpClient, allProductsUrl, null, headers, (Function1)new Function1<Exception, Unit>(onFailure){
            final /* synthetic */ Function1<Exception, Unit> $onFailure;
            {
                this.$onFailure = $onFailure;
                super(1);
            }

            public final void invoke(@NotNull Exception exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                Logger.INSTANCE.error(ExceptionUtilsKt.getExceptionMessage(exception), exception);
                this.$onFailure.invoke((Object)exception);
            }
        }, (Function1)new Function1<ProductInfoDto[], Unit>(onResponse){
            final /* synthetic */ Function1<ProductInfoDto[], Unit> $onResponse;
            {
                this.$onResponse = $onResponse;
                super(1);
            }

            public final void invoke(@Nullable ProductInfoDto[] response) {
                String string = Arrays.toString(response);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
                Logger.debug$default(Logger.INSTANCE, Intrinsics.stringPlus((String)"ProductsApi getAll server response: ", (Object)string), null, 2, null);
                this.$onResponse.invoke((Object)response);
            }
        }, ProductInfoDto[].class, 2, null);
    }
}

