/*
 * Decompiled with CFR 0.152.
 */
package tr.com.mobilex.products.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.mobilex.core.billing.ProductInformationProvider;
import tr.com.mobilex.core.billing.ProductType;
import tr.com.mobilex.core.billing.RevXProduct;
import tr.com.mobilex.core.logging.Logger;
import tr.com.mobilex.core.utils.ExceptionUtilsKt;
import tr.com.mobilex.products.manager.ProductsManager;
import tr.com.mobilex.products.network.ProductInfoDto;
import tr.com.mobilex.products.network.ProductPlatform;
import tr.com.mobilex.products.network.ProductsApi;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0010H\u0016J0\u0010\u000b\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\b2\u0018\u0010\u0013\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\u000e0\u0014H\u0016J*\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0018\u0010\u0013\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\u000e0\u0014H\u0016R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ltr/com/mobilex/products/manager/ImplProductsManager;", "Ltr/com/mobilex/products/manager/ProductsManager;", "productsApi", "Ltr/com/mobilex/products/network/ProductsApi;", "productInformationProvider", "Ltr/com/mobilex/core/billing/ProductInformationProvider;", "(Ltr/com/mobilex/products/network/ProductsApi;Ltr/com/mobilex/core/billing/ProductInformationProvider;)V", "_products", "", "Ltr/com/mobilex/core/billing/RevXProduct;", "products", "getProducts", "()Ljava/util/List;", "fetchProducts", "", "onComplete", "Lkotlin/Function0;", "productIds", "", "onResponse", "Lkotlin/Function1;", "type", "Ltr/com/mobilex/core/billing/ProductType;", "revenuex-android-sdk_release"})
public final class ImplProductsManager
implements ProductsManager {
    @NotNull
    private final ProductsApi productsApi;
    @NotNull
    private final ProductInformationProvider productInformationProvider;
    @Nullable
    private List<RevXProduct> _products;

    public ImplProductsManager(@NotNull ProductsApi productsApi, @NotNull ProductInformationProvider productInformationProvider) {
        Intrinsics.checkNotNullParameter((Object)productsApi, (String)"productsApi");
        Intrinsics.checkNotNullParameter((Object)productInformationProvider, (String)"productInformationProvider");
        this.productsApi = productsApi;
        this.productInformationProvider = productInformationProvider;
    }

    @Override
    @NotNull
    public List<RevXProduct> getProducts() {
        List<RevXProduct> list = this._products;
        return list == null ? CollectionsKt.emptyList() : list;
    }

    @Override
    public void fetchProducts(@Nullable Function0<Unit> onComplete) {
        this.productsApi.getAll((Function1<? super Exception, Unit>)((Function1)new Function1<Exception, Unit>(this, onComplete){
            final /* synthetic */ ImplProductsManager this$0;
            final /* synthetic */ Function0<Unit> $onComplete;
            {
                this.this$0 = $receiver;
                this.$onComplete = $onComplete;
                super(1);
            }

            public final void invoke(@NotNull Exception it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger.INSTANCE.error(ExceptionUtilsKt.getExceptionMessage(it), it);
                ImplProductsManager.access$set_products$p(this.this$0, CollectionsKt.emptyList());
                Function0<Unit> function0 = this.$onComplete;
                if (function0 != null) {
                    function0.invoke();
                }
            }
        }), (Function1<? super ProductInfoDto[], Unit>)((Function1)new Function1<ProductInfoDto[], Unit>(this, onComplete){
            final /* synthetic */ ImplProductsManager this$0;
            final /* synthetic */ Function0<Unit> $onComplete;
            {
                this.this$0 = $receiver;
                this.$onComplete = $onComplete;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@Nullable ProductInfoDto[] response) {
                void $this$mapTo$iv$iv;
                Iterable $this$filterTo$iv$iv;
                String string = Arrays.toString(response);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
                Logger.debug$default(Logger.INSTANCE, Intrinsics.stringPlus((String)"fetchProducts response: ", (Object)string), null, 2, null);
                ProductInfoDto[] productInfoDtoArray = response;
                if (response == null) {
                    productInfoDtoArray = new ProductInfoDto[]{};
                }
                ProductInfoDto[] $this$filter$iv = productInfoDtoArray;
                boolean $i$f$filter = false;
                ProductInfoDto[] productInfoDtoArray2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                Iterator<T> iterator = $this$filterTo$iv$iv;
                int n = 0;
                int n2 = ((void)iterator).length;
                while (n < n2) {
                    CharSequence charSequence;
                    void element$iv$iv = iterator[n];
                    ++n;
                    void it = element$iv$iv;
                    boolean bl = false;
                    boolean bl2 = Intrinsics.areEqual((Object)it.getPlatform(), (Object)ProductPlatform.Android.getText()) && !((charSequence = (CharSequence)it.getProductId()) == null || StringsKt.isBlank((CharSequence)charSequence));
                    if (!bl2) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ProductInfoDto productInfoDto = (ProductInfoDto)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string2 = it.getProductId();
                    Intrinsics.checkNotNull((Object)string2);
                    collection.add(string2);
                }
                List filteredList = (List)destination$iv$iv;
                Logger.debug$default(Logger.INSTANCE, Intrinsics.stringPlus((String)"fetchProducts filtered product ids: ", (Object)filteredList), null, 2, null);
                if (((Collection)filteredList).isEmpty()) {
                    ImplProductsManager.access$set_products$p(this.this$0, CollectionsKt.emptyList());
                    Function0<Unit> function0 = this.$onComplete;
                    if (function0 != null) {
                        function0.invoke();
                    }
                    return;
                }
                ImplProductsManager.access$getProductInformationProvider$p(this.this$0).queryProductDetails(filteredList, ProductType.Subs, (Function1<? super List<RevXProduct>, Unit>)((Function1)new Function1<List<? extends RevXProduct>, Unit>(this.this$0, (List<String>)filteredList, this.$onComplete){
                    final /* synthetic */ ImplProductsManager this$0;
                    final /* synthetic */ List<String> $filteredList;
                    final /* synthetic */ Function0<Unit> $onComplete;
                    {
                        this.this$0 = $receiver;
                        this.$filteredList = $filteredList;
                        this.$onComplete = $onComplete;
                        super(1);
                    }

                    public final void invoke(@NotNull List<RevXProduct> subscriptions) {
                        Intrinsics.checkNotNullParameter(subscriptions, (String)"subscriptions");
                        ImplProductsManager.access$getProductInformationProvider$p(this.this$0).queryProductDetails(this.$filteredList, ProductType.InApp, (Function1<? super List<RevXProduct>, Unit>)((Function1)new Function1<List<? extends RevXProduct>, Unit>(subscriptions, this.this$0, this.$onComplete){
                            final /* synthetic */ List<RevXProduct> $subscriptions;
                            final /* synthetic */ ImplProductsManager this$0;
                            final /* synthetic */ Function0<Unit> $onComplete;
                            {
                                this.$subscriptions = $subscriptions;
                                this.this$0 = $receiver;
                                this.$onComplete = $onComplete;
                                super(1);
                            }

                            public final void invoke(@NotNull List<RevXProduct> inApps) {
                                Intrinsics.checkNotNullParameter(inApps, (String)"inApps");
                                List allProducts = CollectionsKt.plus((Collection)this.$subscriptions, (Iterable)inApps);
                                Logger.debug$default(Logger.INSTANCE, Intrinsics.stringPlus((String)"All products: ", (Object)allProducts), null, 2, null);
                                ImplProductsManager.access$set_products$p(this.this$0, allProducts);
                                Function0<Unit> function0 = this.$onComplete;
                                if (function0 != null) {
                                    function0.invoke();
                                }
                            }
                        }));
                    }
                }));
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void getProducts(@NotNull ProductType type, @NotNull Function1<? super List<RevXProduct>, Unit> onResponse) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter(onResponse, (String)"onResponse");
        List<RevXProduct> list = this._products;
        if (list != null) {
            void $this$filterTo$iv$iv;
            List<RevXProduct> products = list;
            boolean bl = false;
            Iterable $this$filter$iv = products;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                RevXProduct it = (RevXProduct)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getType() == type)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List filteredProducts = (List)destination$iv$iv;
            onResponse.invoke((Object)filteredProducts);
            return;
        }
        this.fetchProducts((Function0<Unit>)((Function0)new Function0<Unit>(this, onResponse, type){
            final /* synthetic */ ImplProductsManager this$0;
            final /* synthetic */ Function1<List<RevXProduct>, Unit> $onResponse;
            final /* synthetic */ ProductType $type;
            {
                this.this$0 = $receiver;
                this.$onResponse = $onResponse;
                this.$type = $type;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                List list;
                List list2 = ImplProductsManager.access$get_products$p(this.this$0);
                if (list2 == null) {
                    list = null;
                } else {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Iterable iterable = list2;
                    ProductType productType = this.$type;
                    boolean $i$f$filter = false;
                    void var6_4 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        RevXProduct it = (RevXProduct)element$iv$iv;
                        boolean bl = false;
                        if (!(it.getType() == productType)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                }
                List list3 = list;
                List filteredProducts = list3 == null ? CollectionsKt.emptyList() : list3;
                this.$onResponse.invoke((Object)filteredProducts);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void getProducts(@NotNull List<String> productIds, @NotNull Function1<? super List<RevXProduct>, Unit> onResponse) {
        Intrinsics.checkNotNullParameter(productIds, (String)"productIds");
        Intrinsics.checkNotNullParameter(onResponse, (String)"onResponse");
        List<RevXProduct> list = this._products;
        if (list != null) {
            void $this$filterTo$iv$iv;
            List<RevXProduct> products = list;
            boolean bl = false;
            Iterable $this$filter$iv = products;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                RevXProduct it = (RevXProduct)element$iv$iv;
                boolean bl2 = false;
                if (!productIds.contains(it.getProductId())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List filteredProducts = (List)destination$iv$iv;
            onResponse.invoke((Object)filteredProducts);
            return;
        }
        this.fetchProducts((Function0<Unit>)((Function0)new Function0<Unit>(this, onResponse, productIds){
            final /* synthetic */ ImplProductsManager this$0;
            final /* synthetic */ Function1<List<RevXProduct>, Unit> $onResponse;
            final /* synthetic */ List<String> $productIds;
            {
                this.this$0 = $receiver;
                this.$onResponse = $onResponse;
                this.$productIds = $productIds;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                List list;
                List list2 = ImplProductsManager.access$get_products$p(this.this$0);
                if (list2 == null) {
                    list = null;
                } else {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Iterable iterable = list2;
                    List<String> list3 = this.$productIds;
                    boolean $i$f$filter = false;
                    void var6_4 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        RevXProduct it = (RevXProduct)element$iv$iv;
                        boolean bl = false;
                        if (!list3.contains(it.getProductId())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                }
                List list4 = list;
                List filteredProducts = list4 == null ? CollectionsKt.emptyList() : list4;
                this.$onResponse.invoke((Object)filteredProducts);
            }
        }));
    }

    public static final /* synthetic */ void access$set_products$p(ImplProductsManager $this, List list) {
        $this._products = list;
    }

    public static final /* synthetic */ ProductInformationProvider access$getProductInformationProvider$p(ImplProductsManager $this) {
        return $this.productInformationProvider;
    }

    public static final /* synthetic */ List access$get_products$p(ImplProductsManager $this) {
        return $this._products;
    }
}

