/*
 * Decompiled with CFR 0.152.
 */
package tr.com.mobilex.offerings.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.mobilex.core.billing.RevXOffering;
import tr.com.mobilex.core.billing.RevXProduct;
import tr.com.mobilex.core.logging.Logger;
import tr.com.mobilex.core.utils.ExceptionUtilsKt;
import tr.com.mobilex.offerings.manager.OfferingsManager;
import tr.com.mobilex.offerings.network.OfferingsApi;
import tr.com.mobilex.offerings.network.OfferingsDto;
import tr.com.mobilex.offerings.network.OfferingsDtoKt;
import tr.com.mobilex.offerings.network.PackageDto;
import tr.com.mobilex.offerings.network.ProductDto;
import tr.com.mobilex.products.manager.ProductsManager;
import tr.com.mobilex.products.network.ProductPlatform;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0010H\u0016J\u001e\u0010\u0011\u001a\u00020\u000e2\u0014\u0010\u0012\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\u000e0\u0013H\u0016R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ltr/com/mobilex/offerings/manager/ImplOfferingsManager;", "Ltr/com/mobilex/offerings/manager/OfferingsManager;", "offeringsApi", "Ltr/com/mobilex/offerings/network/OfferingsApi;", "productsManager", "Ltr/com/mobilex/products/manager/ProductsManager;", "(Ltr/com/mobilex/offerings/network/OfferingsApi;Ltr/com/mobilex/products/manager/ProductsManager;)V", "_offerings", "", "Ltr/com/mobilex/core/billing/RevXOffering;", "offerings", "getOfferings", "()Ljava/util/List;", "fetchOfferings", "", "onComplete", "Lkotlin/Function0;", "getCurrentOffering", "onResponse", "Lkotlin/Function1;", "revenuex-android-sdk_release"})
public final class ImplOfferingsManager
implements OfferingsManager {
    @NotNull
    private final OfferingsApi offeringsApi;
    @NotNull
    private final ProductsManager productsManager;
    @Nullable
    private List<RevXOffering> _offerings;

    public ImplOfferingsManager(@NotNull OfferingsApi offeringsApi, @NotNull ProductsManager productsManager2) {
        Intrinsics.checkNotNullParameter((Object)offeringsApi, (String)"offeringsApi");
        Intrinsics.checkNotNullParameter((Object)productsManager2, (String)"productsManager");
        this.offeringsApi = offeringsApi;
        this.productsManager = productsManager2;
    }

    @Override
    @NotNull
    public List<RevXOffering> getOfferings() {
        List<RevXOffering> list = this._offerings;
        return list == null ? CollectionsKt.emptyList() : list;
    }

    @Override
    public void fetchOfferings(@Nullable Function0<Unit> onComplete) {
        this.offeringsApi.getOfferings((Function1<? super Exception, Unit>)((Function1)new Function1<Exception, Unit>(this, onComplete){
            final /* synthetic */ ImplOfferingsManager this$0;
            final /* synthetic */ Function0<Unit> $onComplete;
            {
                this.this$0 = $receiver;
                this.$onComplete = $onComplete;
                super(1);
            }

            public final void invoke(@NotNull Exception it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger.INSTANCE.error(ExceptionUtilsKt.getExceptionMessage(it), it);
                ImplOfferingsManager.access$set_offerings$p(this.this$0, CollectionsKt.emptyList());
                Function0<Unit> function0 = this.$onComplete;
                if (function0 != null) {
                    function0.invoke();
                }
            }
        }), (Function1<? super OfferingsDto, Unit>)((Function1)new Function1<OfferingsDto, Unit>(this, onComplete){
            final /* synthetic */ ImplOfferingsManager this$0;
            final /* synthetic */ Function0<Unit> $onComplete;
            {
                this.this$0 = $receiver;
                this.$onComplete = $onComplete;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@Nullable OfferingsDto response) {
                Logger.debug$default(Logger.INSTANCE, Intrinsics.stringPlus((String)"getOfferings response: ", (Object)response), null, 2, null);
                List filteredIdList = null;
                filteredIdList = CollectionsKt.emptyList();
                OfferingsDto offeringsDto = response;
                if (offeringsDto != null) {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    void $this$mapTo$iv$iv;
                    OfferingsDto offering = offeringsDto;
                    boolean bl = false;
                    Iterable $this$map$iv = offering.getPackages();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        String string;
                        ProductDto androidProduct;
                        Object v2;
                        Collection collection;
                        block9: {
                            void packageDto;
                            PackageDto packageDto2 = (PackageDto)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl2 = false;
                            Iterable $this$firstOrNull$iv = packageDto.getProducts();
                            boolean $i$f$firstOrNull = false;
                            for (T element$iv : $this$firstOrNull$iv) {
                                CharSequence charSequence;
                                ProductDto it = (ProductDto)element$iv;
                                boolean bl3 = false;
                                boolean bl4 = Intrinsics.areEqual((Object)it.getPlatform(), (Object)ProductPlatform.Android.getText()) && !((charSequence = (CharSequence)it.getIdentifier()) == null || StringsKt.isBlank((CharSequence)charSequence));
                                if (!bl4) continue;
                                v2 = element$iv;
                                break block9;
                            }
                            v2 = null;
                        }
                        ProductDto productDto = androidProduct = (ProductDto)v2;
                        if (productDto == null) {
                            string = "";
                        } else {
                            string = productDto.getIdentifier();
                            if (string == null) {
                                string = "";
                            }
                        }
                        collection.add(string);
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$filter = false;
                    $this$mapTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        String it = (String)element$iv$iv;
                        boolean bl5 = false;
                        if (!(!StringsKt.isBlank((CharSequence)it))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    filteredIdList = (List)destination$iv$iv;
                }
                Logger.debug$default(Logger.INSTANCE, Intrinsics.stringPlus((String)"fetchOfferings filtered product ids: ", (Object)filteredIdList), null, 2, null);
                Collection collection = filteredIdList;
                if (collection == null || collection.isEmpty()) {
                    ImplOfferingsManager.access$set_offerings$p(this.this$0, CollectionsKt.emptyList());
                    Function0<Unit> function0 = this.$onComplete;
                    if (function0 != null) {
                        function0.invoke();
                    }
                    return;
                }
                ImplOfferingsManager.access$getProductsManager$p(this.this$0).getProducts(filteredIdList, (Function1<? super List<RevXProduct>, Unit>)((Function1)new Function1<List<? extends RevXProduct>, Unit>(this.this$0, response, this.$onComplete){
                    final /* synthetic */ ImplOfferingsManager this$0;
                    final /* synthetic */ OfferingsDto $response;
                    final /* synthetic */ Function0<Unit> $onComplete;
                    {
                        this.this$0 = $receiver;
                        this.$response = $response;
                        this.$onComplete = $onComplete;
                        super(1);
                    }

                    public final void invoke(@NotNull List<RevXProduct> products) {
                        Intrinsics.checkNotNullParameter(products, (String)"products");
                        OfferingsDto offeringsDto = this.$response;
                        Intrinsics.checkNotNull((Object)offeringsDto);
                        ImplOfferingsManager.access$set_offerings$p(this.this$0, CollectionsKt.listOf((Object)OfferingsDtoKt.toRevXOffering(offeringsDto, products)));
                        Function0<Unit> function0 = this.$onComplete;
                        if (function0 != null) {
                            function0.invoke();
                        }
                    }
                }));
            }
        }));
    }

    @Override
    public void getCurrentOffering(@NotNull Function1<? super RevXOffering, Unit> onResponse) {
        Intrinsics.checkNotNullParameter(onResponse, (String)"onResponse");
        List<RevXOffering> list = this._offerings;
        if (list != null) {
            Object v1;
            block2: {
                List<RevXOffering> offerings = list;
                boolean bl = false;
                Iterable $this$firstOrNull$iv = offerings;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    RevXOffering it = (RevXOffering)element$iv;
                    boolean bl2 = false;
                    if (!it.isCurrent()) continue;
                    v1 = element$iv;
                    break block2;
                }
                v1 = null;
            }
            RevXOffering currentOffering = v1;
            onResponse.invoke((Object)currentOffering);
            return;
        }
        this.fetchOfferings((Function0<Unit>)((Function0)new Function0<Unit>(this, onResponse){
            final /* synthetic */ ImplOfferingsManager this$0;
            final /* synthetic */ Function1<RevXOffering, Unit> $onResponse;
            {
                this.this$0 = $receiver;
                this.$onResponse = $onResponse;
                super(0);
            }

            public final void invoke() {
                RevXOffering revXOffering;
                List list = ImplOfferingsManager.access$get_offerings$p(this.this$0);
                if (list == null) {
                    revXOffering = null;
                } else {
                    Object v2;
                    block3: {
                        Iterable $this$firstOrNull$iv = list;
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            RevXOffering it = (RevXOffering)element$iv;
                            boolean bl = false;
                            if (!it.isCurrent()) continue;
                            v2 = element$iv;
                            break block3;
                        }
                        v2 = null;
                    }
                    revXOffering = v2;
                }
                RevXOffering currentOffering = revXOffering;
                this.$onResponse.invoke(currentOffering);
            }
        }));
    }

    public static final /* synthetic */ void access$set_offerings$p(ImplOfferingsManager $this, List list) {
        $this._offerings = list;
    }

    public static final /* synthetic */ ProductsManager access$getProductsManager$p(ImplOfferingsManager $this) {
        return $this.productsManager;
    }

    public static final /* synthetic */ List access$get_offerings$p(ImplOfferingsManager $this) {
        return $this._offerings;
    }
}

