/*
 * Decompiled with CFR 0.152.
 */
package tr.com.mobilex.core.sharedpref;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.security.crypto.EncryptedSharedPreferences;
import androidx.security.crypto.MasterKey;
import com.google.gson.Gson;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ-\u0010\r\u001a\u0004\u0018\u0001H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0013\u00a2\u0006\u0002\u0010\u0014J%\u0010\u0015\u001a\u00020\n\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u0002H\u000e\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ltr/com/mobilex/core/sharedpref/EncryptedSharedPrefManager;", "", "()V", "gson", "Lcom/google/gson/Gson;", "masterKey", "Landroidx/security/crypto/MasterKey;", "sharedPreferences", "Landroid/content/SharedPreferences;", "createSecureSharedPreferences", "", "applicationContext", "Landroid/content/Context;", "read", "T", "Ljava/io/Serializable;", "key", "", "classType", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/io/Serializable;", "write", "value", "(Ljava/lang/String;Ljava/io/Serializable;)V", "revenuex-android-sdk_release"})
public final class EncryptedSharedPrefManager {
    @NotNull
    public static final EncryptedSharedPrefManager INSTANCE = new EncryptedSharedPrefManager();
    private static SharedPreferences sharedPreferences;
    private static MasterKey masterKey;
    @NotNull
    private static final Gson gson;

    private EncryptedSharedPrefManager() {
    }

    public final void createSecureSharedPreferences(@NotNull Context applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        MasterKey masterKey = new MasterKey.Builder(applicationContext, "_androidx_security_master_key_").setKeyScheme(MasterKey.KeyScheme.AES256_GCM).build();
        Intrinsics.checkNotNullExpressionValue((Object)masterKey, (String)"Builder(applicationConte\u2026GCM)\n            .build()");
        EncryptedSharedPrefManager.masterKey = masterKey;
        MasterKey masterKey2 = EncryptedSharedPrefManager.masterKey;
        if (masterKey2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"masterKey");
            masterKey2 = null;
        }
        masterKey = EncryptedSharedPreferences.create((Context)applicationContext, (String)"secure_shared_pref", (MasterKey)masterKey2, (EncryptedSharedPreferences.PrefKeyEncryptionScheme)EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV, (EncryptedSharedPreferences.PrefValueEncryptionScheme)EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM);
        Intrinsics.checkNotNullExpressionValue((Object)masterKey, (String)"create(\n            appl\u2026heme.AES256_GCM\n        )");
        sharedPreferences = masterKey;
    }

    public final <T extends Serializable> void write(@NotNull String key, @NotNull T value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        SharedPreferences sharedPreferences = EncryptedSharedPrefManager.sharedPreferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor $this$write_u24lambda_u2d0 = sharedPreferences.edit();
        boolean bl = false;
        $this$write_u24lambda_u2d0.putString(key, gson.toJson(value));
        $this$write_u24lambda_u2d0.apply();
    }

    @Nullable
    public final <T extends Serializable> T read(@NotNull String key, @NotNull Class<T> classType) {
        String serializedObject;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(classType, (String)"classType");
        SharedPreferences sharedPreferences = EncryptedSharedPrefManager.sharedPreferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
            sharedPreferences = null;
        }
        if ((serializedObject = sharedPreferences.getString(key, null)) == null) {
            return (T)((Serializable)((Object)serializedObject));
        }
        return (T)((Serializable)gson.fromJson(serializedObject, classType));
    }

    static {
        gson = new Gson();
    }
}

