/*
 * Decompiled with CFR 0.152.
 */
package tr.com.mobilex.core.network;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.mobilex.core.network.HttpClient;
import tr.com.mobilex.core.utils.RequestUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 &2\u00020\u0001:\u0001&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J/\u0010\u0005\u001a\u0004\u0018\u0001H\u0006\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ\u008e\u0001\u0010\r\u001a\u00020\u000e\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\u00122\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\u00122\u0016\u0010\u0014\u001a\u0012\u0012\b\u0012\u00060\u0016j\u0002`\u0017\u0012\u0004\u0012\u00020\u000e0\u00152\u0014\u0010\u0018\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H\u0006\u0012\u0004\u0012\u00020\u000e0\u00152\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000bH\u0016J\u0084\u0001\u0010\u0019\u001a\u00020\u000e\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\u00122\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\u00122\u0016\u0010\u0014\u001a\u0012\u0012\b\u0012\u00060\u0016j\u0002`\u0017\u0012\u0004\u0012\u00020\u000e0\u00152\u0014\u0010\u0018\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H\u0006\u0012\u0004\u0012\u00020\u000e0\u00152\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000bH\u0016JX\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000f\u001a\u00020\t2\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\u00122\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\u00122\u0016\u0010\u0014\u001a\u0012\u0012\b\u0012\u00060\u0016j\u0002`\u0017\u0012\u0004\u0012\u00020\u000e0\u0015H\u0002J(\u0010\u001c\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\u0012H\u0002JV\u0010\u001d\u001a\u00020\u000e\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001f2\u0016\u0010\u0014\u001a\u0012\u0012\b\u0012\u00060\u0016j\u0002`\u0017\u0012\u0004\u0012\u00020\u000e0\u00152\u0014\u0010\u0018\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H\u0006\u0012\u0004\u0012\u00020\u000e0\u00152\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000bH\u0002JV\u0010 \u001a\u00020\u000e\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010!\u001a\u00020\"2\u0016\u0010\u0014\u001a\u0012\u0012\b\u0012\u00060\u0016j\u0002`\u0017\u0012\u0004\u0012\u00020\u000e0\u00152\u0014\u0010\u0018\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H\u0006\u0012\u0004\u0012\u00020\u000e0\u00152\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000bH\u0002J\u008c\u0001\u0010#\u001a\u00020\u000e\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\u00122\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\u00122\u0016\u0010\u0014\u001a\u0012\u0012\b\u0012\u00060\u0016j\u0002`\u0017\u0012\u0004\u0012\u00020\u000e0\u00152\u0014\u0010\u0018\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H\u0006\u0012\u0004\u0012\u00020\u000e0\u00152\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000bH\u0016J\u008c\u0001\u0010$\u001a\u00020\u000e\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\u00122\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\u00122\u0016\u0010\u0014\u001a\u0012\u0012\b\u0012\u00060\u0016j\u0002`\u0017\u0012\u0004\u0012\u00020\u000e0\u00152\u0014\u0010\u0018\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H\u0006\u0012\u0004\u0012\u00020\u000e0\u00152\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000bH\u0016J\u008c\u0001\u0010%\u001a\u00020\u000e\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\u00122\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\u00122\u0016\u0010\u0014\u001a\u0012\u0012\b\u0012\u00060\u0016j\u0002`\u0017\u0012\u0004\u0012\u00020\u000e0\u00152\u0014\u0010\u0018\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H\u0006\u0012\u0004\u0012\u00020\u000e0\u00152\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Ltr/com/mobilex/core/network/DefaultHttpClient;", "Ltr/com/mobilex/core/network/HttpClient;", "client", "Lokhttp3/OkHttpClient;", "(Lokhttp3/OkHttpClient;)V", "decodeResponse", "T", "Ljava/io/Serializable;", "responseBody", "", "classType", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/io/Serializable;", "delete", "", "url", "jsonBody", "queryParams", "", "headers", "onFailure", "Lkotlin/Function1;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onResponse", "get", "getGenericRequestBuilder", "Lokhttp3/Request$Builder;", "getUrlWithParams", "handleResponse", "response", "Lokhttp3/Response;", "makeCall", "request", "Lokhttp3/Request;", "patch", "post", "put", "Companion", "revenuex-android-sdk_release"})
public final class DefaultHttpClient
implements HttpClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private static final Gson gson = new Gson();

    public DefaultHttpClient(@NotNull OkHttpClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
    }

    @Override
    public <T extends Serializable> void get(@NotNull String url, @Nullable Map<String, String> queryParams, @Nullable Map<String, String> headers, @NotNull Function1<? super Exception, Unit> onFailure, @NotNull Function1<? super T, Unit> onResponse, @NotNull Class<T> classType) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
        Intrinsics.checkNotNullParameter(onResponse, (String)"onResponse");
        Intrinsics.checkNotNullParameter(classType, (String)"classType");
        Request.Builder builder = this.getGenericRequestBuilder(url, queryParams, headers, onFailure);
        if (builder == null) {
            return;
        }
        Request.Builder requestBuilder = builder;
        Request getRequest = requestBuilder.get().build();
        this.makeCall(getRequest, onFailure, onResponse, classType);
    }

    @Override
    public <T extends Serializable> void post(@NotNull String url, @NotNull String jsonBody, @Nullable Map<String, String> queryParams, @Nullable Map<String, String> headers, @NotNull Function1<? super Exception, Unit> onFailure, @NotNull Function1<? super T, Unit> onResponse, @NotNull Class<T> classType) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)jsonBody, (String)"jsonBody");
        Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
        Intrinsics.checkNotNullParameter(onResponse, (String)"onResponse");
        Intrinsics.checkNotNullParameter(classType, (String)"classType");
        RequestBody body = RequestBody.Companion.create(jsonBody, MediaType.Companion.parse("application/json; charset=utf-8"));
        Request.Builder builder = this.getGenericRequestBuilder(url, queryParams, headers, onFailure);
        if (builder == null) {
            return;
        }
        Request.Builder requestBuilder = builder;
        Request postRequest = requestBuilder.post(body).build();
        this.makeCall(postRequest, onFailure, onResponse, classType);
    }

    @Override
    public <T extends Serializable> void put(@NotNull String url, @NotNull String jsonBody, @Nullable Map<String, String> queryParams, @Nullable Map<String, String> headers, @NotNull Function1<? super Exception, Unit> onFailure, @NotNull Function1<? super T, Unit> onResponse, @NotNull Class<T> classType) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)jsonBody, (String)"jsonBody");
        Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
        Intrinsics.checkNotNullParameter(onResponse, (String)"onResponse");
        Intrinsics.checkNotNullParameter(classType, (String)"classType");
        RequestBody body = RequestBody.Companion.create(jsonBody, MediaType.Companion.parse("application/json; charset=utf-8"));
        Request.Builder builder = this.getGenericRequestBuilder(url, queryParams, headers, onFailure);
        if (builder == null) {
            return;
        }
        Request.Builder requestBuilder = builder;
        Request putRequest = requestBuilder.put(body).build();
        this.makeCall(putRequest, onFailure, onResponse, classType);
    }

    @Override
    public <T extends Serializable> void patch(@NotNull String url, @NotNull String jsonBody, @Nullable Map<String, String> queryParams, @Nullable Map<String, String> headers, @NotNull Function1<? super Exception, Unit> onFailure, @NotNull Function1<? super T, Unit> onResponse, @NotNull Class<T> classType) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)jsonBody, (String)"jsonBody");
        Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
        Intrinsics.checkNotNullParameter(onResponse, (String)"onResponse");
        Intrinsics.checkNotNullParameter(classType, (String)"classType");
        RequestBody body = RequestBody.Companion.create(jsonBody, MediaType.Companion.parse("application/json; charset=utf-8"));
        Request.Builder builder = this.getGenericRequestBuilder(url, queryParams, headers, onFailure);
        if (builder == null) {
            return;
        }
        Request.Builder requestBuilder = builder;
        Request patchRequest = requestBuilder.patch(body).build();
        this.makeCall(patchRequest, onFailure, onResponse, classType);
    }

    @Override
    public <T extends Serializable> void delete(@NotNull String url, @Nullable String jsonBody, @Nullable Map<String, String> queryParams, @Nullable Map<String, String> headers, @NotNull Function1<? super Exception, Unit> onFailure, @NotNull Function1<? super T, Unit> onResponse, @NotNull Class<T> classType) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
        Intrinsics.checkNotNullParameter(onResponse, (String)"onResponse");
        Intrinsics.checkNotNullParameter(classType, (String)"classType");
        String string = jsonBody;
        RequestBody body = string == null ? null : RequestBody.Companion.create(string, MediaType.Companion.parse("application/json; charset=utf-8"));
        Request.Builder builder = this.getGenericRequestBuilder(url, queryParams, headers, onFailure);
        if (builder == null) {
            return;
        }
        Request.Builder requestBuilder = builder;
        Request deleteRequest = requestBuilder.delete(body).build();
        this.makeCall(deleteRequest, onFailure, onResponse, classType);
    }

    private final Request.Builder getGenericRequestBuilder(String url, Map<String, String> queryParams, Map<String, String> headers, Function1<? super Exception, Unit> onFailure) {
        String fullUrl = this.getUrlWithParams(url, queryParams);
        Request.Builder requestBuilder = null;
        try {
            requestBuilder = RequestUtilsKt.addHeaders(new Request.Builder().url(fullUrl), headers);
        }
        catch (IllegalArgumentException exception) {
            onFailure.invoke((Object)exception);
        }
        return requestBuilder;
    }

    private final String getUrlWithParams(String url, Map<String, String> queryParams) {
        HttpUrl httpUrl = HttpUrl.Companion.parse(url);
        if (httpUrl == null) {
            return "";
        }
        HttpUrl httpUrl2 = httpUrl;
        HttpUrl.Builder urlBuilder = httpUrl2.newBuilder();
        Map<String, String> map = queryParams;
        if (map != null) {
            Map<String, String> params = map;
            boolean bl = false;
            for (Map.Entry<String, String> entry : params.entrySet()) {
                urlBuilder.addQueryParameter(entry.getKey(), entry.getValue());
            }
        }
        return urlBuilder.build().toString();
    }

    private final <T extends Serializable> void makeCall(Request request, Function1<? super Exception, Unit> onFailure, Function1<? super T, Unit> onResponse, Class<T> classType) {
        this.client.newCall(request).enqueue(new Callback(onFailure, this, onResponse, classType){
            final /* synthetic */ Function1<Exception, Unit> $onFailure;
            final /* synthetic */ DefaultHttpClient this$0;
            final /* synthetic */ Function1<T, Unit> $onResponse;
            final /* synthetic */ Class<T> $classType;
            {
                this.$onFailure = $onFailure;
                this.this$0 = $receiver;
                this.$onResponse = $onResponse;
                this.$classType = $classType;
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$onFailure.invoke((Object)e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                DefaultHttpClient.access$handleResponse(this.this$0, response, this.$onFailure, this.$onResponse, this.$classType);
            }
        });
    }

    private final <T extends Serializable> void handleResponse(Response response, Function1<? super Exception, Unit> onFailure, Function1<? super T, Unit> onResponse, Class<T> classType) {
        if (response.isSuccessful() && response.code() >= 200 && response.code() < 300) {
            if (response.body() == null) {
                onResponse.invoke(null);
            } else {
                try {
                    ResponseBody responseBody = response.body();
                    Intrinsics.checkNotNull((Object)responseBody);
                    T result = this.decodeResponse(responseBody.string(), classType);
                    onResponse.invoke(result);
                }
                catch (JsonSyntaxException exception) {
                    onFailure.invoke((Object)exception);
                }
            }
        } else {
            onFailure.invoke((Object)new IOException(response.code() + " : " + response));
        }
    }

    private final <T extends Serializable> T decodeResponse(String responseBody, Class<T> classType) {
        Serializable result = Intrinsics.areEqual(classType, String.class) ? (Serializable)((Object)responseBody) : (Serializable)gson.fromJson(responseBody, classType);
        return (T)result;
    }

    public static final /* synthetic */ void access$handleResponse(DefaultHttpClient $this, Response response, Function1 onFailure, Function1 onResponse, Class classType) {
        $this.handleResponse(response, (Function1<? super Exception, Unit>)onFailure, onResponse, classType);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ltr/com/mobilex/core/network/DefaultHttpClient$Companion;", "", "()V", "gson", "Lcom/google/gson/Gson;", "revenuex-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

