/*
 * Decompiled with CFR 0.152.
 */
package tr.com.mobilex.core.db.dao;

import android.database.Cursor;
import androidx.collection.LongSparseArray;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import tr.com.mobilex.core.db.dao.UserDao;
import tr.com.mobilex.core.db.entity.AttributeEntity;
import tr.com.mobilex.core.db.entity.UserEntity;
import tr.com.mobilex.core.db.relational.UserWithAttributes;
import tr.com.mobilex.core.utils.Converters;

public final class UserDao_Impl
implements UserDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<UserEntity> __insertionAdapterOfUserEntity;
    private final Converters __converters = new Converters();
    private final EntityDeletionOrUpdateAdapter<UserEntity> __deletionAdapterOfUserEntity;
    private final EntityDeletionOrUpdateAdapter<UserEntity> __updateAdapterOfUserEntity;
    private final SharedSQLiteStatement __preparedStmtOfClear;

    public UserDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfUserEntity = new EntityInsertionAdapter<UserEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `User` (`id`,`applicationId`,`revenueXId`,`createdAt`,`updatedAt`,`lastSeenDate`) VALUES (nullif(?, 0),?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, UserEntity value) {
                stmt.bindLong(1, value.getId());
                if (value.getApplicationId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getApplicationId());
                }
                if (value.getRevenueXId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getRevenueXId());
                }
                Long _tmp = UserDao_Impl.this.__converters.dateToTimestamp(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindLong(4, _tmp.longValue());
                }
                Long _tmp_1 = UserDao_Impl.this.__converters.dateToTimestamp(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindLong(5, _tmp_1.longValue());
                }
                Long _tmp_2 = UserDao_Impl.this.__converters.dateToTimestamp(value.getLastSeenDate());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindLong(6, _tmp_2.longValue());
                }
            }
        };
        this.__deletionAdapterOfUserEntity = new EntityDeletionOrUpdateAdapter<UserEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `User` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, UserEntity value) {
                stmt.bindLong(1, value.getId());
            }
        };
        this.__updateAdapterOfUserEntity = new EntityDeletionOrUpdateAdapter<UserEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `User` SET `id` = ?,`applicationId` = ?,`revenueXId` = ?,`createdAt` = ?,`updatedAt` = ?,`lastSeenDate` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, UserEntity value) {
                stmt.bindLong(1, value.getId());
                if (value.getApplicationId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getApplicationId());
                }
                if (value.getRevenueXId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getRevenueXId());
                }
                Long _tmp = UserDao_Impl.this.__converters.dateToTimestamp(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindLong(4, _tmp.longValue());
                }
                Long _tmp_1 = UserDao_Impl.this.__converters.dateToTimestamp(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindLong(5, _tmp_1.longValue());
                }
                Long _tmp_2 = UserDao_Impl.this.__converters.dateToTimestamp(value.getLastSeenDate());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindLong(6, _tmp_2.longValue());
                }
                stmt.bindLong(7, value.getId());
            }
        };
        this.__preparedStmtOfClear = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM User";
                return "DELETE FROM User";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(UserEntity obj) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result = this.__insertionAdapterOfUserEntity.insertAndReturnId((Object)obj);
            this.__db.setTransactionSuccessful();
            long l = _result;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long[] insertListOfItems(List<? extends UserEntity> items) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            Long[] _result = this.__insertionAdapterOfUserEntity.insertAndReturnIdsArrayBox(items);
            this.__db.setTransactionSuccessful();
            Long[] longArray = _result;
            return longArray;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(UserEntity obj) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfUserEntity.handle((Object)obj);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(UserEntity obj) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfUserEntity.handle((Object)obj);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateListOfItems(List<? extends UserEntity> items) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfUserEntity.handleMultiple(items);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void clear() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClear.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClear.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UserWithAttributes> getUsersWithAttributes() {
        String _sql = "SELECT * FROM User";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM User", (int)0);
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<UserWithAttributes> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
            try {
                int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                int _cursorIndexOfApplicationId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"applicationId");
                int _cursorIndexOfRevenueXId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"revenueXId");
                int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                int _cursorIndexOfLastSeenDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastSeenDate");
                LongSparseArray _collectionAttributes = new LongSparseArray();
                while (_cursor.moveToNext()) {
                    long _tmpKey = _cursor.getLong(_cursorIndexOfId);
                    ArrayList _tmpAttributesCollection = (ArrayList)_collectionAttributes.get(_tmpKey);
                    if (_tmpAttributesCollection != null) continue;
                    _tmpAttributesCollection = new ArrayList();
                    _collectionAttributes.put(_tmpKey, _tmpAttributesCollection);
                }
                _cursor.moveToPosition(-1);
                this.__fetchRelationshipAttributeAstrComMobilexCoreDbEntityAttributeEntity((LongSparseArray<ArrayList<AttributeEntity>>)_collectionAttributes);
                ArrayList<UserWithAttributes> _result = new ArrayList<UserWithAttributes>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    UserEntity _tmpUser;
                    if (!(_cursor.isNull(_cursorIndexOfId) && _cursor.isNull(_cursorIndexOfApplicationId) && _cursor.isNull(_cursorIndexOfRevenueXId) && _cursor.isNull(_cursorIndexOfCreatedAt) && _cursor.isNull(_cursorIndexOfUpdatedAt) && _cursor.isNull(_cursorIndexOfLastSeenDate))) {
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        String _tmpApplicationId = _cursor.isNull(_cursorIndexOfApplicationId) ? null : _cursor.getString(_cursorIndexOfApplicationId);
                        String _tmpRevenueXId = _cursor.isNull(_cursorIndexOfRevenueXId) ? null : _cursor.getString(_cursorIndexOfRevenueXId);
                        Long _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                        Date _tmpCreatedAt = this.__converters.fromTimestamp(_tmp);
                        Long _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        Date _tmpUpdatedAt = this.__converters.fromTimestamp(_tmp_1);
                        Long _tmp_2 = _cursor.isNull(_cursorIndexOfLastSeenDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfLastSeenDate));
                        Date _tmpLastSeenDate = this.__converters.fromTimestamp(_tmp_2);
                        _tmpUser = new UserEntity(_tmpId, _tmpApplicationId, _tmpRevenueXId, _tmpCreatedAt, _tmpUpdatedAt, _tmpLastSeenDate);
                    } else {
                        _tmpUser = null;
                    }
                    ArrayList<AttributeEntity> _tmpAttributesCollection_1 = null;
                    long _tmpKey_1 = _cursor.getLong(_cursorIndexOfId);
                    _tmpAttributesCollection_1 = (ArrayList<AttributeEntity>)_collectionAttributes.get(_tmpKey_1);
                    if (_tmpAttributesCollection_1 == null) {
                        _tmpAttributesCollection_1 = new ArrayList<AttributeEntity>();
                    }
                    UserWithAttributes _item = new UserWithAttributes(_tmpUser, _tmpAttributesCollection_1);
                    _result.add(_item);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __fetchRelationshipAttributeAstrComMobilexCoreDbEntityAttributeEntity(LongSparseArray<ArrayList<AttributeEntity>> _map) {
        if (_map.isEmpty()) {
            return;
        }
        if (_map.size() > 999) {
            LongSparseArray _tmpInnerMap = new LongSparseArray(999);
            int _tmpIndex = 0;
            int _limit = _map.size();
            for (int _mapIndex = 0; _mapIndex < _limit; ++_mapIndex) {
                _tmpInnerMap.put(_map.keyAt(_mapIndex), (Object)((ArrayList)_map.valueAt(_mapIndex)));
                if (++_tmpIndex != 999) continue;
                this.__fetchRelationshipAttributeAstrComMobilexCoreDbEntityAttributeEntity((LongSparseArray<ArrayList<AttributeEntity>>)_tmpInnerMap);
                _tmpInnerMap = new LongSparseArray(999);
                _tmpIndex = 0;
            }
            if (_tmpIndex > 0) {
                this.__fetchRelationshipAttributeAstrComMobilexCoreDbEntityAttributeEntity((LongSparseArray<ArrayList<AttributeEntity>>)_tmpInnerMap);
            }
            return;
        }
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT `id`,`userId`,`name`,`value` FROM `Attribute` WHERE `userId` IN (");
        int _inputSize = _map.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (int i = 0; i < _map.size(); ++i) {
            long _item = _map.keyAt(i);
            _stmt.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        try (Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_stmt, (boolean)false, null);){
            int _itemKeyIndex = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"userId");
            if (_itemKeyIndex == -1) {
                return;
            }
            boolean _cursorIndexOfId = false;
            boolean _cursorIndexOfUserId = true;
            int _cursorIndexOfName = 2;
            int _cursorIndexOfValue = 3;
            while (_cursor.moveToNext()) {
                long _tmpKey = _cursor.getLong(_itemKeyIndex);
                ArrayList _tmpRelation = (ArrayList)_map.get(_tmpKey);
                if (_tmpRelation == null) continue;
                long _tmpId = _cursor.getLong(0);
                long _tmpUserId = _cursor.getLong(1);
                String _tmpName = _cursor.isNull(2) ? null : _cursor.getString(2);
                String _tmpValue = _cursor.isNull(3) ? null : _cursor.getString(3);
                AttributeEntity _item_1 = new AttributeEntity(_tmpId, _tmpUserId, _tmpName, _tmpValue);
                _tmpRelation.add(_item_1);
            }
        }
    }
}

