/*
 * Decompiled with CFR 0.152.
 */
package tr.com.mobilex.core.db;

import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tr.com.mobilex.core.db.RevXRoomDatabase;
import tr.com.mobilex.core.db.dao.AttributeDao;
import tr.com.mobilex.core.db.dao.AttributeDao_Impl;
import tr.com.mobilex.core.db.dao.UserDao;
import tr.com.mobilex.core.db.dao.UserDao_Impl;

public final class RevXRoomDatabase_Impl
extends RevXRoomDatabase {
    private volatile UserDao _userDao;
    private volatile AttributeDao _attributeDao;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(1){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `User` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `applicationId` TEXT, `revenueXId` TEXT, `createdAt` INTEGER, `updatedAt` INTEGER, `lastSeenDate` INTEGER)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `Attribute` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `userId` INTEGER NOT NULL, `name` TEXT, `value` TEXT, FOREIGN KEY(`userId`) REFERENCES `User`(`id`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, 'd1b063807f13b4e6368040d39bc7e711')");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `User`");
                _db.execSQL("DROP TABLE IF EXISTS `Attribute`");
                if (RevXRoomDatabase_Impl.this.mCallbacks != null) {
                    int _size = RevXRoomDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)RevXRoomDatabase_Impl.this.mCallbacks.get(_i)).onDestructiveMigration(_db);
                    }
                }
            }

            protected void onCreate(SupportSQLiteDatabase _db) {
                if (RevXRoomDatabase_Impl.this.mCallbacks != null) {
                    int _size = RevXRoomDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)RevXRoomDatabase_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                RevXRoomDatabase_Impl.this.mDatabase = _db;
                _db.execSQL("PRAGMA foreign_keys = ON");
                RevXRoomDatabase_Impl.this.internalInitInvalidationTracker(_db);
                if (RevXRoomDatabase_Impl.this.mCallbacks != null) {
                    int _size = RevXRoomDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)RevXRoomDatabase_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            public void onPreMigrate(SupportSQLiteDatabase _db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)_db);
            }

            public void onPostMigrate(SupportSQLiteDatabase _db) {
            }

            protected RoomOpenHelper.ValidationResult onValidateSchema(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsUser = new HashMap<String, TableInfo.Column>(6);
                _columnsUser.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                _columnsUser.put("applicationId", new TableInfo.Column("applicationId", "TEXT", false, 0, null, 1));
                _columnsUser.put("revenueXId", new TableInfo.Column("revenueXId", "TEXT", false, 0, null, 1));
                _columnsUser.put("createdAt", new TableInfo.Column("createdAt", "INTEGER", false, 0, null, 1));
                _columnsUser.put("updatedAt", new TableInfo.Column("updatedAt", "INTEGER", false, 0, null, 1));
                _columnsUser.put("lastSeenDate", new TableInfo.Column("lastSeenDate", "INTEGER", false, 0, null, 1));
                HashSet _foreignKeysUser = new HashSet(0);
                HashSet _indicesUser = new HashSet(0);
                TableInfo _infoUser = new TableInfo("User", _columnsUser, _foreignKeysUser, _indicesUser);
                TableInfo _existingUser = TableInfo.read((SupportSQLiteDatabase)_db, (String)"User");
                if (!_infoUser.equals((Object)_existingUser)) {
                    return new RoomOpenHelper.ValidationResult(false, "User(tr.com.mobilex.core.db.entity.UserEntity).\n Expected:\n" + _infoUser + "\n Found:\n" + _existingUser);
                }
                HashMap<String, TableInfo.Column> _columnsAttribute = new HashMap<String, TableInfo.Column>(4);
                _columnsAttribute.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                _columnsAttribute.put("userId", new TableInfo.Column("userId", "INTEGER", true, 0, null, 1));
                _columnsAttribute.put("name", new TableInfo.Column("name", "TEXT", false, 0, null, 1));
                _columnsAttribute.put("value", new TableInfo.Column("value", "TEXT", false, 0, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysAttribute = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysAttribute.add(new TableInfo.ForeignKey("User", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("id")));
                HashSet _indicesAttribute = new HashSet(0);
                TableInfo _infoAttribute = new TableInfo("Attribute", _columnsAttribute, _foreignKeysAttribute, _indicesAttribute);
                TableInfo _existingAttribute = TableInfo.read((SupportSQLiteDatabase)_db, (String)"Attribute");
                if (!_infoAttribute.equals((Object)_existingAttribute)) {
                    return new RoomOpenHelper.ValidationResult(false, "Attribute(tr.com.mobilex.core.db.entity.AttributeEntity).\n Expected:\n" + _infoAttribute + "\n Found:\n" + _existingAttribute);
                }
                return new RoomOpenHelper.ValidationResult(true, null);
            }
        }, "d1b063807f13b4e6368040d39bc7e711", "471130e11375834b7cac2312d751d8e1");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"User", "Attribute"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        boolean _supportsDeferForeignKeys = Build.VERSION.SDK_INT >= 21;
        try {
            if (!_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA foreign_keys = FALSE");
            }
            super.beginTransaction();
            if (_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA defer_foreign_keys = TRUE");
            }
            _db.execSQL("DELETE FROM `User`");
            _db.execSQL("DELETE FROM `Attribute`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            if (!_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA foreign_keys = TRUE");
            }
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
        HashMap _typeConvertersMap = new HashMap();
        _typeConvertersMap.put(UserDao.class, UserDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(AttributeDao.class, AttributeDao_Impl.getRequiredConverters());
        return _typeConvertersMap;
    }

    public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
        HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
        return _autoMigrationSpecsSet;
    }

    public List<Migration> getAutoMigrations(@NonNull Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecsMap) {
        return Arrays.asList(new Migration[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserDao userDao() {
        if (this._userDao != null) {
            return this._userDao;
        }
        RevXRoomDatabase_Impl revXRoomDatabase_Impl = this;
        synchronized (revXRoomDatabase_Impl) {
            if (this._userDao == null) {
                this._userDao = new UserDao_Impl(this);
            }
            return this._userDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttributeDao attributeDao() {
        if (this._attributeDao != null) {
            return this._attributeDao;
        }
        RevXRoomDatabase_Impl revXRoomDatabase_Impl = this;
        synchronized (revXRoomDatabase_Impl) {
            if (this._attributeDao == null) {
                this._attributeDao = new AttributeDao_Impl(this);
            }
            return this._attributeDao;
        }
    }
}

