/*
 * Decompiled with CFR 0.152.
 */
package tr.com.mobilex.core.billing;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import androidx.lifecycle.MutableLiveData;
import com.android.billingclient.api.BillingClient;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingFlowParams;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.PurchaseHistoryRecord;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.SkuDetails;
import com.android.billingclient.api.SkuDetailsParams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.mobilex.core.billing.BillingClientManager;
import tr.com.mobilex.core.billing.ImplBillingClientManager;
import tr.com.mobilex.core.billing.NewPurchaseListener;
import tr.com.mobilex.core.billing.ProductType;
import tr.com.mobilex.core.billing.RevXProduct;
import tr.com.mobilex.core.billing.RevXPurchase;
import tr.com.mobilex.core.billing.RevXPurchaseHistory;
import tr.com.mobilex.core.billing.SetupCompletionListener;
import tr.com.mobilex.core.coroutine.DispatcherProvider;
import tr.com.mobilex.core.logging.Logger;
import tr.com.mobilex.core.utils.BillingUtilsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 D2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001DB#\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\u0014\u0010$\u001a\u0004\u0018\u00010\u00112\b\u0010%\u001a\u0004\u0018\u00010\u001fH\u0002J\b\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020*H\u0016JD\u0010+\u001a\u00020'2\u0006\u0010)\u001a\u00020*2\u000e\u0010,\u001a\n\u0012\u0004\u0012\u00020.\u0018\u00010-2\u0006\u0010/\u001a\u00020!2\u001a\u00100\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170-\u0012\u0004\u0012\u00020'\u0018\u000101H\u0002J \u00102\u001a\u00020'2\u0006\u0010)\u001a\u00020*2\u000e\u00103\u001a\n\u0012\u0004\u0012\u00020#\u0018\u000104H\u0016JB\u00105\u001a\u00020'2\u0006\u0010)\u001a\u00020*2\f\u00103\u001a\b\u0012\u0004\u0012\u00020#0-2\u0006\u0010/\u001a\u00020!2\u001a\u00100\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110-\u0012\u0004\u0012\u00020'\u0018\u000101H\u0002JD\u00106\u001a\u00020'2\u0006\u0010)\u001a\u00020*2\u000e\u00107\u001a\n\u0012\u0004\u0012\u000208\u0018\u0001042\u0006\u0010/\u001a\u00020!2\u001a\u00100\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0-\u0012\u0004\u0012\u00020'\u0018\u000101H\u0002J<\u00109\u001a\u00020'2\f\u00103\u001a\b\u0012\u0004\u0012\u00020#0-2\u0006\u0010:\u001a\u00020!2\u001c\b\u0002\u00100\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110-\u0012\u0004\u0012\u00020'\u0018\u000101H\u0002J\"\u0010;\u001a\u00020'2\u0006\u0010<\u001a\u00020=2\u0006\u0010%\u001a\u00020\u001f2\b\u0010>\u001a\u0004\u0018\u00010\u001fH\u0016J:\u0010?\u001a\u00020'2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00100-2\u0006\u0010/\u001a\u00020!2\u001a\u00100\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0-\u0012\u0004\u0012\u00020'\u0018\u000101H\u0016J,\u0010A\u001a\u00020'2\u0006\u0010/\u001a\u00020!2\u001a\u00100\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170-\u0012\u0004\u0012\u00020'\u0018\u000101H\u0016J,\u0010B\u001a\u00020'2\u0006\u0010/\u001a\u00020!2\u001a\u00100\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110-\u0012\u0004\u0012\u00020'\u0018\u000101H\u0016J\b\u0010C\u001a\u00020'H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R \u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00170\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR \u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001f0\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Ltr/com/mobilex/core/billing/ImplBillingClientManager;", "Ltr/com/mobilex/core/billing/BillingClientManager;", "Lcom/android/billingclient/api/BillingClientStateListener;", "Lcom/android/billingclient/api/PurchasesUpdatedListener;", "application", "Landroid/app/Application;", "setupCompletionListener", "Ltr/com/mobilex/core/billing/SetupCompletionListener;", "newPurchaseListener", "Ltr/com/mobilex/core/billing/NewPurchaseListener;", "(Landroid/app/Application;Ltr/com/mobilex/core/billing/SetupCompletionListener;Ltr/com/mobilex/core/billing/NewPurchaseListener;)V", "billingClient", "Lcom/android/billingclient/api/BillingClient;", "currentPurchases", "Landroidx/lifecycle/MutableLiveData;", "", "", "Ltr/com/mobilex/core/billing/RevXPurchase;", "getNewPurchaseListener", "()Ltr/com/mobilex/core/billing/NewPurchaseListener;", "setNewPurchaseListener", "(Ltr/com/mobilex/core/billing/NewPurchaseListener;)V", "previousPurchases", "Ltr/com/mobilex/core/billing/RevXPurchaseHistory;", "reconnectMilliseconds", "", "getSetupCompletionListener", "()Ltr/com/mobilex/core/billing/SetupCompletionListener;", "setSetupCompletionListener", "(Ltr/com/mobilex/core/billing/SetupCompletionListener;)V", "skusWithSkuDetails", "Ltr/com/mobilex/core/billing/RevXProduct;", "findProductTypeForPurchase", "Ltr/com/mobilex/core/billing/ProductType;", "purchase", "Lcom/android/billingclient/api/Purchase;", "findPurchaseForProduct", "product", "onBillingServiceDisconnected", "", "onBillingSetupFinished", "billingResult", "Lcom/android/billingclient/api/BillingResult;", "onPurchaseHistoryResponse", "purchaseHistoryList", "", "Lcom/android/billingclient/api/PurchaseHistoryRecord;", "type", "callback", "Lkotlin/Function1;", "onPurchasesUpdated", "purchaseList", "", "onQueryPurchasesResponse", "onSkuDetailsResponse", "skuDetailsList", "Lcom/android/billingclient/api/SkuDetails;", "processPurchaseList", "productType", "purchaseProduct", "activity", "Landroid/app/Activity;", "upgradedProduct", "queryProductDetails", "productIds", "queryPurchaseHistory", "queryPurchases", "retryBillingServiceConnectionWithExponentialBackoff", "Companion", "revenuex-android-sdk_release"})
public final class ImplBillingClientManager
implements BillingClientManager,
BillingClientStateListener,
PurchasesUpdatedListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private SetupCompletionListener setupCompletionListener;
    @Nullable
    private NewPurchaseListener newPurchaseListener;
    @NotNull
    private final BillingClient billingClient;
    private long reconnectMilliseconds;
    @NotNull
    private final MutableLiveData<Map<String, RevXProduct>> skusWithSkuDetails;
    @NotNull
    private final MutableLiveData<Map<String, RevXPurchaseHistory>> previousPurchases;
    @NotNull
    private final MutableLiveData<Map<String, RevXPurchase>> currentPurchases;
    @Nullable
    private static volatile ImplBillingClientManager INSTANCE;
    @NotNull
    private static final Handler handler;

    private ImplBillingClientManager(Application application, SetupCompletionListener setupCompletionListener, NewPurchaseListener newPurchaseListener) {
        this.setupCompletionListener = setupCompletionListener;
        this.newPurchaseListener = newPurchaseListener;
        BillingClient billingClient = BillingClient.newBuilder((Context)((Context)application)).setListener((PurchasesUpdatedListener)this).enablePendingPurchases().build();
        Intrinsics.checkNotNullExpressionValue((Object)billingClient, (String)"newBuilder(application)\n\u2026chases()\n        .build()");
        this.billingClient = billingClient;
        this.reconnectMilliseconds = 1000L;
        this.skusWithSkuDetails = new MutableLiveData((Object)new LinkedHashMap());
        this.previousPurchases = new MutableLiveData((Object)new LinkedHashMap());
        this.currentPurchases = new MutableLiveData((Object)new LinkedHashMap());
        if (!this.billingClient.isReady()) {
            Logger.info$default(Logger.INSTANCE, "BillingClient: Start connection...", null, 2, null);
            this.billingClient.startConnection((BillingClientStateListener)this);
        }
    }

    @Override
    @Nullable
    public SetupCompletionListener getSetupCompletionListener() {
        return this.setupCompletionListener;
    }

    @Override
    public void setSetupCompletionListener(@Nullable SetupCompletionListener setupCompletionListener) {
        this.setupCompletionListener = setupCompletionListener;
    }

    @Override
    @Nullable
    public NewPurchaseListener getNewPurchaseListener() {
        return this.newPurchaseListener;
    }

    @Override
    public void setNewPurchaseListener(@Nullable NewPurchaseListener newPurchaseListener) {
        this.newPurchaseListener = newPurchaseListener;
    }

    public void onBillingSetupFinished(@NotNull BillingResult billingResult) {
        Intrinsics.checkNotNullParameter((Object)billingResult, (String)"billingResult");
        int responseCode = billingResult.getResponseCode();
        String string = billingResult.getDebugMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"billingResult.debugMessage");
        String debugMessage = string;
        Logger.debug$default(Logger.INSTANCE, "onBillingSetupFinished: responseCode: " + responseCode + " message: " + debugMessage, null, 2, null);
        if (responseCode == 0) {
            Logger.info$default(Logger.INSTANCE, "BillingClient: Connection established", null, 2, null);
            this.reconnectMilliseconds = 1000L;
            SetupCompletionListener setupCompletionListener = this.getSetupCompletionListener();
            if (setupCompletionListener != null) {
                setupCompletionListener.onSetupComplete();
            }
        } else {
            this.retryBillingServiceConnectionWithExponentialBackoff();
        }
    }

    public void onBillingServiceDisconnected() {
        this.retryBillingServiceConnectionWithExponentialBackoff();
    }

    @Override
    public void queryProductDetails(@NotNull List<String> productIds, @NotNull ProductType type, @Nullable Function1<? super List<RevXProduct>, Unit> callback) {
        Intrinsics.checkNotNullParameter(productIds, (String)"productIds");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)DispatcherProvider.INSTANCE.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(type, productIds, this, callback, null){
            int label;
            final /* synthetic */ ProductType $type;
            final /* synthetic */ List<String> $productIds;
            final /* synthetic */ ImplBillingClientManager this$0;
            final /* synthetic */ Function1<List<RevXProduct>, Unit> $callback;
            {
                this.$type = $type;
                this.$productIds = $productIds;
                this.this$0 = $receiver;
                this.$callback = $callback;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        SkuDetailsParams skuDetailsParams = SkuDetailsParams.newBuilder().setType(this.$type.getText()).setSkusList(this.$productIds).build();
                        Intrinsics.checkNotNullExpressionValue((Object)skuDetailsParams, (String)"newBuilder()\n           \u2026\n                .build()");
                        SkuDetailsParams params = skuDetailsParams;
                        ImplBillingClientManager.access$getBillingClient$p(this.this$0).querySkuDetailsAsync(params, (arg_0, arg_1) -> queryProductDetails.1.invokeSuspend$lambda-0(this.this$0, this.$type, this.$callback, arg_0, arg_1));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda-0(ImplBillingClientManager this$0, ProductType $type, Function1 $callback, BillingResult billingResult, List skuDetailsList) {
                Intrinsics.checkNotNullExpressionValue((Object)billingResult, (String)"billingResult");
                ImplBillingClientManager.access$onSkuDetailsResponse(this$0, billingResult, skuDetailsList, $type, $callback);
            }
        }), (int)3, null);
    }

    @Override
    public void queryPurchaseHistory(@NotNull ProductType type, @Nullable Function1<? super List<RevXPurchaseHistory>, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)DispatcherProvider.INSTANCE.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, type, callback, null){
            int label;
            final /* synthetic */ ImplBillingClientManager this$0;
            final /* synthetic */ ProductType $type;
            final /* synthetic */ Function1<List<RevXPurchaseHistory>, Unit> $callback;
            {
                this.this$0 = $receiver;
                this.$type = $type;
                this.$callback = $callback;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ImplBillingClientManager.access$getBillingClient$p(this.this$0).queryPurchaseHistoryAsync(this.$type.getText(), (arg_0, arg_1) -> queryPurchaseHistory.1.invokeSuspend$lambda-0(this.this$0, this.$type, this.$callback, arg_0, arg_1));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda-0(ImplBillingClientManager this$0, ProductType $type, Function1 $callback, BillingResult billingResult, List purchaseHistoryList) {
                Intrinsics.checkNotNullExpressionValue((Object)billingResult, (String)"billingResult");
                ImplBillingClientManager.access$onPurchaseHistoryResponse(this$0, billingResult, purchaseHistoryList, $type, $callback);
            }
        }), (int)3, null);
    }

    @Override
    public void queryPurchases(@NotNull ProductType type, @Nullable Function1<? super List<RevXPurchase>, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)DispatcherProvider.INSTANCE.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, type, callback, null){
            int label;
            final /* synthetic */ ImplBillingClientManager this$0;
            final /* synthetic */ ProductType $type;
            final /* synthetic */ Function1<List<RevXPurchase>, Unit> $callback;
            {
                this.this$0 = $receiver;
                this.$type = $type;
                this.$callback = $callback;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ImplBillingClientManager.access$getBillingClient$p(this.this$0).queryPurchasesAsync(this.$type.getText(), (arg_0, arg_1) -> queryPurchases.1.invokeSuspend$lambda-0(this.this$0, this.$type, this.$callback, arg_0, arg_1));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda-0(ImplBillingClientManager this$0, ProductType $type, Function1 $callback, BillingResult billingResult, List purchaseList) {
                Intrinsics.checkNotNullExpressionValue((Object)billingResult, (String)"billingResult");
                Intrinsics.checkNotNullExpressionValue((Object)purchaseList, (String)"purchaseList");
                ImplBillingClientManager.access$onQueryPurchasesResponse(this$0, billingResult, purchaseList, $type, $callback);
            }
        }), (int)3, null);
    }

    @Override
    public void purchaseProduct(@NotNull Activity activity, @NotNull RevXProduct product, @Nullable RevXProduct upgradedProduct) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)product, (String)"product");
        BillingFlowParams.Builder builder = BillingFlowParams.newBuilder().setSkuDetails(new SkuDetails(product.getOriginalJson()));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()\n           \u2026ls(product.originalJson))");
        BillingFlowParams.Builder billingFlowParamsBuilder = builder;
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)DispatcherProvider.INSTANCE.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, upgradedProduct, activity, billingFlowParamsBuilder, null){
            int label;
            final /* synthetic */ ImplBillingClientManager this$0;
            final /* synthetic */ RevXProduct $upgradedProduct;
            final /* synthetic */ Activity $activity;
            final /* synthetic */ BillingFlowParams.Builder $billingFlowParamsBuilder;
            {
                this.this$0 = $receiver;
                this.$upgradedProduct = $upgradedProduct;
                this.$activity = $activity;
                this.$billingFlowParamsBuilder = $billingFlowParamsBuilder;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        RevXPurchase revXPurchase;
                        RevXPurchase currentSubscription;
                        ResultKt.throwOnFailure((Object)object);
                        RevXPurchase revXPurchase2 = currentSubscription = ImplBillingClientManager.access$findPurchaseForProduct(this.this$0, this.$upgradedProduct);
                        if (revXPurchase2 != null) {
                            revXPurchase = revXPurchase2;
                            BillingFlowParams.Builder builder = this.$billingFlowParamsBuilder;
                            boolean bl = false;
                            builder.setSubscriptionUpdateParams(BillingFlowParams.SubscriptionUpdateParams.newBuilder().setOldSkuPurchaseToken(currentSubscription.getPurchaseToken()).build());
                        }
                        revXPurchase = ImplBillingClientManager.access$getBillingClient$p(this.this$0).launchBillingFlow(this.$activity, this.$billingFlowParamsBuilder.build());
                        Intrinsics.checkNotNullExpressionValue((Object)revXPurchase, (String)"billingClient.launchBill\u2026lowParamsBuilder.build())");
                        RevXPurchase result = revXPurchase;
                        if (result.getResponseCode() != 0) {
                            Logger.error$default(Logger.INSTANCE, Intrinsics.stringPlus((String)"Launch billing flow failed: ", (Object)result.getDebugMessage()), null, 2, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public void onPurchasesUpdated(@NotNull BillingResult billingResult, @Nullable List<Purchase> purchaseList) {
        Intrinsics.checkNotNullParameter((Object)billingResult, (String)"billingResult");
        int responseCode = billingResult.getResponseCode();
        String string = billingResult.getDebugMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"billingResult.debugMessage");
        String debugMessage = string;
        switch (responseCode) {
            case 0: {
                Object v0;
                Logger.debug$default(Logger.INSTANCE, "onPurchasesUpdated: responseCode: " + responseCode + " message: " + debugMessage, null, 2, null);
                Collection collection = purchaseList;
                if (collection == null || collection.isEmpty()) {
                    Logger.error$default(Logger.INSTANCE, "onPurchasesUpdated: Empty Purchase List Returned from OK response!", null, 2, null);
                    break;
                }
                Iterable $this$maxByOrNull$iv = purchaseList;
                boolean $i$f$maxByOrNull = false;
                Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v0 = null;
                } else {
                    Object maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v0 = maxElem$iv;
                    } else {
                        Purchase it = (Purchase)maxElem$iv;
                        boolean bl = false;
                        long maxValue$iv = it.getPurchaseTime();
                        do {
                            Object e$iv = iterator$iv.next();
                            Purchase it2 = (Purchase)e$iv;
                            $i$a$-maxByOrNull-ImplBillingClientManager$onPurchasesUpdated$lastPurchase$1 = false;
                            long v$iv = it2.getPurchaseTime();
                            if (maxValue$iv >= v$iv) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v0 = maxElem$iv;
                    }
                }
                Intrinsics.checkNotNull(v0);
                Purchase lastPurchase = v0;
                ProductType productType = this.findProductTypeForPurchase(lastPurchase);
                ImplBillingClientManager.processPurchaseList$default(this, purchaseList, productType, null, 4, null);
                NewPurchaseListener newPurchaseListener = this.getNewPurchaseListener();
                if (newPurchaseListener == null) break;
                newPurchaseListener.onNewPurchaseComplete(BillingUtilsKt.toRevXPurchase(lastPurchase, productType));
                break;
            }
            case 1: {
                Logger.info$default(Logger.INSTANCE, "onPurchasesUpdated: User canceled the purchase", null, 2, null);
                break;
            }
            case 7: {
                Logger.info$default(Logger.INSTANCE, "onPurchasesUpdated: The user already owns this item", null, 2, null);
                break;
            }
            case 5: {
                Logger.error$default(Logger.INSTANCE, "onPurchasesUpdated: Developer error thrown", null, 2, null);
                break;
            }
            default: {
                Logger.error$default(Logger.INSTANCE, "onPurchasesUpdated: responseCode: " + responseCode + " message: " + debugMessage, null, 2, null);
            }
        }
    }

    private final void retryBillingServiceConnectionWithExponentialBackoff() {
        handler.postDelayed(() -> ImplBillingClientManager.retryBillingServiceConnectionWithExponentialBackoff$lambda-1(this), this.reconnectMilliseconds);
        this.reconnectMilliseconds = Math.min(this.reconnectMilliseconds * (long)2, 900000L);
    }

    /*
     * WARNING - void declaration
     */
    private final void onSkuDetailsResponse(BillingResult billingResult, List<SkuDetails> skuDetailsList, ProductType type, Function1<? super List<RevXProduct>, Unit> callback) {
        int responseCode = billingResult.getResponseCode();
        String string = billingResult.getDebugMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"billingResult.debugMessage");
        String debugMessage = string;
        switch (responseCode) {
            case 0: {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = skuDetailsList == null ? CollectionsKt.emptyList() : skuDetailsList;
                boolean $i$f$map = false;
                void var11_11 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SkuDetails skuDetails = (SkuDetails)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(BillingUtilsKt.toRevXProduct((SkuDetails)it));
                }
                List skuDetails = (List)destination$iv$iv;
                Logger.debug$default(Logger.INSTANCE, "onSkuDetailsResponse: responseCode: " + responseCode + " message: " + debugMessage, null, 2, null);
                Logger.debug$default(Logger.INSTANCE, "onSkuDetailsResponse: Found " + skuDetails.size() + " SkuDetails as " + type.getText(), null, 2, null);
                Function1<? super List<RevXProduct>, Unit> function1 = callback;
                if (function1 != null) {
                    function1.invoke((Object)skuDetails);
                }
                Map map = (Map)this.skusWithSkuDetails.getValue();
                Map skuDetailsMap = map == null ? (Map)new LinkedHashMap() : map;
                for (RevXProduct skuDetail : skuDetails) {
                    Map map2 = skuDetailsMap;
                    String string2 = skuDetail.getProductId();
                    map2.put(string2, skuDetail);
                }
                this.skusWithSkuDetails.postValue((Object)skuDetailsMap);
                break;
            }
            case -2: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                Logger.error$default(Logger.INSTANCE, "onSkuDetailsResponse: responseCode: " + responseCode + " message: " + debugMessage, null, 2, null);
                Function1<? super List<RevXProduct>, Unit> function1 = callback;
                if (function1 == null) break;
                function1.invoke((Object)CollectionsKt.emptyList());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onPurchaseHistoryResponse(BillingResult billingResult, List<? extends PurchaseHistoryRecord> purchaseHistoryList, ProductType type, Function1<? super List<RevXPurchaseHistory>, Unit> callback) {
        int responseCode = billingResult.getResponseCode();
        String string = billingResult.getDebugMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"billingResult.debugMessage");
        String debugMessage = string;
        if (responseCode == 0) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = purchaseHistoryList == null ? CollectionsKt.emptyList() : purchaseHistoryList;
            boolean $i$f$map = false;
            void var11_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PurchaseHistoryRecord purchaseHistoryRecord = (PurchaseHistoryRecord)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(BillingUtilsKt.toRevXPurchaseHistory((PurchaseHistoryRecord)it, type));
            }
            List purchaseHistory = (List)destination$iv$iv;
            Logger.debug$default(Logger.INSTANCE, "onPurchaseHistoryResponse: responseCode: " + responseCode + " message: " + debugMessage, null, 2, null);
            Logger.debug$default(Logger.INSTANCE, "onPurchaseHistoryResponse: Found " + purchaseHistory.size() + " purchase(s) as " + type.getText(), null, 2, null);
            Function1<? super List<RevXPurchaseHistory>, Unit> function1 = callback;
            if (function1 != null) {
                function1.invoke((Object)purchaseHistory);
            }
            Map map = (Map)this.previousPurchases.getValue();
            Map purchaseHistoryMap = map == null ? (Map)new LinkedHashMap() : map;
            for (RevXPurchaseHistory purchase : purchaseHistory) {
                Map map2 = purchaseHistoryMap;
                String string2 = purchase.getPurchaseToken();
                map2.put(string2, purchase);
            }
            this.previousPurchases.postValue((Object)purchaseHistoryMap);
        } else {
            Logger.error$default(Logger.INSTANCE, "onPurchaseHistoryResponse: responseCode: " + responseCode + " message: " + debugMessage, null, 2, null);
            Function1<? super List<RevXPurchaseHistory>, Unit> function1 = callback;
            if (function1 != null) {
                function1.invoke((Object)CollectionsKt.emptyList());
            }
        }
    }

    private final void onQueryPurchasesResponse(BillingResult billingResult, List<? extends Purchase> purchaseList, ProductType type, Function1<? super List<RevXPurchase>, Unit> callback) {
        int responseCode = billingResult.getResponseCode();
        String string = billingResult.getDebugMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"billingResult.debugMessage");
        String debugMessage = string;
        if (responseCode == 0) {
            Logger.debug$default(Logger.INSTANCE, "onQueryPurchasesResponse: responseCode: " + responseCode + " message: " + debugMessage, null, 2, null);
            this.processPurchaseList(purchaseList, type, callback);
        } else {
            Logger.error$default(Logger.INSTANCE, "onQueryPurchasesResponse: responseCode: " + responseCode + " message: " + debugMessage, null, 2, null);
            Function1<? super List<RevXPurchase>, Unit> function1 = callback;
            if (function1 != null) {
                function1.invoke((Object)CollectionsKt.emptyList());
            }
        }
    }

    private final RevXPurchase findPurchaseForProduct(RevXProduct product) {
        RevXPurchase revXPurchase;
        if (product == null) {
            revXPurchase = null;
        } else {
            Map map = (Map)this.currentPurchases.getValue();
            if (map == null) {
                revXPurchase = null;
            } else {
                Collection collection = map.values();
                if (collection == null) {
                    revXPurchase = null;
                } else {
                    Object v3;
                    block7: {
                        Iterable $this$firstOrNull$iv = collection;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            RevXPurchase it = (RevXPurchase)element$iv;
                            boolean bl = false;
                            if (!it.getProductIds().contains(product.getProductId())) continue;
                            v3 = element$iv;
                            break block7;
                        }
                        v3 = null;
                    }
                    revXPurchase = v3;
                }
            }
        }
        RevXPurchase result = revXPurchase;
        return result;
    }

    private final ProductType findProductTypeForPurchase(Purchase purchase) {
        ProductType result;
        ProductType productType;
        ProductType productType2;
        if (purchase == null) {
            productType2 = null;
        } else {
            ArrayList arrayList = purchase.getSkus();
            Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"purchase.skus");
            String sku = (String)CollectionsKt.first((List)arrayList);
            Map map = (Map)this.skusWithSkuDetails.getValue();
            if (map == null) {
                productType2 = null;
            } else {
                RevXProduct revXProduct = (RevXProduct)map.get(sku);
                productType2 = revXProduct == null ? null : revXProduct.getType();
            }
        }
        if ((productType = (result = productType2)) == null) {
            productType = ProductType.Subs;
        }
        return productType;
    }

    /*
     * WARNING - void declaration
     */
    private final void processPurchaseList(List<? extends Purchase> purchaseList, ProductType productType, Function1<? super List<RevXPurchase>, Unit> callback) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = purchaseList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Purchase purchase = (Purchase)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(BillingUtilsKt.toRevXPurchase((Purchase)it, productType));
        }
        List revXPurchases = (List)destination$iv$iv;
        Logger.debug$default(Logger.INSTANCE, "processPurchaseList: Found " + purchaseList.size() + " purchase(s)", null, 2, null);
        Function1<? super List<RevXPurchase>, Unit> function1 = callback;
        if (function1 != null) {
            function1.invoke((Object)revXPurchases);
        }
        Map map = (Map)this.currentPurchases.getValue();
        Map productMap = map == null ? (Map)new LinkedHashMap() : map;
        for (RevXPurchase purchase : revXPurchases) {
            Map map2 = productMap;
            String string = purchase.getOrderId();
            map2.put(string, purchase);
        }
        this.currentPurchases.postValue((Object)productMap);
    }

    static /* synthetic */ void processPurchaseList$default(ImplBillingClientManager implBillingClientManager, List list, ProductType productType, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = null;
        }
        implBillingClientManager.processPurchaseList(list, productType, (Function1<? super List<RevXPurchase>, Unit>)function1);
    }

    private static final void retryBillingServiceConnectionWithExponentialBackoff$lambda-1(ImplBillingClientManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.billingClient.startConnection((BillingClientStateListener)this$0);
    }

    public /* synthetic */ ImplBillingClientManager(Application application, SetupCompletionListener setupCompletionListener, NewPurchaseListener newPurchaseListener, DefaultConstructorMarker $constructor_marker) {
        this(application, setupCompletionListener, newPurchaseListener);
    }

    public static final /* synthetic */ BillingClient access$getBillingClient$p(ImplBillingClientManager $this) {
        return $this.billingClient;
    }

    public static final /* synthetic */ void access$onSkuDetailsResponse(ImplBillingClientManager $this, BillingResult billingResult, List skuDetailsList, ProductType type, Function1 callback) {
        $this.onSkuDetailsResponse(billingResult, skuDetailsList, type, (Function1<? super List<RevXProduct>, Unit>)callback);
    }

    public static final /* synthetic */ void access$onPurchaseHistoryResponse(ImplBillingClientManager $this, BillingResult billingResult, List purchaseHistoryList, ProductType type, Function1 callback) {
        $this.onPurchaseHistoryResponse(billingResult, purchaseHistoryList, type, (Function1<? super List<RevXPurchaseHistory>, Unit>)callback);
    }

    public static final /* synthetic */ void access$onQueryPurchasesResponse(ImplBillingClientManager $this, BillingResult billingResult, List purchaseList, ProductType type, Function1 callback) {
        $this.onQueryPurchasesResponse(billingResult, purchaseList, type, (Function1<? super List<RevXPurchase>, Unit>)callback);
    }

    public static final /* synthetic */ RevXPurchase access$findPurchaseForProduct(ImplBillingClientManager $this, RevXProduct product) {
        return $this.findPurchaseForProduct(product);
    }

    static {
        handler = new Handler(Looper.getMainLooper());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ltr/com/mobilex/core/billing/ImplBillingClientManager$Companion;", "", "()V", "INSTANCE", "Ltr/com/mobilex/core/billing/ImplBillingClientManager;", "handler", "Landroid/os/Handler;", "getInstance", "app", "Landroid/app/Application;", "setupCompletionListener", "Ltr/com/mobilex/core/billing/SetupCompletionListener;", "newPurchaseListener", "Ltr/com/mobilex/core/billing/NewPurchaseListener;", "revenuex-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final ImplBillingClientManager getInstance(@NotNull Application app, @Nullable SetupCompletionListener setupCompletionListener, @Nullable NewPurchaseListener newPurchaseListener) {
            ImplBillingClientManager implBillingClientManager;
            Intrinsics.checkNotNullParameter((Object)app, (String)"app");
            ImplBillingClientManager implBillingClientManager2 = INSTANCE;
            if (implBillingClientManager2 == null) {
                synchronized (this) {
                    ImplBillingClientManager implBillingClientManager3;
                    boolean bl = false;
                    ImplBillingClientManager implBillingClientManager4 = INSTANCE;
                    if (implBillingClientManager4 == null) {
                        ImplBillingClientManager implBillingClientManager5;
                        ImplBillingClientManager it = implBillingClientManager5 = new ImplBillingClientManager(app, setupCompletionListener, newPurchaseListener, null);
                        boolean bl2 = false;
                        INSTANCE = it;
                        implBillingClientManager3 = implBillingClientManager5;
                    } else {
                        implBillingClientManager3 = implBillingClientManager4;
                    }
                    ImplBillingClientManager implBillingClientManager6 = implBillingClientManager3;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl18 : MonitorExitStatement: MONITOREXIT : this
                    implBillingClientManager = implBillingClientManager6;
                }
            } else {
                implBillingClientManager = implBillingClientManager2;
            }
            return implBillingClientManager;
        }

        public static /* synthetic */ ImplBillingClientManager getInstance$default(Companion companion, Application application, SetupCompletionListener setupCompletionListener, NewPurchaseListener newPurchaseListener, int n, Object object) {
            if ((n & 2) != 0) {
                setupCompletionListener = null;
            }
            if ((n & 4) != 0) {
                newPurchaseListener = null;
            }
            return companion.getInstance(application, setupCompletionListener, newPurchaseListener);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

