/*
 * Decompiled with CFR 0.152.
 */
package tr.com.mobilex.core;

import android.content.Context;
import android.os.Build;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tr.com.mobilex.core.utils.ContextUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010 \u001a\u00020!2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0006\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0006R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0006R\u001a\u0010\u001b\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0006\"\u0004\b\u001d\u0010\nR\u0011\u0010\u001e\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0006\u00a8\u0006\""}, d2={"Ltr/com/mobilex/core/SystemInfo;", "", "()V", "applicationVersion", "", "getApplicationVersion", "()Ljava/lang/String;", "clientId", "getClientId", "setClientId", "(Ljava/lang/String;)V", "context", "Ljava/lang/ref/WeakReference;", "Landroid/content/Context;", "deviceName", "getDeviceName", "isSandbox", "", "()Z", "language", "getLanguage", "platform", "getPlatform", "platformVersion", "getPlatformVersion", "region", "getRegion", "revenueXUserId", "getRevenueXUserId", "setRevenueXUserId", "rootUrl", "getRootUrl", "configure", "", "revenuex-android-sdk_release"})
public final class SystemInfo {
    @NotNull
    public static final SystemInfo INSTANCE = new SystemInfo();
    private static WeakReference<Context> context;
    public static String clientId;
    public static String revenueXUserId;

    private SystemInfo() {
    }

    @NotNull
    public final String getClientId() {
        String string = clientId;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"clientId");
        return null;
    }

    public final void setClientId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        clientId = string;
    }

    @NotNull
    public final String getRevenueXUserId() {
        String string = revenueXUserId;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"revenueXUserId");
        return null;
    }

    public final void setRevenueXUserId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        revenueXUserId = string;
    }

    public final void configure(@NotNull WeakReference<Context> context, @NotNull String clientId, @NotNull String revenueXUserId) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)revenueXUserId, (String)"revenueXUserId");
        SystemInfo.context = context;
        this.setClientId(clientId);
        this.setRevenueXUserId(revenueXUserId);
    }

    @NotNull
    public final String getRootUrl() {
        return "https://sdk-test.revenueplus.net/";
    }

    @NotNull
    public final String getPlatform() {
        return "android";
    }

    @NotNull
    public final String getPlatformVersion() {
        String string = Build.VERSION.RELEASE;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RELEASE");
        return string;
    }

    @NotNull
    public final String getDeviceName() {
        String string = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MODEL");
        return string;
    }

    @NotNull
    public final String getApplicationVersion() {
        WeakReference<Context> weakReference = context;
        if (weakReference == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            weakReference = null;
        }
        Context context = (Context)weakReference.get();
        if (context == null) {
            return "";
        }
        Context contextRef = context;
        String packageName = contextRef.getApplicationInfo().packageName;
        String string = contextRef.getPackageManager().getPackageInfo((String)packageName, (int)0).versionName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"contextRef.packageManage\u2026ckageName, 0).versionName");
        return string;
    }

    public final boolean isSandbox() {
        WeakReference<Context> weakReference = context;
        if (weakReference == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            weakReference = null;
        }
        Context context = (Context)weakReference.get();
        if (context == null) {
            return true;
        }
        Context contextRef = context;
        return (contextRef.getApplicationInfo().flags & 2) != 0;
    }

    @NotNull
    public final String getRegion() {
        WeakReference<Context> weakReference = context;
        if (weakReference == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            weakReference = null;
        }
        Context context = (Context)weakReference.get();
        if (context == null) {
            return "";
        }
        Context contextRef = context;
        String string = ContextUtilsKt.getLocale(contextRef).getCountry();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"contextRef.getLocale().country");
        return string;
    }

    @NotNull
    public final String getLanguage() {
        WeakReference<Context> weakReference = context;
        if (weakReference == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            weakReference = null;
        }
        Context context = (Context)weakReference.get();
        if (context == null) {
            return "";
        }
        Context contextRef = context;
        return ContextUtilsKt.getLocale(contextRef).getLanguage() + '-' + ContextUtilsKt.getLocale(contextRef).getCountry();
    }
}

