/*
 * Decompiled with CFR 0.152.
 */
package com.binance.api.client.impl;

import com.binance.api.client.BinanceApiMarginRestClient;
import com.binance.api.client.domain.TransferType;
import com.binance.api.client.domain.account.LoanQueryResult;
import com.binance.api.client.domain.account.MarginAccount;
import com.binance.api.client.domain.account.MarginNewOrder;
import com.binance.api.client.domain.account.MarginNewOrderResponse;
import com.binance.api.client.domain.account.MarginTransaction;
import com.binance.api.client.domain.account.MaxBorrowableQueryResult;
import com.binance.api.client.domain.account.Order;
import com.binance.api.client.domain.account.RepayQueryResult;
import com.binance.api.client.domain.account.Trade;
import com.binance.api.client.domain.account.request.CancelOrderRequest;
import com.binance.api.client.domain.account.request.CancelOrderResponse;
import com.binance.api.client.domain.account.request.OrderRequest;
import com.binance.api.client.domain.account.request.OrderStatusRequest;
import com.binance.api.client.impl.BinanceApiService;
import com.binance.api.client.impl.BinanceApiServiceGenerator;
import java.util.List;

public class BinanceApiMarginRestClientImpl
implements BinanceApiMarginRestClient {
    private final BinanceApiService binanceApiService;

    public BinanceApiMarginRestClientImpl(String apiKey, String secret) {
        this.binanceApiService = BinanceApiServiceGenerator.createService(BinanceApiService.class, apiKey, secret);
    }

    @Override
    public MarginAccount getAccount() {
        long timestamp = System.currentTimeMillis();
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.getMarginAccount(60000L, timestamp));
    }

    @Override
    public List<Order> getOpenOrders(OrderRequest orderRequest) {
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.getOpenMarginOrders(orderRequest.getSymbol(), orderRequest.getRecvWindow(), orderRequest.getTimestamp()));
    }

    @Override
    public MarginNewOrderResponse newOrder(MarginNewOrder order) {
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.newMarginOrder(order.getSymbol(), order.getSide(), order.getType(), order.getTimeInForce(), order.getQuantity(), order.getPrice(), order.getNewClientOrderId(), order.getStopPrice(), order.getIcebergQty(), order.getNewOrderRespType(), order.getSideEffectType(), order.getRecvWindow(), order.getTimestamp()));
    }

    @Override
    public CancelOrderResponse cancelOrder(CancelOrderRequest cancelOrderRequest) {
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.cancelMarginOrder(cancelOrderRequest.getSymbol(), cancelOrderRequest.getOrderId(), cancelOrderRequest.getOrigClientOrderId(), cancelOrderRequest.getNewClientOrderId(), cancelOrderRequest.getRecvWindow(), cancelOrderRequest.getTimestamp()));
    }

    @Override
    public Order getOrderStatus(OrderStatusRequest orderStatusRequest) {
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.getMarginOrderStatus(orderStatusRequest.getSymbol(), orderStatusRequest.getOrderId(), orderStatusRequest.getOrigClientOrderId(), orderStatusRequest.getRecvWindow(), orderStatusRequest.getTimestamp()));
    }

    @Override
    public List<Trade> getMyTrades(String symbol) {
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.getMyTrades(symbol, null, null, 60000L, System.currentTimeMillis()));
    }

    @Override
    public String startUserDataStream() {
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.startMarginUserDataStream()).toString();
    }

    @Override
    public void keepAliveUserDataStream(String listenKey) {
        BinanceApiServiceGenerator.executeSync(this.binanceApiService.keepAliveMarginUserDataStream(listenKey));
    }

    @Override
    public MarginTransaction transfer(String asset, String amount, TransferType type) {
        long timestamp = System.currentTimeMillis();
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.transfer(asset, amount, type.getValue(), 60000L, timestamp));
    }

    @Override
    public MarginTransaction borrow(String asset, String amount) {
        long timestamp = System.currentTimeMillis();
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.borrow(asset, amount, 60000L, timestamp));
    }

    @Override
    public LoanQueryResult queryLoan(String asset, String txId) {
        long timestamp = System.currentTimeMillis();
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.queryLoan(asset, txId, timestamp));
    }

    @Override
    public RepayQueryResult queryRepay(String asset, String txId) {
        long timestamp = System.currentTimeMillis();
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.queryRepay(asset, txId, (Long)timestamp));
    }

    @Override
    public RepayQueryResult queryRepay(String asset, long startTime) {
        long timestamp = System.currentTimeMillis();
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.queryRepay(asset, startTime, (Long)timestamp));
    }

    @Override
    public MaxBorrowableQueryResult queryMaxBorrowable(String asset) {
        long timestamp = System.currentTimeMillis();
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.queryMaxBorrowable(asset, timestamp));
    }

    @Override
    public MarginTransaction repay(String asset, String amount) {
        long timestamp = System.currentTimeMillis();
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.repay(asset, amount, 60000L, timestamp));
    }
}

